
/** I N C L U D E S **********************************************************/
#include <p18cxxx.h>

int j = 500;
/** V A R I A B L E S ********************************************************/
#pragma udata

/** P R I V A T E  P R O T O T Y P E S ***************************************/

/** V E C T O R  R E M A P P I N G *******************************************/

extern void _startup (void);        // See c018i.c in your C18 compiler dir
#pragma code _RESET_INTERRUPT_VECTOR = 0x000800
void _reset (void)
{
    _asm goto _startup _endasm
}
#pragma code

#pragma code _HIGH_INTERRUPT_VECTOR = 0x00808
void _high_ISR (void)
{

	if  (PIR1bits.TMR1IF)
    {       
		if (j == 0)
		{        
	        LATDbits.LATD0 =! LATDbits.LATD0 ;
			j = 500;
		}

		TMR1H = 0xF4;
		TMR1L = 0x6D; 

		
		PIR1bits.TMR1IF = 0;     // clear flag  
		j--;       
    }

}

#pragma code

/** D E C L A R A T I O N S **************************************************/
#pragma code
/******************************************************************************
 * Function:        void main(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Main program entry point.
 *
 * Note:            None
 *****************************************************************************/

void main(void)
{
   

	ADCON1bits.PCFG3 = 1;
	ADCON1bits.PCFG2 = 1;
	ADCON1bits.PCFG1 = 1;
	ADCON1bits.PCFG0 = 1;

	TRISDbits.TRISD0 = 0;
	TRISDbits.TRISD1 = 0;
	TRISDbits.TRISD2 = 0;
	TRISDbits.TRISD3 = 0;

	LATDbits.LATD0 = 0;
	LATDbits.LATD1 = 0;

	

	RCONbits.IPEN = 1;
	INTCONbits.GIE = 1;
	INTCONbits.PEIE = 1;

	PIR1bits.TMR1IF = 0;

//												timer1 config
	PIE1bits.TMR1IE = 0;
	IPR1bits.TMR1IP = 1;

	T1CONbits.T1CKPS1 = 0;
	T1CONbits.T1CKPS0 = 0;

	T1CONbits.RD16 = 0;
	T1CONbits.T1OSCEN = 0;
	T1CONbits.TMR1CS = 0;

//												end timer1 config


	T1CONbits.TMR1ON = 1;
	




	T1CON = 0b10000001; 
	TMR1H = 0xF4;
	TMR1L = 0x6D; 


	
	while (1)
	{
			
	}


	

}//end main

/** EOF Demo02.c *************************************************************/
