/*********************************************************************
 *
 *                Microchip USB C18 Firmware Version 1.2
 *
 *********************************************************************
 * FileName:        io_cfg.h
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        C18 3.11+
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the Company) for its PICmicro Microcontroller is intended and
 * supplied to you, the Companys customer, for use solely and
 * exclusively on Microchip PICmicro Microcontroller products. The
 * software is owned by the Company and/or its supplier, and is
 * protected under applicable copyright laws. All rights are reserved.
 * Any use in violation of the foregoing restrictions may subject the
 * user to criminal sanctions under applicable laws, as well as to
 * civil liability for the breach of the terms and conditions of this
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Rawin Rojvanit       11/19/04    Original.
 * Rawin Rojvanit       05/14/07    Added pin mapping for PIC18F87J50
 *									FS USB Plug In Module board.
 ********************************************************************/

#ifndef IO_CFG_H
#define IO_CFG_H

/** I N C L U D E S *************************************************/
#include "autofiles\usbcfg.h"

/** T R I S *********************************************************/
#define INPUT_PIN           1
#define OUTPUT_PIN          0


/** U S B ***********************************************************/
#define tris_usb_bus_sense  TRISBbits.TRISA1    // Input

#if defined(USE_USB_BUS_SENSE_IO)
#define usb_bus_sense       PORTBbits.RA1
#else
#define usb_bus_sense       1
#endif

#define tris_self_power     TRISAbits.TRISA2    // Input
#if defined(USE_SELF_POWER_SENSE_IO)
#define self_power          PORTAbits.RA2
#else
#define self_power          1
#endif

/** L E D ***********************************************************/
#define mInitAllLEDs()      LATD &= 0x00; TRISD &= 0x00; LATB &= 0x10; TRISB &= 0x10; TRISEbits.TRISE0=0; LATEbits.LATE0=0; TRISEbits.TRISE1=0; LATEbits.LATE1=0;

#define sLED1				LATEbits.LATE0
#define sLED2				LATEbits.LATE1

#define sLED1_On()			sLED1 = 1;
#define sLED2_On()			sLED2 = 1;

#define sLED1_Off()			sLED1 = 0;
#define sLED2_Off()			sLED2 = 0;

#define sLED1_Toggle()		sLED1 = !sLED1;
#define sLED2_Toggle()		sLED2 = !sLED2;

/** S W I T C H *****************************************************/
/*#define mInitAllSwitches()  TRISBbits.TRISB4=1;
#define mInitSwitch2()      TRISBbits.TRISB4=1;
#define sw2                 PORTBbits.RB4
*/
#define mInitAllSwitches()  TRISEbits.TRISE2=1;
#define mInitSwitch2()      TRISEbits.TRISE2=1;
#define sw2                 PORTEbits.RE2
/********************************************************************/

#endif //IO_CFG_H
