/** I N C L U D E S **********************************************************/
#include <p18cxxx.h>
#include <stdlib.h>
#include "system\typedefs.h"                        // Required
#include "system\usb\usb.h"                         // Required
#include "io_cfg.h"                                 // Required

#include "system\usb\usb_compile_time_validation.h" // Optional
//#include "user\user.h"                              // Modifiable
#include "user\leddisplay.h" // 7 szegmenses LED kijelz driver
#include "user\i2c.h"		// I2C
#include "user\DS1621.h"	// DS1621 driver

/** C O N F I G U R A T I O N ************************************************/
// Note: For a complete list of the available config pragmas and their values, 
// see the compiler documentation, and/or click "Help --> Topics..." and then 
// select "PIC18 Config Settings" in the Language Tools section.

        #pragma config PLLDIV   = 5         // (20 MHz crystal on PICDEM FS USB board)
        #pragma config CPUDIV   = OSC1_PLL2	
        #pragma config USBDIV   = 2         // Clock source from 96MHz PLL/2
        #pragma config FOSC     = HSPLL_HS
        #pragma config FCMEN    = OFF
        #pragma config IESO     = OFF
        #pragma config PWRT     = OFF
        #pragma config BOR      = ON
        #pragma config BORV     = 3
        #pragma config VREGEN   = ON		//USB Voltage Regulator
        #pragma config WDT      = OFF
        #pragma config WDTPS    = 32768
        #pragma config MCLRE    = ON
        #pragma config LPT1OSC  = OFF
        #pragma config PBADEN   = OFF
//      #pragma config CCP2MX   = ON
        #pragma config STVREN   = ON
        #pragma config LVP      = OFF
//      #pragma config ICPRT    = OFF       // Dedicated In-Circuit Debug/Programming
        #pragma config XINST    = OFF       // Extended Instruction Set
        #pragma config CP0      = OFF
        #pragma config CP1      = OFF
//      #pragma config CP2      = OFF
//      #pragma config CP3      = OFF
        #pragma config CPB      = OFF
//      #pragma config CPD      = OFF
        #pragma config WRT0     = OFF
        #pragma config WRT1     = OFF
//      #pragma config WRT2     = OFF
//      #pragma config WRT3     = OFF
        #pragma config WRTB     = ON       // Boot Block Write Protection
        #pragma config WRTC     = OFF
//      #pragma config WRTD     = OFF
        #pragma config EBTR0    = OFF
        #pragma config EBTR1    = OFF
//      #pragma config EBTR2    = OFF
//      #pragma config EBTR3    = OFF
        #pragma config EBTRB    = OFF

/** V A R I A B L E S ********************************************************/
#pragma udata

#define KOMPENZALAS 5540 //5544 //5536 // 5552
#define OSZTO  200 // ((48000000/4/(65536-KOMPENZALAS) /4 a Fosc/4 miatt

byte old_sw2; // sw2 elz llapota
int mode = 0; // kirs md: 1 - hmrsklet, 0 - id
long seconds = 0; // msodpercek trolsra
double temp = -999; // hmrsklet trolsra
static unsigned int tmp = 0; // segdvltoz a msodpercek szmolshoz

/** P R I V A T E  P R O T O T Y P E S ***************************************/
static void InitializeSystem(void);
void InterruptHandlerHigh (void);
void USBTasks(void);
BOOL Switch2IsPressed(void);
void setTime(char *str);

/** V E C T O R  R E M A P P I N G *******************************************/
extern void _startup (void);        // See c018i.c in your C18 compiler dir
#pragma code _RESET_INTERRUPT_VECTOR = 0x000800
void _reset (void)
{
    _asm goto _startup _endasm
}
#pragma code

#pragma code _HIGH_INTERRUPT_VECTOR = 0x000808
void _high_ISR (void)
{
  _asm
    goto InterruptHandlerHigh //jump to interrupt routine
  _endasm
}

//----------------------------------------------------------------------------
// High priority interrupt routine
#pragma code
#pragma interrupt InterruptHandlerHigh

void InterruptHandlerHigh ()
{
	unsigned cf; // TMR0 regiszter rtknek eltrolshoz
	if (INTCONbits.TMR0IF) //check for TMR0 overflow
  	{
		INTCONbits.TMR0IF = 0; //clear interrupt flag
        tmp++;
        T0CONbits.TMR0ON = 0; //meglltjuk a Timer0-t
        cf = TMR0L; // Timer0 llapot mentse
        TMR0H += KOMPENZALAS >> 8;
        if ((cf += (unsigned char) KOMPENZALAS) & 0x0100) TMR0H++; // 0x0100 == 256, ha nem fr el a cf+kompenzls 1 byte-on, akkor a TRM0H-t is nvelni kell
        TMR0L = (unsigned char) cf;
        T0CONbits.TMR0ON = 1; // Timer0 indtsa
        if (tmp == OSZTO)
        {
        	seconds++;
			//KETTOSPONT = !KETTOSPONT;
            if (seconds == 86400) seconds = 0;
            tmp = 0;
		} // if
  } // if
} // InterruptHandlerHigh

#pragma code _LOW_INTERRUPT_VECTOR = 0x000818
void _low_ISR (void)
{
    ;
}
#pragma code

/** D E C L A R A T I O N S **************************************************/
#pragma code
/******************************************************************************
 * Function:        void main(void)
 *
 * Overview:        Main program entry point.
 *****************************************************************************/
void main(void)
{
	int o = 0;
	long p = 0;
	char input_buffer[8];

    InitializeSystem();
	init_temp();
    while(1)
    {
      	USBTasks();         // USB Tasks
      	//*** ProcessIO();        // See user\user.c & .h
		if (!((usb_device_state < CONFIGURED_STATE)||(UCONbits.SUSPND==1))) {
   			if (getsUSBUSART(input_buffer, 8)) {
				switch (input_buffer[0]) {
		  			case 's' : setTime(input_buffer);
							   break;
		  			default : break;
	  			} // switch
    		} // if
		} // if
		// ***
		if (Switch2IsPressed()) {
			//clrscr();
			mode = !mode;
		}
		//if (!(seconds % 10)) mode = !mode; // 10 msodpercenknt vlts a hmrsklet s az idkijelzs kztt
		if (mode) {
			temp = getTemp();
			writeTemperature(temp);
			} else {
				o = seconds / 3600;
				p = (seconds % 3600) / 60;
				writeTime(o, p);
			}
 
    }//end while

}//end main

/******************************************************************************
 * Function:        static void InitializeSystem(void)
 *
 * Overview:        InitializeSystem is a centralize initialization routine.
 *                  All required USB initialization routines are called from
 *                  here.
 *
 *                  User application initialization routine should also be
 *                  called from here.                  
 *****************************************************************************/
static void InitializeSystem(void)
{
	//On the PIC18F87J50 Family of USB microcontrollers, the PLL will not power up and be enabled
	//by default, even if a PLL enabled oscillator configuration is selected (such as HS+PLL).
	//This allows the device to power up at a lower initial operating frequency, which can be
	//advantageous when powered from a source which is not gauranteed to be adequate for 48MHz
	//operation.  On these devices, user firmware needs to manually set the OSCTUNE<PLLEN> bit to
	//power up the PLL.

	ADCON1 |= 0x0F;                 // Default all pins to digital

//	The USB specifications require that USB peripheral devices must never source
//	current onto the Vbus pin.  Additionally, USB peripherals should not source
//	current on D+ or D- when the host/hub is not actively powering the Vbus line.
//	When designing a self powered (as opposed to bus powered) USB peripheral
//	device, the firmware should make sure not to turn on the USB module and D+
//	or D- pull up resistor unless Vbus is actively powered.  Therefore, the
//	firmware needs some means to detect when Vbus is being powered by the host.
//	A 5V tolerant I/O pin can be connected to Vbus (through a resistor), and
// 	can be used to detect when Vbus is high (host actively powering), or low
//	(host is shut down or otherwise not supplying power).  The USB firmware
// 	can then periodically poll this I/O pin to know when it is okay to turn on
//	the USB module/D+/D- pull up resistor.  When designing a purely bus powered
//	peripheral device, it is not possible to source current on D+ or D- when the
//	host is not actively providing power on Vbus. Therefore, implementing this
//	bus sense feature is optional.  This firmware can be made to use this bus
//	sense feature by making sure "USE_USB_BUS_SENSE_IO" has been defined in the
//	usbcfg.h file.
    #if defined(USE_USB_BUS_SENSE_IO)
    tris_usb_bus_sense = INPUT_PIN; // See io_cfg.h
    #endif

//	If the host PC sends a GetStatus (device) request, the firmware must respond
//	and let the host know if the USB peripheral device is currently bus powered
//	or self powered.  See chapter 9 in the official USB specifications for details
//	regarding this request.  If the peripheral device is capable of being both
//	self and bus powered, it should not return a hard coded value for this request.
//	Instead, firmware should check if it is currently self or bus powered, and
//	respond accordingly.  If the hardware has been configured like demonstrated
//	on the PICDEM FS USB Demo Board, an I/O pin can be polled to determine the
//	currently selected power source.  On the PICDEM FS USB Demo Board, "RA2" 
//	is used for	this purpose.  If using this feature, make sure "USE_SELF_POWER_SENSE_IO"
//	has been defined in usbcfg.h, and that an appropriate I/O pin has been mapped
//	to it in io_cfg.h.
    #if defined(USE_SELF_POWER_SENSE_IO)
    tris_self_power = INPUT_PIN;
    #endif
    
    mInitializeUSBDriver();         // See usbdrv.h
  // *** Timer0 belltsa
  INTCON = 0x20;                //disable global and enable TMR0 interrupt
  INTCON2 = 0x84;               //TMR0 high priority
  RCONbits.IPEN = 1;            //enable priority levels
  TMR0H = 0;                    //clear timer
  TMR0L = 0;                    //clear timer
  T0CON = 0b10001000; 			// 16bit eloszt nlkl
  // ***
  INTCONbits.GIEH = 1;          //enable interrupts
//    UserInit();                     // See user.c & .h
    mInitAllLEDs();
    mInitAllSwitches();
    old_sw2 = sw2;
  	clrscr(); 					// LED kijelz trlse
	SCL = 1;                    // Ensure SCL is high
	SDA = 1;

}//end InitializeSystem

/******************************************************************************
 * Function:        void USBTasks(void)
 *
 * PreCondition:    InitializeSystem has been called.
 *
 * Overview:        Service loop for USB tasks.
 *****************************************************************************/
void USBTasks(void)
{
    /*
     * Servicing Hardware
     */
    USBCheckBusStatus();                    // Must use polling method
    if(UCFGbits.UTEYE!=1)
        USBDriverService();                 // Interrupt or polling method
    
    #if defined(USB_USE_CDC)
    CDCTxService();
    #endif

}// end USBTasks

BOOL Switch2IsPressed(void)
{
    if(sw2 != old_sw2)
    {
        old_sw2 = sw2;                  // Save new value
        if(sw2 == 0)                    // If pressed
            return TRUE;                // Was pressed
    }//end if
    return FALSE;                       // Was not pressed
}//end Switch2IsPressed

void setTime(char str[8]) {
	int i;
	char ujs[6];
	for (i = 0; i < 6; i++) {
		ujs[i] = str[2 + i];
		if (str[2 + i] == '\0') break;
	}
	seconds = atol(ujs);
} // setTime

/** EOF main.c ***************************************************************/
