/*****************************************
 * 7 szegmenses LED kijelz driver
 * FileName: leddisplay.c
 * Author: Gyengus(Tm) http://gyengus.hu/
 *****************************************/

#include <p18cxxx.h>
#include "leddisplay.h"

int characters[DIGITS] = {63, // 0
					  6, // 1
                     91, // 2
                     79, // 3
                    102, // 4
                    109, // 5
                    125, // 6
                      7, // 7
                    127, // 8
                    111, // 9
					 57, // C
					 64, // -
		            };

// kijelz trlse
void clrscr() {
	KETTOSPONT = FOKJEL = SEGMENTS = BLANK;
}

void writeDigitToAll(unsigned int i) {
	if (i >= 0 && i < DIGITS) SEGMENTS = characters[i];
}

// id kirsa :pp formban
void writeTime(unsigned int hours, unsigned int minutes) {
	static int akt = -1; // a kirand szmjegy
	static int h = -1; // ra
	static int m = -1; // perc
	unsigned static int tmp[4];
	unsigned static int c = 0; // : villogtatshoz
	// : villogtatsa
	c++;
	if (c == 10000) { KETTOSPONT = !KETTOSPONT; c = 0; }
	//KETTOSPONT = 1;
	// id konvertlsa, ha szksges
	if (h != hours || m != minutes) {
		akt = -1; // ugrs az els szmjegyre
 		h = hours; // ra mentse
		m = minutes; // perc mentse
		// tmp[] feltltse
		tmp[0] = h / 10; // tzesek
		tmp[1] = h % 10; // egyesek
		tmp[2] = m / 10;
		tmp[3] = m % 10;
	}
	FOKJEL = 0;
	// kv szmjegy
	akt++;
	if (akt == 4) akt = 0;
	SEGMENTS = characters[tmp[akt]]; // szegmensek belltsa
	switch (akt) {
		case 0:	D1 = 0; D2 = D3 = D4 = 1;
				break;
		case 1: D2 = 0; D1 = D3 = D4 = 1;
				break;
		case 2: D3 = 0; D1 = D2 = D4 = 1;
				break;
		case 3: D4 = 0; D1 = D2 = D3 = 1;
				break;
	}
}

// 00:00
/*void blinkNull() {
	unsigned static int c = 0;

	D1 = D2 = D3 = D4 = 0; // minden szmjegy egyforma
	c++;
	if (c == 15000) {
		SEGMENTS = characters[0];
		KETTOSPONT = 1;
	} else if (c == 30000) {
		c = 0;
		SEGMENTS = BLANK;
		KETTOSPONT = 0;
	}
}*/

void writeTemperature(double x) {
	static int a = -1; // a kirand szmjegy
	static int tmp[4];
	static int egesz = 0, tort = 0, pont = -1;
	static double last = -999;
	KETTOSPONT = 0;
	FOKJEL = 1;
	if (last != x) {
		last = x;
		pont = -1;
		egesz = x / 1;
		tort = (x - egesz) * 100;
		tmp[3] = 10; // C
		if (x < 0) {
			// negatv
			tmp[0] = 11; // -
			egesz *= -1;
			tort *= -1;
			if (egesz >= 10) {
				// <= -10, csak az egszeket rjuk ki
				tmp[1] = egesz / 10;
				tmp[2] = (int)egesz % 10;
			} else {
				// > -10, 1 tizedesjegy pontossg
				tmp[1] = egesz;
				pont = 1;
				if (tort >= 10) {
					tmp[2] = tort / 10;
				} else { tmp[2] = tort; }
			}
		} else {
			// pozitv
			if (egesz >= 100) {
				// >= 100, nincs tizedesjegy
				tmp[0] = egesz / 100;
				tmp[1] = (egesz % 100) / 10;
				tmp[2] = (egesz % 100) % 10;
			} else if (egesz >= 10) {
				// >= 10, 1 tisedesjegy
				pont = 1;
				tmp[0] = egesz / 10;
				tmp[1] = egesz % 10;
				if (tort >= 10) {
					tmp[2] = tort / 10;
				} else { tmp[2] = tort; }
			} else {
				// 2 tizedesjegy
				pont = 0;
				tmp[0] = egesz;
				if (tort >= 10) {
					tmp[1] = tort / 10;
					tmp[2]= tort % 10;
				} else {
					tmp[1] = tort;
					tmp[2] = 0;
				}
			}
		}
	}
	// kv szmjegy
	a++;
	if (a == 4) a = 0;
	SEGMENTS = characters[tmp[a]] + (a == pont ? 128 : 0); // szegmensek belltsa
	switch (a) {
		case 0:	D1 = 0; D2 = D3 = D4 = 1;
				break;
		case 1: D2 = 0; D1 = D3 = D4 = 1;
				break;
		case 2: D3 = 0; D1 = D2 = D4 = 1;
				break;
		case 3: D4 = 0; D1 = D2 = D3 = 1;
				break;
	}
}
