CON

  EA_DOGM128W_PAGE      = %0_10110000
  EA_DOGM128W_COLUMN    = %0_00010000

  COLS                  = 128
  ROWS                  = 64
  PAGES                 = ROWS / 8
  TILES                 = COLS / 4

  SCREEN                = $8000 - COLS * ROWS
  SYNC                  = SCREEN - 4                            'Display refresh
  CANVAS                = SYNC - COLS * ROWS - 4                '

  SET                   = 1
  CLEAR                 = 0

  NORMAL                = 0
  INVERZ                = 1

Var
  long  Cog
  
PUB Start(CSPin, RSTPin, CLKPin, MOSIPin, A0Pin) : OK

  Stop

  CS    := |<CSPin
  RST   := |<RSTPin
  CLK   := |<CLKPin
  MOSI  := |<MOSIPin
  A0    := |<A0Pin
  
  long[SYNC] := 0
  longfill(CANVAS,0,TILES * PAGES)
  
  Cog := cognew(@Init,SYNC) + 1
  OK := Cog > 0

PUB stop

  if Cog
    cogstop(Cog~ - 1)

PUB ClearScreen
  longfill(SCREEN,0,TILES * PAGES)
  Refresh
    
PUB Refresh
'  repeat while long[LCD#SYNC] == 1
  long[SYNC] := 1

PUB Plot(X,Y,C) | a,p
  a := SCREEN + X + (Y >> 3) << 7
  p := |< (Y & $7)
  p <<= (3 - (X & $3)) * 8
  If C == SET
    long[a] |= p
  Else
    long[a] &= !p

PUB CharLine(X,Y,Line,Mode) | i
    repeat i from 0 to 5
      Line <<= 1
      if Mode == NORMAL
        if (Line & $80) <> 0
          Plot(X + i,Y,SET)
        else
          Plot(X + i,Y,CLEAR)
      else
        if (Line & $80) <> 0
          Plot(X + i,Y,CLEAR)
        else
          Plot(X + i,Y,SET)

PUB PrintChar(X,Y,Char,Mode) | px, py, fchar, i, j
  Char <<= 3
  px := X
  py := Y
  j := 0
  if (Char_ROM.byte[char] & $80 ) == $80
    CharLine(px,py + j,0,Mode)  
    CharLine(px,py + j + 1,0,Mode)  
    py += 2
    repeat
      fchar := Char_ROM.byte[char + j] & $7E
      CharLine(px,py + j,fchar,Mode)  
     
      if ( Char_ROM.byte[char + j] & $01 ) == 1
        quit
      ++j
  else
    repeat
      fchar := Char_ROM.byte[char + j] & $7E
      CharLine(px,py + j,fchar,Mode)  
     
      if ( Char_ROM.byte[char + j] & $01 ) == 1
        quit
      ++j
    CharLine(px,py + j + 1,0,Mode)  
    CharLine(px,py + j + 2,0,Mode)  
       
PUB PrintString(X,Y,Str,Mode)
  repeat while  byte[Str] <> 0
    PrintChar(X, Y,byte[Str++] - 29,Mode)
    X += 6  
    
PUB Button(X,Y,DX,DY,Str,Mode) | i,j
  repeat i from X + 1 to X + DX - 1
    Plot(i,Y,SET)
  repeat i from X + 1 to X + DX - 1
    Plot(i,Y + DY,SET)
  repeat i from Y + 1 to Y + DY - 1
    Plot(X,i,SET)
  repeat i from Y + 1 to Y + DY - 1
    Plot(X + DX,i,SET)

  i := 0
  j := Str
  repeat while  byte[Str++] <> 0
    i += 6  


  X += (DX - i + 6) / 2 - 2
  Y += (DY - 9) / 2
  PrintString(X,Y,j,Mode)

PUB PrintIcon(X,Y,W,H,Addr) | B,S,i,j,f
  If (W // 8) == 0
    S := 0
  Else
    S := ((W / 8) * 8)  + 8 - W
  W--
  H--
  B := (W + 8) / 8
  repeat j from 0 to H
    repeat i from 0 to B - 1
      f <<= 8
      f |=  byte[Addr + j * B + i]
    f >>= S
    repeat i from 0 to W
      if (f & (|< (W - i))) <> 0
        Plot(X + i,Y + j,SET)
      else
        Plot(X + i,Y + j,CLEAR)
        
  
DAT

Char_ROM
byte        $00, $00, $C3, $00, $00, $00, $E8, $ED, $10, $10, $80, $30, $10, $10, $10, $39
byte        $00, $10, $38, $54, $10, $10, $10, $11, $00, $00, $00, $00, $00, $00, $00, $01 
byte        $00, $10, $10, $10, $10, $10, $80, $11, $00, $28, $28, $28, $00, $00, $00, $01 
byte        $00, $28, $28, $7C, $28, $7C, $28, $29, $00, $10, $3C, $50, $38, $14, $78, $11 
byte        $00, $64, $64, $08, $10, $20, $4C, $4D, $00, $10, $28, $28, $30, $54, $48, $35 
byte        $00, $10, $10, $20, $00, $00, $00, $01, $00, $08, $10, $20, $20, $20, $10, $09 
byte        $00, $20, $10, $08, $08, $08, $10, $21, $00, $10, $54, $38, $7C, $38, $54, $11 
byte        $00, $80, $10, $10, $7C, $10, $10, $01, $80, $80, $80, $80, $30, $30, $10, $21 
byte        $00, $80, $80, $80, $7C, $00, $00, $01, $00, $80, $80, $80, $80, $80, $30, $31 
byte        $00, $04, $04, $08, $10, $20, $40, $41, $00, $38, $44, $4C, $54, $64, $44, $39 
byte        $00, $10, $30, $10, $10, $10, $10, $39, $00, $38, $44, $04, $08, $30, $40, $7D 
byte        $00, $38, $44, $04, $18, $04, $44, $39, $00, $08, $18, $28, $48, $7C, $08, $09 
byte        $00, $7C, $40, $78, $04, $04, $44, $39, $00, $1C, $20, $40, $78, $44, $44, $39 
byte        $00, $7C, $04, $08, $10, $20, $20, $21, $00, $38, $44, $44, $38, $44, $44, $39 
byte        $00, $38, $44, $44, $3C, $04, $08, $71, $00, $80, $30, $30, $80, $30, $30, $01 
byte        $80, $30, $30, $80, $30, $30, $10, $21, $00, $0C, $10, $20, $40, $20, $10, $0D 
byte        $00, $80, $80, $7C, $80, $7C, $00, $01, $00, $60, $10, $08, $04, $08, $10, $61 
byte        $00, $38, $44, $04, $08, $10, $80, $11, $10, $7C, $50, $40, $70, $40, $40, $7D 
byte        $00, $38, $44, $44, $7C, $44, $44, $45, $00, $78, $24, $24, $38, $24, $24, $79 
byte        $00, $38, $44, $40, $40, $40, $44, $39, $00, $78, $24, $24, $24, $24, $24, $79 
byte        $00, $7C, $40, $40, $70, $40, $40, $7D, $00, $7C, $40, $40, $70, $40, $40, $41 
byte        $00, $38, $44, $40, $4C, $44, $44, $39, $00, $44, $44, $44, $7C, $44, $44, $45 
byte        $00, $38, $10, $10, $10, $10, $10, $39, $00, $1C, $08, $08, $08, $08, $48, $31 
byte        $00, $44, $48, $50, $60, $50, $48, $45, $00, $40, $40, $40, $40, $40, $40, $7D 
byte        $00, $44, $6C, $54, $54, $44, $44, $45, $00, $44, $44, $64, $54, $4C, $44, $45 
byte        $00, $38, $44, $44, $44, $44, $44, $39, $00, $78, $44, $44, $78, $40, $40, $41 
byte        $00, $38, $44, $44, $44, $54, $48, $35, $00, $78, $44, $44, $78, $50, $48, $45 
byte        $00, $38, $44, $40, $38, $04, $44, $39, $00, $7C, $10, $10, $10, $10, $10, $11 
byte        $00, $44, $44, $44, $44, $44, $44, $39, $00, $44, $44, $44, $28, $28, $10, $11 
byte        $00, $44, $44, $44, $54, $54, $6C, $45, $00, $44, $44, $28, $10, $28, $44, $45 
byte        $00, $44, $44, $44, $38, $10, $10, $11, $00, $7C, $04, $08, $10, $20, $40, $7D 
byte        $10, $10, $80, $38, $44, $44, $44, $39, $28, $38, $44, $44, $44, $44, $44, $39 
byte        $10, $38, $54, $44, $7C, $44, $44, $45, $28, $44, $44, $44, $44, $44, $44, $39 
byte        $10, $10, $80, $48, $48, $48, $48, $35, $10, $10, $80, $38, $44, $78, $40, $39 
byte        $00, $80, $80, $38, $08, $38, $48, $35, $00, $40, $40, $58, $64, $44, $44, $79 
byte        $00, $80, $80, $3C, $40, $40, $40, $3D, $00, $04, $04, $34, $4C, $44, $44, $3D 
byte        $00, $80, $80, $38, $44, $78, $40, $39, $98, $24, $20, $70, $20, $20, $20, $21 
byte        $80, $38, $44, $44, $44, $3C, $04, $39, $00, $40, $40, $58, $64, $44, $44, $45 
byte        $00, $10, $80, $30, $10, $10, $10, $39, $88, $80, $08, $08, $08, $08, $28, $11 
byte        $00, $40, $40, $48, $50, $60, $50, $49, $00, $30, $10, $10, $10, $10, $10, $39 
byte        $00, $80, $80, $68, $54, $54, $54, $45, $00, $80, $80, $58, $24, $24, $24, $25 
byte        $00, $80, $80, $38, $44, $44, $44, $39, $80, $58, $64, $44, $44, $78, $40, $41 
byte        $80, $34, $4C, $44, $44, $3C, $04, $05, $00, $80, $80, $58, $64, $40, $40, $41 
byte        $00, $80, $80, $38, $40, $38, $04, $79, $00, $20, $20, $70, $20, $20, $24, $19 
byte        $00, $80, $80, $48, $48, $48, $48, $35, $00, $80, $80, $44, $44, $28, $28, $11 
byte        $00, $80, $80, $44, $44, $54, $54, $29, $00, $80, $80, $44, $28, $10, $28, $45 
byte        $80, $44, $44, $44, $44, $3C, $04, $19, $00, $80, $80, $7C, $08, $10, $20, $7D 
byte        $28, $28, $80, $38, $44, $44, $44, $39, $00, $28, $80, $38, $44, $44, $44, $39 
byte        $10, $10, $80, $38, $08, $38, $48, $35, $00, $28, $80, $48, $48, $48, $48, $35 
byte        $28, $28, $80, $48, $48, $48, $48, $35, $00, $80, $80, $3C, $68, $28, $28, $29 
byte        $00, $38, $20, $20, $20, $20, $20, $39, $00, $38, $08, $08, $08, $08, $08, $39 
byte        $00, $80, $10, $20, $7C, $20, $10, $01, $00, $80, $10, $08, $7C, $08, $10, $01 
byte        $00, $10, $10, $10, $10, $54, $38, $11, $00, $1C, $10, $10, $10, $50, $30, $11 
byte        $00, $80, $80, $04, $48, $50, $60, $41, $08, $14, $10, $10, $10, $10, $50, $21 
byte        $00, $7C, $40, $50, $78, $50, $54, $49, $00, $10, $10, $10, $10, $10, $10, $11 
byte        $00, $80, $80, $80, $7C, $04, $04, $05, $00, $18, $20, $38, $28, $38, $08, $31 
byte        $00, $80, $04, $7C, $10, $7C, $41, $FF, $80, $38, $44, $5C, $54, $5C, $40, $3D 
byte        $00, $1C, $10, $10, $20, $10, $10, $1D, $00, $38, $08, $08, $04, $08, $08, $39 
byte        $00, $80, $80, $20, $54, $08, $00, $01, $00, $38, $44, $44, $44, $28, $28, $6D 
byte        $80, $48, $48, $48, $48, $74, $40, $41, $30, $48, $10, $20, $78, $00, $00, $01 
byte        $00, $80, $80, $6C, $54, $6C, $00, $01, $00, $7C, $40, $20, $18, $20, $40, $7D 
byte        $00, $7C, $28, $28, $28, $28, $28, $29, $FD, $E5, $E5, $D5, $C5, $D6, $1E, $F5 
byte        $21, $47, $40, $38, $3C, $7E, $E6, $18, $C4, $9F, $36, $DD, $CB, $05, $76, $C4 
byte        $98, $37, $FD, $21, $F7, $31, $F1, $F5, $FE, $62, $38, $06, $D6, $62, $FD, $2A 
byte        $4B, $40, $26, $00, $87, $6F, $29, $29, $EB, $FD, $19, $CD, $9C, $37, $ED, $53
        
DAT
            Org
Init
            mov     Sync_Flag,PAR
            mov     Screen_Ptr,Sync_Flag
            add     Screen_Ptr,#4
            or      outa,CS
            or      dira,CS
            or      outa,RST
            or      dira,RST
            or      outa,CLK
            or      dira,CLK
            or      outa,MOSI
            or      dira,MOSI
            or      dira,A0

            andn    OUTA,RST                                    'Reset start
            mov     Time,Delay
            add     Time,CNT
            waitcnt Time,#0
            or      OUTA,RST                                    'Reset end
            xor     Command,Command                             'Command
            andn    OUTA,CS                                     'CS low

            mov     Count,#32
            mov     Data,EA_DOGM128W_INIT1
            call    #Send_Data

            mov     Count,#32
            mov     Data,EA_DOGM128W_INIT2
            call    #Send_Data

            mov     Count,#32
            mov     Data,EA_DOGM128W_INIT3
            call    #Send_Data

            mov     Count,#16
            mov     Data,EA_DOGM128W_INIT4
            call    #Send_Data
            or      OUTA,#A0
            or      OUTA,CS                                     'CS high
Frame
            rdlong  t1,Sync_Flag
            tjz     t1,#Frame
            mov     Row,#PAGES
Sor
            xor     Command,Command                             'Command
            andn    OUTA,CS                                     'CS low
            mov     Data,#EA_DOGM128W_COLUMN                    'Goto 0. column
            shl     Data,#24
            mov     Count,#16
            call    #Send_Data
            
            mov     Data,#EA_DOGM128W_PAGE                      'Set page
            sub     Data,Row
            add     Data,#PAGES
            shl     Data,#24
            mov     Count,#8
            call    #Send_Data
            or      OUTA,CS                                     'CS high
            mov     Col,#TILES

            mov     Data,Screen_Ptr
            mov     t1,#PAGES
            sub     t1,Row
            shl     t1,#7
            add     t1,Data
Oszlop
            mov     Command, #1                                 'Data
            rdlong  Data,t1

            andn    OUTA,CS                                     'CS low
            mov     Count,#32
            call    #Send_Data
            or      OUTA,CS                                     'CS high

            add     t1,#4
            djnz    Col,#Oszlop
            djnz    Row,#Sor

            wrlong  Row,Sync_Flag                
            jmp     #Frame

Send_Data
            test    Command,#1  WC
            muxc    OUTA,A0                        
Loop
            rol     Data,#1     WC
if_c        or      OUTA,MOSI                                   'Data high
if_nc       andn    OUTA,MOSI                                   'Data low
            andn    OUTA,CLK
            or      OUTA,CLK
            djnz    Count,#Loop
Send_Data_Ret
            ret

Sync_Flag             long 0
CS                    long 0
RST                   long 0
CLK                   long 0
MOSI                  long 0
A0                    long 0

                                    

EA_DOGM128W_INIT1     long $40A1C0A6
EA_DOGM128W_INIT2     long $A22FF800
EA_DOGM128W_INIT3     long $278116AC
EA_DOGM128W_INIT4     long $00AF0000
EA_DOGM128W_HOME      long $B0100000

Delay                 long 80_000_00 


Time        RES 1            

t1          RES 1

Command     RES 1            
Data        RES 1
Count       RES 1

Screen_Ptr  RES 1

Col         RES 1
Row         RES 1