// Copyright  2002-2010 Microchip Technology Inc.  All rights reserved.
// See Microchip TCP/IP Stack documentation for license information.


// Determines when a request is considered "timed out"
var timeOutMS = 5000; //ms
 
// Stores a queue of AJAX events to process
var ajaxList = new Array();

// Initiates a new AJAX command
//	url: the url to access
//	container: the document ID to fill, or a function to call with response XML (optional)
//	repeat: true to repeat this call indefinitely (optional)
//	data: an URL encoded string to be submitted as POST data (optional)
function newAJAXCommand(url, container, repeat, data)
{
	// Set up our object
	var newAjax = new Object();
	var theTimer = new Date();
	newAjax.url = url;
	newAjax.container = container;
	newAjax.repeat = repeat;
	newAjax.ajaxReq = null;
	if(data!=null)data='Frissites: 1sec';
	// Create and send the request
	if(window.XMLHttpRequest) {
        newAjax.ajaxReq = new XMLHttpRequest();
       // newAjax.ajaxReq.open((data==null)?"GET":"POST", newAjax.url, true);
        newAjax.ajaxReq.open("POST", newAjax.url, true);
		newAjax.ajaxReq.send(data);
    // If we're using IE6 style (maybe 5.5 compatible too)
    } else if(window.ActiveXObject) {
        newAjax.ajaxReq = new ActiveXObject("Microsoft.XMLHTTP");
        if(newAjax.ajaxReq) {
         //   newAjax.ajaxReq.open((data==null)?"GET":"POST", newAjax.url, true);
			newAjax.ajaxReq.open("POST", newAjax.url, true);
            newAjax.ajaxReq.send(data);
        }
    }
    
    newAjax.lastCalled = theTimer.getTime();
    
    // Store in our array
    ajaxList.push(newAjax);
}

// Loops over all pending AJAX events to determine if any action is required
function pollAJAX() {	
	var curAjax = new Object();
	var theTimer = new Date();
	var elapsed;
	
	// Read off the ajaxList objects one by one
	for(i = ajaxList.length; i > 0; i--)
	{
		curAjax = ajaxList.shift();
		if(!curAjax)
			continue;
		elapsed = theTimer.getTime() - curAjax.lastCalled;
				
		// If we suceeded
		if(curAjax.ajaxReq.readyState == 4 && curAjax.ajaxReq.status == 200) {
			// If it has a container, write the result
			if(typeof(curAjax.container) == 'function'){
				curAjax.container(curAjax.ajaxReq.responseXML.documentElement);
			} else if(typeof(curAjax.container) == 'string') {
				document.getElementById(curAjax.container).innerHTML = curAjax.ajaxReq.responseText;
			} // (otherwise do nothing for null values)
			
	    	curAjax.ajaxReq.abort();
	    	curAjax.ajaxReq = null;

			// If it's a repeatable request, then do so
			if(curAjax.repeat)
				newAJAXCommand(curAjax.url, curAjax.container, curAjax.repeat, true);
			continue;
		}
		
		// If we've waited over 1 second, then we timed out
		if(elapsed > timeOutMS) {
			// Invoke the user function with null input
			if(typeof(curAjax.container) == 'function'){
				curAjax.container(null);
			} else {
				// Alert the user
				alert("Command failed.\nConnection to development board was lost.");
			}

	    	curAjax.ajaxReq.abort();
	    	curAjax.ajaxReq = null;
			
			// If it's a repeatable request, then do so
			if(curAjax.repeat)
				newAJAXCommand(curAjax.url, curAjax.container, curAjax.repeat, true);
			continue;
		}
		
		// Otherwise, just keep waiting
		ajaxList.push(curAjax);
	}
	
	// Call ourselves again in 10ms
//	setTimeout("pollAJAX()",750);
	
}
			
// Parses the xmlResponse returned by an XMLHTTPRequest object
//	xmlData: the xmlData returned
//  field: the field to search for
function getXMLValue(xmlData, field) {
	try {
		if(xmlData.getElementsByTagName(field)[0].firstChild.nodeValue)
			return xmlData.getElementsByTagName(field)[0].firstChild.nodeValue;
		else
			return null;
	} catch(err) { return null; }
}

//kick off the AJAX Updater
setTimeout("pollAJAX()",500);
//setInterval("pollAJAX()",750);

/*

	  	var xmlhttp;
		
		function loadXMLDoc(url, data, cfunc)
		{
			if (window.XMLHttpRequest)
			{// code for IE7+, Firefox, Chrome, Opera, Safari
				xmlhttp = new XMLHttpRequest();
			}
			else
			{// code for IE6, IE5
			   xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
			}
			
			xmlhttp.open("POST", url , true);  //true=> asszinkron md (ajax)
			xmlhttp.onreadystatechange = cfunc;
			//Send the proper header information along with the request
			xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
			xmlhttp.setRequestHeader("Content-length", data.length);
			xmlhttp.setRequestHeader("Connection", "close");                
			xmlhttp.send(data);
			
		}

		function sendPostFunc(surl, adat, neve)
		{
			var XMLdata;
			var data, inx;
			adat=neve+'='+adat+'&';
			loadXMLDoc(surl, adat, function(){ //Ez fut le vlaszkor
				if (xmlhttp.readyState == 4 && xmlhttp.status == 200)
				{
					XMLdata = xmlhttp.responseXML; //responseXML
					for(inx=0;inx<23;inx++){
						data=XMLdata.getElementsByTagName("adat" + inx)[0].childNodes[0].nodeValue 
						if(inx==0 || inx==1 || inx==8 || inx==9) data=data/10;
						if(inx==14){
							if(data==1)data="Stop";
							if(data==2)data="Begyjts";
							if(data==3)data="Bemelegts";
							if(data==4)data="Szablyzott";
							if(data==5)data="Lngtarts";
							if(data==6)data="Fellobbants";
							if(data==7)data="Tisztts";
						}
						if(inx==15){
							if(data==0) document.getElementById("txHofok15").style.background = "green";
							if(data==1) document.getElementById("txHofok15").style.background = "red";	
							document.getElementById("txHofok15").value = xmlhttp.readyState;
						}
						if(inx<15)document.getElementById("txHofok" + inx).value = data;						
					}        
				}                  
			}   ); 
			setTimeout("sendPostFunc('valasz.xml', 'Refres', '0,5sec')",2000);			
		} 
     setTimeout("sendPostFunc('valasz.xml', 'Refres', '0,5sec')",100); 		
		
     
  	//	setInterval("sendPostFunc('valasz.xml', 'Refres', '0,5sec')",1000);
 	//	setInterval("sendPostFunc('POST_teszt.cgi', 'Status', ' keres')",2000);
     //setTimeout(document.getElementById ('p1').style.color = 20 ,1000);
	 //setTimeout(document.write('<body style="background-color: #ff0000">'), 1000);	 
	 //setTimeout(document.write('<body style="background-color: #00ff00">'), 2000);
	 //document.write('<p1 style="color: #00ff00">')
	 
	// setTimeout("Dinamikus_formazas_teszt()",3000);
	 /*
	function Dinamikus_formazas_teszt(){
		
		document.getElementById("txHofok15").style.background = "green";
		alert("Lefutott.");	
		
	}
*/
