#include "main.h"


/******************************************************************************/
/*						    IC1, IC2, IC7 megszakitas                         */
/******************************************************************************/
void __attribute__((__interrupt__, no_auto_psv)) _IC1Interrupt(void)
{
	IFS0bits.IC1IF = 0;	// Clear interrupt flag
//	LATAbits.LATA4 = ~LATAbits.LATA4;
	commutation();
}

void __attribute__((__interrupt__, no_auto_psv)) _IC2Interrupt(void)
{
	IFS0bits.IC2IF = 0;	// Clear interrupt flag
	commutation();
}

void __attribute__((__interrupt__, no_auto_psv)) _IC7Interrupt(void)
{
	unsigned long int mv;
	int mvc;
	char voltageRS232[6]={'0', '0', '0', '0', '0', '0'};
	
	mv = ADCGetSample(1);
	
	if (mv<100000)
	{
		mvc = 0;
	}
	if (mv<10000)
	{
		mvc = 1;
	}
	if (mv<1000)
	{
		mvc = 2;
	}
	if (mv<100)
	{
		mvc = 3;
	}
	if (mv<10)
	{
		mvc = 4;
	}
	if(mv>0)
	{
	LATAbits.LATA4 = 1;
	}
	else
	{
		LATAbits.LATA4=0;
	}
//	ultoa(mv, &voltageRS232[mvc]);
	
	IFS1bits.IC7IF = 0;	// Clear interrupt flag
	commutation();
	UARTSendChar(mv);
}

/******************************************************************************/
/*					            U1RX megszakitas                              */
/******************************************************************************/
void __attribute__((__interrupt__, no_auto_psv)) _U1RXInterrupt(void)
{
	IFS0bits.U1RXIF = 0; //RX megszakitas flag torlese
	TRISAbits.TRISA4 = 0;
//	LATAbits.LATA4 = ~LATAbits.LATA4;
}
