#include "main.h"

char mode;
char direction;
char deg;
int speed;
//int i=2;

/******************************************************************************/
/*								Kommutacio									  */
/******************************************************************************/
void commutation(void)
{
 char i;
 
 	i=chkPos();
 	
 	if(direction==1)
	{
		if(i<=3)
		{
			i+=3;
		}
		else if(i>3)
		{
			i-=3;
		}
	}
 	
	switch(i)
	{
		case 1 : PWMCON1 = 0x0741; break;
		case 2 : PWMCON1 = 0x0742; break;
		case 3 : PWMCON1 = 0x0712; break;
		case 4 : PWMCON1 = 0x0714; break;
		case 5 : PWMCON1 = 0x0724; break;
		case 6 : PWMCON1 = 0x0721; break;
	}
}



/******************************************************************************/
/*							Pozicio lekerdezese								  */
/******************************************************************************/

unsigned char chkPos(void)
{
	if(mode==0)
	{
		return chkPosSensored();
	}
	
	if(mode==1)
	{
		return chkPosSensorless();
	}
	
	return 0;
}

unsigned char chkPosSensored(void) 
{
 unsigned char hall;
	
	if(deg==0)		//120 deg
	{
		if (( PORTBbits.RB7 == 0 ) & ( PORTBbits.RB4 == 0 ) & ( PORTBbits.RB3 == 1 ))
		{
			hall = 1;	
		}
	
		if (( PORTBbits.RB7 == 0 ) & ( PORTBbits.RB4 == 1 ) & ( PORTBbits.RB3 == 1 ))
		{
			hall = 2;
		}
	
		if (( PORTBbits.RB7 == 0 ) & ( PORTBbits.RB4 == 1 ) & ( PORTBbits.RB3 == 0 ))
		{
			hall = 3;
		}
	
		if (( PORTBbits.RB7 == 1 ) & ( PORTBbits.RB4 == 1 ) & ( PORTBbits.RB3 == 0 ))
		{
			hall = 4;
		}
	
		if (( PORTBbits.RB7 == 1 ) & ( PORTBbits.RB4 == 0 ) & ( PORTBbits.RB3 == 0 ))
		{
			hall = 5;
		}
	
		if (( PORTBbits.RB7 == 1 ) & ( PORTBbits.RB4 == 0 ) & ( PORTBbits.RB3 == 1 ))
		{
			hall = 6;
		}
	}
	
	if(deg==1)		//60 deg
	{
		if (( PORTBbits.RB7 == 0 ) & ( PORTBbits.RB4 == 0 ) & ( PORTBbits.RB3 == 1 ))
		{
			hall = 1;
		}
	
		if (( PORTBbits.RB7 == 0 ) & ( PORTBbits.RB4 == 1 ) & ( PORTBbits.RB3 == 1 ))
		{
			hall = 2;
		}
	
		if (( PORTBbits.RB7 == 1 ) & ( PORTBbits.RB4 == 1 ) & ( PORTBbits.RB3 == 1 ))
		{
			hall = 3;
		}
	
		if (( PORTBbits.RB7 == 1 ) & ( PORTBbits.RB4 == 1 ) & ( PORTBbits.RB3 == 0 ))
		{
			hall = 4;
		}
	
		if (( PORTBbits.RB7 == 1 ) & ( PORTBbits.RB4 == 0 ) & ( PORTBbits.RB3 == 0 ))
		{
			hall = 5;
		}
		
		if (( PORTBbits.RB7 == 0 ) & ( PORTBbits.RB4 == 0 ) & ( PORTBbits.RB3 == 0 ))
		{
			hall = 6;	
		}
	}
	return hall;
}

unsigned char chkPosSensorless(void) 
{
 return 0;
}

/******************************************************************************/
/*							Sebesseg beallitasa								  */
/******************************************************************************/
void setSpeed(void)
{
 P1DC1 = P1DC2 = P1DC3 = speed;		//kitltsi tnyez osszes hdg, max. FFF
}

/******************************************************************************/
/*						1 karakter kuldese soros porton						  */
/******************************************************************************/
void UARTSendChar(char d)
{
	while(U1STAbits.UTXBF);
	U1TXREG = d;	
}

unsigned int ADCGetSample(char i)
{
	unsigned int high_buffer=0;
	unsigned int low_buffer=0;
	
	SPISS = 0; /* select A/D device */
	SPI1BUF = 0b0000110; /* output start bit */
	while(SPI1STATbits.SPITBF!=0){}	/* wait for transfer complete */
	
	//CH 0 kivalsztasa
	if(i==0)
	{
		SPI1BUF = 0x40;
	}
	//CH1 kivalasztasa
	if(i==1)
	{
		SPI1BUF = 0x40;
	}	
	
	while(SPI1STATbits.SPITBF!=0){}	/* wait for transfer complete */
	
	high_buffer = SPI1BUF & 0x0F;
	high_buffer <<= 8;

	SPI1BUF = 0x00; /* output dummy word */
	while(SPI1STATbits.SPITBF!=0){}	/* wait for transfer complete */
	
	SPISS = 1; /* de-select A/D device */

	low_buffer = SPI1BUF;
	high_buffer += low_buffer;

	return high_buffer;
}
