#include "main.h"

void initOscillator(void)
{
 // Configure PLL prescaler, PLL postscaler, PLL divisor
 PLLFBD=30; // M = 32
 CLKDIVbits.PLLPOST = 0;// N2 = 2
 CLKDIVbits.PLLPRE = 0; // N1 = 2
 // Initiate Clock Switch to Primary Oscillator with PLL (NOSC = 0b011)
 __builtin_write_OSCCONH(0x03);
 __builtin_write_OSCCONL(0x01);
 // Wait for Clock switch to occur
 while (OSCCONbits.COSC!= 0b011);
 // Wait for PLL to lock
 while(OSCCONbits.LOCK!= 1) {};
}

void initMCPWM(void)
{
 P1TCON = 0b100;			//1:4 precaler, nincs postscaler, szabadon futo mod
 P1TPER = 0x7FFE;			//305Hz, maximalis kitoltes: 0xFFFE, 16 bit
 PWM1CON1 = 0xF00;			//A PWM fuggetlen modban, az osszes pwm kimenet kikapcsolva
 P1TCONbits.PTEN = 1;		//A PWM idoalap bekapcsolva, modul inditasa		
}

void initRP(void)
{
 AD1PCFGL = 0x1FF;
 RPINR7bits.IC1R = 0x3;		// IC1 az RP3 lab PortB3
 RPINR7bits.IC2R = 0x4;		// IC2 az RP4 lab PortB4
 RPINR10bits.IC7R = 0x7;	// IC7 az RP7 lab Portb7
 RPINR18bits.U1RXR = 0x8;	// U1RX az RP8 lab
 RPINR20bits.SDI1R = 0x1;	// SDI az RP1 lab

 RPOR4bits.RP9R = 0x3;		// U1TX az RP9 lab
 RPOR1bits.RP2R = 0x7;		// SDO az RP2 lab
 RPOR0bits.RP0R = 0x8;		// SCK az RP0 lab
}

void initIC(void)
{
 IC1CON = 1;				//Input Capture inicializalasa
 IC2CON = 1;				//minden esetben megszakitas
 IC7CON = 1;				//felfuto es lefuto elre
}

void initSPI(void)
{
	TRISAbits.TRISA1 = 0;	//SS lab kimenet
	SPISS = 1;		//SS kimenet 1 szint
// SPI1STAT = 0x0;
 SPI1CON1 = 0b0000000001100000;
// SPI1CON2 = 0x0;
 SPI1STATbits.SPIEN = 1;	//SPI inditasa
}

void initUART(void)
{
 U1MODE = 0;
 U1MODEbits.BRGH = 0;		//8N1, gyors atvitel
 U1STAbits.URXISEL = 0;		//megszakitas minden karakter fogadasakor
 U1BRG = 0x103;			//115200 baud
 U1MODEbits.UARTEN = 1;		//UART inditasa
 U1STAbits.UTXEN = 1;		//fogadas engedelyezese
 

/*U1MODEbits.STSEL = 0; // 1 Stop bit
U1MODEbits.PDSEL = 0; // No Parity, 8 data bits
U1MODEbits.ABAUD = 0; // Auto-Baud Disabled
U1MODEbits.BRGH = 0; // Low-Speed mode
U1BRG = BRGVAL; // BAUD Rate Setting for 9600
U1STAbits.URXISEL = 0; // Interrupt after one RX character is received;
U1MODEbits.UARTEN = 1; // Enable UART
 */
}

void initT1(void)
{
 T1CON = 0x30;
 T1CONbits.TON = 1;			//T1 inditasa
}

void initInterrupts(void)
{
 IPC0bits.T1IP = 0x1;		//T1 megszakitas prioritasa	1
 IFS0bits.T1IF = 0;			//megszakitas flag torlese
 IEC0bits.T1IE = 1;			//T1 megszakitas engedelyezese
 
 IPC0bits.IC1IP = 0x2;		//IC1 megszakitas prioritasa 2
 IFS0bits.IC1IF = 0;		//megszakitas flag torlese
 IEC0bits.IC1IE = 1;		//IC1 megszakitas engedelyezese
 
 IPC1bits.IC2IP = 0x2;		//IC2 megszakitas prioritasa 2
 IFS0bits.IC2IF = 0;		//megszakitas flag torlese
 IEC0bits.IC2IE = 1;		//IC2 megszakitas engedelyezese
 
 IPC5bits.IC7IP = 0x2;		//IC7 megszakitas prioritasa 2
 IFS1bits.IC7IF = 0;		//megszakitas flag torlese
 IEC1bits.IC7IE = 1;		//IC7 megszakitas engedelyezese*/
 
 IPC2bits.U1RXIP = 0x3;		//RX megszakitas prioritasa 3
 IFS0bits.U1RXIF = 0;		//megszakitas flag torlese
 IEC0bits.U1RXIE = 1;		//RX megszakitas engedelyezese
}
