; Binary LED Clock with binary output (4 bit nibbles mutiplexed)
; By Hein Ragas
; http://home.publishnet.nl/~hragas
; Version 1.0
; Clock functionality ONLY


; Ports:
;				18 pin device			28 pin device
; 		RA7		Quartz oscillator		Quartz oscillator
; 		RA6		Quartz oscillator		Quartz oscillator
; 		RA5		7 segment display type	7 segment display type		H for CC, L for CA
; 		RA4		Mode					Mode
; 		RA3		Binary D output			Binary D output
; 		RA2		Binary C output			Binary C output
; 		RA1		Binary B output			Binary B output
; 		RA0		Binary A output			Binary A output
;
;
; 		RB7		Hour   setting button	Hour   setting button
; 		RB6		Minute setting button	Minute setting button
; 		RB5		Digit drive 16 hour		Digit drive 16 hour
; 		RB4		Digit drive  1 hour		Digit drive  1 hour
; 		RB3		Digit drive 16 minute	Digit drive 16 minute
; 		RB2		Digit drive  1 minute	Digit drive  1 minute
; 		RB1		Digit drive 16 second	Digit drive 16 second
; 		RB0		Digit drive  1 second	Digit drive  1 second
;
;
;
;	MCLR
; 		RA5								RE3


	title "Binary LED Clock"

	ifdef	__16F627
	list P = 16F627
	include "p16F627.inc"
	__CONFIG _CP_OFF & _XT_OSC & _WDT_OFF & _PWRTE_ON & _MCLRE_OFF & _BODEN_OFF & _LVP_OFF
	endif

	ifdef	__16F627A
	list P = 16F627A
	include "p16F627A.inc"
	__CONFIG _CP_OFF & _XT_OSC & _WDT_OFF & _PWRTE_ON & _MCLRE_OFF & _BODEN_OFF & _LVP_OFF
	endif

	ifdef	__16F628
	list P = 16F628
	include "p16F628.inc"
	__CONFIG _CP_OFF & _XT_OSC & _WDT_OFF & _PWRTE_ON & _MCLRE_OFF & _BODEN_OFF & _LVP_OFF
	endif

	ifdef	__16F628A
	list P = 16F628A
	include "p16F628A.inc"
	__CONFIG _CP_OFF & _XT_OSC & _WDT_OFF & _PWRTE_ON & _MCLRE_OFF & _BODEN_OFF & _LVP_OFF
	endif

	ifdef	__16F870
	list P = 16F870
	include "p16F870.inc"
	__CONFIG _CP_OFF & _XT_OSC & _WDT_OFF & _PWRTE_ON & _BOREN_OFF & _LVP_OFF
	endif

	ifdef	__16F871
	list P = 16F871
	include "p16F871.inc"
	__CONFIG _CP_OFF & _XT_OSC & _WDT_OFF & _PWRTE_ON & _BOREN_OFF & _LVP_OFF
	endif

	ifdef	__16F872
	list P = 16F872
	include "p16F872.inc"
	__CONFIG _CP_OFF & _XT_OSC & _WDT_OFF & _PWRTE_ON & _BOREN_OFF & _LVP_OFF
	endif

	ifdef	__16F873
	list P = 16F873
	include "p16F873.inc"
	__CONFIG _CP_OFF & _XT_OSC & _WDT_OFF & _PWRTE_ON & _BOREN_OFF & _LVP_OFF
	endif

	ifdef	__16F873A
	list P = 16F873A
	include "p16F873A.inc"
	__CONFIG _CP_OFF & _XT_OSC & _WDT_OFF & _PWRTE_ON & _BOREN_OFF & _LVP_OFF
	endif

	ifdef	__16F876
	list P = 16F876
	include "p16F876.inc"
	__CONFIG _CP_OFF & _XT_OSC & _WDT_OFF & _PWRTE_ON & _BOREN_OFF & _LVP_OFF
	endif

	ifdef	__16F876A
	list P = 16F876A
	include "p16F876A.inc"
	__CONFIG _CP_OFF & _XT_OSC & _WDT_OFF & _PWRTE_ON & _BOREN_OFF & _LVP_OFF
	endif

	ifdef	__16F882
	list P = 16F882
	include "p16F882.inc"
	__CONFIG _CONFIG1, _CP_OFF & _XT_OSC & _WDT_OFF & _PWRTE_ON & _MCLRE_OFF & _BOR_OFF & _LVP_OFF
	__CONFIG _CONFIG2, _BOR40V & _WRT_OFF
	endif

	ifdef	__16F883
	list P = 16F883
	include "p16F883.inc"
	__CONFIG _CONFIG1, _CP_OFF & _XT_OSC & _WDT_OFF & _PWRTE_ON & _MCLRE_OFF & _BOR_OFF & _LVP_OFF
	__CONFIG _CONFIG2, _BOR40V & _WRT_OFF
	endif

	ifdef	__16F886
	list P = 16F886
	include "p16F886.inc"
	__CONFIG _CONFIG1, _CP_OFF & _XT_OSC & _WDT_OFF & _PWRTE_ON & _MCLRE_OFF & _BOR_OFF & _LVP_OFF
	__CONFIG _CONFIG2, _BOR40V & _WRT_OFF
	endif

	cblock	0x70
; Variables for delay loop
teller
teller2

; Variables for time-keeping
sece			; Second units
mine			; Minute units
hre				; Hour units

; Variables for the one second timer
bres_hi			; hi byte of our 24bit variable
bres_mid		; mid byte
bres_lo			; lo byte

; Variables to save register statusses during interrupt
temp_s		
temp_w		

; Variables for debouncing and inputs
bounce_timer	; Counter for the debounce routine
		endc

		cblock	0x60
csa			
cva			
count_A		
count_B		
prev_val
disp_type
		endc

			ORG 0x0		
		GOTO 	init

            ORG	0x4		; Choose starting adress

; Interrupt routine. This is called every 256 instructions.
isr		MOVWF	temp_w          ; save w register
      	MOVF	STATUS, W       ; W = STATUS
		clrf	STATUS
       	MOVWF	temp_s          ; save STATUS register
          	
          	; First, see if we need to call the debouncing routine
          	; We don't call the debouncing routine every interrupt, but every 10
          	;   interrupts. That's once every 2560 instructions. Because an input needs
          	;   to be the same for 4 consecutive calls to the debouncing routine, it
          	;   needs to be the same for roughly 0.01 seconds.
       	DECFSZ	bounce_timer, f	; Decrement bounce_timer, see if it's 0
		GOTO 	bookkeeping	; Not 0, skip the debouncing routine
		
		MOVLW	009h		; Bounce_timer == 0
		MOVWF	bounce_timer; Reset bounce_timer to 9
		
		CALL	read_inputs
		CALL	debounce
		CALL	process_inputs

          	; Here comes the bookkeeping for the timer routine
bookkeeping
		TSTF 	bres_mid	; first test for mid==0
		SKPNZ				; nz = no underflow needed
		DECF 	bres_hi,f	; z, so is underflow, so dec the msb

		DECFSZ	bres_mid,f	; dec the mid byte (subtract 256)
		GOTO 	end_isr		; nz, so definitely not one second yet.

		TSTF 	bres_hi		; test hi for zero too
		SKPZ				; z = both hi and mid are zero, is one second!
		GOTO 	end_isr		; nz, so not one second yet.

		MOVLW 	0x0F		; get msb value 
		MOVWF 	bres_hi		; load in msb
		MOVLW 	0x42		; get mid value
		MOVWF 	bres_mid	; load in mid
		MOVLW 	0x40		; lsb value to add
		ADDWF 	bres_lo,f	; add it to the remainder already in lsb
		SKPNC				; nc = no overflow, so mid is still ok
		INCF 	bres_mid,f	; c, so lsb overflowed, so inc mid

       	CALL 	continue	; A second has passed, increase the second count          	
          	
							; End of the interrupt routine
end_isr
       	BCF		INTCON, T0IF; clear the TMR0 flag bit
		MOVF	temp_s, W	; Put STATUS and W back where they belong
       	MOVWF	STATUS
       	SWAPF	temp_w, F
       	SWAPF	temp_w, W
       	RETFIE				; Return from interrupt


; Initialisation routine
init
							; Init all pins to digital I/O
	errorlevel -302
	ifdef	CMCON
		banksel	CMCON
		movlw	0x07
		movwf	CMCON
		clrf	STATUS
	endif
	ifdef	ADCON1
		banksel	ADCON1
		movlw	0x07
		movwf	ADCON1
		clrf	STATUS
	endif
	ifdef	ANSEL
		banksel	ANSEL
		clrf	ANSEL
	  ifdef	ANSELH
		clrf	ANSELH
	  endif
	endif
		clrf	STATUS

		BSF 	STATUS,RP0	; Choose bank 1
		CLRF	TRISA		; All pins of port A are outputs
	ifdef	TRISC
		clrf	TRISC		; All pins of port C are outputs
	endif
		movlw	0xC0
		movwf	TRISB		; All pins of port B are outputs except for the last two
		MOVLW	b'10001000'	; Set the options (prescaler for watchdog timer)
		MOVWF	OPTION_REG
	    BCF 	STATUS,RP0	; Choose bank 0
	errorlevel +302

; Sets the initial values. We start 9 seconds before midnight!
initial_vals
		MOVLW	.51
		MOVWF	sece
		MOVLW	.59
		MOVWF	mine
		MOVLW	.23
		MOVWF	hre
		; Also, set the variables for the counters etc.
		MOVLW	009h
		MOVWF	bounce_timer
		CLRF	csa
		CLRF	cva
		CLRF	count_A
		CLRF	count_B
		CLRF	prev_val
		
		MOVLW	0x0F		; get msb value 
		MOVWF	bres_hi		; put in hi
		MOVLW	0x42 +1		; get mid value (note we added 1 to it)
		MOVWF	bres_mid	; put in mid
		MOVLW	0x40		; get lsb value
		MOVWF	bres_lo		; put in mid
		
		CLRF	INTCON
		BSF		INTCON, T0IE
		BSF		INTCON, GIE	; Set Timer interrupt

; Routine to show the numbers on the display
shownumbers		
		MOVLW	0xFF
		btfsc	PORTA,5
		clrw
		MOVWF	PORTB		; All LEDs off
		MOVF	sece,w		; Load mine into W
		MOVWF	PORTA		; Set the LEDs
		btfsc	PORTA,5
		BcF		PORTB, 0	; Show the first row
		btfss	PORTA,5
		BsF		PORTB, 0	; Show the first row
		CALL	delay

		MOVLW	0xFF
		btfsc	PORTA,5
		clrw
		MOVWF	PORTB		; All LEDs off
		SWAPF	sece,w		; Load mine into W
		MOVWF	PORTA		; Set the LEDs
		btfsc	PORTA,5
		BcF		PORTB, 1	; Show the second row
		btfss	PORTA,5
		BsF		PORTB, 1	; Show the second row
		CALL	delay

		MOVLW	0xFF
		btfsc	PORTA,5
		clrw
		MOVWF	PORTB		; All LEDs off
		MOVF	mine,w		; Load mine into W
		MOVWF	PORTA		; Set the LEDs
		btfsc	PORTA,5
		BcF		PORTB, 2	; Show the third row
		btfss	PORTA,5
		BsF		PORTB, 2	; Show the third row
		CALL	delay

		MOVLW	0xFF
		btfsc	PORTA,5
		clrw
		MOVWF	PORTB		; All LEDs off
		SWAPF	mine,w		; Load mint into W
		MOVWF	PORTA		; Set the LEDs
		btfsc	PORTA,5
		BcF		PORTB, 3	; Show the fourth row
		btfss	PORTA,5
		BsF		PORTB, 3	; Show the fourth row
		CALL	delay

		MOVLW	0xFF
		btfsc	PORTA,5
		clrw
		MOVWF	PORTB		; All LEDs off
		MOVF	hre,w		; Load hre into W
		MOVWF	PORTA		; Set the LEDs
		btfsc	PORTA,5
		BcF		PORTB, 4	; Show the fifth row
		btfss	PORTA,5
		BsF		PORTB, 4	; Show the fifth row
		CALL	delay

		MOVLW	0xFF
		btfsc	PORTA,5
		clrw
		MOVWF	PORTB		; All LEDs off
		SWAPF	hre,w		; Load hrt into W
		MOVWF	PORTA		; Set the LEDs
		btfsc	PORTA,5
		BcF		PORTB, 5	; Show the sixth row
		btfss	PORTA,5
		BsF		PORTB, 5	; Show the sixth row
		CALL	delay

		GOTO	shownumbers	; Just keep on showing those numbers -- the
					;   rest of the functionality is called from the interrupt
					;   routine.

; This routine is called whenever a second has passed.
continue
		INCF	sece, f		; Increase sece
		MOVF	sece, w
		ADDLW	-.60		; sece > 59?
		SKPC
		RETURN

overflow_sect
		CLRF	sece		; Set sect back to 0
		INCF	mine, f		; Increase mine
		MOVF	mine, w
		ADDLW	-.60		; mine > 59?
		SKPC
		RETURN

overflow_mint
		CLRF	mine		; Reset mint to 0
incr_hre
		INCF	hre, f		; Increase hre
		MOVF	hre, w
		ADDLW	-.24		; hre > 24?
		SKPC
		RETURN

		CLRF	hre
		RETURN

; Our delay loop. Waits roughly 1000 instructions, that's 1 msec
delay					
		MOVLW	00Ah		;10 times...
		MOVWF	teller
outerloop
		MOVLW	064h		;100 times...
		MOVWF	teller2
innerloop
		DECFSZ	teller2, f
		GOTO	innerloop
		DECFSZ	teller, f
		GOTO	outerloop
		RETURN

; Read the inputs
read_inputs	
		; Check minute pin, sets the appropriate bit in the csa variable
		BTFSC	PORTB, 6
		GOTO	minute_een
minute_nul
		BCF		csa, 0
		GOTO	einde_minute
minute_een
		BSF		csa, 0
einde_minute

		; Check hour pin, sets the appropriate bit in the csa variable
		BTFSC	PORTB, 7
		GOTO	hour_een
hour_nul
		BCF		csa, 1
		GOTO	einde_hour
hour_een
		BSF		csa, 1
einde_hour
		RETURN

; Debounce routine
debounce
		;Increment the vertical counter
		MOVF    count_B,W
		XORWF   count_A,F
		COMF    count_B,F

		;See if any changes occurred
		MOVF    csa,W
		XORWF   cva,W

		;Reset the counter if no change has occurred
		ANDWF   count_B,F
		ANDWF   count_A,F

		;Determine the counter's state
		MOVF    count_B,W
		IORWF   count_A,W

		;Clear all bits that are filtered-or more accurately, save
		;the state of those that are being filtered
		ANDWF   cva,F
		XORLW   0xff

		;Re-write the bits that haven't changed.
		ANDWF   csa,W
		IORWF   cva,F

		RETURN

; Process the debounced inputs
; We have two variables to work with: prev_val, which contains the previous (debounced) states of the inputs;
;   and cva, the debounced current state of the inputs.
; Each input is set as a bit in both the variables.
process_inputs
		; Check the previous value of the minute-input
		BTFSS	prev_val, 0
		GOTO	minute_was_zero
minute_was_one
		BTFSS	cva, 0
		BCF		prev_val, 0	; from 1 to 0 -> reset prev_val to 0
		GOTO	check_hour
minute_was_zero
		BTFSC	cva, 0
		GOTO	minute_press
		GOTO	check_hour

minute_press
		BSF		prev_val, 0
		CALL	overflow_sect; from 0 to 1 -> tick!
check_hour	; Check the previous value of the hour input
		BTFSS	prev_val, 1
		GOTO	hour_was_zero
hour_was_one
		BTFSS	cva, 1
		BCF		prev_val, 1	; from 1 to 0 -> reset prev_val to 0
		RETURN
hour_was_zero
		BTFSC	cva, 1
		GOTO	hour_press
		RETURN
hour_press
		BSF		prev_val, 1
		CALL	incr_hre	; from 0 to 1 -> tick!
		RETURN

		END
