#include <16f873.h>   // defines variables for PIC 16F873 MCU
#include <ports.h>    // defines variables for Pin Assignments
#include <protocol.h> // defines variables for RS232 Communication Protocol

#use delay (clock=20000000)
#use rs232(baud=38400, xmit=tx, rcv=rc)

int astep=1, bstep=1, cstep=1, dstep=1;
long max=800, min=470;

void setup_ports(void)
  { set_tris_a(0x00);set_tris_b(0x00);set_tris_c(0xF0);set_uart_speed(38400); }
 
void reset_motor(int motor)
  { if (motor==1) {output_low(a_1);output_low(a_2);output_low(a_3);output_low(a_4);output_high(led_a);}
    if (motor==2) {output_low(b_1);output_low(b_2);output_low(b_3);output_low(b_4);output_high(led_b);}
    if (motor==3) {output_low(c_1);output_low(c_2);output_low(c_3);output_low(c_4);output_high(led_c);}
    if (motor==4) {output_low(d_1);output_low(d_2);output_low(d_3);output_low(d_4);output_high(led_d);} 
  }

void reset_ports(void)
  { reset_motor(1);reset_motor(2);reset_motor(3);reset_motor(4);putc(ACKNOWLEDGE); }

void delay_micro(long delay)
  { long n;for(n=1;n<=delay;n+=3)delay_us(6); }

void power_motor(int axis, step)
  { if (axis==1) 
      { 
        if (step==1) {output_bit(a_1,1);output_bit(a_2,0);output_bit(a_3,0);output_bit(a_4,1);}
        if (step==2) {output_bit(a_1,0);output_bit(a_2,1);output_bit(a_3,0);output_bit(a_4,1);}
        if (step==3) {output_bit(a_1,0);output_bit(a_2,1);output_bit(a_3,1);output_bit(a_4,0);}
        if (step==4) {output_bit(a_1,1);output_bit(a_2,0);output_bit(a_3,1);output_bit(a_4,0);}
        output_low(led_a); 
      }
    if (axis==2) 
      { 
        if (step==1) {output_bit(b_1,1);output_bit(b_2,0);output_bit(b_3,0);output_bit(b_4,1);}
        if (step==2) {output_bit(b_1,0);output_bit(b_2,1);output_bit(b_3,0);output_bit(b_4,1);}
        if (step==3) {output_bit(b_1,0);output_bit(b_2,1);output_bit(b_3,1);output_bit(b_4,0);}
        if (step==4) {output_bit(b_1,1);output_bit(b_2,0);output_bit(b_3,1);output_bit(b_4,0);}
        output_low(led_b); 
      }    
    if (axis==3) 
      { 
        if (step==1) {output_bit(c_1,1);output_bit(c_2,0);output_bit(c_3,0);output_bit(c_4,1);}
        if (step==2) {output_bit(c_1,0);output_bit(c_2,1);output_bit(c_3,0);output_bit(c_4,1);}
        if (step==3) {output_bit(c_1,0);output_bit(c_2,1);output_bit(c_3,1);output_bit(c_4,0);}
        if (step==4) {output_bit(c_1,1);output_bit(c_2,0);output_bit(c_3,1);output_bit(c_4,0);}
        output_low(led_c); 
      }
    if (axis==4) 
      { 
        if (step==1) {output_bit(d_1,1);output_bit(d_2,0);output_bit(d_3,0);output_bit(d_4,1);}
        if (step==2) {output_bit(d_1,0);output_bit(d_2,1);output_bit(d_3,0);output_bit(d_4,1);}
        if (step==3) {output_bit(d_1,0);output_bit(d_2,1);output_bit(d_3,1);output_bit(d_4,0);}
        if (step==4) {output_bit(d_1,1);output_bit(d_2,0);output_bit(d_3,1);output_bit(d_4,0);}
        output_low(led_d); 
      }
  }

int move(short direction, long steps, int axis, step)
  { long n, delay, accsteps; 
    delay=max; accsteps=max-min;

    for(n=1;n<=steps;n++)
      {
        if(n<=accsteps)delay--;
        if(steps-n<=accsteps)delay++;
        if(direction==0)step--;else step++;
        if(step==0)step=4;
        if(step==5)step=1;
        power_motor(axis, step); 
        delay_micro(delay);
        reset_motor(axis);
      }
    return(step);
  }

long readlong(void)
  { return(256*getc() + getc()); }

void main(void)
  { 
    char incomm;
    long steps;

    setup_ports();
    reset_ports();

    while(0==0)
      { 
        output_low(led_a); output_low(led_b); output_low(led_c); output_low(led_d);
        incomm=getc();
        output_high(led_a); output_high(led_b); output_high(led_c); output_high(led_d);

        switch(incomm)
          { 
            case RESET:     reset_ports();                                    break;
            case SETUP_ACC: min=readlong(); max=readlong();                   break;
            case MOVE_A_FW: steps=readlong(); astep=move(0, steps, 1, astep); break;
            case MOVE_A_RV: steps=readlong(); astep=move(1, steps, 1, astep); break;
            case MOVE_B_FW: steps=readlong(); bstep=move(0, steps, 2, bstep); break;
            case MOVE_B_RV: steps=readlong(); bstep=move(1, steps, 2, bstep); break;
            case MOVE_C_FW: steps=readlong(); cstep=move(0, steps, 3, cstep); break;
            case MOVE_C_RV: steps=readlong(); cstep=move(1, steps, 3, cstep); break;
            case MOVE_D_FW: steps=readlong(); dstep=move(0, steps, 4, dstep); break;
            case MOVE_D_RV: steps=readlong(); dstep=move(1, steps, 4, dstep); break;
          }  

        putc(ACKNOWLEDGE);
      }
  }
