unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, QCCom32, Buttons, ExtCtrls;

type
  TForm1 = class(TForm)
    QCPort: T_QCCom32;
    xclgroup: TRadioGroup;
    setup_acc: TRadioButton;
    move_a_rv: TRadioButton;
    move_a_fw: TRadioButton; 
    move_b_rv: TRadioButton;
    move_b_fw: TRadioButton;
    move_c_rv: TRadioButton;
    move_c_fw: TRadioButton;
    reset: TRadioButton;
    Commport: TComboBox;
    commportlabel: TLabel;
    parameter1: TEdit;
    parameterlabel: TLabel;
    Executebutton: TBitBtn;
    autoreset: TCheckBox;
    parameter2: TEdit;
    move_d_fw: TRadioButton;
    move_d_rv: TRadioButton;
    procedure CommportChange(Sender: TObject);
    procedure ExecutebuttonClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure setup_accClick(Sender: TObject);
    procedure move_a_fwClick(Sender: TObject);
    procedure move_a_rvClick(Sender: TObject);
    procedure move_b_fwClick(Sender: TObject);
    procedure move_b_rvClick(Sender: TObject);
    procedure move_c_fwClick(Sender: TObject);
    procedure move_c_rvClick(Sender: TObject);
    procedure resetClick(Sender: TObject);
    procedure move_d_fwClick(Sender: TObject);
    procedure move_d_rvClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

  procedure TForm1.resetClick(Sender: TObject);
    begin parameter1.Enabled := FALSE; parameter2.Enabled := FALSE; end;

  procedure TForm1.setup_accClick(Sender: TObject);
    begin parameter1.Enabled := TRUE; parameter2.Enabled := TRUE; end;

  procedure TForm1.move_a_fwClick(Sender: TObject);
    begin parameter1.Enabled := TRUE; parameter2.Enabled := FALSE; end;

  procedure TForm1.move_a_rvClick(Sender: TObject);
    begin parameter1.Enabled := TRUE; parameter2.Enabled := FALSE; end;

  procedure TForm1.move_b_fwClick(Sender: TObject);
    begin parameter1.Enabled := TRUE; parameter2.Enabled := FALSE; end;

  procedure TForm1.move_b_rvClick(Sender: TObject);
    begin parameter1.Enabled := TRUE; parameter2.Enabled := FALSE; end;

  procedure TForm1.move_c_fwClick(Sender: TObject);
    begin parameter1.Enabled := TRUE; parameter2.Enabled := FALSE; end;

  procedure TForm1.move_c_rvClick(Sender: TObject);
    begin parameter1.Enabled := TRUE; parameter2.Enabled := FALSE; end;

  procedure TForm1.move_d_fwClick(Sender: TObject);
    begin parameter1.Enabled := TRUE; parameter2.Enabled := FALSE; end;

  procedure TForm1.move_d_rvClick(Sender: TObject);
    begin parameter1.Enabled := TRUE; parameter2.Enabled := FALSE; end;

  procedure TForm1.CommportChange(Sender: TObject);
    begin QCPort.Port := Commport.ItemIndex + 1; end;

  procedure TForm1.FormShow(Sender: TObject);
    begin QCPort.Port := 1; CommPort.ItemIndex := 0; end;

  procedure TForm1.ExecutebuttonClick(Sender: TObject);
    var
      commandcode : char;
      command     : string;
    begin
      Executebutton.Enabled := FALSE;

      if reset.Checked     then commandcode := char(1);
      if setup_acc.Checked then commandcode := char(10);

      if move_a_fw.Checked then commandcode := char(20);
      if move_a_rv.Checked then commandcode := char(21);
      if move_b_fw.Checked then commandcode := char(22);
      if move_b_rv.Checked then commandcode := char(23);
      if move_c_fw.Checked then commandcode := char(24);
      if move_c_rv.Checked then commandcode := char(25);
      if move_d_fw.Checked then commandcode := char(26);
      if move_d_rv.Checked then commandcode := char(27);

      QCPort.Open;

      setlength(command, 1);
      command[1] := commandcode;
      QCPort.Write(command);

      if (parameter1.enabled) then
        begin
          setlength(command, 2);
          command[1] := char(strtoint(parameter1.text) div 256);
          command[2] := char(strtoint(parameter1.text) mod 256);
          QCPort.Write(command);
        end;

      if (parameter2.enabled) then
        begin
          setlength(command, 2);
          command[1] := char(strtoint(parameter2.text) div 256);
          command[2] := char(strtoint(parameter2.text) mod 256);
          QCPort.Write(command);
        end;

      while(QCPort.Read = '') do;

      if autoreset.Checked then
        begin
          setlength(command, 1);
          command[1] := char(1);
          QCPort.Write(command);
          while(QCPort.Read = '') do;
        end;

      QCPort.Close;

      Executebutton.Enabled := TRUE;
    end;

end.
