/*************************************************************************
 *   2012 Microchip Technology Inc.
 *
 *  Project Name:    mTouch Framework v2.1
 *  FileName:        main.c
 *  Dependencies:    mTouch.h
 *  Processor:       See documentation for supported PIC microcontrollers
 *  Compiler:        HI-TECH Ver. 9.81 or later
 *  IDE:             MPLAB IDE v8.50 (or later) or MPLAB X
 *  Hardware:
 *  Company:
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *  Description:     Main routine
 *                   - Example implementation of the framework's API calls
 *                   - All application code should be implemented in this
 *                     or some other user-created file. This will allow
 *                     for better customer support and easier upgrades to
 *                     later firmware versions.
 *                   - See the documentation located in the docs/ folder
 *                     for a detailed guide on getting started with your
 *                     application and the mTouch framework.
 *************************************************************************/
/*************************************************************************
 * MICROCHIP SOFTWARE NOTICE AND DISCLAIMER: You may use this software, and
 * any derivatives created by any person or entity by or on your behalf,
 * exclusively with Microchip's products in accordance with applicable
 * software license terms and conditions, a copy of which is provided for
 * your referencein accompanying documentation. Microchip and its licensors
 * retain all ownership and intellectual property rights in the
 * accompanying software and in all derivatives hereto.
 *
 * This software and any accompanying information is for suggestion only.
 * It does not modify Microchip's standard warranty for its products. You
 * agree that you are solely responsible for testing the software and
 * determining its suitability. Microchip has no obligation to modify,
 * test, certify, or support the software.
 *
 * THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER
 * EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED
 * WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE, ITS INTERACTION WITH
 * MICROCHIP'S PRODUCTS, COMBINATION WITH ANY OTHER PRODUCTS, OR USE IN ANY
 * APPLICATION.
 *
 * IN NO EVENT, WILL MICROCHIP BE LIABLE, WHETHER IN CONTRACT, WARRANTY,
 * TORT (INCLUDING NEGLIGENCE OR BREACH OF STATUTORY DUTY), STRICT
 * LIABILITY, INDEMNITY, CONTRIBUTION, OR OTHERWISE, FOR ANY INDIRECT,
 * SPECIAL, PUNITIVE, EXEMPLARY, INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE,
 * FOR COST OR EXPENSE OF ANY KIND WHATSOEVER RELATED TO THE SOFTWARE,
 * HOWSOEVER CAUSED, EVEN IF MICROCHIP HAS BEEN ADVISED OF THE POSSIBILITY
 * OR THE DAMAGES ARE FORESEEABLE. TO THE FULLEST EXTENT ALLOWABLE BY LAW,
 * MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN ANY WAY RELATED TO THIS
 * SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF ANY, THAT YOU HAVE PAID
 * DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
 *
 * MICROCHIP PROVIDES THIS SOFTWARE CONDITIONALLY UPON YOUR ACCEPTANCE OF
 * THESE TERMS.
 *************************************************************************/
/** @file   main.c
 *   @brief  Example implementation of the mTouch Framework's API calls
 */
/// @cond
#include <stdio.h>
#include <htc.h>
#include "usart.h"
#include "mTouch.h"                            // Required Include
#include "mComm.h"

// CONFIGURATION SETTINGS
#include "generic_processorConfigBits.h"        // Provided for ease-of-development.
#define LED_ON  1
#define LED_OFF 0
#define ON  1
#define OFF 0
#define DISPLAY_ON 1
#define DISPLAY_OFF 0
#define LED0  LATC0
#define LED1  LATD7
#define LED2  LATE0
#define LED3  LATE1
#define LED4  LATE2
#define LED5  LATC1
#define LED6  LATC2



void Example_System_Init(void);
void interrupt ISR(void);
void value_set(char *valtozo);
void display();
void InitT1(void);
void InitInterrupt(void);
void start_stop(void);
void qsens_on_off(void);
void gombok(void);
void interrupt InterruptHandler(void);

char * x = 0x01;
char ORA = 1;
int var_ido = 0;
int akt_ido = 0;


bit gomb_state = 0;
bit timer = 0;

// #define  NULL  RD0=1,RD1=1

void main(void) {

    unsigned char read;
    OSCCON = 0b01110000;  //32MHz




    ANSELA = 0b00000000;
    ANSELB = 0b00000000;
    ANSELD = 0b00000000;
    ANSELE = 0b00000000;
    TRISA = 0b00000000;
    TRISB = 0b00000000;
    TRISC = 0b10000000;
    TRISD = 0b00000000;
    TRISE = 0b00000000;
    PORTA = 0b11111111;
    PORTB = 0b00000000;
    PORTC = 0b00000000;
    PORTD = 0b11111111;
    PORTE = 0b00000000;

    while (1) {

        read = getch();
        puts(1);

        if(read==0b00000001) LED0=ON;
        if(read==0b00000010) LED1=ON;
        if(read==0b00000011) LED2=ON;
        if(read==4) LED3=ON;
        if(read==0b00000101) LED4=ON;
        if(read==0b00000110) LED5=ON;
        if(read==0b00000111) LED6=ON;
    } // end - while(1) main loop
} // end - main() function
