;    Filename:	    szunyogriaszto.asm                                        	*
#define LastUpdate	"2013-07-08";										*
#define	VersionMajor	0x01	;										*
#define	VersionMinor	0x00	;										*


;;		errorlevel	-302

	ifdef	__12F683
		list	p=12f683              ; 12F683 can be used
		#include <p12f683.inc>        ; processor specific variable definitions
    endif
	ifndef	PCL
		error	"Incompatible processor type selected"
	endif

	__CONFIG _IESO_OFF & _CP_OFF & _CPD_OFF & _WDT_OFF & _BOD_ON & _PWRTE_ON & _FOSC_INTOSCIO & _MCLRE_OFF

	__idlocs		0xB000 | (VersionMajor << 8) | (VersionMinor)

;***** VARIABLE DEFINITIONS

;Vars in shared memory. This memory is available from any bank

  cblock	0x070
	Flags
	NewPR2
	NewCCPRL

	PR2Limit
	TMR1PostScaler
	LedCounter

	w_temp		; variable used for context saving
	status_temp	; variable used for context saving
  endc

; GPIO
bDebug		EQU	0
bLed		EQU	1
bBuzzer		EQU	2
bStart0		EQU	3
bStart1		EQU	4
bStart2		EQU	5

; Flags
bReCalculate	EQU	0
bReLoadPWM		EQU	1
;			EQU	2
;			EQU	3
;			EQU	4
;			EQU	5
;			EQU	6
;			EQU	7


;**********************************************************************
		org     0x0000           	; processor reset vector
		clrf	GPIO				; Clear outputs
		movlw	7					;
		movwf	CMCON0				; Turn off comparator
		goto    Start            	; go to beginning of program

;**********************************************************************
		org     0x0004           	; interrupt vector location

		movwf	w_temp				; context saveing
		swapf	w_temp, f
		swapf	STATUS, w

		clrf 	STATUS				; select Bank0, IRP=0 for interrupt stuff
		movwf	status_temp

		btfss	PIR1,TMR1IF
		goto	TestTMR2Int

		decfsz	TMR1PostScaler,f
		goto	TMR1IntEnd
		movlw	.3
		movwf	TMR1PostScaler
		bsf		Flags,bReCalculate

TMR1IntEnd:
		bcf		PIR1,TMR1IF

TestTMR2Int:
		btfss	PIR1,TMR2IF
		goto	IntExit
		btfss	Flags,bReLoadPWM
		goto	TMR2IntEnd

		movf	NewPR2,w
		bsf		STATUS,RP0			; Bank1
		movwf	PR2
		bcf		STATUS,RP0			; Bank0
		movf	NewCCPRL,w
		movwf	CCPR1L
		bcf		Flags,bReLoadPWM
TMR2IntEnd:
		bcf		PIR1,TMR2IF

;--------
IntExit:
		swapf	status_temp,w		; Restore context for main program
		movwf	STATUS				; This will also restore bank selection and IRP
		swapf	w_temp,w
		retfie                  	; Return from interrupt

;******************************************************************************

Start:
		bsf		STATUS,RP0			; Bank1
		clrf	ANSEL
		bcf		TRISIO,bLed
		bcf		TRISIO,bBuzzer
		bsf		PIE1,TMR1IE
		bsf		PIE1,TMR2IE
		bcf		STATUS,RP0			; Bank0

		rlf		GPIO,w
		movwf	FSR
		swapf	FSR,w
		andlw	0x07
		call	GetPR2Limit
		movwf	PR2Limit

		movlw	.66
		movwf	NewPR2
		bsf		STATUS,RP0
		movwf	PR2
		bcf		STATUS,RP0
		movlw	.33
		movwf	NewCCPRL
		movwf	CCPR1L
		movlw	.3
		movwf	TMR1PostScaler

		clrf	Flags

		clrf	TMR1L
		clrf	TMR1H

		movlw	0x0C
		movwf	CCP1CON

		movlw	0x31
		movwf	T1CON
		
		movlw	0x04
		btfss	GPIO,bDebug
		movlw	0x05
		movwf	T2CON

		movlw	0xC0
		movwf	INTCON

MainLoop:
		movf	TMR1H,w
		btfss	STATUS,Z
		bcf		GPIO,bLed

		btfss	Flags,bReCalculate
		goto 	MainLoop

		bsf		GPIO,bLed

		movf	PR2Limit,w
		subwf	NewPR2,w
		movlw	.66
		btfsc	STATUS,C
		goto	Next

		rrf		NewPR2,w
		movwf	FSR
		swapf	FSR,W
		andlw	0x0F
		addwf	NewPR2,w
		andlw	0xFE
Next:
		movwf	NewPR2
		bcf		STATUS,C
		rrf		NewPR2,w
		movwf	CCPR1L

		bsf		Flags,bReLoadPWM
		bcf		Flags,bReCalculate

		goto	MainLoop

GetPR2Limit:
		addwf	PCL,f
		retlw	.200
		retlw	.190
		retlw	.182
		retlw	.174
		retlw	.166
		retlw	.160
		retlw	.154
		retlw	.138

		end
