	list	b=4

;    Filename:	    szunyogriaszto.asm                                  *
#define LastUpdate	"2013-07-11";										*
#define	VersionMajor	0x01	;										*
#define	VersionMinor	0x02	;										*


;;		errorlevel	-302

	ifdef	__12F683
		list	p=12f683              ; 12F683 can be used
		#include <p12f683.inc>        ; processor specific variable definitions
	__CONFIG _FCMEN_OFF & _IESO_OFF & _CP_OFF & _CPD_OFF & _WDT_OFF & _BOD_ON & _PWRTE_ON & _FOSC_INTOSCIO & _MCLRE_OFF
    endif
	ifdef	__16F684
		list	p=16f684              ; 16F684 can be used
		#include <p16f684.inc>        ; processor specific variable definitions
		__CONFIG _IESO_OFF & _CP_OFF & _CPD_OFF & _WDT_OFF & _BOD_ON & _PWRTE_ON & _FOSC_INTOSCIO & _MCLRE_OFF
    endif
	ifdef	__16F627
		list	p=16f627              ; 16F627 can be used
		#include <p16f627.inc>        ; processor specific variable definitions
		__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _FOSC_INTOSCIO & _MCLRE_OFF & _LVP_OFF
    endif
	ifdef	__16F627A
		list	p=16f627A             ; 16F627A can be used
		#include <p16f627A.inc>       ; processor specific variable definitions
		__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _FOSC_INTOSCIO & _MCLRE_OFF & _LVP_OFF
    endif
	ifdef	__16F628
		list	p=16f628              ; 16F628 can be used
		#include <p16f628.inc>        ; processor specific variable definitions
		__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _FOSC_INTOSCIO & _MCLRE_OFF & _LVP_OFF
    endif
	ifdef	__16F628A
		list	p=16f628A             ; 16F628A can be used
		#include <p16f628A.inc>       ; processor specific variable definitions
		__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _FOSC_INTOSCIO & _MCLRE_OFF & _LVP_OFF
    endif
	ifndef	PCL
		error	"Incompatible processor type selected"
	endif


	__idlocs		0xB000 | (VersionMajor << 8) | (VersionMinor)

;***** VARIABLE DEFINITIONS

;Vars in shared memory. This memory is available from any bank

  cblock	0x070
	Flags
	NewPR2
	NewCCPRL
	TMR1HMask

	PR2Limit
	TMR1PostScaler
	LedCounter

	w_temp		; variable used for context saving
	status_temp	; variable used for context saving
  endc

	ifdef	GPIO
; GPIO
bDebug		EQU	3
bLed		EQU	1
bBuzzer		EQU	2
bStart0		EQU	0
bStart1		EQU	4
bStart2		EQU	5
	endif
	ifdef	PORTB
; PORTB
bDebug		EQU	7
bLed		EQU	1
bBuzzer		EQU	3
bStart0		EQU	4
bStart1		EQU	5
bStart2		EQU	6
#define	GPIO	PORTB
#define	TRISIO	TRISB
#define	CMCON0	CMCON
	endif
	ifdef	PORTC
; PORTC
bDebug		EQU	7
bLed		EQU	3
bBuzzer		EQU	5
bStart0		EQU	0
bStart1		EQU	1
bStart2		EQU	2
#define	GPIO	PORTC
#define	TRISIO	TRISC
	endif

; Flags
bReCalculate	EQU	0
bReLoadPWM		EQU	1
bNewLoop		EQU	2
bDirection		EQU	3
;			EQU	4
;			EQU	5
;			EQU	6
;			EQU	7


;**********************************************************************
		org     0x0000           	; processor reset vector
		clrf	GPIO				; Clear outputs
		movlw	7					;
		movwf	CMCON0				; Turn off comparator
		goto    Start            	; go to beginning of program

;**********************************************************************
		org     0x0004           	; interrupt vector location

		movwf	w_temp				; context saveing
		swapf	w_temp, f
		swapf	STATUS, w

		clrf 	STATUS				; select Bank0, IRP=0 for interrupt stuff
		movwf	status_temp

		btfss	PIR1,TMR1IF
		goto	TestTMR2Int

		decfsz	TMR1PostScaler,f
		goto	TMR1IntEnd
		movlw	.3
		movwf	TMR1PostScaler
		bsf		Flags,bReCalculate

TMR1IntEnd:
		bcf		PIR1,TMR1IF

TestTMR2Int:
		btfss	PIR1,TMR2IF
		goto	IntExit
		btfss	Flags,bReLoadPWM
		goto	TMR2IntEnd

		bcf		PIR1,TMR2IF
WaitOneMore:
		btfss	PIR1,TMR2IF
		goto	WaitOneMore
		
		decf	NewPR2,w
		bsf		STATUS,RP0			; Bank1
		movwf	PR2
		bcf		STATUS,RP0			; Bank0
		movf	NewCCPRL,w
		movwf	CCPR1L
		bcf		Flags,bReLoadPWM
TMR2IntEnd:
		bcf		PIR1,TMR2IF

;--------
IntExit:
		swapf	status_temp,w		; Restore context for main program
		movwf	STATUS				; This will also restore bank selection and IRP
		swapf	w_temp,w
		retfie                  	; Return from interrupt

;******************************************************************************

Start:
		bsf		STATUS,RP0			; Bank1
	ifdef	ANSEL
		clrf	ANSEL
	endif

		bcf		TRISIO,bLed
		bcf		TRISIO,bBuzzer
		bsf		PIE1,TMR1IE
		bsf		PIE1,TMR2IE
		bcf		STATUS,RP0			; Bank0

		movlw	0
		btfsc	GPIO,bStart0
		iorlw	0x01
		btfsc	GPIO,bStart1
		iorlw	0x02
		btfsc	GPIO,bStart2
		iorlw	0x04
		call	GetPR2Limit
		movwf	PR2Limit

		movlw	.16
		movwf	NewPR2
		bsf		STATUS,RP0
		addlw	-1
		movwf	PR2
		bcf		STATUS,RP0
		movlw	.8
		movwf	NewCCPRL
		movwf	CCPR1L
		movlw	.3
		movwf	TMR1PostScaler
		movlw	1 << bNewLoop
		movwf	Flags

		clrf	TMR1L
		clrf	TMR1H

		movlw	0x0C
		movwf	CCP1CON

		movlw	0x31
		movwf	T1CON
		
		movlw	0x04
		btfss	GPIO,bDebug
		movlw	0x05
		movwf	T2CON

		movlw	0xC0
		movwf	INTCON

MainLoop:
		bcf		STATUS,C
		movf	TMR1H,w
		btfsc	Flags,bNewLoop
		rrf		TMR1H,w
		addlw	0
		btfsc	STATUS,Z
		goto	TestRecalc
		bcf		GPIO,bLed
		bcf		Flags,bNewLoop

TestRecalc:
		btfss	Flags,bReCalculate
		goto 	MainLoop

		bsf		GPIO,bLed

		btfsc	Flags,bDirection
		goto	LowToHigh

HighToLow
		movf	PR2Limit,w
		xorwf	NewPR2,w
		btfsc	STATUS,Z
		goto	ToDown
Inc2:
		incf	NewPR2,f
		incf	NewPR2,f

Ready
		bcf		STATUS,C
		rrf		NewPR2,w
		movwf	NewCCPRL
		bsf		Flags,bReLoadPWM
		bcf		Flags,bReCalculate

		goto	MainLoop

LowToHigh
		movf	NewPR2,w
		xorlw	.16
		btfsc	STATUS,Z
		goto	ToUp
Dec2:
		decf	NewPR2,f
		decf	NewPR2,f
		goto	Ready

ToDown:
		bsf		Flags,bDirection
		bsf		Flags,bNewLoop

		goto	Dec2

ToUp:
		bcf		Flags,bDirection
		bsf		Flags,bNewLoop
		goto	Inc2


GetPR2Limit:
		addwf	PCL,f
		retlw	.44		; 22.727 kHz
		retlw	.42		; 23.809 kHz
		retlw	.40		; 25.000 kHz
		retlw	.38		; 26.316 kHz
		retlw	.36		; 27.777 kHz
		retlw	.34		; 29.412 kHz
		retlw	.32		; 31.250 kHz
		retlw	.30		; 33.333 kHz

;;				.28		; 35.714 kHz
;;				.26		; 38.461 kHz
;;				.24		; 41.666 kHz
;;				.22		; 45.454 kHz
;;				.20		; 50.000 kHz
;;				.18		; 55.555 kHz
;;				.16		; 62.500 kHz

		end
