/*
 * Verzio:1.0 B
 * Szerzo:Tth Lajos alias matrix64
 * matrix64@vipmail.hu
 * Dtum:2008.02.03
 * Program lersa:alap rutinok HD44780 kompatibilis LCD kijelz 
 * 4 bites kezelsre,valamint egy LED villogtatsa a fel nem hasznlt
 * portlbon(PortB.0).A program AVRStudiban HAPSIM szimultor
 * segtsgvel lett tesztelve.(http://www.helmix.at/hapsim)
 * Kp mellkelve hapsim.jpg nven.Msodlagos clom volt az ASM2
 * lehetsgeinek rvid bemutatsa.
 */


.equ	LCD_RS	=1
.equ	LCD_RW	=2
.equ	LCD_E	=3

.equ	LCD_PORT	=PORTB	

.equ	LCD_DDR		=LCD_PORT-1
.equ	LCD_PIN		=LCD_PORT-2


.equ LCD_CLR  = 0x01

.equ LCD_HOME = 0x02

/* C-bol atvett makrok,lcd utasitasok ltrehozsra 
 * Csak ASM2-ben hasznalhatok !
 * 
 */
#define LCD_ENTMODE(inc, shift) \
	(0x04 | ((inc)? 0x02: 0) | ((shift)? 1: 0))


#define LCD_DISPCTL(disp, cursor, blink) \
	(0x08 | ((disp)? 0x04: 0) | ((cursor)? 0x02: 0) | ((blink)? 1: 0))


#define LCD_SHIFT(shift, right) \
	(0x10 | ((shift)? 0x08: 0) | ((right)? 0x04: 0))


#define LCD_FNSET(if8bit, twoline, font5x10) \
	(0x20 | ((if8bit)? 0x10: 0) | ((twoline)? 0x08: 0) | \
		((font5x10)? 0x04: 0))

#define LCD_CGADDR(addr) \
	(0x40 | ((addr) & 0x3f))


#define LCD_DDADDR(addr) \
	(0x80 | ((addr) & 0x7f))




.equ	DATA	=1
.equ	CMD		=0
.def    delay1	=R19
.def    delay2	=R20

//.listmac

/* Egy byte kuldese az LCD fele,BF bit ellenorzsvel.
 * Hivas:  LCD_PUTC  DATA  -adat kuldes eseten
 *        LCD_PUTC  CMD   -utasitas kuldes eseten 
 * A byte-ot a makro meghivasa elott az  attr_l regiszterbe
 * kell helyezni!! Lasd: lcd_test.asm
 */
 	
   .MACRO  LCD_PUTC  		
		
			clt

		.IF @0
        
			set
	
		.ENDIF
    	
		rcall	lcd_put	
			
	.ENDMACRO		


/* Fejlesztes alatt,mukodo kepes delay makro 
 * korltosasokkal.
 * Hivas : pl: delay_us 1000
 * F_CPU frekvenciat Hz-ben megadni !!
 *
 */

 
 .MACRO   delay_us    
		
		.set	count=int(@0*F_CPU/1000000)

			
			.if  count==1
			nop

			.elif count==2
			
			nop
			nop
			.endif
			

		.if  (count>=3) && (count < 768)
			
				.SET        fine=count/3
			
					ldi		delay1,low(fine)
	      fine0:  	dec		delay1
					brne    fine0						
		.endif	
		
				
		.if (count>=768)
			
				.set        coarse=count/768
				
					ldi		delay2,low(coarse)
					
					ldi		delay1,0xFF
	    fine1:		dec		delay1
					brne    fine1
					
					ldi		delay1,0xFF
					
					dec  	delay2
					brne	fine1
		  
					
			.set		remain=count%768
			
			.if remain >= 3
			
			.set remain=remain/3		

					ldi		delay1,low(remain)
	     fine2:     dec		delay1
					brne    fine2
					
			.endif
			.endif
	
	
	
	.ENDMACRO 


/* Teljes string kiirasa az LCD-re Program Memoriabol 
 * Hivas:  lcd_puts  <string label>
 *
 */ 


.MACRO   lcd_puts   //label
 		

    	ldi 	zl,low(@0<<1)
		ldi 	zh,high(@0<<1)
		
loop:	lpm		r0,Z+
		
		tst    	r0
		breq	end
				
		mov		attr_l,r0
			
		LCD_PUTC  DATA
	
		rjmp   loop

end:    nop		

.ENDMACRO

/* Sajat karakter kiirasa CGRAM-ba
 * Hivas elott CGRAM cimet allitani !
 *
 */		


.MACRO 	lcd_putdef  //label
		
		ldi		cx,8

		ldi 	zl,low(@0<<1)
		ldi 	zh,high(@0<<1)

loop2:	lpm		r0,Z+
		mov		attr_l,r0

		LCD_PUTC  DATA

		dec		cx
		brne    loop2

.ENDMACRO









