/*
 ---------------- MSP430 LaunchPad + ENC28j60 Ethernet Controller ------------------------------------------
 -
 - Eredeti forrskd (Arduino):
 -                        http://trollmaker.com/article11/arduino-1-0-with-enc28j60-ethernet-shield-v1-1
 - trva MSP430g2553-ra! IAR Embedded Workbench for MSP430 IDE v5.50.2
 -                        Ksztette: Szitkovits Gbor
 ------------------------------------------------ MSP430g2553 -------------------------------------------- */

#ifndef IP_ARP_UDP_TCP_H
#define IP_ARP_UDP_TCP_H

#include "ethernet.h"

// you must call this function once before you use any of the other functions:
void init_ip_arp_udp_tcp(const uint8_t* mymac, uint8_t *myip, uint8_t wwwp);
//
uint8_t eth_type_is_arp_and_my_ip(uint8_t *buf,uint16_t len);
uint8_t eth_type_is_ip_and_my_ip(uint8_t *buf,uint16_t len);
void make_arp_answer_from_request(uint8_t *buf);
void make_echo_reply_from_request(uint8_t *buf,uint16_t len);
void make_udp_reply_from_request(uint8_t *buf,char *data,uint8_t datalen,uint16_t port);


void make_tcp_synack_from_syn(uint8_t *buf);
void init_len_info(uint8_t *buf);
uint16_t get_tcp_data_pointer(void);
uint16_t fill_tcp_data_p(uint8_t *buf,uint16_t pos, char *p_str);
uint16_t fill_tcp_data(uint8_t *buf,uint16_t pos, const char *s);
void make_tcp_ack_from_any(uint8_t *buf);
void make_tcp_ack_with_data(uint8_t *buf,uint16_t dlen);
void make_arp_request(uint8_t *buf, uint8_t *server_ip);
uint8_t arp_packet_is_myreply_arp ( uint8_t *buf );
void tcp_client_send_packet(uint8_t *buf,uint16_t dest_port, uint16_t src_port, uint8_t flags, uint8_t max_segment_size, 
	uint8_t clear_seqck, uint16_t next_ack_num, uint16_t dlength, uint8_t *dest_mac, uint8_t *dest_ip);
uint16_t tcp_get_dlength ( uint8_t *buf );


#endif /* IP_ARP_UDP_TCP_H */
