/*
 ---------------- MSP430 LaunchPad + ENC28j60 Ethernet Controller ------------------------------------------
 -
 - Eredeti forrskd (Arduino):
 -                        http://trollmaker.com/article11/arduino-1-0-with-enc28j60-ethernet-shield-v1-1
 - trva MSP430g2553-ra! IAR Embedded Workbench for MSP430 IDE v5.50.2
 -                        Ksztette: Szitkovits Gbor
 ------------------------------------------------ MSP430g2553 -------------------------------------------- */
#include <msp430.h>
#include <string.h>
#include <stdint.h>
#include "enc28j60.h"
#include "ip_arp_udp_tcp.h"
#include "web.h"
#include "spi.h"

#define LED BIT0

const unsigned char mac[6] = {0x74,0x69,0x69,0x2D,0x30,0x31}; 
uint8_t ip[4] = {192, 168, 1, 105};
uint16_t port = 80;
uint16_t data;
int32_t temp;

uint16_t ADC_conv(){
     ADC10CTL0 &= ~ENC;
     ADC10CTL0 = ADC10SHT_3 | ADC10ON | SREF_0;
     ADC10CTL1 = ADC10SSEL_0 + INCH_10;
     ADC10CTL0 |= ENC + ADC10SC;
     while (ADC10CTL1 & BUSY);
     return ADC10MEM;
} // ADC

void main( void )
{
     // Stop watchdog
     WDTCTL = WDTPW + WDTHOLD;
     
     DCOCTL = CALDCO_8MHZ;
     BCSCTL1 = CALBC1_8MHZ;
     
     P1DIR |= LED;
     P1OUT &= ~LED;
     
     enc28j60Init(mac);
     Web_setup();
     init_ip_arp_udp_tcp(mac, ip, port);
     

     while(1){
          // ------------------ Bels hmr adatok kirsa weblapra -----------------------
          data = ADC_conv();
          uint16_t temp = (uint16_t)( ((float)data*3500/1023 - 986) / (float)3.55 );
          
          if (Web_serviceRequest(port)){
               Web_print("<!DOCTYPE HTML PUBLIC -//W3C//DTD HTML 4.00 TRANSITIONAL//EN>");
               Web_print("<html><head>");
               Web_print("<meta http-equiv='refresh' content='50'>");  // oldal frisstse 50s
               Web_print("<title>MSP430g2553</title>");
               Web_print("</head><body bgcolor='#990'>");
               Web_print("<h1 align='center'>MSP430g2553 LaunchPad</h1>");
               Web_print("<h2 align='center' >MCU bels hmr rtknek kirsa</h2>");
               Web_print("<br /><br />");
               Web_print("<p align='center' style='font-size: 100px; color: #09C'>");
               Web_print_num(temp);
               Web_print(" C");
               Web_print("</p>");
               Web_respond();
          } // if
          Web_print("</body></html>");
          
//          // --------------- LaunchPad Piros LED (P1.0) ki/be kapcsolsa weboldalrl ---------------------
//          char* params;
//          if (params = Web_serviceRequest(port)){
//               Web_print("<h1 align='center'>MSP430g2553 Web Remote</h1>");
//               Web_print("<div align='center'><h3><a href='/?led=off'>Led switch</a></h3></div>");
//               if (strcmp(params, "?led=on") == 0){
//                    P1OUT |= LED;
//                    Web_print("<a href='?led=off'><button style='border: 2px solid #ff0000' type='button'>LED ON</button></a>");
//               }
//               else if (strcmp(params, "?led=off") == 0){
//                    P1OUT &= ~LED;
//                    Web_print("<a href='?led=on'><button style='border: 2px solid #0000ff' type='button'>LED OFF</button></a>");
//               }
//               Web_respond();
//          } // if
          
     } // while
} // main


