if (! this.sh_languages) {
  this.sh_languages = {};
}
sh_languages['asm'] = [
  [
    [
      /\b(?:external|open|include|[A-Z][\w']*(?=\.))\b/g,
      'sh_preproc',
      -1
    ],
    [
      /\b[+-]?(?:(?:0x[A-Fa-f0-9]+)|(?:(?:[\d]*\.)?[\d]+(?:[eE][+-]?[\d]+)?))u?(?:(?:int(?:8|16|32|64))|L)?\b/g,
      'sh_number',
      -1
    ],
    [
      /"/g,
      'sh_string',
      1
    ],
    [
      /;/g,
      'sh_comment',
      1
    ],
    [
      /~|!|%|\^|\*|\(|\)|-|\+|=|\[|\]|\\|:|;|,|\.|\/|\?|&|<|>|\|/g,
      'sh_symbol',
      -1
    ],
    [
      /\{|\}/g,
      'sh_cbracket',
      -1
    ],
	[
      /\b(?:res|ADDWF|ADDWFC|ANDWF|CLRF|COMF|CPFSEQ|CPFSGT|CPFSLT|DECF|DECFSZ|DCFSNZ|INCF|INCFSZ|INFSNZ|IORWF|MOVF|MOVFF|MOVWF|MULWF|NEGF|RLCF|RLNCF|RRCF|RRNCF|SETF|SUBFWB|SUBWF|SUBWFB|SWAPF|TSTFSZ|XORWF|BCF|BSF|BTFSC|BTFSS|BTG|BC|BN|BNC|BNN|BNOV|BNZ|BOV|BRA|BZ|CALL|CLRWDT|DAW|GOTO|NOP|NOP|POP|PUSH|RCALL|RESET|RETFIE|RETLW|RETURN|SLEEP|ADDLW|ANDLW|IORLW|LFSR|MOVLB|MOVLW|MULLW|RETLW|SUBLW|XORLW|TBLRD|TBLWT|ADDFSR|ADDULNK|CALLW|MOVSF|MOVSS|PUSHL|SUBFSR|SUBULNK)\b/g,
      'sh_keyword',
      -1
    ],
	[
      /\b(?:res|addwf|addwfc|andwf|clrf|comf|cpfseq|cpfsgt|cpfslt|decf|decfsz|dcfsnz|incf|incfsz|infsnz|iorwf|movf|movff|movwf|mulwf|negf|rlcf|rlncf|rrcf|rrncf|setf|subfwb|subwf|subwfb|swapf|tstfsz|xorwf|bcf|bsf|btfsc|btfss|btg|bc|bn|bnc|bnn|bnov|bnz|bov|bra|bz|call|clrwdt|daw|goto|nop|nop|pop|push|rcall|reset|retfie|retlw|return|sleep|addlw|andlw|iorlw|lfsr|movlb|movlw|mullw|retlw|sublw|xorlw|tblrd|tblwt|addfsr|addulnk|callw|movsf|movss|pushl|subfsr|subulnk)\b/g,
      'sh_keyword',
      -1
    ],
    [
      /\b(?:RES|IDATA|UDATA|UDATA_ACS|CODE|END|ENDC|ORG|CBLOCK)\b/g,
      'sh_type',
      -1
    ],
    [
      /\b(?:res|idata|udata|udata_acs|code|end|endc|org|cblock)\b/g,
      'sh_type',
      -1
    ],	
	[
      /^(?:[A-Za-z0-9_]*)\b/g,
      'sh_usertype',
      -1
    ]
  ],
  [
    [
      /$/g,
      null,
      -2
    ],
    [
      /\\(?:\\|")/g,
      null,
      -1
    ],
    [
      /"/g,
      'sh_string',
      -2
    ]
  ],
  [
    [
      /\*\)/g,
      'sh_comment',
      -2
    ],
    [
      /\(\*/g,
      'sh_comment',
      2
    ]
  ]
];
