	list	b=4

;    Filename:	    szunyogriaszto.asm                                  *
#define LastUpdate	"2013-07-11";										*
#define	VersionMajor	0x01	;										*
#define	VersionMinor	0x00	;										*


;;		errorlevel	-302

	ifdef	__10F320
		list	p=10f320              ; 10F320 can be used
		#include <p10f320.inc>        ; processor specific variable definitions
	__CONFIG _CP_OFF & _WDTE_OFF & _BORV_HI & _PWRTE_ON & _FOSC_INTOSC & _MCLRE_OFF & _LVP_OFF
    endif
	ifdef	__10F322
		list	p=10f322              ; 10F322 can be used
		#include <p10f322.inc>        ; processor specific variable definitions
	__CONFIG _CP_OFF & _WDTE_OFF & _BORV_HI & _PWRTE_ON & _FOSC_INTOSC & _MCLRE_OFF & _LVP_OFF
    endif
	ifndef	PCL
		error	"Incompatible processor type selected"
	endif


	__idlocs		0x3000 | (VersionMajor << 8) | (VersionMinor)

;***** VARIABLE DEFINITIONS

;Vars in shared memory. This memory is available from any bank

  cblock	0x070
	Flags
	NewPR2
	NewCCPRL
	TMR1HMask

	PR2Limit
	CounterL
	CounterH
	PostScaler
	LedCounter

	w_temp		; variable used for context saving
	status_temp	; variable used for context saving
  endc

; PORTA
bDebug		EQU	3
bLed		EQU	2
bBuzzer		EQU	0
bBuzzer2	EQU	1

; Flags
bReCalculate	EQU	0
bReLoadPWM		EQU	1
bNewLoop		EQU	2
bDirection		EQU	3
;			EQU	4
;			EQU	5
;			EQU	6
;			EQU	7


;**********************************************************************
		org     0x0000           	; processor reset vector
		clrf	PORTA				; Clear outputs
		goto    Start            	; go to beginning of program

LowLimit:
		retlw	.88
HighLimit:
		retlw	.23


;**********************************************************************
		org     0x0004           	; interrupt vector location

		movwf	w_temp				; context saveing
		swapf	w_temp, f
		swapf	STATUS, w

		clrf 	STATUS				; select Bank0, IRP=0 for interrupt stuff
		movwf	status_temp

TestTMR2Int:
		btfss	Flags,bReLoadPWM
		goto	TMR2IntEnd

		bcf		PIR1,TMR2IF
WaitOneMore:
		btfss	PIR1,TMR2IF
		goto	WaitOneMore
		
		decf	NewPR2,w
		movwf	PR2
		movf	NewCCPRL,w
		movwf	PWM1DCH
		movwf	PWM2DCH
		bcf		Flags,bReLoadPWM
TMR2IntEnd:
		bcf		PIR1,TMR2IF

;--------
IntExit:
		swapf	status_temp,w		; Restore context for main program
		movwf	STATUS				; This will also restore bank selection and IRP
		swapf	w_temp,w
		retfie                  	; Return from interrupt

;******************************************************************************

Start:
		movlw	0x00
		movwf	OPTION_REG

		clrf	ANSELA

		bcf		TRISA,bLed
		bcf		TRISA,bBuzzer
		bcf		TRISA,bBuzzer2
		bsf		PIE1,TMR2IE

		call	LowLimit
		movwf	PR2Limit

		movlw	.16
		movwf	NewPR2
		addlw	-1
		movwf	PR2
		movlw	.8
		movwf	NewCCPRL
		movwf	PWM1DCH
		movwf	PWM2DCH
		clrf	PWM1DCL
		clrf	PWM2DCL

		clrf	CounterL
		clrf	CounterH
		movlw	.3*.4
		movwf	PostScaler
		movlw	1 << bNewLoop
		movwf	Flags

		movlw	0xC0
		movwf	PWM1CON
		movlw	0xD0
		movwf	PWM2CON

		movlw	0x04
		btfss	PORTA,bDebug
		movlw	0x05
		movwf	T2CON

		movlw	(1 << GIE) | (1 << PEIE)
		movwf	INTCON

MainLoop:
;		btfsc	PIR1,TMR2IF
;		call	0x004

		incfsz	CounterL,f
		goto	TestRecalc
		bcf		PORTA,bLed
		bcf		Flags,bNewLoop
		incfsz	CounterH,f
		goto	TestRecalc
		decfsz	PostScaler,f
		goto	TestRecalc

		bsf		Flags,bReCalculate

TestRecalc:
		btfss	Flags,bReCalculate
		goto 	MainLoop

		movlw	.3*.4
		movwf	PostScaler
		bsf		PORTA,bLed

		btfsc	Flags,bDirection
		goto	LowToHigh

HighToLow
		movf	PR2Limit,w
		xorwf	NewPR2,w
		btfsc	STATUS,Z
		goto	ToDown
Inc2:
		incf	NewPR2,f
		incf	NewPR2,f

Ready
		bcf		STATUS,C
		rrf		NewPR2,w
		movwf	NewCCPRL
		bsf		Flags,bReLoadPWM
		bcf		Flags,bReCalculate

		goto	MainLoop

LowToHigh
		movf	NewPR2,w
		xorlw	.16
		btfsc	STATUS,Z
		goto	ToUp
Dec2:
		decf	NewPR2,f
		decf	NewPR2,f
		goto	Ready

ToDown:
		bsf		Flags,bDirection
		bsf		Flags,bNewLoop

		goto	Dec2

ToUp:
		bcf		Flags,bDirection
		bsf		Flags,bNewLoop
		goto	Inc2


GetPR2Limit:
		addwf	PCL,f
		retlw	.88		; 22.727 kHz
		retlw	.84		; 23.809 kHz
		retlw	.80		; 25.000 kHz
		retlw	.76		; 26.316 kHz
		retlw	.72		; 27.777 kHz
		retlw	.68		; 29.412 kHz
		retlw	.64		; 31.250 kHz
		retlw	.60		; 33.333 kHz

;; PWM frequency table
;;				PR2+1	Frequency
;;				.100	; 20.000 kHz
;;				.96		; 20.833 kHz
;;				.92		; 21.739 kHz
;;				.88		; 22.727 kHz
;;				.84		; 23.809 kHz
;;				.80		; 25.000 kHz
;;				.76		; 26.316 kHz
;;				.72		; 27.777 kHz
;;				.68		; 29.412 kHz
;;				.64		; 31.250 kHz
;;				.60		; 33.333 kHz
;;				.56		; 35.714 kHz
;;				.52		; 38.461 kHz
;;				.48		; 41.666 kHz
;;				.44		; 45.454 kHz
;;				.40		; 50.000 kHz
;;				.36		; 55.555 kHz
;;				.32		; 62.500 kHz
;;				.28		; 71.428 kHz
;;				.24		; 83.333 kHz

		end
