/////////////////////////////////////////////////////////////////////////////
////   Library for a Dallas 1621 Temperature chip                        ////
////                                                                     ////
////   init_temp(a);          Call before the other functions are used   ////
////                                                                     ////
////   d = read_high_temp(a); Read the temperature in degrees C (0-255)  ////
////                                                                     ////
////   d = read_low_temp(a);  Read the temp in degrees C (-67 to 127)    ////
////                                                                     ////
////   d = read_full_temp(a); Read the temp in degrees C (-67 to 257)    ////
////                                                                     ////
////   a in all these functions is the I2C address of the DS1621 sensor, ////
////   to specify which DS1621 when there are more than one on the bus.  ////
////   a can range from 0 to 7.                                          ////
////                                                                     ////
/////////////////////////////////////////////////////////////////////////////
////        (C) Copyright 1996,2003 Custom Computer Services             ////
//// This source code may only be used by licensed users of the CCS C    ////
//// compiler.  This source code may only be distributed to other        ////
//// licensed users of the CCS C compiler.  No other use, reproduction   ////
//// or distribution is permitted without written permission.            ////
//// Derivative programs created using this software in object code      ////
//// form are not restricted in any way.                                 ////
/////////////////////////////////////////////////////////////////////////////

#include <m_temp.c>

#define read_temp    read_high_temp // for backwards compatability


void temp_config(int address, BYTE data) {

   i2c_start();
   i2c_write(0x90 | (address<<1));
   i2c_write(0xac);
   i2c_write(data);
   i2c_stop();
}


void init_temp(int address) {
   i2c_start();
   i2c_write(0x90 | (address<<1));
   i2c_write(0xee);
   i2c_stop();
   temp_config(address,8);
}

int read_high_temp(int address) {        // Returns degrees F (0-255)
   int datah, datal;

   i2c_start();
   i2c_write(0x90 | (address<<1));
   i2c_write(0xaa);
   i2c_start();
   i2c_write(0x91 | (address<<1));
   datah=i2c_read();
   datal=i2c_read(0);
   i2c_stop();

   return((int)datah);
}

int read_low_temp(int address) {  // Returns degrees F (-67 to 127)
   unsigned int datah, datal;

   i2c_start();
   i2c_write(0x90 | (address<<1));
   i2c_write(0xaa);
   i2c_start();
   i2c_write(0x91 | (address<<1));
   datah=i2c_read();
   datal=i2c_read(0);
   i2c_stop();

   return((int)datal);
}


float read_full_temp(int address) {  // Returns degrees C (-55 to 125)
   unsigned int datah, datal;

   i2c_start();
   i2c_write(0x90 | (address<<1));
   i2c_write(0xaa);
   i2c_start();
   i2c_write(0x91 | (address<<1));
   datah=i2c_read();
   datal=i2c_read(0);
   i2c_stop();

   return(convert_temp(datah,datal));
}

