package com.atmel.atusbhid;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Properties;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

import com.atmel.atusbhidjni.AtUsbHidJni;
/**
 * The Class AtUsbHidGui.
 */
public class AtUsbHidGui implements Runnable
{

  /** The usb device. */
  private AtUsbHidJni         usbDevice        = null;

  /** The j frame. */
  private JFrame              jFrame           = null;

  /** The j panel button. */
  private AtUsbHidPanelButton jPanelButton     = null;

  /** The j content pane. */
  private JPanel              jContentPane     = null;

  /** The j panel text. */
  private JPanel              jPanelText       = null;

  /** The j panel led. */
  private AtUsbHidPanelLed    jPanelLed        = null;

  /** The j scroll pane. */
  private JScrollPane         jScrollPane      = null;

  /** The j text area. */
  private JTextArea           jTextArea        = null;

  /** The j panel status. */
  private JPanel              jPanelStatus     = null;

  /** The j label status. */
  private JLabel              jLabelStatus     = null;

  /** The device connected. */
  private boolean             deviceConnected  = false;

  /** The j label buffer info. */
  private JLabel              jLabelBufferInfo = null;
  
  MyTableModel tableModel;

  ActionEditorDialog actionEditorDialog;
  
	  public MyTableModel getTableModel() {
		return tableModel;
		}
		
		public void setTableModel(MyTableModel tableModel) {
			this.tableModel = tableModel;
		}

/**
   * Instantiates a new at usb hid gui.
   */
  public AtUsbHidGui()
  {
    super();
    String libraryPath = System.getProperty("user.dir") + "\\AtUsbHidJni";
    System.out.println("libraryPath:" + libraryPath);
    try
    {
      usbDevice = new AtUsbHidJni();
    }
    catch (UnsatisfiedLinkError ex)
    {
    	ex.printStackTrace();
      System.err.println("AtUsbHid.AtUsbHid():UnsatisfiedLinkError");
      JOptionPane.showMessageDialog(null,
          "AtUsbHid.AtUsbHid():UnsatisfiedLinkError\n" + "Can't find "
              + libraryPath + ".dll", "AtUsbHidJni.java error",
          JOptionPane.ERROR_MESSAGE);
      System.exit(0);
    } catch (SecurityException ex)
    {
      JOptionPane.showMessageDialog(null,
          "AtUsbHid.AtUsbHid():SecurityException", "AtUsbHidJni.java error",
          JOptionPane.ERROR_MESSAGE);
      System.exit(0);
    } catch (NullPointerException ex)
    {
      JOptionPane.showMessageDialog(null,
          "AtUsbHid.AtUsbHid():NullPointerException", "AtUsbHidJni.java error",
          JOptionPane.ERROR_MESSAGE);
      System.err.println("AtUsbHid.AtUsbHid():NullPointerException");
      System.exit(0);
    }

    if(usbDevice.loadLibraryUsbHid() == false)
    {
      JOptionPane.showMessageDialog(null, "DemoAtUsbHid.main():LoadLibrary",
          "AtUsbHidGui.java error", JOptionPane.ERROR_MESSAGE);
      System.exit(0);
    }
  }

  /*
   * (non-Javadoc)
   * 
   * @see java.lang.Runnable#run()
   */
  public void run()
  {
    getJFrame().pack();
    getJFrame().setVisible(true);
  }

  /**
   * This method initializes jFrame.
   * 
   * @return javax.swing.JFrame
   */
  private JFrame getJFrame()
  {
    if(jFrame == null)
    {
      jFrame = new JFrame();
      jFrame.setSize(new Dimension(800, 400));
      jFrame.setResizable(false);
      jFrame.setTitle("Távirányító");
      jFrame.setContentPane(getJContentPane());
      jFrame.addWindowListener(new java.awt.event.WindowAdapter()
      {
        public void windowClosing(java.awt.event.WindowEvent e)
        {
          if(deviceConnected == true)
          {
            setDeviceConnected(false);
          }
          usbDevice.UnloadloadLibraryUsbHid();
          System.exit(0);
        }
      });
      centerJFrame();
    }
    return jFrame;
  }

  /**
   * Center J frame.
   */
  private void centerJFrame()
  {
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = getJFrame().getSize();
    if(frameSize.height > screenSize.height)
    {
      frameSize.height = screenSize.height;
    }
    if(frameSize.width > screenSize.width)
    {
      frameSize.width = screenSize.width;
    }

    getJFrame().setLocation((screenSize.width - frameSize.width) / 2,
        (screenSize.height - frameSize.height) / 2);
  }

//  private void shakingWindow() {
//	  Point loc = getJFrame().getLocation();
//	  for(int i = 0; i < 10; i++) {
//		  loc.x = loc.x + 10;
//		  getJFrame().setLocation(loc);
//		  sleep();
//		  loc.y = loc.y + 10;
//		  getJFrame().setLocation(loc);
//		  sleep();
//		  loc.y = loc.y - 10;
//		  getJFrame().setLocation(loc);
//		  sleep();
//		  loc.x = loc.x - 10;
//		  getJFrame().setLocation(loc);
//		  sleep();
//	  }
//  }

  void sleep() {
	  try {
		Thread.sleep(40);
	} catch (InterruptedException e) {
		e.printStackTrace();
	}
  }
  
  private void saveToFile() {
	  final JFileChooser fc = new JFileChooser();
	  //In response to a button click:
	  
	  int returnVal = fc.showSaveDialog(jFrame);
	  if(returnVal == JFileChooser.APPROVE_OPTION) {
		  File file = fc.getSelectedFile();
		  Writer out;
		try {
			out = new OutputStreamWriter(new FileOutputStream(file));
			  List<Assotiation> assotiations = tableModel.data;
			  for (Assotiation assotiation : assotiations) {
				  out.write(assotiation.function + ";" + assotiation.key + ";" + assotiation.event.value + ";" + assotiation.event.label + ";");
				  out.write(assotiation.ctrl + ";" + assotiation.shift + ";" + assotiation.alt + ";" + assotiation.altGr + "\n");
			  }
			  out.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	  }
  }
  
  private void openFile() {
	  final JFileChooser fc = new JFileChooser();
	  //In response to a button click:
	  
	  int returnVal = fc.showOpenDialog(jFrame);
	  if(returnVal == JFileChooser.APPROVE_OPTION) {
		  File file = fc.getSelectedFile();
		  openFile(file);
	  }
	  
  }
  
  private void openFile(File file) {
		  try {
			BufferedReader in = new BufferedReader(new FileReader(file));
			String line;
			while((line = in.readLine()) != null) {
				String[] sp = line.split(";");
				Assotiation assotiation = new Assotiation();
				assotiation.setFunction(sp[0]);
				assotiation.setKey(sp[1]);
				MyKeyEvent event = new MyKeyEvent(sp[3], Integer.parseInt(sp[2]));
				assotiation.setEvent(event);
				
				if(sp.length > 4){
					System.out.println("itt vagyok");
					assotiation.setCtrl(Boolean.parseBoolean(sp[4]));
					assotiation.setShift(Boolean.parseBoolean(sp[5]));
					assotiation.setAlt(Boolean.parseBoolean(sp[6]));
					assotiation.setAltGr(Boolean.parseBoolean(sp[7]));
				}
				
				tableModel.addNewRow(assotiation);
			}
			
			in.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		  
  }
  
  /**
   * This method initializes jContentPane.
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getJContentPane()
  {
    if(jContentPane == null)
    {
      jContentPane = new JPanel();
      jContentPane
          .setLayout(new BoxLayout(getJContentPane(), BoxLayout.Y_AXIS));
      jPanelButton = new AtUsbHidPanelButton(this);
      jContentPane.add(jPanelButton.getJPanelButton(), null);
      jContentPane.add(getJPanelText(), null);
      
      tableModel = new MyTableModel();
      
      final JTable table = new JTable(tableModel);
      JScrollPane scrollPane = new JScrollPane(table);
      table.setFillsViewportHeight(true);
      jContentPane.add(scrollPane, null);
	  actionEditorDialog = new ActionEditorDialog(jFrame, tableModel);

      
      table.addMouseListener(new MouseAdapter() {
    	     public void mouseClicked(MouseEvent e){
    	      if (e.getClickCount() == 2){
    	         	int selInd = table.getSelectedRow();
    	         	System.out.println("  " + tableModel.getValueAt(selInd, 1));
//    	         	Assotiation assotiation = new Assotiation();
//    	            assotiation.setKey("0A3D");
//    	            assotiation.setEvent("event2");
//    	            assotiation.setFunction("Prev");
//    	            tableModel.addNewRow(assotiation);
//    	            tableModel.fireTableDataChanged();
    	         	actionEditorDialog.setKey((String)tableModel.getValueAt(selInd, 0));
    	         	actionEditorDialog.setFunction((String)tableModel.getValueAt(selInd, 1));
    	  			actionEditorDialog.setCtrl((Boolean) tableModel.getValueAt(selInd, 3));
    	  			actionEditorDialog.setShift((Boolean) tableModel.getValueAt(selInd, 4));
    	  			actionEditorDialog.setAlt((Boolean) tableModel.getValueAt(selInd, 5));
    	  			actionEditorDialog.setAltGr((Boolean) tableModel.getValueAt(selInd, 6));

    	         	MyKeyEvent mke = (MyKeyEvent) tableModel.getValueAt(selInd, 2);
    	         	actionEditorDialog.setEvent(mke.value);
    	         	actionEditorDialog.editIndex = selInd;
    	         	actionEditorDialog.editMode = true;
    	    	  	actionEditorDialog.setVisible(true);
    	      }
    	      }
    	     });
    	   
      jContentPane.add(scrollPane, null);

      JButton addNewRowButton = new JButton("Uj társítás");
      addNewRowButton.addActionListener(new ActionListener() {
  		
  		@Override
  		public void actionPerformed(ActionEvent e) {
  			actionEditorDialog.setKey(null);
  			actionEditorDialog.setFunction(null);
  			actionEditorDialog.setCtrl(false);
  			actionEditorDialog.setShift(false);
  			actionEditorDialog.setAlt(false);
  			actionEditorDialog.setAltGr(false);
  			//actionEditorDialog.setEvent(0);
  			actionEditorDialog.editMode = false;
  			actionEditorDialog.setVisible(true);
  		}
      });
      //actionEditorDialog.editMode = true;
      jContentPane.add(addNewRowButton, null);

      JButton deleteRowButton = new JButton("Kijelölt törlése");
      deleteRowButton.addActionListener(new ActionListener() {
  		
  		@Override
  		public void actionPerformed(ActionEvent e) {
  			tableModel.remove(table.getSelectedRow());
  			tableModel.fireTableDataChanged();
  		}
      });
      //actionEditorDialog.editMode = true;
      jContentPane.add(deleteRowButton, null);

      
      JButton saveToFileButton = new JButton("Mentés fájlba");
      saveToFileButton.addActionListener(new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {
			saveToFile();
		}
      });
      jContentPane.add(saveToFileButton, null);
      
      JButton openFileButton = new JButton("Betöltés fájlból");
      openFileButton.addActionListener(new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {
			openFile();
			tableModel.fireTableDataChanged();
		}
      });
      jContentPane.add(openFileButton, null);
      
      
//      jPanelLed = new AtUsbHidPanelLed(this);
//      jContentPane.add(jPanelLed.getJPanelLed(), null);
      jContentPane.add(getJPanelStatus(), null);
      setControlEnable(false); // Just enable Connect
      TaskReadText();
    }
    return jContentPane;
  }

  /**
   * This method initializes jPanelText.
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getJPanelText()
  {
    if(jPanelText == null)
    {
      jPanelText = new JPanel();
      jPanelText.setLayout(new FlowLayout());
      jPanelText.add(getJScrollPane(), null);
    }
    return jPanelText;
  }

  /**
   * This method initializes jTextArea.
   * 
   * @return javax.swing.JTextArea
   */
  private JTextArea getJTextArea()
  {
    if(jTextArea == null)
    {
      jTextArea = new JTextArea();
    }
    return jTextArea;
  }

  /**
   * This method initializes jPanelStatus.
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getJPanelStatus()
  {
    if(jPanelStatus == null)
    {
      jLabelBufferInfo = new JLabel("");
      jLabelStatus = new JLabel("Not Connected");
      jLabelStatus.setFont(new Font("Courier New", Font.BOLD, 14));
      jLabelStatus.setForeground(Color.blue);
      jPanelStatus = new JPanel();
      jPanelStatus.setLayout(new BorderLayout());
      jPanelStatus.setBorder(BorderFactory.createTitledBorder(null, "Status",
          TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION,
          new Font("Dialog", Font.BOLD, 12), new Color(51, 51, 51)));
      jPanelStatus.add(jLabelStatus, BorderLayout.WEST);
      jPanelStatus.add(jLabelBufferInfo, BorderLayout.EAST);
    }
    return jPanelStatus;
  }

  /**
   * Sets the control enable.
   * 
   * @param b
   *                the new control enable
   */
  private void setControlEnable(boolean b)
  {
//    jPanelLed.setCommunicationEnable(b);
    jPanelButton.setCommunicationEnable(b);
  }


  public void toogleLed()
  {
    byte[] byteArray = new byte[usbDevice.getOutputReportLength()];
    for (int i = 0; i < byteArray.length; i++)
    {
      byteArray[i] = (byte) 0;
    }

    byteArray[0] = (byte) 0x80; 
    
    
    if(usbDevice.writeData(byteArray) == false)
    {
      setDeviceConnected(false);
      jLabelStatus.setText("Connection to device lost during led setting");
    }
  }

  public void toogleTemperatureMeasuring()
  {
    byte[] byteArray = new byte[usbDevice.getOutputReportLength()];
    for (int i = 0; i < byteArray.length; i++)
    {
      byteArray[i] = (byte) 0;
    }

    byteArray[0] = (byte) 0x79; 
    
    
    if(usbDevice.writeData(byteArray) == false)
    {
      setDeviceConnected(false);
      jLabelStatus.setText("Connection to device lost during Toogle Temperature Messaure");
    }
  }

  
  /**
   * Task read text.
   */
  private void TaskReadText()
  {
    Timer timer;
    timer = createTimer();
    timer.start();
  }

  /**
   * Creates the timer.
   * 
   * @return the timer
   */
  private Timer createTimer()
  {
    ActionListener action = new ActionListener()
    {
      public void actionPerformed(ActionEvent event)
      {
        if(deviceConnected == true)
        {
          // Check if there is new data to read
          byte data[] = usbDevice.readData();
          if(data.length > 0)
          {

//        	  switch(data[0]) {
//       	  		case 1:
//	          		  if(data[1] == 113) {
//	        			  jPanelLed.setColorRed();
//	        		  } else {
//	        			  jPanelLed.setColorGray();
//	        		  }
//	          		  break;
//       	  		case 2:
//	           		  jPanelLed.setTemperatureLabel(data[1], data[2]);
//	            	  break;
//       	  		case 3:
//	              	  byte[] bt = new byte[2];
//	            	  bt[0] = data[1];
//	            	  bt[1] = data[2];
//	        		  jPanelLed.setAdLabel(byteArrayToInt(bt, 0));
//	        		  break;
//        		default:
//	        		  jLabelStatus.setText("Unknown data packet received");
//        			  //shakingWindow();
//        	  }
        	  
//        	  if(data[10] != 0 || data[11] != 0 || data[12] != 0 || data[13] != 0 ) {
        	  
//	        	  getJTextArea().append("data[" +  data[0] + ", " + data[1] + ", " + data[2] 
//	        	       + ", " + data[3] + ", " + data[4] + ", " + data[5] 
//	           	       + ", " + data[6] + ", " + data[7] + ", " + data[8] 
//	        	       + ", ...]\n");
        	  
        	  String key = Test.convertToHexString(data);
        	  
        	  if(actionEditorDialog.isVisible()) {
        		  actionEditorDialog.setKey(key);
        	  } else {
        		  
        		try {
					Robot robot = new Robot();
					
					for (Assotiation ass : tableModel.data) {
						if(ass.getKey().equals(key)) {
							if(ass.getEvent().getLabel().equals("VK_AT")) {
						        setDeviceConnected(false);
								Runtime runtime = Runtime.getRuntime();
						        try {
									Process proc = runtime.exec("shutdown -s -t 5");
									System.exit(0);
								} catch (IOException e) {
									e.printStackTrace();
								}
							}
							if(ass.isCtrl()) {
								robot.keyPress(KeyEvent.VK_CONTROL);
							}
							if(ass.isShift()) {
								robot.keyPress(KeyEvent.VK_SHIFT);
							}
							if(ass.isAlt()) {
								robot.keyPress(KeyEvent.VK_ALT);
							}
							if(ass.isAltGr()) {
								robot.keyPress(KeyEvent.VK_ALT_GRAPH);
							}
			      		    robot.keyPress(ass.getEvent().getValue());
			    		    robot.keyRelease(ass.getEvent().getValue());
							if(ass.isCtrl()) {
								robot.keyRelease(KeyEvent.VK_CONTROL);
							}
							if(ass.isShift()) {
								robot.keyRelease(KeyEvent.VK_SHIFT);
							}
							if(ass.isAlt()) {
								robot.keyRelease(KeyEvent.VK_ALT);
							}
							if(ass.isAltGr()) {
								robot.keyRelease(KeyEvent.VK_ALT_GRAPH);
							}
						}
					}
				} catch (AWTException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

        	  }
        	  
        	  getJTextArea().append(Test.convertToHexString(data) + " data[");
	        	  for (int i = 0; i < data.length; i++) {
					byte b = data[i];
					getJTextArea().append(b + ", ");
				}
	        	  getJTextArea().append("]\n");

        	  
//        	  }
        	  
          }
        }
      }
    };

    return new Timer(10, action);
  }
  

  public static int byteArrayToInt(byte[] b, int offset) {
      int value = 0;
      for (int i = 0; i < 2; i++) {
          int shift = (2 - 1 - i) * 8;
          value += (b[i + offset] & 0x000000FF) << shift;
      }
      return value;
  }

  
  /**
   * Sets the device connected.
   * 
   * @param b
   *                the new device connected
   */
  public void setDeviceConnected(boolean b)
  {
    jLabelBufferInfo.setText("");
    if(b == true)
    {
      int state = usbDevice.findHidDevice(jPanelButton.getVid(), jPanelButton
          .getPid());
      switch (state)
      {
      case 1: // Find Device
        jPanelButton.setCommunicationEnable(false);
        setControlEnable(true);
          jLabelStatus.setText("Connected to the device");
        jLabelBufferInfo.setText("Buffer Size, In:"
            + usbDevice.getInputReportLength() + "Byte, Out="
            + usbDevice.getOutputReportLength() + "Byte, Feature"
            + usbDevice.getFeatureReportLength() + "Byte");
        deviceConnected = true;
        break;
      case -1: // ERROR_USB_DEVICE_NOT_FOUND
          JOptionPane.showMessageDialog(getJFrame(), "Usb Device Not Found",
              "AtUsbHidGui.java error", JOptionPane.ERROR_MESSAGE);
        jLabelStatus.setText("Usb Device Not Found");
        deviceConnected = false;
        break;
      case -2: // ERROR_USB_DEVICE_NO_CAPABILITIES:
          JOptionPane.showMessageDialog(getJFrame(), "Usb no capabilities",
              "AtUsbHidGui.java error", JOptionPane.ERROR_MESSAGE);
        jLabelStatus.setText("Usb no capabilities");
        deviceConnected = false;
        break;
      case 0: // unknown Error
      default:
          JOptionPane.showMessageDialog(getJFrame(), "Usb Unknown Error",
              "AtUsbHidGui.java error", JOptionPane.ERROR_MESSAGE);
        jLabelStatus.setText("Usb Unknown Error");
        deviceConnected = false;
        break;
      }

    } else
    {
      usbDevice.closeDevice();
      setControlEnable(false);
      jLabelStatus.setText("Disconneted from the device");
      deviceConnected = false;
    }
  }


  /**
   * This method initializes jScrollBar.
   * 
   * @return javax.swing.JScrollBar
   */
  private JScrollPane getJScrollPane()
  {
    if(jScrollPane == null)
    {
      jScrollPane = new JScrollPane(getJTextArea());
      jScrollPane.setPreferredSize(new Dimension(490, 120));
    }
    return jScrollPane;
  }

  /**
   * The main method.
   * 
   * @param args
   *                the args
   */
  public static void main(String[] args)
  {
    Runnable gui = new AtUsbHidGui();

    try
    {
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    } catch (Exception e)
    {
      e.printStackTrace();
    }

    try
    {
      SwingUtilities.invokeAndWait(gui);
      Properties properties = new Properties();
      InputStream inStream;
	try {
		inStream = new FileInputStream("tavir.properties");
		properties.load(inStream);
		inStream.close();
	} catch (Exception e) {
		e.printStackTrace();
	}
	  if(properties.get("loadFileStartup") != null) {
		  ((AtUsbHidGui)gui).openFile(new File((String) properties.get("loadFileStartup")));
	  }
      ((AtUsbHidGui)gui).setDeviceConnected(true);
      ((AtUsbHidGui)gui).jFrame.setState(Frame.ICONIFIED);
    } catch (InvocationTargetException ex)
    {
      ex.printStackTrace();
    } catch (InterruptedException ex)
    {
      ex.printStackTrace();
    }

  }

}
