package com.atmel.atusbhid;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.Vector;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;


@SuppressWarnings("serial")
public class ActionEditorDialog extends JDialog {
	
	boolean editMode;
	int editIndex;
	
	class MyComboboxModel extends DefaultComboBoxModel {
	}

	public void setKey(String key) {
		messagePane.getKeyField().setText(key);
	}

	public void setFunction(String function) {
		messagePane.getFunctionField().setText(function);
	}

	public void setCtrl(boolean selected) {
		messagePane.getCtrlCheckBox().setSelected(selected);
	}

	public void setShift(boolean selected) {
		messagePane.getShiftCheckBox().setSelected(selected);
	}

	public void setAlt(boolean selected) {
		messagePane.getAltCheckBox().setSelected(selected);
	}

	public void setAltGr(boolean selected) {
		messagePane.getAltGrCheckBox().setSelected(selected);
	}

	
	public void setEvent(int eventCode) {
		int ind = 0;
		
		int comboSize = messagePane.getEventField().getModel().getSize();
		for (int i = 0; i < comboSize; i++) {
			MyKeyEvent ev = (MyKeyEvent) messagePane.getEventField().getModel().getElementAt(i);
			if(ev.value == eventCode) {
				ind = i;
			}
		}
		
		messagePane.getEventField().setSelectedIndex(ind);
	}
	
	class EditorPanel extends JPanel {

		JTextField keyField;
		JTextField functionField;
		JComboBox eventField;
		JButton button;
		JCheckBox ctrlCheckBox;
		JCheckBox shiftCheckBox;
		JCheckBox altCheckBox;
		JCheckBox altGrCheckBox;
		
		
		
		public JCheckBox getCtrlCheckBox() {
			return ctrlCheckBox;
		}


		public void setCtrlCheckBox(JCheckBox ctrlCheckBox) {
			this.ctrlCheckBox = ctrlCheckBox;
		}


		public JCheckBox getShiftCheckBox() {
			return shiftCheckBox;
		}


		public void setShiftCheckBox(JCheckBox shiftCheckBox) {
			this.shiftCheckBox = shiftCheckBox;
		}


		public JCheckBox getAltCheckBox() {
			return altCheckBox;
		}


		public void setAltCheckBox(JCheckBox altCheckBox) {
			this.altCheckBox = altCheckBox;
		}


		public JCheckBox getAltGrCheckBox() {
			return altGrCheckBox;
		}


		public void setAltGrCheckBox(JCheckBox altGrCheckBox) {
			this.altGrCheckBox = altGrCheckBox;
		}


		public JTextField getKeyField() {
			return keyField;
		}


		public void setKeyField(JTextField keyField) {
			this.keyField = keyField;
		}


		public JTextField getFunctionField() {
			return functionField;
		}


		public void setFunctionField(JTextField functionField) {
			this.functionField = functionField;
		}


		public JComboBox getEventField() {
			return eventField;
		}


		public void setEventField(JComboBox eventField) {
			this.eventField = eventField;
		}


		public EditorPanel() {
			super(new GridBagLayout());
			keyField = new JTextField();
			functionField = new JTextField();
			eventField = new JComboBox();
			ctrlCheckBox = new JCheckBox();
			shiftCheckBox = new JCheckBox();
			altCheckBox = new JCheckBox();
			altGrCheckBox = new JCheckBox();
			Field[] fields = KeyEvent.class.getDeclaredFields();
			MyComboboxModel comboboxModel = new MyComboboxModel();
			for (Field field : fields) {
				try {
					field.setAccessible(true);
		//			System.out.println(field.getName() + ": " + field.get(null));
					MyKeyEvent keyEvent = new MyKeyEvent();
					keyEvent.setLabel(field.getName());
					keyEvent.setValue((Integer) field.get(null));
					comboboxModel.addElement(keyEvent);
				} catch (Exception e) {
					//e.printStackTrace();
				}
			}
			eventField = new JComboBox(comboboxModel);
			addComponent(this, new JLabel("Kód"), 0, 0, 1, 1, GridBagConstraints.CENTER, GridBagConstraints.NONE);
			addComponent(this, keyField, 1, 0, 1, 1, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL);
			addComponent(this, new JLabel("Funkció"), 0, 1, 1, 1, GridBagConstraints.CENTER, GridBagConstraints.NONE);
			addComponent(this, functionField, 1, 1, 1, 1, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL);
			
			addComponent(this, new JLabel("VK_AT - gép leállítása"), 0, 2, 2, 1, GridBagConstraints.CENTER, GridBagConstraints.NONE);
			addComponent(this, new JLabel("Esemény"), 0, 3, 1, 1, GridBagConstraints.CENTER, GridBagConstraints.NONE);
			addComponent(this, eventField, 1, 3, 1, 1, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL);
			addComponent(this, new JLabel("CTRL"), 0, 4, 1, 1, GridBagConstraints.CENTER, GridBagConstraints.NONE);
			addComponent(this, ctrlCheckBox, 1, 4, 1, 1, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL);
			addComponent(this, new JLabel("SHIFT"), 0, 5, 1, 1, GridBagConstraints.CENTER, GridBagConstraints.NONE);
			addComponent(this, shiftCheckBox, 1, 5, 1, 1, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL);
			addComponent(this, new JLabel("ALT"), 0, 6, 1, 1, GridBagConstraints.CENTER, GridBagConstraints.NONE);
			addComponent(this, altCheckBox, 1, 6, 1, 1, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL);
			addComponent(this, new JLabel("ALTGR"), 0, 7, 1, 1, GridBagConstraints.CENTER, GridBagConstraints.NONE);
			addComponent(this, altGrCheckBox, 1, 7, 1, 1, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL);

			button = new JButton("OK");
			//button.addActionListener(okButtonActionListener);
			addComponent(this,button, 0, 8, 2, 1, GridBagConstraints.CENTER, GridBagConstraints.NONE);

		}
		
		private final Insets insets = new Insets(0, 0, 0, 0);

		
		public void addComponent(Container container, Component component, int gridx, int gridy,
			      int gridwidth, int gridheight, int anchor, int fill) {
			    GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, 1.0, 1.0,
			        anchor, fill, insets, 0, 0);
			    container.add(component, gbc);
		}

	}
	
	class ButtonActionListener implements ActionListener {
    	
		MyTableModel tableModel;
		
		EditorPanel messagePane;
     	
		public ButtonActionListener(EditorPanel messagePane, MyTableModel tableModel) {
			super();
			this.messagePane = messagePane;
			this.tableModel = tableModel;
		}

		@Override
		public void actionPerformed(ActionEvent e) {
			
         	Assotiation assotiation = new Assotiation();
            assotiation.setKey(messagePane.getKeyField().getText());
            assotiation.setEvent(((MyKeyEvent)messagePane.getEventField().getSelectedItem()));
            assotiation.setFunction(messagePane.getFunctionField().getText());
            assotiation.setCtrl(messagePane.getCtrlCheckBox().isSelected());
            assotiation.setShift(messagePane.getShiftCheckBox().isSelected());
            assotiation.setAlt(messagePane.getAltCheckBox().isSelected());
            assotiation.setAltGr(messagePane.getAltGrCheckBox().isSelected());
            if(editMode) {
            	tableModel.replace(editIndex, assotiation);
            } else {
            	tableModel.addNewRow(assotiation);
            }
            tableModel.fireTableDataChanged();

			
			ActionEditorDialog.this.setVisible(false);
			
		}
	}

    EditorPanel messagePane = new EditorPanel();

	
	public ActionEditorDialog(JFrame parent, MyTableModel tableModel) {
		super(parent, "Esemény szerkesztése", true);
		setSize(400, 400);
	    if (parent != null) {
	        Dimension parentSize = parent.getSize(); 
	        Point p = parent.getLocation(); 
	        setLocation(p.x + parentSize.width / 4, p.y + parentSize.height / 4);
	      }

	    
	    messagePane = new EditorPanel();
	    ActionListener okButtonActionListener = new ButtonActionListener(messagePane, tableModel);

	    messagePane.button.addActionListener(okButtonActionListener);
	    //messagePane.add(new JLabel("jdsfsaédkfh"));
	    getContentPane().add(messagePane);
	}

}
