package com.atmel.atusbhid;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;


/**
 * The Class AtUsbHidPanelLed.
 */
public class AtUsbHidPanelLed extends JPanel {
    
    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = -9098183392513006046L;
    
    
    /** The j panel led. */
    private JPanel      jPanelLed     = null;

    /** The j parent. */
    private AtUsbHidGui jParent       = null;

    private JButton toogleLedButton; 
    
    private JPanel ledColorPanel;
    
    private JLabel temperatureLabel;
    
    private JLabel adLabel;
    
    private JButton toogleTemperatureMeasuringButton; 
    
    JProgressBar progressBar;


    /**
     * Instantiates a new at usb hid panel led.
     * 
     * @param jParent
     *            the j parent
     */
    public AtUsbHidPanelLed(AtUsbHidGui jParent) {
        super();
        this.jParent = jParent;
        this.ledColorPanel = new JPanel();
        this.ledColorPanel.setSize(10,10);
        this.ledColorPanel.setBackground(Color.GRAY);
        this.temperatureLabel = new JLabel("xx.xx");
        this.adLabel = new JLabel("xxxx");
        
        //Where the GUI is constructed:
        progressBar = new JProgressBar(0, 1023);
        progressBar.setValue(0);
        progressBar.setStringPainted(true);

    }

    public void setColorGray(){
    	this.ledColorPanel.setBackground(Color.GRAY);
    }
    
    public void setColorRed() {
    	this.ledColorPanel.setBackground(Color.RED);
    }
    
    public void setTemperatureLabel(byte high, byte low) {
    	this.temperatureLabel.setText("" + high + "." + low);
    }
  
    public void setAdLabel(int val) {
    	this.adLabel.setText("" + val + " (" + (5 * (float)val / 1023) + " V)");
    	progressBar.setValue(val);
    }

    /**
     * This method initializes jPanelLed.
     * 
     * @return javax.swing.JPanel
     */
    public JPanel getJPanelLed() {
        if (jPanelLed == null) {
            jPanelLed = new JPanel();
            jPanelLed.setLayout(new FlowLayout());
            jPanelLed.add(getTemperatureMeasuringButton(), null);
            jPanelLed.add(getToogleLedButton(), null);
            jPanelLed.add(new JLabel(" LED:"), null);
            jPanelLed.add(ledColorPanel, null);
            jPanelLed.add(new JLabel(", Temperature:"), null);
            jPanelLed.add(temperatureLabel, null);
            jPanelLed.add(new JLabel(" °C"), null);

            jPanelLed.add(new JLabel(", AD converter:"), null);
            jPanelLed.add(adLabel, null);

            jPanelLed.add(progressBar, null);
            
        }
        return jPanelLed;
    }

    private JButton getTemperatureMeasuringButton() {
    	if(toogleTemperatureMeasuringButton == null) {
    		toogleTemperatureMeasuringButton = new JButton("Temperature measuring");
    		toogleTemperatureMeasuringButton.addActionListener(new ActionListener(){

				@Override
				public void actionPerformed(ActionEvent e) {
					jParent.toogleTemperatureMeasuring();
				}
    			
    		});
    	}
    	return toogleTemperatureMeasuringButton;
    }
    
    private JButton getToogleLedButton() {
    	if(toogleLedButton == null) {
    		toogleLedButton = new JButton("Toogle LED");
    		toogleLedButton.addActionListener(new ActionListener(){

				@Override
				public void actionPerformed(ActionEvent e) {
					jParent.toogleLed();
				}
    			
    		});
    	}
    	return toogleLedButton;
    }
    
    
    /**
     * Sets the communication enable.
     * 
     * @param b
     *            the new communication enable
     */
    public void setCommunicationEnable(boolean b) {
        toogleLedButton.setEnabled(b);
        toogleTemperatureMeasuringButton.setEnabled(b);
    }

}
