package com.atmel.atusbhid;

import java.util.ArrayList;
import java.util.List;

import javax.swing.table.AbstractTableModel;

@SuppressWarnings("serial")
public class MyTableModel extends AbstractTableModel {

	String[] columnNames = {"Kód", "Funkció", "Esemény", "CTRL", "SHIFT", "ALT", "ALTGR"};
	
	List<Assotiation> data = new ArrayList<Assotiation>();
	
	public void replace(int index, Assotiation assotiation) {
		data.remove(index);
		data.add(index, assotiation);
	}

	public void remove(int index) {
		data.remove(index);
	}

	
	public void addNewRow(Assotiation assotiation) {
		data.add(assotiation);
	}
	
	@Override
	public int getRowCount() {
		return data.size();
	}

	@Override
	public int getColumnCount() {
		return 7;
	}

	@Override
	public String getColumnName(int column) {
		return columnNames[column];
	}
	
	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		Assotiation assotiation = data.get(rowIndex);
		switch (columnIndex) {
			case 0:
				return assotiation.getKey();
			case 1:
				return assotiation.getFunction();
			case 2:
				return assotiation.getEvent();
			case 3:
				return assotiation.isCtrl();
			case 4:
				return assotiation.isShift();
			case 5:
				return assotiation.isAlt();
			case 6:
				return assotiation.isAltGr();
		}
		return null;
	}

}
