;=======================================
;  CVASM16 INCLUDE FILE for the 16F877
;      Copyright (c) 2001 by TechTools
;support@tech-tools.com, sales@tech-tools.com
;    972-272-9392  FAX: 972-494-5814
;
;  - Last update: 04/23/01
;=======================================

                     DEVCODE    00877h      
                     ROMSIZE    8192        
                     EESIZE     256         
                     CORE       _14bit      
                     PAGEBIT    2           
                     MAXTRIS    0009        

;=======================================
;  Main File Register Definitions 
;=======================================
INDF                 EQU        0000h       
INDIRECT             EQU        0000h       ; backwards compatability
TMR0                 EQU        0001h       
PCL                  EQU        0002h       
STATUS               EQU        0003h       
FSR                  EQU        0004h       
PORTA                EQU        0005h       
RA                   EQU        0005h       ; backwards compatability
PORTB                EQU        0006h       
RB                   EQU        0006h       ; backwards compatability
PORTC                EQU        0007h       
RC                   EQU        0007h       ; backwards compatability
PORTD                EQU        0008h       
; RD                 EQU        0008h       ;  backwards compatability
PORTE                EQU        0009h       
RE                   EQU        0009h       ; backwards compatability
PCLATH               EQU        000Ah       
INTCON               EQU        000Bh       
PIR1                 EQU        000Ch       
PIR2                 EQU        000Dh       
TMR1L                EQU        000Eh       
TMR1H                EQU        000Fh       
T1CON                EQU        0010h       
TMR2                 EQU        0011h       
T2CON                EQU        0012h       
SSPBUF               EQU        0013h       
SSPCON               EQU        0014h       
CCPR1L               EQU        0015h       
CCPR1H               EQU        0016h       
CCP1CON              EQU        0017h       
RCSTA                EQU        0018h       
TXREG                EQU        0019h       
RCREG                EQU        001Ah       
CCPR2L               EQU        001Bh       
CCPR2H               EQU        001Ch       
CCP2CON              EQU        001Dh       
ADRESH               EQU        001Eh       
ADCON0               EQU        001Fh       
OPTION_REG           EQU        0081h       
OPTION               EQU        0081h       ; backwards compatability
TRISA                EQU        0085h       
TRISB                EQU        0086h       
TRISC                EQU        0087h       
TRISD                EQU        0088h       
TRISE                EQU        0089h       
PIE1                 EQU        008Ch       
PIE2                 EQU        008Dh       
PCON                 EQU        008Eh       
SSPCON2              EQU        0091h       
PR2                  EQU        0092h       
SSPADD               EQU        0093h       
SSPSTAT              EQU        0094h       
TXSTA                EQU        0098h       
SPBRG                EQU        0099h       
ADRESL               EQU        009Eh       
ADCON1               EQU        009Fh       
EEDATA               EQU        010Ch       
EEADR                EQU        010Dh       
EEDATH               EQU        010Eh       
EEADRH               EQU        010Fh       
EECON1               EQU        018Ch       
EECON2               EQU        018Dh       


;=======================================
;  STATUS Register BIT Definitions 
;=======================================
IRP                  EQU        STATUS.7    
RP1                  EQU        STATUS.6    
RP0                  EQU        STATUS.5    
NOT_TO               EQU        STATUS.4    
NOT_PD               EQU        STATUS.3    
Z                    EQU        STATUS.2    
DC                   EQU        STATUS.1    
C                    EQU        STATUS.0    


;=======================================
;  INTCON Register BIT Definitions 
;=======================================
GIE                  EQU        INTCON.7    
PEIE                 EQU        INTCON.6    
T0IE                 EQU        INTCON.5    
INTE                 EQU        INTCON.4    
RBIE                 EQU        INTCON.3    
T0IF                 EQU        INTCON.2    
INTF                 EQU        INTCON.1    
RBIF                 EQU        INTCON.0    


;=======================================
;  PIR1 Register BIT Definitions 
;=======================================
PSPIF                EQU        PIR1.7      
ADIF                 EQU        PIR1.6      
RCIF                 EQU        PIR1.5      
TXIF                 EQU        PIR1.4      
SSPIF                EQU        PIR1.3      
CCP1IF               EQU        PIR1.2      
TMR2IF               EQU        PIR1.1      
TMR1IF               EQU        PIR1.0      


;=======================================
;  PIR2 Register BIT Definitions 
;=======================================
EEIF                 EQU        PIR2.4      
BCLIF                EQU        PIR2.3      
CCP2IF               EQU        PIR2.0      


;=======================================
;  T1CON Register BIT Definitions 
;=======================================
T1CKPS1              EQU        T1CON.5     
T1CKPS0              EQU        T1CON.4     
T1OSCEN              EQU        T1CON.3     
NOT_T1SYNC           EQU        T1CON.2     
T1INSYNC             EQU        T1CON.2     
T1SYNC               EQU        T1CON.2     
TMR1CS               EQU        T1CON.1     
TMR1ON               EQU        T1CON.0     


;=======================================
;  T2CON Register BIT Definitions 
;=======================================
TOUTPS3              EQU        T2CON.6     
TOUTPS2              EQU        T2CON.5     
TOUTPS1              EQU        T2CON.4     
TOUTPS0              EQU        T2CON.3     
TMR2ON               EQU        T2CON.2     
T2CKPS1              EQU        T2CON.1     
T2CKPS0              EQU        T2CON.0     


;=======================================
;  SSPCON Register BIT Definitions 
;=======================================
WCOL                 EQU        SSPCON.7    
SSPOV                EQU        SSPCON.6    
SSPEN                EQU        SSPCON.5    
CKP                  EQU        SSPCON.4    
SSPM3                EQU        SSPCON.3    
SSPM2                EQU        SSPCON.2    
SSPM1                EQU        SSPCON.1    
SSPM0                EQU        SSPCON.0    


;=======================================
;  CCP1CON Register BIT Definitions 
;=======================================
CCP1X                EQU        CCP1CON.5   
CCP1Y                EQU        CCP1CON.4   
CCP1M3               EQU        CCP1CON.3   
CCP1M2               EQU        CCP1CON.2   
CCP1M1               EQU        CCP1CON.1   
CCP1M0               EQU        CCP1CON.0   


;=======================================
;  RCSTA Register BIT Definitions 
;=======================================
SPEN                 EQU        RCSTA.7     
RX9                  EQU        RCSTA.6     
RC9                  EQU        RCSTA.6     
NOT_RC8              EQU        RCSTA.6     
RC8_9                EQU        RCSTA.6     
SREN                 EQU        RCSTA.5     
CREN                 EQU        RCSTA.4     
ADDEN                EQU        RCSTA.3     
FERR                 EQU        RCSTA.2     
OERR                 EQU        RCSTA.1     
RX9D                 EQU        RCSTA.0     
RCD8                 EQU        RCSTA.0     


;=======================================
;  CCP2CON Register BIT Definitions 
;=======================================
CCP2X                EQU        CCP2CON.5   
CCP2Y                EQU        CCP2CON.4   
CCP2M3               EQU        CCP2CON.3   
CCP2M2               EQU        CCP2CON.2   
CCP2M1               EQU        CCP2CON.1   
CCP2M0               EQU        CCP2CON.0   


;=======================================
;  ADCON0 Register BIT Definitions 
;=======================================
ADCS1                EQU        ADCON0.7    
ADCS0                EQU        ADCON0.6    
CHS2                 EQU        ADCON0.5    
CHS1                 EQU        ADCON0.4    
CHS0                 EQU        ADCON0.3    
GO                   EQU        ADCON0.2    
NOT_DONE             EQU        ADCON0.2    
GO_DONE              EQU        ADCON0.2    
ADON                 EQU        ADCON0.0    


;=======================================
;  OPTION_REG Register BIT Definitions 
;=======================================
NOT_RBPU             EQU        OPTION_REG.7
INTEDG               EQU        OPTION_REG.6
T0CS                 EQU        OPTION_REG.5
T0SE                 EQU        OPTION_REG.4
PSA                  EQU        OPTION_REG.3
PS2                  EQU        OPTION_REG.2
PS1                  EQU        OPTION_REG.1
PS0                  EQU        OPTION_REG.0


;=======================================
;  TRISE Register BIT Definitions 
;=======================================
IBF                  EQU        TRISE.7     
OBF                  EQU        TRISE.6     
IBOV                 EQU        TRISE.5     
PSPMODE              EQU        TRISE.4     
TRISE2               EQU        TRISE.2     
TRISE1               EQU        TRISE.1     
TRISE0               EQU        TRISE.0     


;=======================================
;  PIE1 Register BIT Definitions 
;=======================================
PSPIE                EQU        PIE1.7      
ADIE                 EQU        PIE1.6      
RCIE                 EQU        PIE1.5      
TXIE                 EQU        PIE1.4      
SSPIE                EQU        PIE1.3      
CCP1IE               EQU        PIE1.2      
TMR2IE               EQU        PIE1.1      
TMR1IE               EQU        PIE1.0      


;=======================================
;  PIE2 Register BIT Definitions 
;=======================================
EEIE                 EQU        PIE2.4      
BCLIE                EQU        PIE2.3      
CCP2IE               EQU        PIE2.0      


;=======================================
;  PCON Register BIT Definitions 
;=======================================
NOT_POR              EQU        PCON.1      
NOT_BO               EQU        PCON.0      
NOT_BOR              EQU        PCON.0      


;=======================================
;  SSPCON2 Register BIT Definitions 
;=======================================
GCEN                 EQU        SSPCON2.7   
ACKSTAT              EQU        SSPCON2.6   
ACKDT                EQU        SSPCON2.5   
ACKEN                EQU        SSPCON2.4   
RCEN                 EQU        SSPCON2.3   
PEN                  EQU        SSPCON2.2   
RSEN                 EQU        SSPCON2.1   
SEN                  EQU        SSPCON2.0   


;=======================================
;  SSPSTAT Register BIT Definitions 
;=======================================
SMP                  EQU        SSPSTAT.7   
CKE                  EQU        SSPSTAT.6   
D                    EQU        SSPSTAT.5   
I2C_DATA             EQU        SSPSTAT.5   
NOT_A                EQU        SSPSTAT.5   
NOT_ADDRESS          EQU        SSPSTAT.5   
D_A                  EQU        SSPSTAT.5   
DATA_ADDRESS         EQU        SSPSTAT.5   
P                    EQU        SSPSTAT.4   
I2C_STOP             EQU        SSPSTAT.4   
S                    EQU        SSPSTAT.3   
I2C_START            EQU        SSPSTAT.3   
R                    EQU        SSPSTAT.2   
I2C_READ             EQU        SSPSTAT.2   
NOT_W                EQU        SSPSTAT.2   
NOT_WRITE            EQU        SSPSTAT.2   
R_W                  EQU        SSPSTAT.2   
READ_WRITE           EQU        SSPSTAT.2   
UA                   EQU        SSPSTAT.1   
BF                   EQU        SSPSTAT.0   


;=======================================
;  TXSTA Register BIT Definitions 
;=======================================
CSRC                 EQU        TXSTA.7     
TX9                  EQU        TXSTA.6     
NOT_TX8              EQU        TXSTA.6     
TX8_9                EQU        TXSTA.6     
TXEN                 EQU        TXSTA.5     
SYNC                 EQU        TXSTA.4     
BRGH                 EQU        TXSTA.2     
TRMT                 EQU        TXSTA.1     
TX9D                 EQU        TXSTA.0     
TXD8                 EQU        TXSTA.0     


;=======================================
;  ADCON1 Register BIT Definitions 
;=======================================
ADFM                 EQU        ADCON1.7    
PCFG3                EQU        ADCON1.3    
PCFG2                EQU        ADCON1.2    
PCFG1                EQU        ADCON1.1    
PCFG0                EQU        ADCON1.0    


;=======================================
;  EECON1 Register BIT Definitions 
;=======================================
EEPGD                EQU        EECON1.7    
WRERR                EQU        EECON1.3    
WREN                 EQU        EECON1.2    
WR                   EQU        EECON1.1    
RD                   EQU        EECON1.0    


;=======================================
;  Configuration (FUSE) BIT Definitions 
;=======================================
_CP_ALL              EQU        0FCFh       
_CP_HALF             EQU        1FDFh       
_CP_UPPER_256        EQU        2FEFh       
_CP_OFF              EQU        3FFFh       
_DEBUG_ON            EQU        37FFh       
_DEBUG_OFF           EQU        3FFFh       
_WRT_ENABLE_ON       EQU        3FFFh       
_WRT_ENABLE_OFF      EQU        3DFFh       
_CPD_ON              EQU        3EFFh       
_CPD_OFF             EQU        3FFFh       
_LVP_ON              EQU        3FFFh       
_LVP_OFF             EQU        3F7Fh       
_BODEN_ON            EQU        3FFFh       
_BODEN_OFF           EQU        3FBFh       
_PWRTE_OFF           EQU        3FFFh       
_PWRTE_ON            EQU        3FF7h       
_WDT_ON              EQU        3FFFh       
_WDT_OFF             EQU        3FFBh       
_LP_OSC              EQU        3FFCh       
_XT_OSC              EQU        3FFDh       
_HS_OSC              EQU        3FFEh       
_RC_OSC              EQU        3FFFh       
