/*
  Project: Scrolling message on LED dot matrix display
  MCU: PIC16F1847 @ 32.0 MHz
  Copyright @ Rajendra Bhatt
  Apr 14, 2012
*/

// Define 74HC595 connections.

 sbit Serial_Data at RA0_bit;
 sbit SH_Clk at RA1_bit;
 sbit ST_Clk at RA2_bit;

 unsigned short Buffer[8][8] = {
                              {0,0,0,0,0,0,},
                              {0,0,0,0,0,0,},
                              {0,0,0,0,0,0,},
                              {0,0,0,0,0,0,},
                              {0,0,0,0,0,0,},
                              {0,0,0,0,0,0,},
                              {0,0,0,0,0,0,},
                              {0,0,0,0,0,0,},
                              };

unsigned int speed, StringLength;
unsigned short i, l, k, row, scroll, temp, shift_step=1;
unsigned short m, SerialConnect=0, UserIP = 0;

const unsigned char default_message[]="THIS IS A DEMONSTRATION OF AN 8X48 LED MATRIX DISPLAY USING \
SHIFT REGISTERS AND PIC16F1847 MICROCONTROLLER. FOR MORE DETAILS VISIT \
WWW.EMBEDDED-LAB.COM.    ";

char message[250], index;

void Send_Data(unsigned short rw){
 unsigned short Mask, t, num, Flag;
 for (num = 0; num < 8; num++)
 {
  Mask = 0x01;
  for (t=0; t<6; t++)
  {
   Flag = Buffer[rw][num] & Mask;
   if(Flag==0) Serial_Data = 0;
   else Serial_Data = 1;
   SH_Clk = 1;
   SH_Clk = 0;
   Mask = Mask << 1;
   }
 }

  // Apply clock on ST_Clk
  ST_Clk = 1;
  ST_Clk = 0;

}

/* CharData is a two dimensional constant array that holds the 8-bit column values of
   individual rows for ASCII characters on a 8x8 matrix format.
*/
const unsigned short CharData[][8] ={
{0b000000, // " "
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b000000},
{0b000000,  // "!"
 0b000100,
 0b000100,
 0b000100,
 0b000100,
 0b000100,
 0b000000,
 0b000100},
{0b011011, // """
 0b001001,
 0b010010,
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b000000},
{0b000000, // "#"
 0b001010,
 0b001010,
 0b011111,
 0b001010,
 0b011111,
 0b001010,
 0b001010},
{0b000000, // "$"
 0b000100,
 0b001111,
 0b010100,
 0b001110,
 0b000101,
 0b011110,
 0b000100},
{0b001110, // "%"
 0b010000,
 0b001110,
 0b010001,
 0b010001,
 0b001110,
 0b001001,
 0b001110},
{0b000000, // "&"
 0b001000,
 0b010100,
 0b010100,
 0b001100,
 0b100101,
 0b1000010,
 0b001101},
{0b001100, // "'"
 0b000100,
 0b001000,
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b000000},
{0b000000, // "("
 0b000010,
 0b000100,
 0b001000,
 0b001000,
 0b001000,
 0b000100,
 0b000010},
{0b000000, // ")"
 0b001000,
 0b000100,
 0b000010,
 0b000010,
 0b000010,
 0b000100,
 0b001000},
{0b000000, // "*"
 0b000100,
 0b010101,
 0b001110,
 0b001110,
 0b001110,
 0b010101,
 0b000100},
{0b000000, // "+"
 0b000000,
 0b000100,
 0b000100,
 0b011111,
 0b000100,
 0b000100,
 0b000000},
{0b000000, // ","
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b001100,
 0b000100,
 0b001000},
{0b000000, // "-"
 0b000000,
 0b000000,
 0b000000,
 0b011111,
 0b000000,
 0b000000,
 0b000000},
{0b000000, // "."
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b001100,
 0b001100},
{0b000000, // "/"
 0b000000,
 0b000001,
 0b000010,
 0b000100,
 0b001000,
 0b010000,
 0b000000},
{0b000000, // "0"
 0b001110,
 0b010001,
 0b010011,
 0b010101,
 0b011001,
 0b010001,
 0b001110},
{0b000000, // "1"
 0b000100,
 0b001100,
 0b000100,
 0b000100,
 0b000100,
 0b000100,
 0b001110},
{0b000000, // "2"
 0b001110,
 0b010001,
 0b000001,
 0b000010,
 0b000100,
 0b001000,
 0b011111},
{0b000000, // "3"
 0b011111,
 0b000010,
 0b000100,
 0b000010,
 0b000001,
 0b010001,
 0b001110},
{0b000000, // "4"
 0b000010,
 0b000110,
 0b001010,
 0b010010,
 0b011111,
 0b000010,
 0b000010},
{0b000000, // "5"
 0b011111,
 0b010000,
 0b011110,
 0b000001,
 0b000001,
 0b010001,
 0b001110},
{0b000000, // "6"
 0b000110,
 0b001000,
 0b010000,
 0b011110,
 0b010001,
 0b010001,
 0b001110},
{0b000000, // "7"
 0b011111,
 0b000001,
 0b000010,
 0b000100,
 0b001000,
 0b001000,
 0b001000},
{0b000000, // "8"
 0b001110,
 0b010001,
 0b010001,
 0b001110,
 0b010001,
 0b010001,
 0b001110},
{0b000000, // "9"
 0b001110,
 0b010001,
 0b010001,
 0b001111,
 0b000001,
 0b000010,
 0b001100},
{0b000000, // ":"
 0b000000,
 0b001100,
 0b001100,
 0b000000,
 0b001100,
 0b001100,
 0b000000},
{0b000000, // ";"
 0b000000,
 0b001100,
 0b001100,
 0b000000,
 0b001100,
 0b000100,
 0b001000},
{0b000000, // "<"
 0b000001,
 0b000010,
 0b000100,
 0b001000,
 0b000100,
 0b000010,
 0b000001},
{0b000000, // "="
 0b000000,
 0b000000,
 0b011111,
 0b000000,
 0b011111,
 0b000000,
 0b000000},
{0b000000, // ">"
 0b010000,
 0b001000,
 0b000100,
 0b000010,
 0b000100,
 0b001000,
 0b010000},
{0b000000, // "?"
 0b001110,
 0b010001,
 0b000001,
 0b000010,
 0b000100,
 0b000000,
 0b000100},
{0b000000, // "@"
 0b001110,
 0b010001,
 0b010111,
 0b010101,
 0b010111,
 0b010000,
 0b001110},
{0b000000, // "A"
 0b000100,
 0b001010,
 0b010001,
 0b010001,
 0b011111,
 0b010001,
 0b010001},
{0b000000, // "B"
 0b011110,
 0b010001,
 0b010001,
 0b011110,
 0b010001,
 0b010001,
 0b011110},
{0b000000, // "C"
 0b001110,
 0b010001,
 0b010000,
 0b010000,
 0b010000,
 0b010001,
 0b001110},
{0b000000, // "D"
 0b011100,
 0b010010,
 0b010001,
 0b010001,
 0b010001,
 0b010010,
 0b011100},
{0b000000, // "E"
 0b011111,
 0b010000,
 0b010000,
 0b011110,
 0b010000,
 0b010000,
 0b011111},
{0b000000, // "F"
 0b011111,
 0b010000,
 0b010000,
 0b011110,
 0b010000,
 0b010000,
 0b010000},
{0b000000, // "G"
 0b001110,
 0b010001,
 0b010000,
 0b010111,
 0b010001,
 0b010001,
 0b001110},
{0b000000, // "H"
 0b010001,
 0b010001,
 0b010001,
 0b011111,
 0b010001,
 0b010001,
 0b010001},
{0b000000, // "I"
 0b001110,
 0b000100,
 0b000100,
 0b000100,
 0b000100,
 0b000100,
 0b001110},
{0b000000, // "J"
 0b001111,
 0b000010,
 0b000010,
 0b000010,
 0b000010,
 0b010010,
 0b001100},
{0b000000, // "K"
 0b010001,
 0b010010,
 0b010100,
 0b011000,
 0b010100,
 0b010010,
 0b010001},
{0b000000, // "L "
 0b010000,
 0b010000,
 0b010000,
 0b010000,
 0b010000,
 0b010000,
 0b011111},
{0b000000, // "M"
 0b010001,
 0b011011,
 0b010101,
 0b010101,
 0b010001,
 0b010001,
 0b010001},
{0b000000, // "N"
 0b010001,
 0b010001,
 0b011001,
 0b010101,
 0b010011,
 0b010001,
 0b010001},
{0b000000, // "O"
 0b001110,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b001110},
{0b000000, // "P"
 0b011110,
 0b010001,
 0b010001,
 0b011110,
 0b010000,
 0b010000,
 0b010000},
{0b000000, // "Q"
 0b001110,
 0b010001,
 0b010001,
 0b010001,
 0b010101,
 0b010010,
 0b001101},
{0b000000, // "R"
 0b011110,
 0b010001,
 0b010001,
 0b011110,
 0b010100,
 0b010010,
 0b010001},
{0b000000, // "S"
 0b001110,
 0b010001,
 0b010000,
 0b001110,
 0b000001,
 0b010001,
 0b001110},
{0b000000, // "T"
 0b011111,
 0b000100,
 0b000100,
 0b000100,
 0b000100,
 0b000100,
 0b000100},
{0b000000, // "U"
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b001110},
{0b000000, // "V"
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b001010,
 0b000100},
{0b000000, // "W"
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b010101,
 0b010101,
 0b001010},
{0b000000, // "X"
 0b010001,
 0b010001,
 0b001010,
 0b000100,
 0b001010,
 0b010001,
 0b010001},
{0b000000, // "Y"
 0b010001,
 0b010001,
 0b001010,
 0b000100,
 0b000100,
 0b000100,
 0b000100},
{0b000000, // "Z"
 0b011111,
 0b000001,
 0b000010,
 0b000100,
 0b001000,
 0b010000,
 0b011111},
{0b001110, // "["
 0b001000,
 0b001000,
 0b001000,
 0b001000,
 0b001000,
 0b001000,
 0b001110},
{0b010000, // "\"
 0b001000,
 0b001000,
 0b000100,
 0b000100,
 0b000010,
 0b000010,
 0b000001},
{0b001110, // "]"
 0b000010,
 0b000010,
 0b000010,
 0b000010,
 0b000010,
 0b000010,
 0b001110},
{0b000100, // "^"
 0b001010,
 0b010001,
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b000000},
{0b000000, // "_"
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b011111},
{0b001000, // "`"
 0b000100,
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b000000},
{0b000000, // "a"
 0b000000,
 0b000000,
 0b001110,
 0b000001,
 0b001111,
 0b010001,
 0b001111},
{0b000000, // "b"
 0b010000,
 0b010000,
 0b010000,
 0b011100,
 0b010010,
 0b010010,
 0b011100},
{0b000000, // "c"
 0b000000,
 0b000000,
 0b001110,
 0b010000,
 0b010000,
 0b010000,
 0b001110},
{0b000000, // "d"
 0b000001,
 0b000001,
 0b000001,
 0b000111,
 0b001001,
 0b001001,
 0b000111},
{0b000000, // "e"
 0b000000,
 0b000000,
 0b011100,
 0b010010,
 0b011110,
 0b010000,
 0b001110},
{0b000000, // "f"
 0b000011,
 0b000100,
 0b000100,
 0b000110,
 0b000100,
 0b000100,
 0b000100},
{0b000000, // "g"
 0b000000,
 0b000000,
 0b001111,
 0b010001,
 0b001111,
 0b000001,
 0b001110},
{0b000000, // "h"
 0b010000,
 0b010000,
 0b010000,
 0b011100,
 0b010010,
 0b010010,
 0b010010},
{0b000000, // "i"
 0b000000,
 0b000100,
 0b000000,
 0b000100,
 0b000100,
 0b000100,
 0b000100},
{0b000000, // "j"
 0b000001,
 0b000000,
 0b000111,
 0b000001,
 0b000001,
 0b010001,
 0b001110},
{0b000000, // "k"
 0b010000,
 0b010000,
 0b010100,
 0b011000,
 0b011000,
 0b010100,
 0b010000},
{0b000000, // "l"
 0b010000,
 0b010000,
 0b010000,
 0b010000,
 0b010000,
 0b010000,
 0b001100},
{0b000000, // "m"
 0b000000,
 0b000000,
 0b001010,
 0b010101,
 0b010001,
 0b010001,
 0b010001},
{0b000000, // "n"
 0b000000,
 0b000000,
 0b111110,
 0b011001,
 0b010001,
 0b010001,
 0b111110},
{0b000000, // "o"
 0b000000,
 0b000000,
 0b001110,
 0b010001,
 0b010001,
 0b010001,
 0b001110},
{0b000000, // "p"
 0b011100,
 0b010010,
 0b010010,
 0b011100,
 0b010000,
 0b010000,
 0b010000},
{0b000000, // "q"
 0b001110,
 0b010010,
 0b010010,
 0b001110,
 0b000010,
 0b000010,
 0b000001},
{0b000000, // "r"
 0b000000,
 0b000000,
 0b010111,
 0b011000,
 0b010000,
 0b010000,
 0b010000},
{0b000000, // "s"
 0b000000,
 0b000000,
 0b001110,
 0b010000,
 0b001110,
 0b000001,
 0b011110},
{0b000000, // "t"
 0b010000,
 0b010000,
 0b011100,
 0b010000,
 0b010000,
 0b010000,
 0b001100},
{0b000000, // "u"
 0b000000,
 0b000000,
 0b010010,
 0b010010,
 0b010010,
 0b010010,
 0b001100},
{0b000000, // "v"
 0b000000,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b001010,
 0b000100},
{0b000000, // "w"
 0b000000,
 0b000000,
 0b010001,
 0b010001,
 0b010001,
 0b010101,
 0b001010},
{0b000000, // "x"
 0b000000,
 0b000000,
 0b010001,
 0b001010,
 0b000100,
 0b001010,
 0b010001},
{0b000000, // "y"
 0b000000,
 0b010001,
 0b001010,
 0b000100,
 0b001000,
 0b001000,
 0b010000},
{0b000000, // "z"
 0b000000,
 0b000000,
 0b011111,
 0b000010,
 0b000100,
 0b001000,
 0b011111},
{0b000010, // "{"
 0b000100,
 0b000100,
 0b000100,
 0b001000,
 0b000100,
 0b000100,
 0b000010},
{0b000100, // "|"
 0b000100,
 0b000100,
 0b000100,
 0b000100,
 0b000100,
 0b000100,
 0b000100},
{0b001000, // "}"
 0b000100,
 0b000100,
 0b000100,
 0b000010,
 0b000100,
 0b000100,
 0b001000},
{0b000000, // "~"
 0b000000,
 0b000000,
 0b001010,
 0b011110,
 0b010100,
 0b000000,
 0b000000},
{0b000000, // "\0x7F"
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b000000,
 0b000000},
{0b001110, // ""
 0b010101,
 0b010001,
 0b010001,
 0b011111,
 0b010001,
 0b010001,
 0b010001},
{0b011111, // ""
 0b010100,
 0b010000,
 0b011110,
 0b010000,
 0b010000,
 0b010000,
 0b011111},
{0b011111, // ""
 0b000100,
 0b000100,
 0b000100,
 0b000100,
 0b000100,
 0b000100,
 0b011111},
{0b001110, // ""
 0b010101,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b001110},
{0b001110, // ""
 0b011011,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b001110},
{0b001110, // ""
 0b011011,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b001110},
{0b010101, // ""
 0b010101,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b001110},
{0b011011, // ""
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b001110},
{0b011011, // ""
 0b011011,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b010001,
 0b001110},
{0b000001, // ""
 0b000010,
 0b000000,
 0b001110,
 0b010010,
 0b010010,
 0b010010,
 0b001111},
{0b000001, // ""
 0b000010,
 0b000000,
 0b011100,
 0b010010,
 0b011110,
 0b010000,
 0b001110},
{0b000000, // ""
 0b000010,
 0b000100,
 0b000000,
 0b000100,
 0b000100,
 0b000100,
 0b000100},
{0b000001, // ""
 0b000010,
 0b000000,
 0b001100,
 0b010010,
 0b010010,
 0b010010,
 0b001100},
{0b000000, // ""
 0b001010,
 0b000000,
 0b001100,
 0b010010,
 0b010010,
 0b010010,
 0b001100},
{0b000101, // ""
 0b001010,
 0b000000,
 0b001100,
 0b010010,
 0b010010,
 0b010010,
 0b001100},
{0b000010, // ""
 0b000100,
 0b000000,
 0b010010,
 0b010010,
 0b010010,
 0b010010,
 0b001100},
{0b000000, // ""
 0b001010,
 0b000000,
 0b010010,
 0b010010,
 0b010010,
 0b010010,
 0b001100},
{0b000101, // ""
 0b001010,
 0b000000,
 0b010010,
 0b010010,
 0b010010,
 0b010010,
 0b001100},
{0b111111, // " " full rectagle
 0b111111,
 0b111111,
 0b111111,
 0b111111,
 0b111111,
 0b111111,
 0b111111}
};

void Delay_onesec(){
  Delay_ms(1000);
}
unsigned short Find_StrLength(){
  return strlen(message);
}

// Subroutine to load the stored message onto RAM
void Load_Data(){
 for (k=0; k<StringLength+5; k++){
  message[k] = EEPROM_Read(k+2);
 }
}

void Save_Message(){
char c;
  EEPROM_Write(0x00, 1);
  EEPROM_Write(0x01, StringLength);
  for(i=0; i<StringLength; i++)
  {
    c = message[i];
    if (c == 0xC1) c = 128; // ""
    if (c == 0xC9) c = 129; // ""
    if (c == 0xCD) c = 130; // ""
    if (c == 0xD3) c = 131; // ""
    if (c == 0xD6) c = 132; // ""
    if (c == 0xD5) c = 133; // ""
    if (c == 0xDA) c = 134; // ""
    if (c == 0xDC) c = 135; // ""
    if (c == 0xDB) c = 136; // ""
    if (c == 0xE1) c = 137; // ""
    if (c == 0xE9) c = 138; // ""
    if (c == 0xED) c = 139; // ""
    if (c == 0xF3) c = 140; // ""
    if (c == 0xF6) c = 141; // ""
    if (c == 0xF5) c = 142; // ""
    if (c == 0xFA) c = 143; // ""
    if (c == 0xFC) c = 144; // ""
    if (c == 0xFB) c = 145; // ""
    EEPROM_Write(i+2, c);
  }
  EEPROM_Write(i+2, 32);
  EEPROM_Write(i+3, 32);
  EEPROM_Write(i+4, 32);
  EEPROM_Write(i+5, 32);
  EEPROM_Write(i+6, 32);
  UART1_Write(13); // Carriage Return
  UART1_Write(10); // Line Feed
  UART1_Write_Text("MESSAGE SAVED!");
}

void ListenSerial(){
  unsigned char RxByte, c;
  UART1_Write_Text("---- 8X48 LED Matrix Display ----");
  UART1_Write(13); // Carriage Return
  UART1_Write(10); // Line Feed
  UART1_Write_Text("ARE YOU READY FOR YOUR INPUT? Y/N");
  Delay_onesec();
  Delay_onesec();
  Delay_onesec();
  Delay_onesec();
  Delay_onesec();
  Delay_onesec();
  if (UART1_Data_Ready()) {
    RxByte = UART1_Read();
    if(RxByte == 'Y') {
      UART1_Write(13); // Carriage Return
      UART1_Write(10); // Line Feed
      UART1_Write_Text("Great! Always terminate your message with #");
      UART1_Write(13); // Carriage Return
      UART1_Write(10); // Line Feed
      UART1_Write_Text("Waiting for your input (MAX. 250 char.) ...");
      while (!UART1_Data_Ready());          // if data is received
      UART1_Read_Text(message, "#", 249);    // reads text until '#' is found
      message[0] = ' ';
      StringLength = Find_StrLength();
      UART1_Write(13); // Carriage Return
      UART1_Write(10); // Line Feed
      UART1_Write_Text("Message received. Now saving into EEPROM ...");
      Save_Message();
    }
    if(RxByte == 'M') {
      UART1_Write(13); // Carriage Return
      UART1_Write(10); // Line Feed
      UART1_Write_Text("Great! Stored message: ");
      UART1_Write(13); // Carriage Return
      UART1_Write(10); // Line Feed
      Load_Data();
      StringLength = Find_StrLength();
      for (RxByte = 2; RxByte < StringLength + 2; RxByte++)
      {
          c = message[RxByte];
          if (c == 128) c = 0xC1; // ""
          if (c == 129) c = 0xC9; // ""
          if (c == 130) c = 0xCD; // ""
          if (c == 131) c = 0xD3; // ""
          if (c == 132) c = 0xD6; // ""
          if (c == 133) c = 0xD5; // ""
          if (c == 134) c = 0xDA; // ""
          if (c == 135) c = 0xDC; // ""
          if (c == 136) c = 0xDB; // ""
          if (c == 137) c = 0xE1; // ""
          if (c == 138) c = 0xE9; // ""
          if (c == 139) c = 0xED; // ""
          if (c == 140) c = 0xF3; // ""
          if (c == 141) c = 0xF6; // ""
          if (c == 142) c = 0xF5; // ""
          if (c == 143) c = 0xFA; // ""
          if (c == 144) c = 0xFC; // ""
          if (c == 145) c = 0xFB; // ""
          UART1_Write(c); // Current character
      }
      UART1_Write(13); // Carriage Return
      UART1_Write(10); // Line Feed
    }
  }
}

void main() {
 OSCCON = 0b01110000;  // 32 MHz internal
 ANSELA = 0b00000000;  // PORTA all digital pins
 ANSELB = 0b00000000;  // PORTB all digital pins
 TRISA  = 0b00100000;  // RA5 is input only
 TRISB  = 0b00000010;  // RB1 is UART Rx
 PORTB  = 0;
 UART1_Init(115200);
 Delay_ms(100);
 ListenSerial();       // Check for serial data receive
 TRISB  = 0b00000000;  // PORTB is now all output
 RCSTA  = 0x00;
 // Read first two EEPROM locations
 UserIP = EEPROM_Read(0x00);
 
 if(UserIP == 1) {
   StringLength = EEPROM_Read(0x01);
   Load_Data();  // Read stored data and save into RAM
 }
 else  StringLength = strlen(default_message);

 do {
 for (k=0; k < StringLength + 5; k++){
  for (scroll=0; scroll<(6/shift_step); scroll++) {
   for (row=0; row<8; row++){
     if(UserIP == 1) index = message[k];
     else index = default_message[k];
     if (index > 146) index = 146;
     temp = CharData[index-32][row];
     Buffer[row][7] = (Buffer[row][7] << Shift_Step) | (Buffer[row][6] >> (6-Shift_Step));
     Buffer[row][6] = (Buffer[row][6] << Shift_Step) | (Buffer[row][5] >> (6-Shift_Step));
     Buffer[row][5] = (Buffer[row][5] << Shift_Step) | (Buffer[row][4] >> (6-Shift_Step));
     Buffer[row][4] = (Buffer[row][4] << Shift_Step) | (Buffer[row][3] >> (6-Shift_Step));
     Buffer[row][3] = (Buffer[row][3] << Shift_Step) | (Buffer[row][2] >> (6-Shift_Step));
     Buffer[row][2] = (Buffer[row][2] << Shift_Step) | (Buffer[row][1] >> (6-Shift_Step));
     Buffer[row][1] = (Buffer[row][1] << Shift_Step) | (Buffer[row][0] >> (6-Shift_Step));
     Buffer[row][0] = (Buffer[row][0] << Shift_Step)| (temp >> ((6-shift_step)-scroll*shift_step));
   }
   speed = 15;
   for(l=0; l<speed;l++){
     m = 1;
     for (i=0; i<8; i++) {
       Send_Data(i);
       LATB = m;
       m = m << 1;
       Delay_us(1000);
     }  // i
   } // l
  } // scroll
 } // k

} while(1);
}