
_Send_Data:

;LED_Matrix_With_UART.c,35 :: 		void Send_Data(unsigned short rw){
;LED_Matrix_With_UART.c,37 :: 		for (num = 0; num < 8; num++)
	CLRF       R5+0
L_Send_Data0:
	MOVLW      8
	SUBWF      R5+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_Send_Data1
;LED_Matrix_With_UART.c,39 :: 		Mask = 0x01;
	MOVLW      1
	MOVWF      R3+0
;LED_Matrix_With_UART.c,40 :: 		for (t=0; t<6; t++)
	CLRF       R4+0
L_Send_Data3:
	MOVLW      6
	SUBWF      R4+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_Send_Data4
;LED_Matrix_With_UART.c,42 :: 		Flag = Buffer[rw][num] & Mask;
	MOVLW      3
	MOVWF      R2
	MOVF       FARG_Send_Data_rw+0, 0
	MOVWF      R0
	CLRF       R1
	MOVF       R2, 0
L__Send_Data85:
	BTFSC      STATUS+0, 2
	GOTO       L__Send_Data86
	LSLF       R0, 1
	RLF        R1, 1
	ADDLW      255
	GOTO       L__Send_Data85
L__Send_Data86:
	MOVLW      _Buffer+0
	ADDWF      R0, 1
	MOVLW      hi_addr(_Buffer+0)
	ADDWFC     R1, 1
	MOVF       R5+0, 0
	ADDWF      R0, 0
	MOVWF      FSR0L
	MOVLW      0
	ADDWFC     R1, 0
	MOVWF      FSR0H
	MOVF       R3+0, 0
	ANDWF      INDF0+0, 0
	MOVWF      R1
;LED_Matrix_With_UART.c,43 :: 		if(Flag==0) Serial_Data = 0;
	MOVF       R1, 0
	XORLW      0
	BTFSS      STATUS+0, 2
	GOTO       L_Send_Data6
	BCF        RA0_bit+0, 0
	GOTO       L_Send_Data7
L_Send_Data6:
;LED_Matrix_With_UART.c,44 :: 		else Serial_Data = 1;
	BSF        RA0_bit+0, 0
L_Send_Data7:
;LED_Matrix_With_UART.c,45 :: 		SH_Clk = 1;
	BSF        RA1_bit+0, 1
;LED_Matrix_With_UART.c,46 :: 		SH_Clk = 0;
	BCF        RA1_bit+0, 1
;LED_Matrix_With_UART.c,47 :: 		Mask = Mask << 1;
	LSLF       R3+0, 1
;LED_Matrix_With_UART.c,40 :: 		for (t=0; t<6; t++)
	INCF       R4+0, 1
;LED_Matrix_With_UART.c,48 :: 		}
	GOTO       L_Send_Data3
L_Send_Data4:
;LED_Matrix_With_UART.c,37 :: 		for (num = 0; num < 8; num++)
	INCF       R5+0, 1
;LED_Matrix_With_UART.c,49 :: 		}
	GOTO       L_Send_Data0
L_Send_Data1:
;LED_Matrix_With_UART.c,52 :: 		ST_Clk = 1;
	BSF        RA2_bit+0, 2
;LED_Matrix_With_UART.c,53 :: 		ST_Clk = 0;
	BCF        RA2_bit+0, 2
;LED_Matrix_With_UART.c,55 :: 		}
L_end_Send_Data:
	RETURN
; end of _Send_Data

_Delay_onesec:

;LED_Matrix_With_UART.c,983 :: 		void Delay_onesec(){
;LED_Matrix_With_UART.c,984 :: 		Delay_ms(1000);
	MOVLW      41
	MOVWF      R11
	MOVLW      150
	MOVWF      R12
	MOVLW      127
	MOVWF      R13
L_Delay_onesec8:
	DECFSZ     R13, 1
	GOTO       L_Delay_onesec8
	DECFSZ     R12, 1
	GOTO       L_Delay_onesec8
	DECFSZ     R11, 1
	GOTO       L_Delay_onesec8
;LED_Matrix_With_UART.c,985 :: 		}
L_end_Delay_onesec:
	RETURN
; end of _Delay_onesec

_Find_StrLength:

;LED_Matrix_With_UART.c,986 :: 		unsigned short Find_StrLength(){
;LED_Matrix_With_UART.c,987 :: 		return strlen(message);
	MOVLW      _message+0
	MOVWF      FARG_strlen_s+0
	MOVLW      hi_addr(_message+0)
	MOVWF      FARG_strlen_s+1
	CALL       _strlen+0
;LED_Matrix_With_UART.c,988 :: 		}
L_end_Find_StrLength:
	RETURN
; end of _Find_StrLength

_Load_Data:

;LED_Matrix_With_UART.c,991 :: 		void Load_Data(){
;LED_Matrix_With_UART.c,992 :: 		for (k=0; k<StringLength+5; k++){
	CLRF       _k+0
L_Load_Data9:
	MOVLW      5
	ADDWF      _StringLength+0, 0
	MOVWF      R1
	MOVLW      0
	ADDWFC     _StringLength+1, 0
	MOVWF      R2
	MOVF       R2, 0
	SUBLW      0
	BTFSS      STATUS+0, 2
	GOTO       L__Load_Data90
	MOVF       R1, 0
	SUBWF      _k+0, 0
L__Load_Data90:
	BTFSC      STATUS+0, 0
	GOTO       L_Load_Data10
;LED_Matrix_With_UART.c,993 :: 		message[k] = EEPROM_Read(k+2);
	MOVLW      _message+0
	MOVWF      R0
	MOVLW      hi_addr(_message+0)
	MOVWF      R1
	MOVF       _k+0, 0
	ADDWF      R0, 0
	MOVWF      FLOC__Load_Data+0
	MOVLW      0
	ADDWFC     R1, 0
	MOVWF      FLOC__Load_Data+1
	MOVLW      2
	ADDWF      _k+0, 0
	MOVWF      FARG_EEPROM_Read_Address+0
	CALL       _EEPROM_Read+0
	MOVF       FLOC__Load_Data+0, 0
	MOVWF      FSR1L
	MOVF       FLOC__Load_Data+1, 0
	MOVWF      FSR1H
	MOVF       R0, 0
	MOVWF      INDF1+0
;LED_Matrix_With_UART.c,992 :: 		for (k=0; k<StringLength+5; k++){
	INCF       _k+0, 1
;LED_Matrix_With_UART.c,994 :: 		}
	GOTO       L_Load_Data9
L_Load_Data10:
;LED_Matrix_With_UART.c,995 :: 		}
L_end_Load_Data:
	RETURN
; end of _Load_Data

_Save_Message:

;LED_Matrix_With_UART.c,997 :: 		void Save_Message(){
;LED_Matrix_With_UART.c,999 :: 		EEPROM_Write(0x00, 1);
	CLRF       FARG_EEPROM_Write_Address+0
	MOVLW      1
	MOVWF      FARG_EEPROM_Write_data_+0
	CALL       _EEPROM_Write+0
;LED_Matrix_With_UART.c,1000 :: 		EEPROM_Write(0x01, StringLength);
	MOVLW      1
	MOVWF      FARG_EEPROM_Write_Address+0
	MOVF       _StringLength+0, 0
	MOVWF      FARG_EEPROM_Write_data_+0
	CALL       _EEPROM_Write+0
;LED_Matrix_With_UART.c,1001 :: 		for(i=0; i<StringLength; i++)
	CLRF       _i+0
L_Save_Message12:
	MOVF       _StringLength+1, 0
	SUBLW      0
	BTFSS      STATUS+0, 2
	GOTO       L__Save_Message92
	MOVF       _StringLength+0, 0
	SUBWF      _i+0, 0
L__Save_Message92:
	BTFSC      STATUS+0, 0
	GOTO       L_Save_Message13
;LED_Matrix_With_UART.c,1003 :: 		c = message[i];
	MOVLW      _message+0
	MOVWF      R0
	MOVLW      hi_addr(_message+0)
	MOVWF      R1
	MOVF       _i+0, 0
	ADDWF      R0, 0
	MOVWF      FSR0L
	MOVLW      0
	ADDWFC     R1, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R1
	MOVF       R1, 0
	MOVWF      Save_Message_c_L0+0
;LED_Matrix_With_UART.c,1004 :: 		if (c == 0xC1) c = 128; // ""
	MOVF       R1, 0
	XORLW      193
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message15
	MOVLW      128
	MOVWF      Save_Message_c_L0+0
L_Save_Message15:
;LED_Matrix_With_UART.c,1005 :: 		if (c == 0xC9) c = 129; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      201
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message16
	MOVLW      129
	MOVWF      Save_Message_c_L0+0
L_Save_Message16:
;LED_Matrix_With_UART.c,1006 :: 		if (c == 0xCD) c = 130; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      205
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message17
	MOVLW      130
	MOVWF      Save_Message_c_L0+0
L_Save_Message17:
;LED_Matrix_With_UART.c,1007 :: 		if (c == 0xD3) c = 131; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      211
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message18
	MOVLW      131
	MOVWF      Save_Message_c_L0+0
L_Save_Message18:
;LED_Matrix_With_UART.c,1008 :: 		if (c == 0xD6) c = 132; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      214
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message19
	MOVLW      132
	MOVWF      Save_Message_c_L0+0
L_Save_Message19:
;LED_Matrix_With_UART.c,1009 :: 		if (c == 0xD5) c = 133; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      213
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message20
	MOVLW      133
	MOVWF      Save_Message_c_L0+0
L_Save_Message20:
;LED_Matrix_With_UART.c,1010 :: 		if (c == 0xDA) c = 134; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      218
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message21
	MOVLW      134
	MOVWF      Save_Message_c_L0+0
L_Save_Message21:
;LED_Matrix_With_UART.c,1011 :: 		if (c == 0xDC) c = 135; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      220
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message22
	MOVLW      135
	MOVWF      Save_Message_c_L0+0
L_Save_Message22:
;LED_Matrix_With_UART.c,1012 :: 		if (c == 0xDB) c = 136; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      219
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message23
	MOVLW      136
	MOVWF      Save_Message_c_L0+0
L_Save_Message23:
;LED_Matrix_With_UART.c,1013 :: 		if (c == 0xE1) c = 137; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      225
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message24
	MOVLW      137
	MOVWF      Save_Message_c_L0+0
L_Save_Message24:
;LED_Matrix_With_UART.c,1014 :: 		if (c == 0xE9) c = 138; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      233
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message25
	MOVLW      138
	MOVWF      Save_Message_c_L0+0
L_Save_Message25:
;LED_Matrix_With_UART.c,1015 :: 		if (c == 0xED) c = 139; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      237
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message26
	MOVLW      139
	MOVWF      Save_Message_c_L0+0
L_Save_Message26:
;LED_Matrix_With_UART.c,1016 :: 		if (c == 0xF3) c = 140; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      243
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message27
	MOVLW      140
	MOVWF      Save_Message_c_L0+0
L_Save_Message27:
;LED_Matrix_With_UART.c,1017 :: 		if (c == 0xF6) c = 141; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      246
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message28
	MOVLW      141
	MOVWF      Save_Message_c_L0+0
L_Save_Message28:
;LED_Matrix_With_UART.c,1018 :: 		if (c == 0xF5) c = 142; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      245
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message29
	MOVLW      142
	MOVWF      Save_Message_c_L0+0
L_Save_Message29:
;LED_Matrix_With_UART.c,1019 :: 		if (c == 0xFA) c = 143; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      250
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message30
	MOVLW      143
	MOVWF      Save_Message_c_L0+0
L_Save_Message30:
;LED_Matrix_With_UART.c,1020 :: 		if (c == 0xFC) c = 144; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      252
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message31
	MOVLW      144
	MOVWF      Save_Message_c_L0+0
L_Save_Message31:
;LED_Matrix_With_UART.c,1021 :: 		if (c == 0xFB) c = 145; // ""
	MOVF       Save_Message_c_L0+0, 0
	XORLW      251
	BTFSS      STATUS+0, 2
	GOTO       L_Save_Message32
	MOVLW      145
	MOVWF      Save_Message_c_L0+0
L_Save_Message32:
;LED_Matrix_With_UART.c,1022 :: 		EEPROM_Write(i+2, c);
	MOVLW      2
	ADDWF      _i+0, 0
	MOVWF      FARG_EEPROM_Write_Address+0
	MOVF       Save_Message_c_L0+0, 0
	MOVWF      FARG_EEPROM_Write_data_+0
	CALL       _EEPROM_Write+0
;LED_Matrix_With_UART.c,1001 :: 		for(i=0; i<StringLength; i++)
	INCF       _i+0, 1
;LED_Matrix_With_UART.c,1023 :: 		}
	GOTO       L_Save_Message12
L_Save_Message13:
;LED_Matrix_With_UART.c,1024 :: 		EEPROM_Write(i+2, 32);
	MOVLW      2
	ADDWF      _i+0, 0
	MOVWF      FARG_EEPROM_Write_Address+0
	MOVLW      32
	MOVWF      FARG_EEPROM_Write_data_+0
	CALL       _EEPROM_Write+0
;LED_Matrix_With_UART.c,1025 :: 		EEPROM_Write(i+3, 32);
	MOVLW      3
	ADDWF      _i+0, 0
	MOVWF      FARG_EEPROM_Write_Address+0
	MOVLW      32
	MOVWF      FARG_EEPROM_Write_data_+0
	CALL       _EEPROM_Write+0
;LED_Matrix_With_UART.c,1026 :: 		EEPROM_Write(i+4, 32);
	MOVLW      4
	ADDWF      _i+0, 0
	MOVWF      FARG_EEPROM_Write_Address+0
	MOVLW      32
	MOVWF      FARG_EEPROM_Write_data_+0
	CALL       _EEPROM_Write+0
;LED_Matrix_With_UART.c,1027 :: 		EEPROM_Write(i+5, 32);
	MOVLW      5
	ADDWF      _i+0, 0
	MOVWF      FARG_EEPROM_Write_Address+0
	MOVLW      32
	MOVWF      FARG_EEPROM_Write_data_+0
	CALL       _EEPROM_Write+0
;LED_Matrix_With_UART.c,1028 :: 		EEPROM_Write(i+6, 32);
	MOVLW      6
	ADDWF      _i+0, 0
	MOVWF      FARG_EEPROM_Write_Address+0
	MOVLW      32
	MOVWF      FARG_EEPROM_Write_data_+0
	CALL       _EEPROM_Write+0
;LED_Matrix_With_UART.c,1029 :: 		UART1_Write(13); // Carriage Return
	MOVLW      13
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1030 :: 		UART1_Write(10); // Line Feed
	MOVLW      10
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1031 :: 		UART1_Write_Text("MESSAGE SAVED!");
	MOVLW      ?lstr1_LED_Matrix_With_UART+0
	MOVWF      FARG_UART1_Write_Text_uart_text+0
	MOVLW      hi_addr(?lstr1_LED_Matrix_With_UART+0)
	MOVWF      FARG_UART1_Write_Text_uart_text+1
	CALL       _UART1_Write_Text+0
;LED_Matrix_With_UART.c,1032 :: 		}
L_end_Save_Message:
	RETURN
; end of _Save_Message

_ListenSerial:

;LED_Matrix_With_UART.c,1034 :: 		void ListenSerial(){
;LED_Matrix_With_UART.c,1036 :: 		UART1_Write_Text("---- 8X48 LED Matrix Display ----");
	MOVLW      ?lstr2_LED_Matrix_With_UART+0
	MOVWF      FARG_UART1_Write_Text_uart_text+0
	MOVLW      hi_addr(?lstr2_LED_Matrix_With_UART+0)
	MOVWF      FARG_UART1_Write_Text_uart_text+1
	CALL       _UART1_Write_Text+0
;LED_Matrix_With_UART.c,1037 :: 		UART1_Write(13); // Carriage Return
	MOVLW      13
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1038 :: 		UART1_Write(10); // Line Feed
	MOVLW      10
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1039 :: 		UART1_Write_Text("ARE YOU READY FOR YOUR INPUT? Y/N");
	MOVLW      ?lstr3_LED_Matrix_With_UART+0
	MOVWF      FARG_UART1_Write_Text_uart_text+0
	MOVLW      hi_addr(?lstr3_LED_Matrix_With_UART+0)
	MOVWF      FARG_UART1_Write_Text_uart_text+1
	CALL       _UART1_Write_Text+0
;LED_Matrix_With_UART.c,1040 :: 		Delay_onesec();
	CALL       _Delay_onesec+0
;LED_Matrix_With_UART.c,1041 :: 		Delay_onesec();
	CALL       _Delay_onesec+0
;LED_Matrix_With_UART.c,1042 :: 		Delay_onesec();
	CALL       _Delay_onesec+0
;LED_Matrix_With_UART.c,1043 :: 		Delay_onesec();
	CALL       _Delay_onesec+0
;LED_Matrix_With_UART.c,1044 :: 		Delay_onesec();
	CALL       _Delay_onesec+0
;LED_Matrix_With_UART.c,1045 :: 		Delay_onesec();
	CALL       _Delay_onesec+0
;LED_Matrix_With_UART.c,1046 :: 		if (UART1_Data_Ready()) {
	CALL       _UART1_Data_Ready+0
	MOVF       R0, 0
	BTFSC      STATUS+0, 2
	GOTO       L_ListenSerial33
;LED_Matrix_With_UART.c,1047 :: 		RxByte = UART1_Read();
	CALL       _UART1_Read+0
	MOVF       R0, 0
	MOVWF      ListenSerial_RxByte_L0+0
;LED_Matrix_With_UART.c,1048 :: 		if(RxByte == 'Y') {
	MOVF       R0, 0
	XORLW      89
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial34
;LED_Matrix_With_UART.c,1049 :: 		UART1_Write(13); // Carriage Return
	MOVLW      13
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1050 :: 		UART1_Write(10); // Line Feed
	MOVLW      10
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1051 :: 		UART1_Write_Text("Great! Always terminate your message with #");
	MOVLW      ?lstr4_LED_Matrix_With_UART+0
	MOVWF      FARG_UART1_Write_Text_uart_text+0
	MOVLW      hi_addr(?lstr4_LED_Matrix_With_UART+0)
	MOVWF      FARG_UART1_Write_Text_uart_text+1
	CALL       _UART1_Write_Text+0
;LED_Matrix_With_UART.c,1052 :: 		UART1_Write(13); // Carriage Return
	MOVLW      13
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1053 :: 		UART1_Write(10); // Line Feed
	MOVLW      10
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1054 :: 		UART1_Write_Text("Waiting for your input (MAX. 250 char.) ...");
	MOVLW      ?lstr5_LED_Matrix_With_UART+0
	MOVWF      FARG_UART1_Write_Text_uart_text+0
	MOVLW      hi_addr(?lstr5_LED_Matrix_With_UART+0)
	MOVWF      FARG_UART1_Write_Text_uart_text+1
	CALL       _UART1_Write_Text+0
;LED_Matrix_With_UART.c,1055 :: 		while (!UART1_Data_Ready());          // if data is received
L_ListenSerial35:
	CALL       _UART1_Data_Ready+0
	MOVF       R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial36
	GOTO       L_ListenSerial35
L_ListenSerial36:
;LED_Matrix_With_UART.c,1056 :: 		UART1_Read_Text(message, "#", 249);    // reads text until '#' is found
	MOVLW      _message+0
	MOVWF      FARG_UART1_Read_Text_Output+0
	MOVLW      hi_addr(_message+0)
	MOVWF      FARG_UART1_Read_Text_Output+1
	MOVLW      ?lstr6_LED_Matrix_With_UART+0
	MOVWF      FARG_UART1_Read_Text_Delimiter+0
	MOVLW      hi_addr(?lstr6_LED_Matrix_With_UART+0)
	MOVWF      FARG_UART1_Read_Text_Delimiter+1
	MOVLW      249
	MOVWF      FARG_UART1_Read_Text_Attempts+0
	CALL       _UART1_Read_Text+0
;LED_Matrix_With_UART.c,1057 :: 		message[0] = ' ';
	MOVLW      _message+0
	MOVWF      FSR1L
	MOVLW      hi_addr(_message+0)
	MOVWF      FSR1H
	MOVLW      32
	MOVWF      INDF1+0
;LED_Matrix_With_UART.c,1058 :: 		StringLength = Find_StrLength();
	CALL       _Find_StrLength+0
	MOVF       R0, 0
	MOVWF      _StringLength+0
	CLRF       _StringLength+1
;LED_Matrix_With_UART.c,1059 :: 		UART1_Write(13); // Carriage Return
	MOVLW      13
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1060 :: 		UART1_Write(10); // Line Feed
	MOVLW      10
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1061 :: 		UART1_Write_Text("Message received. Now saving into EEPROM ...");
	MOVLW      ?lstr7_LED_Matrix_With_UART+0
	MOVWF      FARG_UART1_Write_Text_uart_text+0
	MOVLW      hi_addr(?lstr7_LED_Matrix_With_UART+0)
	MOVWF      FARG_UART1_Write_Text_uart_text+1
	CALL       _UART1_Write_Text+0
;LED_Matrix_With_UART.c,1062 :: 		Save_Message();
	CALL       _Save_Message+0
;LED_Matrix_With_UART.c,1063 :: 		}
L_ListenSerial34:
;LED_Matrix_With_UART.c,1064 :: 		if(RxByte == 'M') {
	MOVF       ListenSerial_RxByte_L0+0, 0
	XORLW      77
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial37
;LED_Matrix_With_UART.c,1065 :: 		UART1_Write(13); // Carriage Return
	MOVLW      13
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1066 :: 		UART1_Write(10); // Line Feed
	MOVLW      10
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1067 :: 		UART1_Write_Text("Great! Stored message: ");
	MOVLW      ?lstr8_LED_Matrix_With_UART+0
	MOVWF      FARG_UART1_Write_Text_uart_text+0
	MOVLW      hi_addr(?lstr8_LED_Matrix_With_UART+0)
	MOVWF      FARG_UART1_Write_Text_uart_text+1
	CALL       _UART1_Write_Text+0
;LED_Matrix_With_UART.c,1068 :: 		UART1_Write(13); // Carriage Return
	MOVLW      13
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1069 :: 		UART1_Write(10); // Line Feed
	MOVLW      10
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1070 :: 		Load_Data();
	CALL       _Load_Data+0
;LED_Matrix_With_UART.c,1071 :: 		StringLength = Find_StrLength();
	CALL       _Find_StrLength+0
	MOVF       R0, 0
	MOVWF      _StringLength+0
	CLRF       _StringLength+1
;LED_Matrix_With_UART.c,1072 :: 		for (RxByte = 2; RxByte < StringLength + 2; RxByte++)
	MOVLW      2
	MOVWF      ListenSerial_RxByte_L0+0
L_ListenSerial38:
	MOVLW      2
	ADDWF      _StringLength+0, 0
	MOVWF      R1
	MOVLW      0
	ADDWFC     _StringLength+1, 0
	MOVWF      R2
	MOVF       R2, 0
	SUBLW      0
	BTFSS      STATUS+0, 2
	GOTO       L__ListenSerial94
	MOVF       R1, 0
	SUBWF      ListenSerial_RxByte_L0+0, 0
L__ListenSerial94:
	BTFSC      STATUS+0, 0
	GOTO       L_ListenSerial39
;LED_Matrix_With_UART.c,1074 :: 		c = message[RxByte];
	MOVLW      _message+0
	MOVWF      R0
	MOVLW      hi_addr(_message+0)
	MOVWF      R1
	MOVF       ListenSerial_RxByte_L0+0, 0
	ADDWF      R0, 0
	MOVWF      FSR0L
	MOVLW      0
	ADDWFC     R1, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R1
	MOVF       R1, 0
	MOVWF      ListenSerial_c_L0+0
;LED_Matrix_With_UART.c,1075 :: 		if (c == 128) c = 0xC1; // ""
	MOVF       R1, 0
	XORLW      128
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial41
	MOVLW      193
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial41:
;LED_Matrix_With_UART.c,1076 :: 		if (c == 129) c = 0xC9; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      129
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial42
	MOVLW      201
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial42:
;LED_Matrix_With_UART.c,1077 :: 		if (c == 130) c = 0xCD; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      130
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial43
	MOVLW      205
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial43:
;LED_Matrix_With_UART.c,1078 :: 		if (c == 131) c = 0xD3; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      131
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial44
	MOVLW      211
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial44:
;LED_Matrix_With_UART.c,1079 :: 		if (c == 132) c = 0xD6; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      132
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial45
	MOVLW      214
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial45:
;LED_Matrix_With_UART.c,1080 :: 		if (c == 133) c = 0xD5; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      133
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial46
	MOVLW      213
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial46:
;LED_Matrix_With_UART.c,1081 :: 		if (c == 134) c = 0xDA; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      134
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial47
	MOVLW      218
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial47:
;LED_Matrix_With_UART.c,1082 :: 		if (c == 135) c = 0xDC; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      135
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial48
	MOVLW      220
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial48:
;LED_Matrix_With_UART.c,1083 :: 		if (c == 136) c = 0xDB; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      136
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial49
	MOVLW      219
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial49:
;LED_Matrix_With_UART.c,1084 :: 		if (c == 137) c = 0xE1; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      137
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial50
	MOVLW      225
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial50:
;LED_Matrix_With_UART.c,1085 :: 		if (c == 138) c = 0xE9; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      138
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial51
	MOVLW      233
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial51:
;LED_Matrix_With_UART.c,1086 :: 		if (c == 139) c = 0xED; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      139
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial52
	MOVLW      237
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial52:
;LED_Matrix_With_UART.c,1087 :: 		if (c == 140) c = 0xF3; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      140
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial53
	MOVLW      243
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial53:
;LED_Matrix_With_UART.c,1088 :: 		if (c == 141) c = 0xF6; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      141
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial54
	MOVLW      246
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial54:
;LED_Matrix_With_UART.c,1089 :: 		if (c == 142) c = 0xF5; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      142
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial55
	MOVLW      245
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial55:
;LED_Matrix_With_UART.c,1090 :: 		if (c == 143) c = 0xFA; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      143
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial56
	MOVLW      250
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial56:
;LED_Matrix_With_UART.c,1091 :: 		if (c == 144) c = 0xFC; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      144
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial57
	MOVLW      252
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial57:
;LED_Matrix_With_UART.c,1092 :: 		if (c == 145) c = 0xFB; // ""
	MOVF       ListenSerial_c_L0+0, 0
	XORLW      145
	BTFSS      STATUS+0, 2
	GOTO       L_ListenSerial58
	MOVLW      251
	MOVWF      ListenSerial_c_L0+0
L_ListenSerial58:
;LED_Matrix_With_UART.c,1093 :: 		UART1_Write(c); // Current character
	MOVF       ListenSerial_c_L0+0, 0
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1072 :: 		for (RxByte = 2; RxByte < StringLength + 2; RxByte++)
	INCF       ListenSerial_RxByte_L0+0, 1
;LED_Matrix_With_UART.c,1094 :: 		}
	GOTO       L_ListenSerial38
L_ListenSerial39:
;LED_Matrix_With_UART.c,1095 :: 		UART1_Write(13); // Carriage Return
	MOVLW      13
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1096 :: 		UART1_Write(10); // Line Feed
	MOVLW      10
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;LED_Matrix_With_UART.c,1097 :: 		}
L_ListenSerial37:
;LED_Matrix_With_UART.c,1098 :: 		}
L_ListenSerial33:
;LED_Matrix_With_UART.c,1099 :: 		}
L_end_ListenSerial:
	RETURN
; end of _ListenSerial

_main:

;LED_Matrix_With_UART.c,1101 :: 		void main() {
;LED_Matrix_With_UART.c,1102 :: 		OSCCON = 0b01110000;  // 32 MHz internal
	MOVLW      112
	MOVWF      OSCCON+0
;LED_Matrix_With_UART.c,1103 :: 		ANSELA = 0b00000000;  // PORTA all digital pins
	CLRF       ANSELA+0
;LED_Matrix_With_UART.c,1104 :: 		ANSELB = 0b00000000;  // PORTB all digital pins
	CLRF       ANSELB+0
;LED_Matrix_With_UART.c,1105 :: 		TRISA  = 0b00100000;  // RA5 is input only
	MOVLW      32
	MOVWF      TRISA+0
;LED_Matrix_With_UART.c,1106 :: 		TRISB  = 0b00000010;  // RB1 is UART Rx
	MOVLW      2
	MOVWF      TRISB+0
;LED_Matrix_With_UART.c,1107 :: 		PORTB  = 0;
	CLRF       PORTB+0
;LED_Matrix_With_UART.c,1108 :: 		UART1_Init(115200);
	BSF        BAUDCON+0, 3
	MOVLW      68
	MOVWF      SPBRG+0
	MOVLW      0
	MOVWF      SPBRG+1
	BSF        TXSTA+0, 2
	CALL       _UART1_Init+0
;LED_Matrix_With_UART.c,1109 :: 		Delay_ms(100);
	MOVLW      5
	MOVWF      R11
	MOVLW      15
	MOVWF      R12
	MOVLW      241
	MOVWF      R13
L_main59:
	DECFSZ     R13, 1
	GOTO       L_main59
	DECFSZ     R12, 1
	GOTO       L_main59
	DECFSZ     R11, 1
	GOTO       L_main59
;LED_Matrix_With_UART.c,1110 :: 		ListenSerial();       // Check for serial data receive
	CALL       _ListenSerial+0
;LED_Matrix_With_UART.c,1111 :: 		TRISB  = 0b00000000;  // PORTB is now all output
	CLRF       TRISB+0
;LED_Matrix_With_UART.c,1112 :: 		RCSTA  = 0x00;
	CLRF       RCSTA+0
;LED_Matrix_With_UART.c,1114 :: 		UserIP = EEPROM_Read(0x00);
	CLRF       FARG_EEPROM_Read_Address+0
	CALL       _EEPROM_Read+0
	MOVF       R0, 0
	MOVWF      _UserIP+0
;LED_Matrix_With_UART.c,1116 :: 		if(UserIP == 1) {
	MOVF       R0, 0
	XORLW      1
	BTFSS      STATUS+0, 2
	GOTO       L_main60
;LED_Matrix_With_UART.c,1117 :: 		StringLength = EEPROM_Read(0x01);
	MOVLW      1
	MOVWF      FARG_EEPROM_Read_Address+0
	CALL       _EEPROM_Read+0
	MOVF       R0, 0
	MOVWF      _StringLength+0
	CLRF       _StringLength+1
;LED_Matrix_With_UART.c,1118 :: 		Load_Data();  // Read stored data and save into RAM
	CALL       _Load_Data+0
;LED_Matrix_With_UART.c,1119 :: 		}
	GOTO       L_main61
L_main60:
;LED_Matrix_With_UART.c,1120 :: 		else  StringLength = strlen(default_message);
	MOVLW      _default_message+0
	MOVWF      FARG_strlen_s+0
	MOVLW      hi_addr(_default_message+0)
	MOVWF      FARG_strlen_s+1
	CALL       _strlen+0
	MOVF       R0, 0
	MOVWF      _StringLength+0
	MOVF       R1, 0
	MOVWF      _StringLength+1
L_main61:
;LED_Matrix_With_UART.c,1122 :: 		do {
L_main62:
;LED_Matrix_With_UART.c,1123 :: 		for (k=0; k < StringLength + 5; k++){
	CLRF       _k+0
L_main65:
	MOVLW      5
	ADDWF      _StringLength+0, 0
	MOVWF      R1
	MOVLW      0
	ADDWFC     _StringLength+1, 0
	MOVWF      R2
	MOVF       R2, 0
	SUBLW      0
	BTFSS      STATUS+0, 2
	GOTO       L__main96
	MOVF       R1, 0
	SUBWF      _k+0, 0
L__main96:
	BTFSC      STATUS+0, 0
	GOTO       L_main66
;LED_Matrix_With_UART.c,1124 :: 		for (scroll=0; scroll<(6/shift_step); scroll++) {
	CLRF       _scroll+0
L_main68:
	MOVF       _shift_step+0, 0
	MOVWF      R4
	MOVLW      6
	MOVWF      R0
	CALL       _Div_8x8_U+0
	MOVF       R0, 0
	SUBWF      _scroll+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_main69
;LED_Matrix_With_UART.c,1125 :: 		for (row=0; row<8; row++){
	CLRF       _row+0
L_main71:
	MOVLW      8
	SUBWF      _row+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_main72
;LED_Matrix_With_UART.c,1126 :: 		if(UserIP == 1) index = message[k];
	MOVF       _UserIP+0, 0
	XORLW      1
	BTFSS      STATUS+0, 2
	GOTO       L_main74
	MOVLW      _message+0
	MOVWF      R0
	MOVLW      hi_addr(_message+0)
	MOVWF      R1
	MOVF       _k+0, 0
	ADDWF      R0, 0
	MOVWF      FSR0L
	MOVLW      0
	ADDWFC     R1, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      _index+0
	GOTO       L_main75
L_main74:
;LED_Matrix_With_UART.c,1127 :: 		else index = default_message[k];
	MOVLW      _default_message+0
	MOVWF      FSR0L
	MOVLW      hi_addr(_default_message+0)
	MOVWF      FSR0H
	MOVF       _k+0, 0
	ADDWF      FSR0L, 1
	BTFSC      STATUS+0, 0
	INCF       FSR0H, 1
	MOVF       INDF0+0, 0
	MOVWF      _index+0
L_main75:
;LED_Matrix_With_UART.c,1128 :: 		if (index > 146) index = 146;
	MOVF       _index+0, 0
	SUBLW      146
	BTFSC      STATUS+0, 0
	GOTO       L_main76
	MOVLW      146
	MOVWF      _index+0
L_main76:
;LED_Matrix_With_UART.c,1129 :: 		temp = CharData[index-32][row];
	MOVLW      32
	SUBWF      _index+0, 0
	MOVWF      R3
	CLRF       R4
	MOVLW      0
	SUBWFB     R4, 1
	MOVLW      3
	MOVWF      R2
	MOVF       R3, 0
	MOVWF      R0
	MOVF       R4, 0
	MOVWF      R1
	MOVF       R2, 0
L__main97:
	BTFSC      STATUS+0, 2
	GOTO       L__main98
	LSLF       R0, 1
	RLF        R1, 1
	ADDLW      255
	GOTO       L__main97
L__main98:
	MOVLW      _CharData+0
	ADDWF      R0, 1
	MOVLW      hi_addr(_CharData+0)
	ADDWFC     R1, 1
	MOVF       _row+0, 0
	ADDWF      R0, 0
	MOVWF      FSR0L
	MOVLW      0
	ADDWFC     R1, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      _temp+0
;LED_Matrix_With_UART.c,1130 :: 		Buffer[row][7] = (Buffer[row][7] << Shift_Step) | (Buffer[row][6] >> (6-Shift_Step));
	MOVLW      3
	MOVWF      R2
	MOVF       _row+0, 0
	MOVWF      R0
	CLRF       R1
	MOVF       R2, 0
L__main99:
	BTFSC      STATUS+0, 2
	GOTO       L__main100
	LSLF       R0, 1
	RLF        R1, 1
	ADDLW      255
	GOTO       L__main99
L__main100:
	MOVLW      _Buffer+0
	ADDWF      R0, 0
	MOVWF      R2
	MOVLW      hi_addr(_Buffer+0)
	ADDWFC     R1, 0
	MOVWF      R3
	MOVLW      7
	ADDWF      R2, 0
	MOVWF      R5
	MOVLW      0
	ADDWFC     R3, 0
	MOVWF      R6
	MOVF       R5, 0
	MOVWF      FSR0L
	MOVF       R6, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R1
	MOVF       _shift_step+0, 0
	MOVWF      R0
	MOVF       R1, 0
	MOVWF      R4
	MOVF       R0, 0
L__main101:
	BTFSC      STATUS+0, 2
	GOTO       L__main102
	LSLF       R4, 1
	ADDLW      255
	GOTO       L__main101
L__main102:
	MOVLW      6
	ADDWF      R2, 0
	MOVWF      FSR0L
	MOVLW      0
	ADDWFC     R3, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R2
	MOVF       _shift_step+0, 0
	SUBLW      6
	MOVWF      R0
	CLRF       R1
	MOVLW      0
	SUBWFB     R1, 1
	MOVF       R0, 0
	MOVWF      R1
	MOVF       R2, 0
	MOVWF      R0
	MOVF       R1, 0
L__main103:
	BTFSC      STATUS+0, 2
	GOTO       L__main104
	LSRF       R0, 1
	ADDLW      255
	GOTO       L__main103
L__main104:
	MOVF       R4, 0
	IORWF       R0, 1
	MOVF       R5, 0
	MOVWF      FSR1L
	MOVF       R6, 0
	MOVWF      FSR1H
	MOVF       R0, 0
	MOVWF      INDF1+0
;LED_Matrix_With_UART.c,1131 :: 		Buffer[row][6] = (Buffer[row][6] << Shift_Step) | (Buffer[row][5] >> (6-Shift_Step));
	MOVLW      3
	MOVWF      R2
	MOVF       _row+0, 0
	MOVWF      R0
	CLRF       R1
	MOVF       R2, 0
L__main105:
	BTFSC      STATUS+0, 2
	GOTO       L__main106
	LSLF       R0, 1
	RLF        R1, 1
	ADDLW      255
	GOTO       L__main105
L__main106:
	MOVLW      _Buffer+0
	ADDWF      R0, 0
	MOVWF      R2
	MOVLW      hi_addr(_Buffer+0)
	ADDWFC     R1, 0
	MOVWF      R3
	MOVLW      6
	ADDWF      R2, 0
	MOVWF      R5
	MOVLW      0
	ADDWFC     R3, 0
	MOVWF      R6
	MOVF       R5, 0
	MOVWF      FSR0L
	MOVF       R6, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R1
	MOVF       _shift_step+0, 0
	MOVWF      R0
	MOVF       R1, 0
	MOVWF      R4
	MOVF       R0, 0
L__main107:
	BTFSC      STATUS+0, 2
	GOTO       L__main108
	LSLF       R4, 1
	ADDLW      255
	GOTO       L__main107
L__main108:
	MOVLW      5
	ADDWF      R2, 0
	MOVWF      FSR0L
	MOVLW      0
	ADDWFC     R3, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R2
	MOVF       _shift_step+0, 0
	SUBLW      6
	MOVWF      R0
	CLRF       R1
	MOVLW      0
	SUBWFB     R1, 1
	MOVF       R0, 0
	MOVWF      R1
	MOVF       R2, 0
	MOVWF      R0
	MOVF       R1, 0
L__main109:
	BTFSC      STATUS+0, 2
	GOTO       L__main110
	LSRF       R0, 1
	ADDLW      255
	GOTO       L__main109
L__main110:
	MOVF       R4, 0
	IORWF       R0, 1
	MOVF       R5, 0
	MOVWF      FSR1L
	MOVF       R6, 0
	MOVWF      FSR1H
	MOVF       R0, 0
	MOVWF      INDF1+0
;LED_Matrix_With_UART.c,1132 :: 		Buffer[row][5] = (Buffer[row][5] << Shift_Step) | (Buffer[row][4] >> (6-Shift_Step));
	MOVLW      3
	MOVWF      R2
	MOVF       _row+0, 0
	MOVWF      R0
	CLRF       R1
	MOVF       R2, 0
L__main111:
	BTFSC      STATUS+0, 2
	GOTO       L__main112
	LSLF       R0, 1
	RLF        R1, 1
	ADDLW      255
	GOTO       L__main111
L__main112:
	MOVLW      _Buffer+0
	ADDWF      R0, 0
	MOVWF      R2
	MOVLW      hi_addr(_Buffer+0)
	ADDWFC     R1, 0
	MOVWF      R3
	MOVLW      5
	ADDWF      R2, 0
	MOVWF      R5
	MOVLW      0
	ADDWFC     R3, 0
	MOVWF      R6
	MOVF       R5, 0
	MOVWF      FSR0L
	MOVF       R6, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R1
	MOVF       _shift_step+0, 0
	MOVWF      R0
	MOVF       R1, 0
	MOVWF      R4
	MOVF       R0, 0
L__main113:
	BTFSC      STATUS+0, 2
	GOTO       L__main114
	LSLF       R4, 1
	ADDLW      255
	GOTO       L__main113
L__main114:
	MOVLW      4
	ADDWF      R2, 0
	MOVWF      FSR0L
	MOVLW      0
	ADDWFC     R3, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R2
	MOVF       _shift_step+0, 0
	SUBLW      6
	MOVWF      R0
	CLRF       R1
	MOVLW      0
	SUBWFB     R1, 1
	MOVF       R0, 0
	MOVWF      R1
	MOVF       R2, 0
	MOVWF      R0
	MOVF       R1, 0
L__main115:
	BTFSC      STATUS+0, 2
	GOTO       L__main116
	LSRF       R0, 1
	ADDLW      255
	GOTO       L__main115
L__main116:
	MOVF       R4, 0
	IORWF       R0, 1
	MOVF       R5, 0
	MOVWF      FSR1L
	MOVF       R6, 0
	MOVWF      FSR1H
	MOVF       R0, 0
	MOVWF      INDF1+0
;LED_Matrix_With_UART.c,1133 :: 		Buffer[row][4] = (Buffer[row][4] << Shift_Step) | (Buffer[row][3] >> (6-Shift_Step));
	MOVLW      3
	MOVWF      R2
	MOVF       _row+0, 0
	MOVWF      R0
	CLRF       R1
	MOVF       R2, 0
L__main117:
	BTFSC      STATUS+0, 2
	GOTO       L__main118
	LSLF       R0, 1
	RLF        R1, 1
	ADDLW      255
	GOTO       L__main117
L__main118:
	MOVLW      _Buffer+0
	ADDWF      R0, 0
	MOVWF      R2
	MOVLW      hi_addr(_Buffer+0)
	ADDWFC     R1, 0
	MOVWF      R3
	MOVLW      4
	ADDWF      R2, 0
	MOVWF      R5
	MOVLW      0
	ADDWFC     R3, 0
	MOVWF      R6
	MOVF       R5, 0
	MOVWF      FSR0L
	MOVF       R6, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R1
	MOVF       _shift_step+0, 0
	MOVWF      R0
	MOVF       R1, 0
	MOVWF      R4
	MOVF       R0, 0
L__main119:
	BTFSC      STATUS+0, 2
	GOTO       L__main120
	LSLF       R4, 1
	ADDLW      255
	GOTO       L__main119
L__main120:
	MOVLW      3
	ADDWF      R2, 0
	MOVWF      FSR0L
	MOVLW      0
	ADDWFC     R3, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R2
	MOVF       _shift_step+0, 0
	SUBLW      6
	MOVWF      R0
	CLRF       R1
	MOVLW      0
	SUBWFB     R1, 1
	MOVF       R0, 0
	MOVWF      R1
	MOVF       R2, 0
	MOVWF      R0
	MOVF       R1, 0
L__main121:
	BTFSC      STATUS+0, 2
	GOTO       L__main122
	LSRF       R0, 1
	ADDLW      255
	GOTO       L__main121
L__main122:
	MOVF       R4, 0
	IORWF       R0, 1
	MOVF       R5, 0
	MOVWF      FSR1L
	MOVF       R6, 0
	MOVWF      FSR1H
	MOVF       R0, 0
	MOVWF      INDF1+0
;LED_Matrix_With_UART.c,1134 :: 		Buffer[row][3] = (Buffer[row][3] << Shift_Step) | (Buffer[row][2] >> (6-Shift_Step));
	MOVLW      3
	MOVWF      R2
	MOVF       _row+0, 0
	MOVWF      R0
	CLRF       R1
	MOVF       R2, 0
L__main123:
	BTFSC      STATUS+0, 2
	GOTO       L__main124
	LSLF       R0, 1
	RLF        R1, 1
	ADDLW      255
	GOTO       L__main123
L__main124:
	MOVLW      _Buffer+0
	ADDWF      R0, 0
	MOVWF      R2
	MOVLW      hi_addr(_Buffer+0)
	ADDWFC     R1, 0
	MOVWF      R3
	MOVLW      3
	ADDWF      R2, 0
	MOVWF      R5
	MOVLW      0
	ADDWFC     R3, 0
	MOVWF      R6
	MOVF       R5, 0
	MOVWF      FSR0L
	MOVF       R6, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R1
	MOVF       _shift_step+0, 0
	MOVWF      R0
	MOVF       R1, 0
	MOVWF      R4
	MOVF       R0, 0
L__main125:
	BTFSC      STATUS+0, 2
	GOTO       L__main126
	LSLF       R4, 1
	ADDLW      255
	GOTO       L__main125
L__main126:
	MOVLW      2
	ADDWF      R2, 0
	MOVWF      FSR0L
	MOVLW      0
	ADDWFC     R3, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R2
	MOVF       _shift_step+0, 0
	SUBLW      6
	MOVWF      R0
	CLRF       R1
	MOVLW      0
	SUBWFB     R1, 1
	MOVF       R0, 0
	MOVWF      R1
	MOVF       R2, 0
	MOVWF      R0
	MOVF       R1, 0
L__main127:
	BTFSC      STATUS+0, 2
	GOTO       L__main128
	LSRF       R0, 1
	ADDLW      255
	GOTO       L__main127
L__main128:
	MOVF       R4, 0
	IORWF       R0, 1
	MOVF       R5, 0
	MOVWF      FSR1L
	MOVF       R6, 0
	MOVWF      FSR1H
	MOVF       R0, 0
	MOVWF      INDF1+0
;LED_Matrix_With_UART.c,1135 :: 		Buffer[row][2] = (Buffer[row][2] << Shift_Step) | (Buffer[row][1] >> (6-Shift_Step));
	MOVLW      3
	MOVWF      R2
	MOVF       _row+0, 0
	MOVWF      R0
	CLRF       R1
	MOVF       R2, 0
L__main129:
	BTFSC      STATUS+0, 2
	GOTO       L__main130
	LSLF       R0, 1
	RLF        R1, 1
	ADDLW      255
	GOTO       L__main129
L__main130:
	MOVLW      _Buffer+0
	ADDWF      R0, 0
	MOVWF      R2
	MOVLW      hi_addr(_Buffer+0)
	ADDWFC     R1, 0
	MOVWF      R3
	MOVLW      2
	ADDWF      R2, 0
	MOVWF      R5
	MOVLW      0
	ADDWFC     R3, 0
	MOVWF      R6
	MOVF       R5, 0
	MOVWF      FSR0L
	MOVF       R6, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R1
	MOVF       _shift_step+0, 0
	MOVWF      R0
	MOVF       R1, 0
	MOVWF      R4
	MOVF       R0, 0
L__main131:
	BTFSC      STATUS+0, 2
	GOTO       L__main132
	LSLF       R4, 1
	ADDLW      255
	GOTO       L__main131
L__main132:
	MOVLW      1
	ADDWF      R2, 0
	MOVWF      FSR0L
	MOVLW      0
	ADDWFC     R3, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R2
	MOVF       _shift_step+0, 0
	SUBLW      6
	MOVWF      R0
	CLRF       R1
	MOVLW      0
	SUBWFB     R1, 1
	MOVF       R0, 0
	MOVWF      R1
	MOVF       R2, 0
	MOVWF      R0
	MOVF       R1, 0
L__main133:
	BTFSC      STATUS+0, 2
	GOTO       L__main134
	LSRF       R0, 1
	ADDLW      255
	GOTO       L__main133
L__main134:
	MOVF       R4, 0
	IORWF       R0, 1
	MOVF       R5, 0
	MOVWF      FSR1L
	MOVF       R6, 0
	MOVWF      FSR1H
	MOVF       R0, 0
	MOVWF      INDF1+0
;LED_Matrix_With_UART.c,1136 :: 		Buffer[row][1] = (Buffer[row][1] << Shift_Step) | (Buffer[row][0] >> (6-Shift_Step));
	MOVLW      3
	MOVWF      R2
	MOVF       _row+0, 0
	MOVWF      R0
	CLRF       R1
	MOVF       R2, 0
L__main135:
	BTFSC      STATUS+0, 2
	GOTO       L__main136
	LSLF       R0, 1
	RLF        R1, 1
	ADDLW      255
	GOTO       L__main135
L__main136:
	MOVLW      _Buffer+0
	ADDWF      R0, 0
	MOVWF      R2
	MOVLW      hi_addr(_Buffer+0)
	ADDWFC     R1, 0
	MOVWF      R3
	MOVLW      1
	ADDWF      R2, 0
	MOVWF      R5
	MOVLW      0
	ADDWFC     R3, 0
	MOVWF      R6
	MOVF       R5, 0
	MOVWF      FSR0L
	MOVF       R6, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R1
	MOVF       _shift_step+0, 0
	MOVWF      R0
	MOVF       R1, 0
	MOVWF      R4
	MOVF       R0, 0
L__main137:
	BTFSC      STATUS+0, 2
	GOTO       L__main138
	LSLF       R4, 1
	ADDLW      255
	GOTO       L__main137
L__main138:
	MOVF       R2, 0
	MOVWF      FSR0L
	MOVF       R3, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R2
	MOVF       _shift_step+0, 0
	SUBLW      6
	MOVWF      R0
	CLRF       R1
	MOVLW      0
	SUBWFB     R1, 1
	MOVF       R0, 0
	MOVWF      R1
	MOVF       R2, 0
	MOVWF      R0
	MOVF       R1, 0
L__main139:
	BTFSC      STATUS+0, 2
	GOTO       L__main140
	LSRF       R0, 1
	ADDLW      255
	GOTO       L__main139
L__main140:
	MOVF       R4, 0
	IORWF       R0, 1
	MOVF       R5, 0
	MOVWF      FSR1L
	MOVF       R6, 0
	MOVWF      FSR1H
	MOVF       R0, 0
	MOVWF      INDF1+0
;LED_Matrix_With_UART.c,1137 :: 		Buffer[row][0] = (Buffer[row][0] << Shift_Step)| (temp >> ((6-shift_step)-scroll*shift_step));
	MOVLW      3
	MOVWF      R2
	MOVF       _row+0, 0
	MOVWF      R0
	CLRF       R1
	MOVF       R2, 0
L__main141:
	BTFSC      STATUS+0, 2
	GOTO       L__main142
	LSLF       R0, 1
	RLF        R1, 1
	ADDLW      255
	GOTO       L__main141
L__main142:
	MOVLW      _Buffer+0
	ADDWF      R0, 1
	MOVLW      hi_addr(_Buffer+0)
	ADDWFC     R1, 1
	MOVF       R0, 0
	MOVWF      FLOC__main+3
	MOVF       R1, 0
	MOVWF      FLOC__main+4
	MOVF       R0, 0
	MOVWF      FSR0L
	MOVF       R1, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R1
	MOVF       _shift_step+0, 0
	MOVWF      R0
	MOVF       R1, 0
	MOVWF      FLOC__main+2
	MOVF       R0, 0
L__main143:
	BTFSC      STATUS+0, 2
	GOTO       L__main144
	LSLF       FLOC__main+2, 1
	ADDLW      255
	GOTO       L__main143
L__main144:
	MOVF       _shift_step+0, 0
	SUBLW      6
	MOVWF      FLOC__main+0
	CLRF       FLOC__main+1
	MOVLW      0
	SUBWFB     FLOC__main+1, 1
	MOVF       _scroll+0, 0
	MOVWF      R0
	MOVF       _shift_step+0, 0
	MOVWF      R4
	CALL       _Mul_8x8_U+0
	MOVF       R0, 0
	SUBWF      FLOC__main+0, 0
	MOVWF      R0
	MOVF       R1, 0
	SUBWFB     FLOC__main+1, 0
	MOVWF      R1
	MOVF       R0, 0
	MOVWF      R1
	MOVF       _temp+0, 0
	MOVWF      R0
	MOVF       R1, 0
L__main145:
	BTFSC      STATUS+0, 2
	GOTO       L__main146
	LSRF       R0, 1
	ADDLW      255
	GOTO       L__main145
L__main146:
	MOVF       FLOC__main+2, 0
	IORWF       R0, 1
	MOVF       FLOC__main+3, 0
	MOVWF      FSR1L
	MOVF       FLOC__main+4, 0
	MOVWF      FSR1H
	MOVF       R0, 0
	MOVWF      INDF1+0
;LED_Matrix_With_UART.c,1125 :: 		for (row=0; row<8; row++){
	INCF       _row+0, 1
;LED_Matrix_With_UART.c,1138 :: 		}
	GOTO       L_main71
L_main72:
;LED_Matrix_With_UART.c,1139 :: 		speed = 15;
	MOVLW      15
	MOVWF      _speed+0
	MOVLW      0
	MOVWF      _speed+1
;LED_Matrix_With_UART.c,1140 :: 		for(l=0; l<speed;l++){
	CLRF       _l+0
L_main77:
	MOVF       _speed+1, 0
	SUBLW      0
	BTFSS      STATUS+0, 2
	GOTO       L__main147
	MOVF       _speed+0, 0
	SUBWF      _l+0, 0
L__main147:
	BTFSC      STATUS+0, 0
	GOTO       L_main78
;LED_Matrix_With_UART.c,1141 :: 		m = 1;
	MOVLW      1
	MOVWF      _m+0
;LED_Matrix_With_UART.c,1142 :: 		for (i=0; i<8; i++) {
	CLRF       _i+0
L_main80:
	MOVLW      8
	SUBWF      _i+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_main81
;LED_Matrix_With_UART.c,1143 :: 		Send_Data(i);
	MOVF       _i+0, 0
	MOVWF      FARG_Send_Data_rw+0
	CALL       _Send_Data+0
;LED_Matrix_With_UART.c,1144 :: 		LATB = m;
	MOVF       _m+0, 0
	MOVWF      LATB+0
;LED_Matrix_With_UART.c,1145 :: 		m = m << 1;
	LSLF       _m+0, 1
;LED_Matrix_With_UART.c,1146 :: 		Delay_us(1000);
	MOVLW      11
	MOVWF      R12
	MOVLW      98
	MOVWF      R13
L_main83:
	DECFSZ     R13, 1
	GOTO       L_main83
	DECFSZ     R12, 1
	GOTO       L_main83
	NOP
;LED_Matrix_With_UART.c,1142 :: 		for (i=0; i<8; i++) {
	INCF       _i+0, 1
;LED_Matrix_With_UART.c,1147 :: 		}  // i
	GOTO       L_main80
L_main81:
;LED_Matrix_With_UART.c,1140 :: 		for(l=0; l<speed;l++){
	INCF       _l+0, 1
;LED_Matrix_With_UART.c,1148 :: 		} // l
	GOTO       L_main77
L_main78:
;LED_Matrix_With_UART.c,1124 :: 		for (scroll=0; scroll<(6/shift_step); scroll++) {
	INCF       _scroll+0, 1
;LED_Matrix_With_UART.c,1149 :: 		} // scroll
	GOTO       L_main68
L_main69:
;LED_Matrix_With_UART.c,1123 :: 		for (k=0; k < StringLength + 5; k++){
	INCF       _k+0, 1
;LED_Matrix_With_UART.c,1150 :: 		} // k
	GOTO       L_main65
L_main66:
;LED_Matrix_With_UART.c,1152 :: 		} while(1);
	GOTO       L_main62
;LED_Matrix_With_UART.c,1153 :: 		}
L_end_main:
	GOTO       $+0
; end of _main
