#ifndef F_CPU
#define F_CPU 16000000UL
#endif

#include <avr/io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <util/delay.h>
#include <avr/interrupt.h>
#include <inttypes.h>
#include "lcd.h"
#include "ds1820.h"


int main(void) {

uint8_t spad[9];
char homerfull[10];
char homerdec[10];
uint8_t golcd;

uint16_t hom;
//int16_t  tempdec;

// PB1 lb kimenet, LED felkapcsolsa
DDRB |= (1<<PINB1);
PORTB |= (1<<PINB1);

lcd_init(LCD_DISP_ON);
lcd_clrscr();

	while(1) {

	hom = DS1820_read(spad);
	
	golcd = DS1820_format_temp( hom, homerfull, 0);
	lcd_gotoxy(0,2);
	lcd_puts("Ho: ");
	if ( golcd ) {
		lcd_puts("???");
	} else {
		lcd_puts(homerfull);
	}
	
	golcd = DS1820_format_temp( hom, homerdec, 1);
	lcd_gotoxy(0,3);
	lcd_puts("Ho: ");	
	if ( golcd ) {
		lcd_puts("???");
	} else {
		lcd_puts(homerdec);
	}

	
			lcd_gotoxy(0,0);
			lcd_puthex_byte(spad[0]);
			lcd_putc(':');lcd_puthex_byte(spad[1]);
			lcd_putc(':');lcd_puthex_byte(spad[2]);
			lcd_putc(':');lcd_puthex_byte(spad[3]);
			lcd_putc(':');lcd_puthex_byte(spad[4]);
			lcd_gotoxy(0,1);
			lcd_puthex_byte(spad[5]);
			lcd_putc(':');lcd_puthex_byte(spad[6]);
			lcd_putc(':');lcd_puthex_byte(spad[7]);
			lcd_putc(':');lcd_puthex_byte(spad[8]);
			
	_delay_ms(500);
	
	}

}



