#include "microthreads.h"

#include <avr/interrupt.h>
#include <avr/io.h>
#include <util/delay.h>

ISR( TIMER0_OVF_vect )
{
  TIFR0 |= (1<<TOIE0);
  sei();
  microthreads_scheduleNext();
}

void microthreads_enableInterrupts()
{
  sei();
}


void microthreads_disableInterrupts()
{
  cli();
}

void thread_main()
{
  while(1)
  {
    _delay_ms(1000);
    PINB = _BV(PB5); // Toggle the Arduino LED on Digital Pin 13
  }
}

void thread_2()
{
  while(1)
  {
    uint8_t c;
    for( c=0; c < 10; c++ )
    {
      _delay_ms(100);
      PINB = _BV(PB5); // Toggle the Arduino LED on Digital Pin 13
    }
    _delay_ms(3000); // wait 3 seconds
  }
}

void timer_init()
{  
  TCCR0A = 0;
  TCCR0B = _BV(CS02);

  TIMSK0 |= (1<<TOIE0);
  TCNT0 = 0;
}

int main()
{
  cli();
  DDRB = _BV(PB5);
  timer_init();
  sei();
  
  microthreads_init();
  microthreads_startThread( &thread_2 );
  thread_main();
  return 0;
}
