#include <signal.h>
#include <unistd.h>
#include <stdio.h>

#include "microthreads.h"


int interruptsEnabled = 1;

void microthreads_enableInterrupts()
{
  interruptsEnabled = 1;
}

void microthreads_disableInterrupts()
{
  interruptsEnabled = 0;
}

void handle_sighup(int signum)
{
  if( interruptsEnabled )
    microthreads_scheduleNext();
}

void thread2(void);
void thread3(void);
void thread4(void);

int main(void)
{
  pid_t pid;
  if( ( pid = fork() ) != 0 )
  {
    for(;;)
    {
      // here we generate interrupts for the thread by the HUP signal
      sleep(3);
      kill( pid, SIGHUP );
    }
  }

  struct sigaction sa;
  sa.sa_handler = handle_sighup;
  sigemptyset(&sa.sa_mask);
  sa.sa_flags = SA_NODEFER; /* Restart functions if interrupted by handler */
  sigaction( SIGHUP, &sa, NULL);
    
  microthreads_init();
  microthreads_startThread(&thread4);
  microthreads_startThread(&thread3);
  microthreads_startThread(&thread2);
    
  for(;;)
  {
    printf("+");
    fflush(stdout);
    usleep(100000);
  }
}

void thread2(void)
{
  int k=0;
  for(;;)
  {
    if( ++k == 100 )
      microthreads_killThread(2);
    if( ++k == 200 )
      microthreads_startThread(&thread3);
    printf("-");
    fflush(stdout);
    usleep(100000);
  }
}

void thread3(void)
{
  int k=0;
  for(;;)
  {
    printf("*");
    fflush(stdout);
    usleep(100000);
    if((++k%5)==0)
      microthreads_scheduleNext();
  }
}

void thread4(void)
{
  int k=0;
  for(;;)
  {
    if( ++k == 100 )
      return;
    printf("^");
    fflush(stdout);
    usleep(100000);
  }
}
