#ifndef __MICROTHREADS_H__
#define __MICROTHREADS_H__

#ifdef _LINUX
#include <sys/types.h>
#else
#include <inttypes.h>
#endif

#ifndef MAX_THREADS
#define MAX_THREADS 4
#endif

#ifndef STACK_SIZE
#define STACK_SIZE 64
#endif

typedef enum {
  MT_Unallocated = 0,
  MT_Running = 1,
  MT_Main = 2,
} ThreadState;

int8_t  microthreads_startThread( void (*pointer)(void) );
void    microthreads_init(void);
void    microthreads_scheduleNext(void);
void    microthreads_killThread(int8_t number);
int8_t  microthreads_getCurrentThread(void);

// architecture specific parts
void    microthreads_enableInterrupts();
void    microthreads_disableInterrupts();

#endif /* __MICROTHREADS_H__ */
