
; PicBasic Pro Compiler 2.45, (c) 1998, 2004 microEngineering Labs, Inc. All Rights Reserved.  
PM_USED			EQU	1

	INCLUDE	"16F628.INC"


; Define statements.
#define		LCD_DREG		 PORTB                   
#define		LCD_DBIT		 4                       
#define		LCD_RSREG		 PORTA                  
#define		LCD_RSBIT		 1                      
#define		LCD_EREG		 PORTA                   
#define		LCD_EBIT		 0                       
#define		LCD_BITS		 4                       
#define		LCD_LINES		 2                      

RAM_START       		EQU	00020h
RAM_END         		EQU	0014Fh
RAM_BANKS       		EQU	00003h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00120h
BANK2_END       		EQU	0014Fh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0217Fh

R0              		EQU	RAM_START + 000h
R1              		EQU	RAM_START + 002h
R2              		EQU	RAM_START + 004h
R3              		EQU	RAM_START + 006h
R4              		EQU	RAM_START + 008h
R5              		EQU	RAM_START + 00Ah
R6              		EQU	RAM_START + 00Ch
R7              		EQU	RAM_START + 00Eh
R8              		EQU	RAM_START + 010h
T1              		EQU	RAM_START + 012h
T2              		EQU	RAM_START + 014h
FLAGS           		EQU	RAM_START + 016h
GOP             		EQU	RAM_START + 017h
RM1             		EQU	RAM_START + 018h
RM2             		EQU	RAM_START + 019h
RR1             		EQU	RAM_START + 01Ah
RR2             		EQU	RAM_START + 01Bh
_Hyst            		EQU	RAM_START + 01Ch
_TargetTemp      		EQU	RAM_START + 01Eh
_Temperature     		EQU	RAM_START + 020h
_V               		EQU	RAM_START + 022h
_B1              		EQU	RAM_START + 024h
_B2              		EQU	RAM_START + 025h
_Count_Per_C     		EQU	RAM_START + 026h
_Count_Remain    		EQU	RAM_START + 027h
_Mode            		EQU	RAM_START + 028h
_Sign            		EQU	RAM_START + 029h
_PORTL           		EQU	 PORTB
_PORTH           		EQU	 PORTA
_TRISL           		EQU	 TRISB
_TRISH           		EQU	 TRISA
_Temperature_LOWBYTE		EQU	_Temperature
_Temperature_HIGHBYTE		EQU	_Temperature + 001h
#define _DQ              	_PORTA_4
#define _PORTA_4         	 PORTA, 004h
#define _PORTA_2         	 PORTA, 002h
#define _PORTA_3         	 PORTA, 003h
#define _PORTB_0         	 PORTB, 000h
#define _PORTB_1         	 PORTB, 001h
#define _PORTB_2         	 PORTB, 002h

; EEPROM data.
	ORG EEPROM_START

	DE	02Eh
	DE	0E0h
	DE	014h

	INCLUDE	"1820THER.MAC"
	INCLUDE	"PBPPIC14.LIB"

	MOVE?CB	0F0h, TRISA
	MOVE?CB	007h, TRISB
	MOVE?CB	007h, CMCON
	MOVE?CT	000h, _PORTA_2
	MOVE?CT	000h, _PORTA_3
	MOVE?CB	000h, _Mode
	LCDOUT?C	0FEh
	LCDOUT?C	001h
	LCDOUT?C	0FEh
	LCDOUT?C	00Ch
	READ?CB	000h, _B1
	READ?CB	001h, _B2
	MUL?BCW	_B1, 00100h, T1
	ADD?WBW	T1, _B2, _TargetTemp
	READ?CB	002h, _B1
	MUL?CBW	00Ah, _B1, _Hyst

	LABEL?L	_MainLoop	
	CMPNE?TCL	_PORTB_0, 000h, L00001
	PAUSE?C	032h
	LCDOUT?C	0FEh
	LCDOUT?C	08Fh
	LCDOUT?C	02Ah
	CMPEQ?TCL	_PORTB_0, 000h, _MainLoop
	ADD?BCB	_Mode, 001h, _Mode
	CMPNE?BCL	_Mode, 002h, L00003
	DIV?WCW	_TargetTemp, 00100h, T1
	WRITE?CW	000h, T1
	MOD?WCW	_TargetTemp, 00100h, T1
	WRITE?CW	001h, T1
	LABEL?L	L00003	
	CMPLE?BCL	_Mode, 002h, L00005
	MOVE?CB	000h, _Mode
	DIV?WCW	_Hyst, 00Ah, T1
	WRITE?CW	002h, T1
	LABEL?L	L00005	
	LABEL?L	L00001	
	CMPNE?BCL	_Mode, 001h, L00007
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	053h
	LCDOUT?C	045h
	LCDOUT?C	054h
	LCDOUT?C	020h
	LCDOUT?C	054h
	LCDOUT?C	045h
	LCDOUT?C	04Dh
	LCDOUT?C	050h
	LCDOUT?C	045h
	LCDOUT?C	052h
	LCDOUT?C	041h
	LCDOUT?C	054h
	LCDOUT?C	055h
	LCDOUT?C	052h
	LCDOUT?C	045h
	LCDOUT?C	020h
	MOVE?WW	_TargetTemp, _V
	GOSUB?L	_SelectSign
	GOSUB?L	_DisplayTemp
	CMPEQ?TCB	_PORTB_1, 000h, T1
	CMPEQ?TCB	_PORTB_2, 000h, T2
	LOR?BBW	T1, T2, T2
	CMPF?WL	T2, L00009
	CMPNE?TCL	_PORTB_2, 000h, L00011
	CMPLE?WCL	_TargetTemp, 01D4Ch, L00013
	SUB?WCW	_TargetTemp, 019h, _TargetTemp
	LABEL?L	L00013	
	LABEL?L	L00011	
	CMPNE?TCL	_PORTB_1, 000h, L00015
	CMPGE?WCL	_TargetTemp, 0445Ch, L00017
	ADD?WCW	_TargetTemp, 019h, _TargetTemp
	LABEL?L	L00017	
	LABEL?L	L00015	
	GOSUB?L	_SetTargetTemp
	LABEL?L	L00009	
	LABEL?L	L00007	
	CMPNE?BCL	_Mode, 002h, L00019
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	048h
	LCDOUT?C	059h
	LCDOUT?C	053h
	LCDOUT?C	054h
	LCDOUT?C	045h
	LCDOUT?C	052h
	LCDOUT?C	045h
	LCDOUT?C	053h
	LCDOUT?C	049h
	LCDOUT?C	053h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	MOVE?CB	020h, _Sign
	ADD?CWW	02710h, _Hyst, _V
	GOSUB?L	_DisplayTemp
	CMPEQ?TCB	_PORTB_1, 000h, T1
	CMPEQ?TCB	_PORTB_2, 000h, T2
	LOR?BBW	T1, T2, T2
	CMPF?WL	T2, L00021
	MOVE?CB	020h, _Sign
	CMPNE?TCL	_PORTB_2, 000h, L00023
	CMPLE?WCL	_Hyst, 00Ah, L00025
	SUB?WCW	_Hyst, 00Ah, _Hyst
	LABEL?L	L00025	
	LABEL?L	L00023	
	CMPNE?TCL	_PORTB_1, 000h, L00027
	CMPGE?WCL	_Hyst, 003E8h, L00029
	ADD?WCW	_Hyst, 00Ah, _Hyst
	LABEL?L	L00029	
	LABEL?L	L00027	
	ADD?CWW	02710h, _Hyst, _V
	GOSUB?L	_DisplayTemp
	PAUSE?C	0FAh
	LABEL?L	L00021	
	LABEL?L	L00019	
	CMPGT?BCL	_Mode, 000h, _MainLoop
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	054h
	LCDOUT?C	045h
	LCDOUT?C	04Dh
	LCDOUT?C	050h
	LCDOUT?C	045h
	LCDOUT?C	052h
	LCDOUT?C	041h
	LCDOUT?C	054h
	LCDOUT?C	055h
	LCDOUT?C	052h
	LCDOUT?C	045h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	OUTPUT?T	_DQ
	MOVE?CT	000h, _DQ
	PAUSEUS?C	001E0h
	INPUT?T	_DQ
	PAUSEUS?C	046h
	CMPNE?TCL	_DQ, 001h, L00031
	LCDOUT?C	0FEh
	LCDOUT?C	001h
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	LCDOUT?C	020h
	LCDOUT?C	04Eh
	LCDOUT?C	06Fh
	LCDOUT?C	020h
	LCDOUT?C	073h
	LCDOUT?C	065h
	LCDOUT?C	06Eh
	LCDOUT?C	073h
	LCDOUT?C	06Fh
	LCDOUT?C	072h
	LCDOUT?C	021h
	LCDOUT?C	020h
	LCDOUT?C	02Ah
	LCDOUT?C	02Ah
	PAUSE?C	001F4h
	GOTO?L	_MainLoop
	LABEL?L	L00031	
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	0CCh
	OWOUT?C	044h
	OWEND?	

	LABEL?L	_WaitLoop	
	OWPIN?T	_DQ
	OWMODE?C	004h
	OWIN?B	_Count_Remain
	OWEND?	
	CMPEQ?BCL	_Count_Remain, 000h, _WaitLoop
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	0CCh
	OWOUT?C	0BEh
	OWEND?	
	OWPIN?T	_DQ
	OWMODE?C	000h
	OWIN?B	_Temperature_LOWBYTE
	OWIN?B	_Temperature_HIGHBYTE
	OWCOUNT?C	004h
	OWINSKIP?	
	OWIN?B	_Count_Remain
	OWIN?B	_Count_Per_C
	OWEND?	
	SHIFTR?WCW	_Temperature, 001h, T1
	MUL?WCW	T1, 064h, T1
	SUB?WCW	T1, 019h, T1
	SUB?BBW	_Count_Per_C, _Count_Remain, T2
	MUL?WCW	T2, 064h, T2
	DIV?WBW	T2, _Count_Per_C, T2
	ADD?WWW	T1, T2, _Temperature
	CMPLE?WCL	_Temperature, 07FFFh, L00033
	NOT?WW	_Temperature, _Temperature
	SUB?CWW	02710h, _Temperature, _V
	GOTO?L	L00034
	LABEL?L	L00033	
	ADD?CWW	02710h, _Temperature, _V
	LABEL?L	L00034	
	SUB?WWW	_TargetTemp, _Hyst, T1
	CMPGE?WWL	_V, T1, L00035
	MOVE?CT	001h, _PORTA_2
	MOVE?CT	000h, _PORTA_3
	LABEL?L	L00035	
	ADD?WWW	_TargetTemp, _Hyst, T1
	CMPLE?WWL	_V, T1, L00037
	MOVE?CT	000h, _PORTA_2
	MOVE?CT	001h, _PORTA_3
	LABEL?L	L00037	
	GOSUB?L	_SelectSign
	GOSUB?L	_DisplayTemp
	GOTO?L	_MainLoop

	LABEL?L	_SelectSign	
	CMPNE?WCL	_V, 02710h, L00039
	MOVE?CB	020h, _Sign
	GOTO?L	L00040
	LABEL?L	L00039	
	CMPGE?WCL	_V, 02710h, L00041
	MOVE?CB	02Dh, _Sign
	GOTO?L	L00042
	LABEL?L	L00041	
	MOVE?CB	02Bh, _Sign
	LABEL?L	L00042	
	LABEL?L	L00040	
	RETURN?	

	LABEL?L	_DisplayTemp	
	CMPLT?WCL	_V, 02710h, L00043
	SUB?WCW	_V, 02710h, _Temperature
	GOTO?L	L00044
	LABEL?L	L00043	
	SUB?CWW	02710h, _V, _Temperature
	LABEL?L	L00044	
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?B	_Sign
	LCDOUTCOUNT?C	000h
	DIV?WCW	_Temperature, 064h, T1
	LCDOUTNUM?W	T1
	LCDOUTDEC?	
	LCDOUT?C	02Eh
	LCDOUTCOUNT?C	002h
	LCDOUTNUM?W	_Temperature
	LCDOUTDEC?	
	LCDOUT?C	020h
	LCDOUT?C	0DFh
	LCDOUT?C	043h
	LCDOUT?C	020h
	RETURN?	

	LABEL?L	_SetTargetTemp	
	MOVE?WW	_TargetTemp, _V
	GOSUB?L	_SelectSign
	GOSUB?L	_DisplayTemp
	PAUSE?C	0FAh
	RETURN?	

	END
