'* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
'* Universal thermostat -25/+75 C.  by R.T.G. van Steenis                  *
'* Compiler : PicBasic Pro 2.45                                            *
'* B0 = Mode switch in (In)            A0 = LCD Enable    (Out)            *
'* B1 = + switch in    (In)            A1 = LCD RS        (Out)            *
'* B2 = - switch in    (In)            A2 = "Warm" Output (Out)            *
'* B3 = Not connected  (Out)           A3 = "Cold" Output (Out)            *
'* B4 = LCD Bit 4      (Out)           A4 = DQ DS1820     (In)             *
'* B5 = LCD Bit 5      (Out)                                               *
'* B6 = LCD Bit 6      (Out)                                               *
'* B7 = LCD Bit 7      (Out            PIC16F628 Code size = 1124 Words    *
'*                                                                         * 
'* Oscillator XP (4 MHz.) - Power up timer enabled - MCR enable            *
'* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

TRISA= %11110000                        ' RA0..3=Outputs RA4=Input
TRISB= %00000111 			' RB0..RB2=Inputs, RB3..RB7=Outputs
CMCON=7                                 ' Disable comparators

DEFINE LCD_DREG PORTB                   ' LCD on port B
DEFINE LCD_DBIT 4                       ' Data bits B4..B7
DEFINE LCD_RSREG PORTA                  ' RS on PORTA
DEFINE LCD_RSBIT 1                      ' RS on A1 
DEFINE LCD_EREG PORTA                   ' E on PORTA
DEFINE LCD_EBIT 0                       ' E on A0
DEFINE LCD_BITS 4                       ' LCD 4 bit mode
DEFINE LCD_LINES 2                      ' 2 line LCD display

Temperature 	Var	Word		' Temperature storage
TargetTemp	Var	Word		' Desired Temperature
Hyst		Var	Word		' Hystereris
V		Var	Word		' Var. for display
B1              Var     Byte            ' Byte for TargetTemp calculation 
B2              Var     Byte            ' Byte for TargetTemp calculation
Count_Remain 	Var 	Byte		' Count remaining
Count_Per_C 	Var	Byte		' Count per degree C
Sign		Var	Byte		' +/- sign
Mode 		Var	Byte		' 0=Temp. display, 1=Set Temp, 2=Set Hysteresis
DQ		Var	PORTA.4		' One-wire data pin

DATA 46, 224, 20                        ' Temp MSB, TEMP LSB, Hysteresis DIV 10

PORTA.2=0                               ' Warm Output Low
PORTA.3=0                               ' Cold Output Low
Mode=0                                  ' Temperature display mode  

LCDOUT $FE, 1, $FE, $0C                 ' Clear display, cursor off

Read 0, B1                              ' Read TargetTemp MSB
Read 1, B2                              ' Read TargetTemp LSB
TargetTemp=B1*256+B2                    ' Calculate TargetTemp value (Default=20.0 C.)
Read 2, B1                              ' Read Hysteresis 
Hyst=10*B1                              ' Calculate Hysteresis value (Default= 2.0 C.)  

MainLoop: 
 If PORTB.0=0 then                      ' Mode switch pressed
  Pause 50                              ' Debounce 
  LcdOut $FE, $8F, "*"                  ' Show that command is accepted 
  If PORTB.0=0 then MainLoop            ' Wait until button is released  
  Mode=Mode+1                           ' Increment mode
  If Mode=2 then                        ' Save Target Temperature (Mode1 -> Mode2)
   Write 0, TargetTemp / 256		' TargetTemp MSB
   Write 1, TargetTemp MOD 256          ' TargetTemp LSB
  EndIf
  If Mode > 2 Then                      ' Save Hysteresis (Mode 2 -> Mode 0) 
   Mode=0               		' Only 0, 1, 2 are valid
   Write 2, Hyst / 10                   ' Divide Hyst value to fit in Byte
  EndIf
 EndIf

 If Mode =1 then                        ' Set Target Temperature
  LcdOut $FE, $80, "SET TEMPERATURE "   ' Show function
  V=TargetTemp                          ' TargetTemp in V  
  Gosub SelectSign                      ' Select +/blank/- 
  Gosub DisplayTemp                     ' Display Target Temperature
  If (PORTB.1=0) Or (PORTB.2=0) then    ' Up or Down button pushed
   If PORTB.2=0 then                    ' Down button 
    If TargetTemp > 7500 then           ' Not lower than -25 C. (10000-MinTemp * 100)
     TargetTemp=TargetTemp-25           ' Decrease temperuture with 0.25 C.
    EndIf
   EndIf
   If PORTB.1=0 then                    ' Up button
    If TargetTemp < 17500 then          ' Not higher than 75 C. (10000+MaxTemp * 100)
     TargetTemp=TargetTemp+25           ' Increase temperature with 0.25 C.
    EndIf
   EndIf
   GoSub SetTargetTemp                  ' Display TargetTemp and delay 0.25 Sec.
  EndIf
 EndIf 

 If Mode=2 then                         ' Set Hysteresis    
  LcdOut $FE, $80, "HYSTERESIS      "   ' Show function
  Sign=" "                              ' No sign  
  V= 10000+Hyst                         ' Set value for V  
  Gosub DisplayTemp                     ' Display Hysteresis
  If (PORTB.1=0) Or (PORTB.2=0) then    ' Up or down button pushed  
   Sign=" "                             ' No sign for Hysteresis
   If PORTB.2=0 then                    ' Down button
    If Hyst > 10 then Hyst=Hyst-10      ' Not less than 0.1 C.
   EndIf
   If PORTB.1=0 then                    ' Up button
    If Hyst < 1000 then Hyst=Hyst+10    ' Not more than 10.0 C.
   EndIf 
   V= 10000+Hyst                        ' Set value for V
   Gosub DisplayTemp                    ' Display Hysteresis 
   Pause 250                            ' Delay 0.25 Sec.
  EndIf
 EndIf 

 If Mode > 0 then Mainloop              ' Setting TargetTemperature or Hysteresis

 LcdOut $FE, $80, "TEMPERATURE     "    ' Show function

 Output DQ             			' Make Pin Output
 DQ=0					' OneWire line Low
 PauseUs 480                            ' Keep down for 480 S  
 Input DQ                               ' Make Pin Input
 PauseUs 70                             ' Wait 70 S
 If DQ=1 then                           ' No presence pulse from DS1820   
  LcdOut $FE, $1, "** No sensor! **"    ' Show message
  Pause 500                             ' Wait 0.5 Sec. 
  Goto MainLoop                         ' Check again
 EndIf

 OWOut DQ, 1, [$CC, $44]       		' Start temperature conversion
WaitLoop: OWIn DQ, 4, [Count_Remain]	' Check for still busy converting
 If Count_Remain = 0 Then WaitLoop      ' Busy 
 OWOut DQ, 1, [$CC, $BE]		' Read the temperature
 OWIn DQ, 0, [Temperature.LowByte, Temperature.HighByte, Skip 4, Count_Remain, Count_Per_C]
 Temperature = (((Temperature >> 1) * 100) - 25) + (((Count_Per_C - Count_Remain) * 100) / Count_Per_C)
 if Temperature > 32767 then
  Temperature= ~Temperature
  V= 10000 - Temperature                ' 25 C=12500  0 C=10000  -10 C=9000 
 else
  V= 10000 + Temperature
 EndIf

 If V < TargetTemp - Hyst then          ' Below Target temperature - Hysteresis
  PORTA.2=1                             ' Activate   Warm Output
  PORTA.3=0                             ' Deactivate Cold Output
 EndIf

 If V > TargetTemp + Hyst then          ' Above Target temperature + Hysteresis
  PORTA.2=0                             ' Deactivate Warm output
  PORTA.3=1                             ' Activate   Cold Output
 EndIf

 GoSub SelectSign                       ' +/blank/- Sign 
 GoSub DisplayTemp                      ' Temperature to LCD

Goto MainLoop				' Do it forever

' SUBROUTINES:
'----------------------------------------
SelectSign:
 If v = 10000 then                      ' Temperature = 0 C.
  Sign=" " 				' No sign
 Else 
  If v < 10000 then              	' <> 0
   Sign="-"				' Temperature below 0 C. 	
  Else
   Sign="+"				' Temperature above 0 C.
  EndIf
 EndIf
Return

'----------------------------------------
DisplayTemp:
 If V >= 10000 then                     ' Above 0 C.      
  Temperature=V-10000                   
 Else                                   
  Temperature=10000-V                   ' Below 0 C. 
 EndIf
 LcdOut $FE, $C0, Sign, DEC (Temperature / 100), ".", DEC2 Temperature, " ",223,"C "
Return

'-----------------------------------------
SetTargetTemp:
 V=TargetTemp
 Gosub SelectSign
 Gosub DisplayTemp 
 Pause 250
Return

'-----------------------------------------
