#ifndef __AVR_EXCEPTION_H__
#define __AVR_EXCEPTION_H__

#include <avr/io.h>
#include <setjmp.h>

extern jmp_buf  *jmp_ptr;
extern int       exception_code;


#define TRY(a)                                 \
  {                                            \
    jmp_buf env;                               \
    jmp_buf * old_env = jmp_ptr;               \
    jmp_ptr = &env;                            \
    uint8_t sreg = SREG;                       \
    if( ! ( exception_code = setjmp( env ) ) ) \
    {                                          \
      a                                        \
    }                                          \
    jmp_ptr = old_env;                         \
    SREG = sreg;                               \
  }

#define CATCH(a,b)                             \
  {                                            \
    if( exception_code == (a) )                \
    {                                          \
      b                                        \
    }                                          \
  }

#define THROW(a)                               \
  {                                            \
    longjmp(*jmp_ptr, (a));                    \
  }

#endif /* __AVR_EXCEPTION_H__ */
