/*
 * pwm.h
 *
 *  Created on: 14.10.2010
 *  (C) 2010 D.Goersch
 */

#ifndef PWM_H_
#define PWM_H_

#ifndef F_CPU
#define F_CPU 16000000L              	// F_CPU
#endif

#define F_PWM 100                       // PWM freq
#define PWM_STEPS 256                   // PWM steps
#define T_PWM (F_CPU/(F_PWM*PWM_STEPS)) // tics/PWM cycle

#if (T_PWM<(93+5))
#error T_PWM too low, increase F_CPU or decrease F_PWM or PWM_STEPS
#endif

#include <stdint.h>
#include <avr/io.h>
#include <avr/interrupt.h>

volatile uint8_t pwm_setting[24];	// Array with the PWM values
#endif /* PWM_H_ */
