'
'|-------------------------------------------------------------------------|
'|  Netzteil Power Meter Modul                         Stand: 24.10.2007   |
'| Fr 13,8 V und wahlweise 5A/50A Strom               C by DG7XO          |
'| Anzeige U, I, Is, P und W sowie Power Peak Balken                       |
'|                                                                         |
'| Diese Software darf fr private Zwecke verwendet und angepasst werden,  |
'| sofern das Copyright mit angegeben wird.                                |
'| Eine kommerzielle Verwendung ist hiermit untersagt bzw. bedarf meiner   |
'| schriftlichen Genehmigung!                                              |
'|                                                                         |
'| C by Oliver Micic  |  mail@dg7xo.de  |  www.dg7xo.de                    |
'|                                                                         |
'| Bei xxxxV Meldung berspannung,                    Messbereiche         |
'| bei 10,8V Abschaltung ber Relais              Spannung: 0V (5V) - 30V  |
'|                                                   Strom: 0,2A - 5A/50A  |
'| Software Version   1.16a 4x20 Zeichen          Leistung: 1W - 999W      |
'| Layout Version     1.07                    elek. Arbeit: max 999kWh     |
'| Schaltplan Version 1.06      KS0076B DIP Version !!!!                   |
'|-------------------------------------------------------------------------|
'                               'english version
'$dbg
$regfile = "m8def.dat"
$crystal = 8000000                           'interner 8 MHz RC-Osz.
'$baud = 9600

$hwstack = 64                                '64
$swstack = 16                                '8
$framesize = 64                              '32






'Ausgnge definieren
' 0 = Eingang, 1 = Ausgang
'Eingnge-----------------------------------------------------------------
Ddrb.1 = 0                                   '5A oder 50A abfrage JP1
Ddrd.6 = 0                                   'Taster Beleuchtung
Ddrd.5 = 0                                   'Abfrage ob Is oder Ah  JP2
Ddrb.2 = 0                                   'Pin fr Temp_Adj
Ddrc.5 = 0                                   'AD Eingang fr Temp
Ddrd.4 = 0                                   'Jumper fr U-berwachung

'PullUps -------------------------
Portb.1 = 1                                  'PullUp
Portd.6 = 1                                  'PullUp
Portd.5 = 1
Portb.2 = 1
Portc.5 = 1
Portd.4 = 1

'Ausgnge------------------------------------------------------------------
Ddrb.3 = 1                                   'Relais Ausgang fr Untersp.

Taster Alias Pind.6                          'Eingang Taster
Rufzeichen Alias Pind.5                      'Eingang Is oder Ah, 1=Is; 0=Ah
Relais Alias Portb.3                         'Ausgang Relais
Jumper3 Alias Pind.4                         'Jumper Relais-Fkn. Aktiv



Dim Ad0 As Word                              'Spannungswert in Bits 0-1023
Dim Ad1 As Word                              'Stromwert in Bits

Dim Urech As Single                          'Endergebnis U
Dim U_corr As Single                         'Corr-Faktor fr u-Mess
Dim U_soll As Single                         'U-Soll einstellen
Dim Irech As Single                          'Enfergebnis I
Dim Irech_mittel As Single                   'Strom Mittelwert
Dim Irech_mittel2 As Single                  'Strom Mittelwert Ergebnis
Dim Irech_count As Byte                      '10x messen = Mittelwert
Dim Ipeak As Single                          'Endergebnis Spitzen-Strom
Dim Ipeak_p As Single                        'Strom Peak fr Leistung / Barg.
Dim Imerken As Single                        'Is fr vergleich merken
Dim Traege As Byte                           'Zhler fr Trgheit
Dim Pout As Word                             'Endergebnis P
Dim Pout_s As Word                           'Schnelle Pwr
Dim Pwr_lcd As Byte                          'Trgheit LCD Anzeige
Dim Messbereich As Byte                      'Abfrage Messbereich 25/50A
Dim U_min_dec As Bit


Dim P_save As Bit                            'Wenn keine Leistung, LCD aus

'Laufzeit ermitteln
Dim Stunde As Word
Dim Minute As Byte
Dim Lz_sec As Word
Dim Tage As Word

Dim Zeichen As String * 13                   'Peak-String Voll Zeichen
Dim Zeichenl As String * 13                  'Peak-String Leer Zeichen  war 16
Dim Balken As String * 13                    'Peak-String Ergebnis/Anzeige
Dim Teil As Word                             'Hilfs-var fr Zwischen-Peak
Dim Teilz As Word                            'Hilfs-var fr Zwischen-Peak
Dim Teiler As Word                           'Hilfs-var fr Zwischen-Peak
Dim Tast_merker As Bit                       'EEPROM schreiben begrenzen
Dim Testi As Word                            '5er Mittelwert vom A/D Wdl
Dim Ad11 As Word                             'Bit Word vom Strom A/D Wdl
Dim Ad11h As Word                            'Bits runden wegen Digit-err
Dim Ad11_p As Word                           'Bit Spitze Strom

Dim Sekunden As Word                         'Arbeit
Dim Arbeit_sec As Word                       'Ws
Dim Arbeit_sec1 As Word                      'Ws Ausgabe LCD
Dim Arbeit_h As Long                         'Wh
Dim Arbeit_h_kw As Single                    'Wh Temp Zwischenwert
Dim Sec_fertig As Word                       'Sec Umsprung erkennen
Dim Kwh As Bit                               'Merker ob kWh anzeigen
Dim Kein_ocr As Bit                          'Dimmsperre wenn kwh gewhlt
Dim Welcome As Byte                          'Merker erstes Mal on
Dim Ah_temp As Single                        'Wert Kapazitt Zwischenwert
Dim Ah_stunde As Single                      'Wert Kapatitt Ergebniss

Dim Temp_ad As Word                          'Hilfs-Car fr Temperatur und
Dim Temp_adj As Word                         'Abgleichfunktion
Temp_adj = 1
Dim Lcd_traege As Byte                       'Zeigt nicht jeden ermittelten
Lcd_traege = 10                              'Wert an, da sonst schlecht ab-
                                              'zulesen.

Dim Ausgabebit As Byte

'Var fr Digit Fehler korr, da der AD-Wandler sonst springt (Zahlenwert)
Dim Anzeige As Byte
Anzeige = 1


'Var fr Digit Fehler korr
Dim Ad_i_min As Word
Dim Ad_i_max As Word
Dim Ad_u_min As Word
Dim Ad_u_max As Word
Dim Ad_ip_min As Word
Dim Ad_ip_max As Word


Pwr_lcd = 9                                  'erste Anzeige sofort



Enable Interrupts

Config Lcd = 20 * 4a , Chipset = Ks077       'Fr DIP Modul !  Chipset = Ks077
'Config Lcd = 20 * 4                          'Fr normale HD44780 LCDs

Config Lcdbus = 4

Config Adc = Single , Prescaler = Auto , Reference = Avcc

On Timer1 Sec_counter
Config Timer1 = Timer , Prescale = 64        'Quarz/64  mit Timer1 = 100ms!!!
'Timer1 = 34286
Enable Timer1


'Sonderzeichen selbst gestrickt
Deflcdchar 0 , 32 , 32 , 32 , 32 , 32 , 32 , 32 , 32       'Teilstriche 0-5
Deflcdchar 1 , 16 , 16 , 16 , 16 , 16 , 16 , 16 , 16
Deflcdchar 2 , 24 , 24 , 24 , 24 , 24 , 24 , 24 , 24
Deflcdchar 3 , 28 , 28 , 28 , 28 , 28 , 28 , 28 , 28
Deflcdchar 4 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30
Deflcdchar 5 , 31 , 31 , 31 , 31 , 31 , 31 , 31 , 31
Deflcdchar 6 , 4 , 14 , 21 , 4 , 4 , 4 , 4 , 4       ' Pfeil oben klein
Deflcdchar 7 , 32 , 32 , 32 , 4 , 14 , 21 , 4 , 4       ' Pfeil oben gro

Config Lcdpin = Pin , Db4 = Portd.0 , Db5 = Portd.1 , Db6 = Portd.2 , Db7 = Portd.3 , E = Portd.7 , Rs = Portb.0
'Config Lcdpin = Pin , Db4 = Portd.0 , Db5 = Portb.3 , Db6 = Portd.2 , Db7 = Portd.3 , E = Portd.7 , Rs = Portb.0

'-------------------------------------------------------------------------------


Initlcd
Waitms 50
Cursor Off
Cls
Waitms 100

'A Bissl Werbung und dann gehts los....

'Logo-Text anzeigen
Locate 1 , 1
Lcd "===================="
Locate 2 , 1
Lcd "   DC Power Meter   "
Locate 3 , 1
Lcd "  Firmware  V1.16a  "
Locate 4 , 1
Lcd "===================="
Waitms 1500
Locate 3 , 1
Lcd "  by DG7XO 03/2007  "
Waitms 1200
Locate 3 , 1
Lcd "       hello        "
Wait 2
Cls
Waitms 100
' Ab hier etwas Small-Talk und U-Abgleich wenn EEPROM leer oder Wunsch --------
Readeeprom Welcome , 5
If Welcome > 0 Or Taster = 0 Then            'Abgleich starten wenn uC leer
                                              'oder Taster = 0 beim Einschalten
U_soll = 13.80                               'default U-Wert vom NT

Temp_adj = 1
Writeeeprom Temp_adj , 40
Waitms 10

Schritt00:                                   'Taster sperre, damit er wartet
If Taster = 0 Then
Locate 2 , 1
Lcd "Release key         "
Goto Schritt00
Else
End If

Schritt0:                                    'Ab hier die Werbe-Texte
 Locate 1 , 1
Lcd "Press key           "
Locate 2 , 1
Lcd "to continue         "
If Taster = 0 Then
    Waitms 400
    Cls
    Goto Schritt3
   Else
End If
Goto Schritt0

'Schritt1:                      'Fr diesen Text kein Platz mehr
'Locate 1 , 1
'Lcd "Mit dem SMD-Poti"
'Locate 2 , 1
'Lcd "den Kontrast    "
'If Taster = 0 Then
'    Waitms 400
'    Goto Schritt2
'   Else
'End If
'Goto Schritt1
'
'Schritt2:
'Ocr2 = 0
'Locate 1 , 1
'Lcd "einstellen und  "
'Locate 2 , 1
'Lcd "im Anschluss    "
'If Taster = 0 Then
'    Waitms 400
'    Goto Schritt3
'   Else
'End If
'Goto Schritt2

Schritt3:
Locate 1 , 1
Lcd "    voltage/current "
Locate 2 , 1
Lcd " adjust mode        "
If Taster = 0 Then
    Waitms 600
    Sekunden = 0
    Goto Schritt6                            'war Schritt 4
   Else
End If
Goto Schritt3


'----- Ab hier das Spannung abgleich Programm !!!!! -------------------------

Schritt6:
Start Adc
Ad0 = Getadc(0)                              'U-Wert holen in Ad0 = ADC1
Stop Adc


Urech = Ad0 * 4.89                           'Spannung ausrechnen
Urech = Urech * 6                            'Spannungsteiler mal 3
Urech = Urech / 1000

U_corr = U_soll / Urech                      'Corr Faktor ermitteln (stndig)

Locate 1 , 1                                 'U-Ist anzeigen
Lcd "Now:     "
Locate 1 , 10
Lcd Fusing(urech , "#.##") ; "V     "

Locate 2 , 1                                 'U-Soll anzeigen
Lcd "Target:  "
Locate 2 , 10
Lcd Fusing(u_soll , "#.##") ; "V     "

Locate 3 , 1
Lcd "Push button to     "
Locate 4 , 1
Lcd "adjust voltage     "

If Taster = 0 Then                           'Spannung um 10mV erhhen
   U_soll = U_soll + 0.01
   Sekunden = 0                              'Immer wieder lschen, bei Tastend.
   Waitms 100

   Else
   End If

   If U_soll => 14.4 Then                    'berlauf verhindern = Stellbereich
   U_soll = 12.3                             '12,3 - 14,4V fr Abgleich
   Else
   End If

   If Sekunden => 100 Then                   'Nach 10s warten ins Hauptprogramm
   Sekunden = 0
   Goto Schritt7
   Else
   End If

Goto Schritt6

Schritt7:                                    'Werte ins EEPROM schreiben
Welcome = 0
'Anzeige = 1
Writeeeprom Welcome , 5
Waitms 20
Writeeeprom U_corr , 20
Waitms 20
Temp_adj = 0
Writeeeprom Temp_adj , 40
Waitms 50
'Writeeeprom Anzeige , 30
Cls

Else
End If                                       'Werbe- und Config abgeschlossen

' ============================================================================
' ====================== Hauptprogramm =======================================
' ============================================================================

Readeeprom U_corr , 20
Waitms 50                                    'Cor Faktor holen

'Readeeprom Anzeige , 30                      'entfllt bei 4x20
Readeeprom Temp_adj , 40
Waitms 50
Do                                           'Ab hier die Programmschleife !!!
Main:

For Pwr_lcd = 1 To 10                        'Schleife bis nach unten


'Anzeige Modi auswhlen ---- entfllt da 4x20 LCD ----------------------------
'If Taster = 0 Then
'Anzeige = Anzeige + 1
'If Anzeige => 5 Then Anzeige = 1
'Writeeeprom Anzeige , 30

'Waitms 200
'Else
'End If

'1 = kWh
'2 = Bargraph
'3 = Laufzeit
'4 = Ah

' Bei Modi 3 Laufzeit anzeigen ------------
'If Anzeige = 3 Then




  Locate 4 , 1
  Lcd "Time: "
  If Stunde < 168 Then
                         Locate 4 , 7
                         Lcd Stunde ; "h " ; Minute ; "m "
                        Else
                         Tage = Stunde / 24
                         Locate 4 , 7
                         'Lcd "   "
                         Lcd Tage ; "D     "
                     End If


  'Temp Sensor rechnen und erkennen

 If Pinb.2 = 0 Then
 Temp_adj = Temp_adj + 1
    If Temp_adj => 25 Then Temp_adj = 0
    Writeeeprom Temp_adj , 40
    Waitms 200
 Else
 End If

 'Locate 4 , 15
 'Lcd Temp_ad

  Temp_ad = Temp_ad * 48.82
 Temp_ad = Temp_ad - 28900
 Temp_ad = Temp_ad / 100
 Temp_ad = Temp_ad + Temp_adj

  Lcd_traege = Lcd_traege + 1

  'Wenn kein LM335 angeschlossen ist, wrde er ber 200C anzeigen, da techn.
'nicht mglich, wird auf nicht vorhanden ausgegangen.
If Temp_ad =< 200 And Lcd_traege => 7 Then
Lcd_traege = 0
 Locate 4 , 15



 'Ausgabe auf LCD
 Lcd " +" ; Temp_ad
 'Print Temp_ad

 If Temp_ad < 10 Then
 Lcd Chr(128) ; "C "
 Else
 Lcd Chr(128) ; "C"
 End If

 Else
 End If

 'Else
 'End If


 If Temp_ad > 200 Then
 Locate 4 , 15
 Lcd "no tmp"                                '<= max 6 Zeichen
 Else
 End If



'Bei Modi 4 Ah anzeigen---------------
'If Anzeige = 4 Then
 Locate 3 , 12
'Lcd Ah_stunde ; "mAh"
Lcd Fusing(ah_stunde , "#.###") ; "Ah"
'Else
'End If





'Messbereich umschalten 2 = 200W ; 1 = 800W fr den Bargraphen
If Pinb.1 = 1 Then
   Messbereich = 1                           '800W/50A Version
  Else
   Messbereich = 5                           '150W/5A Version
 End If

'A/D starten und Werte holen und ausrechnen ---------------------------------

Start Adc
Ad11 = Getadc(1)                             'I-Wert holen in Ad1
Ad0 = Getadc(0)
Temp_ad = Getadc(5)                          'U-Wert holen in Ad0
Stop Adc

Ad11_p = Ad11                                'Hilfs-var fr Spitzenwerte



'Runden Vomn Bit -------------
Ad11h = Ad11h + Ad11
Testi = Testi + 1
If Testi => 3 Then
Testi = 0
Ad1 = Ad11h / 3
Ad11h = 0
Else
End If


' Digit-Fehler +/- 1 komp. ----- Strom ---------------------------------------
If Ad_i_min = Ad1 Then
Ad1 = Ad1 + 1
Else
End If

If Ad_i_max = Ad1 Then
Ad1 = Ad1 - 1
Else
End If

Ad_i_min = Ad1 - 1
Ad_i_max = Ad1 + 1
'---- Spannung ---------------------
If Ad_u_min = Ad0 Then
Ad0 = Ad0 + 1
Else
End If

If Ad_u_max = Ad0 Then
Ad0 = Ad0 - 1
Else
End If

Ad_u_min = Ad0 - 1
Ad_u_max = Ad0 + 1
'------ Spitzen-Strom -------------

If Ad_ip_min = Ad11_p Then
Ad11_p = Ad11_p + 1
Else
End If

If Ad_ip_max = Ad11_p Then
Ad11_p = Ad11_p - 1
Else
End If

Ad_ip_min = Ad11_p - 1
Ad_ip_max = Ad11_p + 1
'-------------Ende----------
'Da der AD-Wandler sich mal fr das eine oder andere Bit entscheiden kann,
' (rauschen), werden mit dieser Hilfe das stnde kippen verhindert

If Ad1 <= 1 Then Ad1 = 0                     ' Die ersten beiden bits auf 0 !!

' U und I errechnen
Urech = Ad0 * 4.89                           'Spannung ausrechnen
Urech = Urech * 6
Urech = Urech * U_corr
Urech = Urech / 1000

Irech = Ad1 * 4.8875855                      'Strom ausrechnen
Irech = Irech / 100


Ipeak_p = Ad11 * 4.8875855                   'Spitzenstrom ausrechnen
Ipeak_p = Ipeak_p / 100

If Pinb.1 = 0 Then                           'Wenn JP1 gesteckt, 5A Version !!
Irech = Irech / 10                           'mit 10mOhm Shunt !!!
Ipeak_p = Ipeak_p / 10
Else
End If




'Strom Mittelwert von 5 Werten ermitteln--- fllt aus -----------------------
Irech_mittel = Irech



'Wenn Spannung unter 10,8V bei Akku-Betrieb, abschalten !! ----------------
' und Jumper 3 auf Masse !!


If Urech < 10.8 And Jumper3 = 0 Then
Waitms 400
  If Urech < 10.8 Then
     Locate 1 , 7
     Lcd "Low battery   "
     Relais = 1
    Else
  End If
 Else
End If

If Urech > 11.8 Then
Relais = 0

Else
End If

'==============================================================================


'If Pwr_lcd = 5 Then                          'jeden 5. Durchgang anzeigen
'Spannung messen, rechnen, anzeigen -----------------------------------------
'
 If Urech < 10 Then                          'Ausgabe formatieren
      Locate 1 , 1
      Lcd Fusing(urech , "#.##") ; "V "

     Else
  End If

   If Urech => 10 Then
      Locate 1 , 1
      Lcd Fusing(urech , "#.#") ; "V "
     Else
   End If

'Locate 1 , 1
'Lcd Arbeit_h

'Strom messen, rechnen, anzeigen ----------------------------------------------
   If Irech_mittel < 10 And Relais = 0 Then
      Locate 1 , 7
      Lcd " " ; Fusing(irech_mittel , "#.##") ; "A "
     Else
   End If

   If Irech_mittel => 10 And Relais = 0 Then 'And Irech_count => 2 Then
   'Irech_count = 0
      Locate 1 , 7
      Lcd " " ; Fusing(irech_mittel , "#.#") ; "A"
    Else
   End If

 ' Else
'End If

'Spitzenstrom ermitteln und anzeigen -----------------------------------------




   Traege = Traege + 1                       'Mal zhlen fr die Hold-Time
 Locate 1 , 14                               'Position angeben


  ' Lcd Ipeak Ausgabe formatieren und anzeigen
    If Ipeak < 10 And Relais = 0 Then
       Lcd " " ; Fusing(ipeak , "#.##") ; "A "
      Else
    End If
    If Ipeak => 10 And Relais = 0 Then
        Lcd " " ; Fusing(ipeak , "#.#") ; "A "
       Else
    End If


   'Warte schleife fr max. Wert und Spitzenstrom ermitteln
    If Ipeak_p > Imerken Then
    Imerken = Ipeak_p
    Traege = 0
    Ipeak = Ipeak_p
    Else
       If Traege => 70 And Ipeak_p < Imerken Then
       Imerken = 0
       Ipeak = Ipeak_p
       Else
       End If
    End If


'Ah-Ermitteln und statt Is anzeigen ----------------------------------------
'===========================================================================

'entfllt da 4x20 LCD
  Ah_stunde = Ah_temp / 36000

'Elek. Arbeit in kWh  -------------------------------------------------------
'===========================================================================0


'Watt/sec zhlen  10 Werte pro sekunde => alle 100ms eine Messung
If Sekunden => 65000 Then
     Sekunden = 1
     Sec_fertig = 0
    Else
End If

'alle 100ms Leistung und Strom addieren
If Sekunden > Sec_fertig Then                'wenn neue 100ms angefangen sind.
     Sec_fertig = Sekunden
     Arbeit_sec = Arbeit_sec + Pout          'Ws
   Ah_temp = Ah_temp + Ipeak_p
   Else
End If
         '1 Wh ermitteln
         If Arbeit_sec => 36000 Then
              Sekunden = 0
              Sec_fertig = 0
              Arbeit_sec = Arbeit_sec - 35999       'Ws auf null
             ' Ah_temp = Ah_temp - 35999      'Ah auf Null

              Arbeit_h = Arbeit_h + 1
              'Ah_stunde = Ah_stunde + 1
            Else
         End If

'Ausgabe formatiert aufs LCD wenn gewhlt

             Arbeit_h_kw = Arbeit_h / 1000
            Locate 3 , 1
  'Lcd "1234567890"
 'Lcd Fusing(arbeit_h_kw , "#.###") ; "kWh "
 If Arbeit_h_kw < 10 Then Lcd Fusing(arbeit_h_kw , "#.###") ; "kWh"
 If Arbeit_h_kw => 10 And Arbeit_h_kw < 100 Then Lcd Fusing(arbeit_h_kw , "#.##") ; "kWh"
 If Arbeit_h_kw => 100 Then Lcd Fusing(arbeit_h_kw , "#.#") ; "kWh"




' Leistungsanzeige U x I = P ------------------------------------------------

Pout = Irech_mittel * Urech                  'Normale Leistung gerundet
Pout_s = Ipeak_p * Urech                     'Fr Spitznwertanzeige und Bargraph


  Pwr_lcd = 0

  'Ausgabe formatieren und anzeigen
  Locate 2 , 1
    If Pout < 10 Then Lcd "  " ; Pout ; "W"  '1er
    If Pout => 10 And Pout < 100 Then Lcd " " ; Pout ; "W"       '10er
    If Pout > 100 Then Lcd Pout ; "W"        '100er
    If Pout_s > 780 And Messbereich = 1 Then 'wenn berlauf pfeil 390W

        If Pout_s > 900 And Messbereich = 1 Then       'wenn berlauf pfeil 550W
           Locate 2 , 6
           Lcd Chr(6)
          Else
           Locate 2 , 6
           Lcd Chr(7)
        End If
       Else
        Locate 2 , 6
        Lcd " "
     End If


' ---------------- Leistungs Peak Anzeige -----------------------------------


     Pout_s = Pout_s * Messbereich           'x2 fr 720W=25A NT, sonst 50A
     Teiler = Pout_s / 70                    'ca 700W durch 10 Balken


     'Teilz = Pout_s
     Teilz = 70 * Teiler                     'bissl rechnen
     Teilz = Pout_s - Teilz


     ' Hier die Teilstriche  rechnen und anzeigen
     Locate 2 , 8
     If Teilz <= 3 Then Teil = 0
     If Teilz > 3 And Teilz <= 17 Then Teil = 1
     If Teilz > 17 And Teilz <= 34 Then Teil = 2
     If Teilz > 34 And Teilz <= 51 Then Teil = 3
     If Teilz > 51 And Teilz <= 70 Then Teil = 4

     If Teiler < 1 Then

        Lcd Chr(teil) ; "            "
      Else

        'Wenn grer 0, dann Balken anzeige der Spannung nach
         Zeichen = Chr(5) + Chr(5) + Chr(5) + Chr(5) + Chr(5) + Chr(5) + Chr(5) + Chr(5) + Chr(5) + Chr(5) + Chr(5)
         Zeichenl = "            "
         'Zeichenl = "________________"
         Balken = Left(zeichen , Teiler)
         Lcd Balken ; Chr(teil)
         Teiler = 11 - Teiler
         Balken = Right(zeichenl , Teiler)
         Lcd Balken
      End If


' Einschaltzeit ermitteln, und anzeigen, nach umschaltung

If Lz_sec => 600 Then                        'Minuten ermitteln
   Lz_sec = 0
   Minute = Minute + 1
   Else
   End If
If Minute => 60 Then                         'Stunden ermitteln
   Minute = 0
   Stunde = Stunde + 1
   Else
   End If

'----------------------------------------------------------------------
 Next Pwr_lcd                                'Fr LCD Trgheit
Goto Main
Loop

' ------------------ Unterprogramme ------------------------------------

Sec_counter:
'sekunden erzeugen mit Timer1  = 10x 100ms !!!
Timer1 = 53036                               'bei /64 100ms
Sekunden = Sekunden + 1
Lz_sec = Lz_sec + 1
Ausgabebit = Ausgabebit + 1
Return


End