;----------------------------------------------------------------------------------------
;-	Procedury obsugi magistrali 1-Wire:
;-		- reset
;-		- odczyt/zapis bitu
;-		- odczyt/zapis bajtu
;----------------------------------------------------------------------------------------
; Zdefiniowanie portu x i jego pinu n do ktrego podczone zostao urzdzenie 1-Wire:
	.equ	portx		=portb		;port x = portb
	.equ	pinx		=pinb		;port wejciowy pinx = pinb
	.equ	ddrx		=ddrb		;rejestr kierunkowy portu x = ddrb
	.equ	pxn		=pb3		;n-ty pin portu x = pb3 - urzdzenie 1-Wire
; Rejestry: temp,licz,dana zostay wczeniej zdefiniowane nastpujco:
;	.def	temp		=r20		;rejestr tymczasowy
;	.def	licz		=r22		;licznik
;	.def	dana		=r23		;rejestr danych
;----------------------------------------------------------------------------------------
;-	Reset
;----------------------------------------------------------------------------------------
reset_1wire:
		rcall pxn_out		;ustaw lini jako wyjcie
		ldi temp,3
		rcall wait		;czekaj 387us
		ldi temp,183
		rcall wait_us		;+92us = ~480us
		rcall pxn_in		;ustaw lini jako wejcie
		ldi temp,139
		rcall wait_us		;czekaj 70us

		sbis pinx,pxn		;sprawd stan linii:
		ser dana		;stan niski (dana:=$ff) = wykryto urzdzenia 1-Wire 
		sbic pinx,pxn		;
		clr dana		;stan wysoki (dana:=$00) = brak urzdzenia 1-Wire

		ldi temp,3
		rcall wait		; czekaj 387us
		ldi temp,45
		rcall wait_us		;+23us = 119us
		ret
;----------------------------------------------------------------------------------------
;-	Odczyt bajtu lub pojedynczego bitu
;----------------------------------------------------------------------------------------
read_bit:				;odczyt bitu
		ldi licz,$80		;aduj licznik wartoci dla odczytu bitu
		rjmp one_bit
read_byte:				;odczyt bajtu
		ldi licz,1		;aduj licznik wartoci dla odczytu bajtu
	one_bit:
		clr dana		;zeruj dan
	rb_loop:
		rcall pxn_out		;ustaw lini jako wyjcie
		ldi temp,11
		rcall wait_us		;czekaj 6us
		rcall pxn_in		;ustaw lini jako wejcie
		ldi temp,17
		rcall wait_us		;czekaj 9us

		sbic pinx,pxn		;sprawd stan linii 
		or dana,licz		;jeeli stan wysoki to do dodaj licznik do danej
		lsl licz		;przesu bity licznika o jedn pozycj w lewo 
					;jeeli odczytywano jeden bit to: dana=$80 (1)
		ldi temp,109
		rcall wait_us		;czekaj 55us

		cpi licz,0		;jeli licznik=0
		brne rb_loop		;to bit/bajt zosta odczytany
		ret
;----------------------------------------------------------------------------------------
;-	Zapisz bajt
;----------------------------------------------------------------------------------------
write_byte:				
		clr licz
	wb_loop:
		sbrc dana,0
		rcall write_1
		sbrs dana,0
		rcall write_0
		lsr dana
		inc licz
		cpi licz,8
		brne wb_loop
		ret	
;----------------------------------------------------------------------------------------
;-	Zapisz '1'
;----------------------------------------------------------------------------------------
write_1:
		rcall pxn_out		;ustaw lini jako wyjcie
		ldi temp,11
		rcall wait_us		;czekaj 6us
		rcall pxn_in		;ustaw lini jako wejcie
		ldi temp,127		;czekaj 64us
		rcall wait_us
		ret
;----------------------------------------------------------------------------------------
;-	Zapisz '0'
;----------------------------------------------------------------------------------------
write_0:
		rcall pxn_out		;ustaw lini jako wyjcie
		ldi temp,119
		rcall wait_us		;czekaj 60us
		rcall pxn_in		;ustaw lini jako wejcie
		ldi temp,19
		rcall wait_us		;czekaj 10us	
		ret
;----------------------------------------------------------------------------------------
;-	Zmiana kierunku linii
;----------------------------------------------------------------------------------------
pxn_out:
		in temp,ddrx			;zaaduj rejestr kierunkowy portu x
		ori temp,1<<pxn			;ustaw bit n w stanie wysokim
		out ddrx,temp			;pin pxn jako wyjcie
		in temp,portx			;zaaduj stan portu x
		andi temp,~(1<<pxn) 		;ustaw bit n w stanie niskim
		out portx,temp			;pin pxn w stanie niskim
		ret
pxn_in:
		in temp,ddrx
		andi temp,~(1<<pxn)
		out ddrx,temp
		in temp,portx
		andi temp,~(1<<pxn)  
		out portx,temp			;pin pxn w stanie wysokiej impedancji
		ret
;----------------------------------------------------------------------------------------
;-	Realizacja opnienia programowego	t(us)=(1+temp)/2	temp = 2*t(us)-1
;----------------------------------------------------------------------------------------
wait_us:
		dec temp
		cpi temp,0
		brne wait_us
		ret
;----------------------------------------------------------------------------------------