;----------------------------------------------------------------------------------------
;- 	Procedury:
;-			-	obsuga wywietlacza LCD 2x16 znakw
;-			-	zamiana BIN/BCD liczb 16 bitowych
;-			- 	opnienie programowe
;----------------------------------------------------------------------------------------
;- Definicje

	.equ 	e		=pd4	;przypisanie pinw dla LCD
	.equ 	rs		=pd6	;
	.equ 	db4		=pd3	;tylko 4 linie danych
	.equ 	db5		=pd2	;w trybie 4-bitowym
	.equ 	db6		=pd1	;
	.equ 	db7		=pd0	;

	.def	temp		=r20	;rejestr tymczasowy
	.def	temp2		=r21	;rejestr tymczasowy nr2
	.def	licz		=r22	;licznik
	.def	dana		=r23	;rejestr danych
;----------------------------------------------------------------------------------------
;-	Inicjalizacja LCD
;----------------------------------------------------------------------------------------
lcd_init:
	cbi portd,e		;zeruj magistral
	cbi portd,rs		;
	cbi portd,db4		;
	cbi portd,db5		;
	cbi portd,db6		;
	cbi portd,db7		;

	ldi temp,130		;standardowy proces inicjalizacji LCD
	rcall wait		;dla trybu 4-bitowego
	ldi licz,3
	sbi portd,db4
	sbi portd,db5
   	send3x3:
	sbi portd,e
	cbi portd,e
	ldi temp,40
	rcall wait
	dec licz
	cpi licz,0
	brne send3x3
	cbi portd,db4
	cbi portd,db5
	sbi portd,db5
	sbi portd,e
	cbi portd,e
	ldi temp,2
	rcall wait
	ldi dana,$28
	rcall send_to_lcd
	ldi dana,$08
	rcall send_to_lcd
	rcall clr_lcd
	cbi portd,rs
      	ldi dana,$06
	rcall send_to_lcd
    	ldi dana,$0f
	rcall send_to_lcd
	sbi portd,rs
	ret
;----------------------------------------------------------------------------------------
;-	Wysyanie danych/instrukcji do LCD
;----------------------------------------------------------------------------------------
send_to_lcd:
	push temp
	cbi portd,db4
	cbi portd,db5
	cbi portd,db6
	cbi portd,db7 
         
	sbrc dana,7       	;przeskocz, jeli bit 7 wyzeroway
	sbi portd,db7     	;jeli jest '1' to ustaw lini db7
	sbrc dana,6
	sbi portd,db6
	sbrc dana,5
	sbi portd,db5
	sbrc dana,4
	sbi portd,db4
	sbi portd,e       	;wylij 4 starsze bity 
	nop
	cbi portd,e       
	ldi temp,7
	rcall wait

	cbi portd,db4
	cbi portd,db5
	cbi portd,db6
	cbi portd,db7 

	sbrc dana,3
	sbi portd,db7
	sbrc dana,2
	sbi portd,db6
	sbrc dana,1
	sbi portd,db5
	sbrc dana,0
	sbi portd,db4
	sbi portd,e       	;wylij 4 modsze bity
	nop
	cbi portd,e      

	ldi temp,8
	rcall wait
	pop temp
	ret

;----------------------------------------------------------------------------------------
;-	Procedury dla LCD
;----------------------------------------------------------------------------------------
cur_left:			;przesu kursor w lewo
	cbi portd,rs
	ldi dana,$10
	push temp
	rcall send_to_lcd
	pop temp		;temp = liczba przesuni kursora
	dec temp
	cpi temp,0
	brne cur_left
	sbi portd,rs
	ret
;--------
cur_right:			;przesu kursor w prawo
	cbi portd,rs
	ldi dana,$14
	push temp
	rcall send_to_lcd
	pop temp
	dec temp
	cpi temp,0
	brne cur_right
	sbi portd,rs
	ret
;--------
empty_right:			;przesu pusty znak w prawo (nie kursor)
	ldi dana,$20
	push temp
	rcall send_to_lcd
	pop temp
	dec temp
	cpi temp,0
	brne cur_right
	ret
;--------
cur_off:			;wycz kursor
	cbi portd,rs
	ldi dana,$0c
	rcall send_to_lcd
	sbi portd,rs
	ret
;--------
cur_on:				;wcz kursor
	cbi portd,rs
	ldi dana,$0e
	rcall send_to_lcd
	sbi portd,rs
	ret
;--------
clr_lcd:			;czyszcz lcd
	cbi portd,rs
	ldi dana,$01
	rcall send_to_lcd
	ldi temp,20
	rcall wait
	sbi portd,rs
	ret
;---------------------------------------------------------------------------------------
;-	Realizacja opnienia programowego			kwarc=8MHz, T=0,125us
;-	Czas opnienia okrela rej. temp wedug wzoru:		t(us) = (1028*temp+13)/8
;-	Wartoc rej. temp okrela si wedug wzoru:		temp = (8*t(us)-13)/1028
;-	minimalny czas opnienia= 131 us, maksymalny - 33ms
;---------------------------------------------------------------------------------------
wait:     
	push temp		;zachowaj na stosie temp	
	push temp2   		;oraz temp2      
	ldi temp2,$ff		;aduj temp2
  loop_0:
	inc temp2		;zwieksz temp2
	cpi temp2,$ff		;porwnaj zawarto temp2 z $ff
	brne loop_0		;jesli nie rwne to kontynuuj petle 0
	ldi temp2,0		;jeli rwne to zeruj temp2 
  loop_1:
	dec temp		;zmniejsz temp
	cpi temp,0		;porwnaj zawarto temp z dan 0
	brne loop_0		;jezeli nie rwne to kontynuuj ptle 1
	pop temp2		;zdejmij ze stosu temp2
	pop temp  		;oraz temp 
	ret
;---------------------------------------------------------------------------------------
;-	Konwersja binarnej liczby 16-bitowej na posta BCD (na podstawie noty ATMEL AVR)
;-	bin_ah:bin_al = bcd2:bcd1:bcd0
;---------------------------------------------------------------------------------------
	.def	BCD0		=r14
	.def	BCD1		=r15	
	.def	BCD2		=r16	
	.def	bin_al		=r24
	.def	bin_ah		=r25

word_to_bcd:
		push bin_al
		push bin_ah
		ldi	licz,16		;zainicjuj licznik ptli
		clr	bcd2		;zeruj wynik (3 bajty)
		clr	bcd1		
		clr	bcd0		
		clr	zh
	bbcdx_1:
		lsl	bin_al		;przesu w lewo wartoc wejciow
		rol	bin_ah		;przez wszystkie bajty
		rol	bcd0		;
		rol	bcd1
		rol	bcd2
		dec	licz		;dekrementuj licznik ptli
		brne	bbcdx_2		;jeli licznik nie jest zero to powrt
		pop bin_ah
		pop bin_al
		ret	
	bbcdx_2:		
		ldi	r30,16
	bbcdx_3:
		ld	temp,-z		;pobierz (z) z predekrementacj
		subi	temp,-$03	;dodaj 0x03
		sbrc	temp,3		;jeeli bit 3 nie jest 0
		st	z,temp		;	przechowaj
		ld	temp,z		;pobierz (z)
		subi	temp,-$30	;dodaj 0x30
		sbrc	temp,7		;jeeli bit 7 nie jest 0
		st	z,temp		;	przechowaj
		cpi	zl,13		;czy skoczone?
		brne	bbcdx_3		;kolejna ptla jeli nie
		rjmp	bbcdx_1		
;---------------------------------------------------------------------------------------