;------------------------------------------------------------------------
;-
;- Nazwa projektu:		
;-			Modu woltomierza/amperomierza z termostatem
;- Mikrokontroler:	
;-			ATmega8, 8MHz
;- Kompilator:		
;-			wavrasm Version 1.30
;- Autor:	
;-			Patryk Ziewiec (patele@wp.pl)
;-
;------------------------
;- Data ostatniej
;- modyfikacji:		21.02.2009
;------------------------
;-	Funkcje podstawowe:
;-			- pomiar napicia do 50V w dwch podzakresach:
;-				- do 20V z krokiem 0,01V 
;-				- od 20 do 50V z krokiem 0,1V
;-			- pomiar prdu do 10A z krokiem 0,01A
;-			
;-	Funkcje dodatkowe:
;-			- termostat, pomiar temperatury do 125'C,
;-			- ograniczenie prdowe
;-			- wejcie rnicowe umoliwiajce pomiar
;-			  napicia do 20V z krokiem 0,01V z moliwoci
;-			  porwnania z wartoci zadan oraz histerez
;-
;------------------------------------------------------------------------
.include "m8def.inc"
;-	Definicje:

.equ	sw1		=pb0	;przypisanie nazw przyciskw
.equ	sw2		=pd7	;wybranym wyprowadzeniom
.equ	switch1		=pinb	;przypisanie nazw dla portw
.equ	switch2		=pind

.equ	vout		=pb4	;wyjcie wykonawcze dla wej.rnicowego
.equ	tout		=pb2	;wyjcie wykonawcze dla termostatu
.equ	iout		=pb1	;wyjcie wykonawcze ograniczenia prdowego

.def	bin_bl		=r26	;rejestry
.def	bin_bh		=r27	;oglnego
.def 	licz2		=r28	;przeznaczenia

.equ	ds_temp		=$6a	;przechowuje temperatur z DS18B20

.equ	difvol_l	=$6b	;przechowuje zadan warto napicia
.equ	difvol_h	=$6c	;porwnywan z napiciem z wej. rnicowego
.equ	hyst_vl		=$6d	;przechowuje zadan warto histerezy
.equ	hyst_vh		=$6e	;porwnywan z napiciem z wej. rnicowego

.equ	therm		=$6f	;przechowuje zadan temperatur termostatu
.equ	hyst_t		=$70	;przechowuje zadan histerez termostatu

.equ	flag_0		=$71	;bajt znacznik, przechowuje informacje:

	;bity: 0,1,2	- pozycja kursora w menu wyboru
	;3 		- wywietl(1)/ukryj(0) temperatur
	;4 		- wcz(1)/wycz(0) termostat
	;5		- wywietl(1)/ukryj(0) napicie z wej. rnicowego
	;6		- wcz(1)/wycz(0) porwnywanie w.w. napicia
	;7		- wcz(1)/wycz(0) ograniczenie prdowe


.equ	current_l	=$72	;przechowuje zadan warto prdu
.equ	current_h	=$73	;
.equ	hyst_cl		=$74	;oraz zadan histerez
.equ	hyst_ch		=$75

.equ	flag_2		=$76	;bajt znacznik,
	;bit 0		-powrt z menu_3

.equ	offset_l	=$77	;przechowuje warto zmierzonego bdu zera
.equ	offset_h	=$78	;(offset error) przetwornika AC


.equ	vol_l		=$79	;przechowuje aktualne
.equ	vol_h		=$7a	;napicie

.equ	flag_1		=$7b	;bajt znacznik:

	;0	- S2 wcinity cigle (1) lub jednorazowo (0)
	;1	- wejcie do menu_3 (1)
	;2	- S1
	;3	- rwnoczesnego wcinicia przyciskw S1 S2
	;4	- wejcia do menu_2 (1) lub do menu_1 (0)
	;5	- znacznik wyjcia wykonawczego ograniczenia prdowego CO
	;6	- znacznik wyjcia wykonawczego wej. rnicowego UO
	;7	- znacznik wyjcia wykonawczego termostatu TO

.org $00			;reset mikrokontrolera
		rjmp start	;skok do gwnego programu

.org $1a			;adres rozpoczynajcy kod programu
.include 	"lcd2def.inc"	;docz dane obsugi LCD 2x16
.include 	"1wiredef.inc"	;docz dane obsugi linii 1-Wire
.include	"otherdef.inc"	;docz pozostae procedury

;------------------------------------------------------------------------
;-	Konwersja przetwornika z wykorzystaniem metody nadprbkowania.
;-	Uzyskana rozdzielczo: 11-bitw
;-	Urednienie wyniku pomiaru na podstawie 32 kolejnych odczytw
;-	Odczyt kolejno dla kadego z 5 wej
;------------------------------------------------------------------------
.equ	adr0		=$60
.equ	vola_h		=$60
.equ	vola_l		=$61
.equ	volb_h		=$62
.equ	volb_l		=$63
.equ	cur_h		=$64
.equ	cur_l		=$65
.equ	vol_ah		=$66
.equ	vol_al		=$67
.equ	vol_bh		=$68
.equ	vol_bl		=$69

adc_conversion:
		
		rcall channel_0	;wcz kana 0
		clr zh
		ldi zl,adr0
	channel_set:
		clr licz
		clr bin_bl
		clr bin_bh
	adc_loop:
		push licz
		push bin_bl
		push bin_bh
		clr licz
		clr bin_bl
		clr bin_bh
		clr bin_al
		clr bin_ah
	adc_sum_loop:
		clr temp
		out adch,temp
		out adcl,temp
		sbi adcsr,adsc
	adc_pending:
		sbic adcsr,adsc	;czekaj na zakoczenie przetwarzania
		rjmp adc_pending
		in bin_al,adcl		;zachowaj odczytan warto
		in bin_ah,adch

		
		add bin_bl,bin_al
		adc bin_bh,bin_ah
		inc licz
		cpi licz,4		;sumuj 4 kolejne prbki z adc
		brne adc_sum_loop
		lsr bin_bh		;podziel sum przez 2
		ror bin_bl
		mov bin_al,bin_bl
		mov bin_ah,bin_bh
	adc_end:
		pop bin_bh		 
		pop bin_bl
		pop licz
		add bin_bl,bin_al	;sumuj 32 odczyty 
		adc bin_bh,bin_ah
		inc licz
		cpi licz,32
		brne adc_loop
		lsr bin_bh		;podziel sum przez 32 (urednianie)
		ror bin_bl
		lsr bin_bh
		ror bin_bl
		lsr bin_bh
		ror bin_bl
		lsr bin_bh
		ror bin_bl
		lsr bin_bh
		ror bin_bl
		mov bin_al,bin_bl
		mov bin_ah,bin_bh
		
	
		lds bin_bl,offset_l	;zaaduj warto bdu offsetu
		lds bin_bh,offset_h

		cpi bin_bh,$ff		;jeeli offset_h = $ff to znaczy e
		brne no_offset_check	;trwa kalibracja
		ret

	no_offset_check:
		cp bin_al,bin_bl
		cpc bin_ah,bin_bh
		brlo offset_higher_result	;nie pozwl na "przekrcenie" wyniku

		sub bin_al,bin_bl	;odejmij bd offsetu od wyniku
		sbc bin_ah,bin_bh
	offset_higher_result:
		mov bin_bl,bin_al
		mov bin_bh,bin_ah

	no_offset_error:
		in temp,admux
		andi temp,$0f
		cpi temp,0
		brne check_chan_1
		st z+,bin_ah
		st z+,bin_al
		rcall channel_1
		rjmp channel_set
	check_chan_1:			;odczyty dla kanaw nr. 0,1
		cpi temp,1
		brne check_chan_2
		st z+,bin_ah
		st z+,bin_al
		rcall channel_2
		rjmp channel_set
	check_chan_2:
		cpi temp,2
		brne check_chan_3
		lsr bin_ah		;dzielenie przez 2 (ze wzgldu
		ror bin_al		;na przedwzmacniacz LM358)
		st z+,bin_ah
		st z+,bin_al
		rcall channel_3
		rjmp channel_set
	check_chan_3:
		cpi temp,3
		brne check_chan_4
		st z+,bin_ah
		st z+,bin_al
		rcall channel_4
		rjmp channel_set
	check_chan_4:
		cpi temp,4
		brne check_chan_end
		st z+,bin_ah
		st z,bin_al
	check_chan_end:
		rcall difvol_set
		ret
;------------------------------------------------------------------------
;-	Wywietlenie gwnego okna danych na LCD
;------------------------------------------------------------------------
send_window:
		lds temp,flag_1
		ori temp,$02
		sts flag_1,temp		;V

		lds bin_ah,vola_h
		lds bin_al,vola_l
		rcall word_to_bcd
		
		mov temp,bcd1
		cpi temp,$20
		brlo no_ov20v
		mov temp,bcd0
		cpi temp,$00
		brsh ov20v
		rjmp no_ov20v
		
	ov20v:
		lds bin_ah,volb_h
		lds bin_al,volb_l
		rcall word_to_bcd

		mov dana,bcd1
		andi dana,$0f
		ori dana,$30
		rcall send_to_lcd
		mov dana,bcd0
		andi dana,$f0
		swap dana
		ori dana,$30
		rcall send_to_lcd
		ldi dana,$2e		;.
		rcall send_to_lcd
		mov dana,bcd0
		andi dana,$0f
		ori dana,$30
		rcall send_to_lcd
		ldi dana,$56		;V
		rcall send_to_lcd
		ldi dana,$20		;''
		rcall send_to_lcd
		rjmp ov20v_end
	no_ov20v:
		rcall send_vol
	ov20v_end:
		ldi temp,3
		rcall cur_right

		
		lds temp,flag_1
		andi temp,$fd
		sts flag_1,temp		;A

		lds bin_ah,cur_h
		lds bin_al,cur_l
		rcall send_vol

		lds temp,flag_1
		sbrc temp,5
		ldi dana,$20		;''
		sbrs temp,5
		ldi dana,$2a		;*
		rcall send_to_lcd

		lds temp,flag_1
		ori temp,$02
		sts flag_1,temp		;V

		ldi temp,25
		rcall cur_right

		lds temp,flag_0
		sbrc temp,5
		rjmp no_chide_vol
		ldi temp,7
		rcall empty_right
		rjmp chide_vol
	no_chide_vol:
		lds bin_al,vol_l
		lds bin_ah,vol_h
		rcall send_vol

		lds temp,flag_1
		sbrc temp,6
		ldi dana,$20		;''
		sbrs temp,6
		ldi dana,$2a		;*
		rcall send_to_lcd
	chide_vol:
		ldi temp,1
		rcall cur_right

		lds temp,flag_0
		sbrc temp,3
		rjmp no_chide_tmp
		ldi temp,6
		rcall empty_right
		rjmp chide_tmp
	no_chide_tmp:
		rcall send_temp
		lds temp,flag_1
		sbrc temp,7
		ldi dana,$20		;''
		sbrs temp,7
		ldi dana,$2a		;*
		rcall send_to_lcd
	chide_tmp:
		ldi temp,25
		rcall cur_right
		lds temp,flag_1
		andi temp,$fd
		sts flag_1,temp
		ret
;------------------------------------------------------------------------
;-	Wywietlenie temperatury na LCD
;------------------------------------------------------------------------
send_temp:
		lds bin_al,ds_temp
		sbrs bin_al,7		;czy minus?
		rjmp no_send_minus
		ldi dana,$2d		;'-'
		rcall send_to_lcd
		rjmp minus_enter

	no_send_minus:
		cpi bin_al,100
		brlo no_over99
		clr bin_ah
		rcall word_to_bcd
		mov dana,bcd1
		andi dana,$0f
		ori dana,$30
		rcall send_to_lcd	;1xx,x
		rjmp over_enter
	no_over99:
		ldi dana,$20		;'' - pusty znak
		rcall send_to_lcd
	minus_enter:
	over_enter:
		clr bin_ah
		andi bin_al,$7f	;maska na minus
		rcall word_to_bcd
		mov dana,bcd0
		rcall bcd_to_lcd	;.xx..
		ldi dana,$df		;'
		rcall send_to_lcd
		ldi dana,$43		;C
		rcall send_to_lcd
		ret
;------------------------------------------------------------------------
;-	Wywietlenie napicia/prdu na LCD
;------------------------------------------------------------------------
send_vol:
		rcall word_to_bcd
		mov temp,bcd1
		cpi temp,$10
		brsh no_hide_zero_sv
		ldi dana,$20		;''
		rcall send_to_lcd
		mov dana,bcd1
		ori dana,$30
		rcall send_to_lcd
		rjmp zero_hide_sv
	no_hide_zero_sv:
		mov dana,bcd1
		rcall bcd_to_lcd
	zero_hide_sv:

		ldi dana,$2e		;.
		rcall send_to_lcd
		mov dana,bcd0
		rcall bcd_to_lcd

		lds temp,flag_1	;sprawd ktre menu wczone (3 czy 1)
		sbrs temp,1
		ldi dana,$41		;A
		sbrc temp,1
		ldi dana,$56		;V
		rcall send_to_lcd
		ret
;------------------------------------------------------------------------
;-	Wywietlenie menu nastaw ograniczenia prdowego
;------------------------------------------------------------------------
menu_1:
;****
		ser temp2
	m1_wait:
		sbic switch1,sw1	;dusze wcisnicie klawisza
		ret
		ldi temp,22
		rcall wait
		dec temp2
		brne m1_wait

		ser temp2
	m1_wait_sw:
		sbic switch1,sw1
		rjmp m1_enter		;a nastpnie zwolnienie klawisza
		ldi temp,255		;uruchamia menu
		rcall wait
		dec temp2
		brne m1_wait_sw
	m1_enter:
;****
		lds temp,flag_1
		andi temp,0b11101111	;menu_1 aktywne
		sts flag_1,temp

		rcall clr_lcd		;czy LCD
		ldi dana,$49		;I
		rcall send_to_lcd
		ldi dana,$3d
		rcall send_to_lcd	;=

		lds bin_al,current_l
		lds bin_ah,current_h
		rcall send_vol

		ldi temp,3
		rcall cur_right

		lds temp,flag_0
		sbrc temp,7
		rcall send_on
		sbrs temp,7
		rcall send_off
		
		ldi temp,26		;skok na dolny wiersz
		rcall cur_right

		ldi dana,$48		;H
		rcall send_to_lcd
		ldi dana,$3d
		rcall send_to_lcd	;=

		lds bin_al,hyst_cl
		lds bin_ah,hyst_ch
		rcall send_vol

		ldi temp,3
		rcall cur_right

		ldi dana,$7e		;->>
		rcall send_to_lcd
		ldi dana,$3e
		rcall send_to_lcd
		ldi dana,$3e
		rcall send_to_lcd

		ldi temp,26
		rcall cur_right
		rjmp unia
;------------------------------------------------------------------------
;-	Wywietlenie menu nastaw termostatu
;------------------------------------------------------------------------
menu_2:

;****
		ser temp2
	m2_wait:
		sbic switch2,sw2	;dusze wcisnicie klawisza
		ret
		ldi temp,22
		rcall wait
		dec temp2
		brne m2_wait

		ser temp2
	m2_wait_sw:
		sbic switch2,sw2
		rjmp m2_enter		;a nastpnie zwolnienie klawisza
		ldi temp,255		;uruchamia menu
		rcall wait
		dec temp2
		brne m2_wait_sw
	m2_enter:
;****

		lds temp,flag_1
		ori temp,$10
		sts flag_1,temp

		rcall clr_lcd
		ldi dana,$54
		rcall send_to_lcd	;T
		ldi dana,$3d
		rcall send_to_lcd	;=
		rcall send_therm
		ldi dana,$df		;'
		rcall send_to_lcd
		ldi dana,$43		;C
		rcall send_to_lcd

		ldi temp,4
		rcall cur_right

		lds temp,flag_0
		sbrc temp,4
		rcall send_on
		sbrs temp,4
		rcall send_off

		ldi temp,26
		rcall cur_right

		ldi dana,$48		;H
		rcall send_to_lcd
		ldi dana,$3d
		rcall send_to_lcd	;=
		rcall send_hyst_t
		ldi dana,$df		;'
		rcall send_to_lcd
		ldi dana,$43		;C
		rcall send_to_lcd

		ldi temp,4
		rcall cur_right

		lds temp,flag_0
		sbrs temp,3
		ldi dana,$db
		sbrc temp,3
		ldi dana,$78		;'x'
		rcall send_to_lcd

		ldi dana,$4c		;L
		rcall send_to_lcd
		ldi dana,$43		;C
		rcall send_to_lcd
		ldi dana,$44		;D
		rcall send_to_lcd

		ldi temp,25
		rcall cur_right
		rjmp unia
;------------------------------------------------------------------------
;-	Wywietlenie menu nastaw napicia z wejcia rnicowego
;------------------------------------------------------------------------
menu_3:
		lds temp,flag_1
		ori temp,$02
		sts flag_1,temp

		rcall clr_lcd		;czy LCD
		ldi dana,$55		;U
		rcall send_to_lcd
		ldi dana,$3d
		rcall send_to_lcd	;=
		lds bin_al,difvol_l
		lds bin_ah,difvol_h
		rcall send_vol

		ldi temp,3
		rcall cur_right

		lds temp,flag_0
		sbrc temp,6
		rcall send_on
		sbrs temp,6
		rcall send_off
		
		ldi temp,26		;skok na dolny wiersz
		rcall cur_right

		ldi dana,$48		;H
		rcall send_to_lcd
		ldi dana,$3d
		rcall send_to_lcd	;=
		lds bin_al,hyst_vl
		lds bin_ah,hyst_vh
		rcall send_vol

		ldi temp,3
		rcall cur_right

		lds temp,flag_0
		sbrs temp,5
		ldi dana,$db
		sbrc temp,5
		ldi dana,$78		;'x'
		rcall send_to_lcd

		ldi dana,$4c		;L
		rcall send_to_lcd
		ldi dana,$43		;C
		rcall send_to_lcd
		ldi dana,$44		;D
		rcall send_to_lcd


		ldi temp,25
		rcall cur_right
		rjmp unia
;------------------------------------------------------------------------
;	Procedura koczca, wsplna dala menu nastaw
;------------------------------------------------------------------------
unia:
		lds temp,flag_0
		andi temp,$f8
		sts flag_0,temp		;bity 0,1,2= 0 -kursor na poz. 0
		rcall cur_on			;wcz kursor
		clr licz2
	menu_sw:
		rcall scan_switch
		sbrc temp,0
		rjmp sw1_msw
		sbrc temp,1
		rjmp sw2_msw
		rjmp no_msw
	sw1_msw:
		rcall shift_cur
		rjmp menu_sw
	sw2_msw:
		lds temp,flag_1
		sbrs temp,0
		rjmp no_cntsw
		ori temp,$04
		sts flag_1,temp
		rjmp cntsw
	no_cntsw:
		andi temp,0b11111011
		sts flag_1,temp
	cntsw:
		lds temp,flag_1
		sbrc temp,4
		rjmp s2_mset
		rcall set_s1

		lds temp,flag_2		;powrt z menu_3 ?
		sbrc temp,0			;jeli
		rjmp end_menu3
		rjmp menu_sw			;nie to kontynuuj ptle
	s2_mset:
		rcall set_s2
		rjmp menu_sw 
	no_msw:	
		rcall write_to_eeprom		;zapisz zmiany do eeprom
		rcall cur_off
		rcall clr_lcd
		rcall send_window
		ret
	end_menu3:
		andi temp,$fe
		sts flag_2,temp

		lds temp,flag_1
		andi temp,$f0
		sts flag_1,temp
		ret
;------------------------------------------------------------------------
;-	Przesuwanie kursora w menu
;------------------------------------------------------------------------
shift_cur:
		lds licz,flag_0
		sbrc licz,0
		rjmp to2_shift
		sbrc licz,1
		rjmp to3_shift
		sbrc licz,2
		rjmp to0_shift
	to1_shift:	
		ldi temp,11
		rcall cur_right
		andi licz,$f8
		ori licz,$01
		rjmp end_cshift
	to2_shift:
		ldi temp,29
		rcall cur_right
		andi licz,$f8
		ori licz,$02
		rjmp end_cshift
	to3_shift:
		ldi temp,11
		rcall cur_right
		andi licz,$f8
		ori licz,$04
		rjmp end_cshift
	to0_shift:
		ldi temp,29
		rcall cur_right
		andi licz,$f8
		rjmp end_cshift
	end_cshift:
		sts flag_0,licz
		ser temp
		rcall wait_long
		rcall wait_long
		ret
;------------------------------------------------------------------------
;-	wprowadzanie zmian w menu nastaw prdu i napicia wej.rnicowego
;------------------------------------------------------------------------
set_s1:
		rcall cur_off
		lds temp,flag_0	;zaaduj aktualn pozycj kursora
		sbrc temp,0
		rjmp sets1_onoff
		sbrc temp,1
		rjmp set_hystvol
		sbrc temp,2
		rjmp sets1_xo
		rjmp set_difvol
		
	sets1_xo:
		lds temp,flag_1
		sbrs temp,1		;bit nr 1 flag_1 = menu wej rnicowego
		rjmp go_to_menu3
		
		lds temp,flag_0
		sbrc temp,5
		rjmp s1_lcd_o
		ori temp,$20
		ldi dana,$78		;'x'
		rjmp s1_lcd_x
	s1_lcd_o:
		andi temp,0b11011111
		ldi dana,$db		;'o'
	s1_lcd_x:
		sts flag_0,temp
		rcall send_to_lcd
		ldi temp,1
		rcall cur_left
		rjmp no_set
	go_to_menu3:
		lds temp,flag_1
		ori temp,$02
		sts flag_1,temp
		rcall menu_3		;wejd do menu_3
		lds temp,flag_2
		ori temp,$01
		sts flag_2,temp	;powrt z menu_3
		ret
	set_difvol:
		ldi temp,2
		rcall cur_right
		lds temp,flag_1
		sbrs temp,1
		rjmp send_current
		ldi zl,difvol_l
		rcall inc_vh
		lds bin_al,difvol_l
		lds bin_ah,difvol_h
		rcall send_vol
		rjmp end_vset
	send_current:
		ldi zl,current_l
		rcall inc_vh
		lds bin_al,current_l
		lds bin_ah,current_h
		rcall send_vol
		rjmp end_vset
	set_hystvol:
		ldi temp,2
		rcall cur_right
		lds temp,flag_1
		sbrs temp,1
		rjmp set_hyst_c
		ldi zl,hyst_vl
		rcall inc_hystv
		lds bin_al,hyst_vl
		lds bin_ah,hyst_vh
		rcall send_vol
		rjmp end_vset
	set_hyst_c:
		ldi zl,hyst_cl
		rcall inc_hystc
		lds bin_al,hyst_cl
		lds bin_ah,hyst_ch
		rcall send_vol
		rjmp end_vset
	sets1_onoff:
		lds temp,flag_1
		sbrs temp,1
		rjmp set_onoff_c
		lds temp,flag_0
		sbrc temp,6
		rjmp s1_to_off
		ori temp,$40
		sts flag_0,temp
		rcall send_on
		rjmp s1_to_on
	set_onoff_c:
		lds temp,flag_0
		sbrc temp,7
		rjmp s1_to_off_c
		ori temp,$80
		sts flag_0,temp
		rcall send_on
		rjmp s1_to_on
	s1_to_off_c:
		andi temp,$7f
		sts flag_0,temp
		rcall send_off
		rjmp s1_to_on
	s1_to_off:
		lds temp,flag_0
		andi temp,$bf
		sts flag_0,temp
		rcall send_off
	s1_to_on:
		ldi temp,3
		rcall cur_left
		rjmp no_set
	end_vset:
		ldi temp,8
		rcall cur_left
	no_set:
		lds temp,flag_1
		sbrs temp,3
		rjmp no_sw1sw2t
		andi temp,0b11110111
		sts flag_1,temp
		rcall wait_long
	no_sw1sw2t:
		rcall cur_on
	wait_long:
		ser temp
		rcall wait
		rcall wait
		rcall wait
		rcall wait
		rcall wait
		ret
;------------------------------------------------------------------------
;-	Inkrementacja wartoci komrek w menu wejcia rnicowego
;------------------------------------------------------------------------
inc_vh:
		clr zh
		lds temp,flag_1
		sbrs temp,3
		rjmp no_zero_vh
		clr temp
		st z+,temp
		st z,temp
		ret
	no_zero_vh:
		ld bin_al,z+
		ld bin_ah,z
		push zl
		rcall word_to_bcd
		lds temp,flag_1
		sbrs temp,2		;sprawd czy klawisz cigle nacinity
		rjmp no_dv10add	;jeli nie to nie dodawaj 10
		mov temp,bcd0
		andi temp,$0f		;jeli tak to poczekaj a cz jednostek
		cpi temp,0		;wyniku bdzie rwna 0
		brne no_dv10add
		adiw bin_ah:bin_al,50
		adiw bin_ah:bin_al,50	;i dopiero teraz zwikszaj wynik o 10
		rjmp dvadd10
	no_dv10add:
		adiw bin_ah:bin_al,1
	dvadd10:
		mov temp,bcd1
		cpi temp,$20
		brlo no_dfov2000
		clr bin_ah
		clr bin_al
	no_dfov2000:
		clr zh
		pop zl
		st z,bin_ah
		st -z,bin_al
		ret
;--------
inc_hystv:
		lds temp,flag_1	;czy obyda klawisze wcinite?
		sbrs temp,3
		rjmp no_zero_hv
		rjmp zero_hv		;jeli tak to zerowanie komrek
	no_zero_hv:
		rcall inc_vh
		lds bin_al,hyst_vl
		lds bin_ah,hyst_vh
		lds bin_bl,difvol_l
		lds bin_bh,difvol_h
		cp bin_bl,bin_al	;nie pozwl by hyst>dif_vol
		cpc bin_bh,bin_ah
		brsh no_ov_df
	zero_hv:
		clr bin_ah
		clr bin_al
		sts hyst_vl,bin_al
		sts hyst_vh,bin_ah
	no_ov_df:
		ret
;-------
inc_hystc:
		lds temp,flag_1		;czy obydwa klawisze wcinite?
		sbrs temp,3
		rjmp no_zero_hc
		rjmp zero_hc		;jeli tak to zerowanie komrek
	no_zero_hc:
		rcall inc_vh
		lds bin_al,hyst_cl
		lds bin_ah,hyst_ch
		lds bin_bl,current_l
		lds bin_bh,current_h
		cp bin_bl,bin_al	;nie pozwl by hyst>current
		cpc bin_bh,bin_ah
		brsh no_ov_dfc
	zero_hc:
		clr bin_ah
		clr bin_al
		sts hyst_cl,bin_al
		sts hyst_ch,bin_ah
	no_ov_dfc:
		ret
;------------------------------------------------------------------------
;-	Inkrementacja wartoci komrek w menu termostatu
;------------------------------------------------------------------------
inc_th:
		clr zh	
		lds temp,flag_1
		sbrs temp,3
		rjmp no_zero_th
		clr temp
		st z,temp
		ret
	no_zero_th:
		ld bin_al,z
		push zl
		clr bin_ah
		rcall word_to_bcd
		lds temp,flag_1
		sbrs temp,2
		rjmp no_th10add
		mov temp,bcd0
		andi temp,$0f
		cpi temp,0
		brne no_th10add
		subi bin_al,-10
		rjmp thadd10
	no_th10add:
		inc bin_al
	thadd10:
		cpi bin_al,141
		brlo no_thov140
		clr bin_al
	no_thov140:
		pop zl
		clr zh
		st z,bin_al
		ret
;--------
inc_hysttemp:
		lds temp,flag_1
		sbrs temp,3
		rjmp no_zero_ht
		rjmp zero_ht
	no_zero_ht:
		rcall inc_th
		lds bin_ah,hyst_t
		lds bin_al,therm
		cp bin_al,bin_ah	;nie pozwl by hyst_t>therm
		brsh no_ov_th
	zero_ht:
		clr temp
		sts hyst_t,temp
	no_ov_th:
		ret
;------------------------------------------------------------------------
;-	Wprowadzanie zmian w menu nastaw termostatu
;------------------------------------------------------------------------
set_s2:
		rcall cur_off
		lds temp,flag_0	;zaaduj aktualn pozycj kursora
		sbrc temp,0
		rjmp sets2_onoff
		sbrc temp,1
		rjmp set_hysttemp
		sbrc temp,2
		rjmp sets2_xo
		rjmp set_themp
		
	sets2_xo:
		lds temp,flag_0
		sbrc temp,3
		rjmp s2_sendo
		ori temp,$08
		ldi dana,$78		;'x'
		rjmp s2_sendx
	s2_sendo:
		andi temp,$f7
		ldi dana,$db		;'o'
	s2_sendx:
		sts flag_0,temp
		rcall send_to_lcd
		ldi temp,1
		rcall cur_left
		rjmp no_set
	set_hysttemp:
		ldi temp,2
		rcall cur_right
		ldi zl,hyst_t
		rcall inc_hysttemp
		rcall send_hyst_t
		rjmp end_tset
	set_themp:
		ldi temp,2
		rcall cur_right
		ldi zl,therm
		rcall inc_th
		rcall send_therm
		rjmp end_tset
	sets2_onoff:
		lds temp,flag_0
		sbrc temp,4
		rjmp s2_to_off
		ori temp,$10
		sts flag_0,temp
		rcall send_on
		rjmp s2_to_on
	s2_to_off:
		andi temp,$ef
		sts flag_0,temp
		rcall send_off
	s2_to_on:
		ldi temp,3
		rcall cur_left
		rjmp no_set
	end_tset:
		ldi temp,5
		rcall cur_left
		rjmp no_set
;------------------------------------------------------------------------
;-	Skanowanie klawiszy w menu nastaw
;------------------------------------------------------------------------
scan_switch:
		clr temp
		clr temp2
		clr licz

		lds temp,flag_1
		ori temp,$01		;sw2 wcinity cigle
		sts flag_1,temp

		sbic switch1,sw1	;
		rjmp sw_loop		;
		sbic switch2,sw2	;
		rjmp sw_loop		;
		
		lds temp,flag_1
		ori temp,$08		;sw1 i sw2 wcinite rwnoczenie
		sts flag_1,temp
		rjmp sw2_sw
	sw_loop:
		sbis switch1,sw1
		rjmp sw1_sw
		sbis switch2,sw2
		rjmp sw2_sw


		push temp
		lds temp,flag_1
		andi temp,$fe		;sw2 wcinity chwilowo
		sts flag_1,temp
		pop temp

		inc temp
		cpi temp,$ff
		brne sw_loop

		inc temp2
		cpi temp2,$ff
		brne sw_loop
		inc licz
		cpi licz,40		;czas wywietlania menu
		brne sw_loop
		clr temp
		ret
	sw1_sw:
		ldi temp,1
		ret
	sw2_sw:
		ldi temp,2
		ret
;------------------------------------------------------------------------
;-	Skanowanie klawiszy
;------------------------------------------------------------------------
scan_sw:
		sbis switch1,sw1
		rjmp ss_menu1
		sbis switch2,sw2
		rcall menu_2
		rjmp ss_end
	ss_menu1:
		rcall menu_1
	ss_end:
		ret
;------------------------------------------------------------------------
;-	Wywietlanie temperatury termostatu 
;------------------------------------------------------------------------
send_therm:
		lds bin_al,therm
		clr bin_ah
		rcall word_to_bcd
		mov temp,bcd1
		ldi dana,$20		;''
		sbrc temp,0
		ldi dana,$31		;1
		rcall send_to_lcd
		mov dana,bcd0
		rcall bcd_to_lcd
		ret
;------------------------------------------------------------------------
;-	Wywietlanie histerezy termostatu
;------------------------------------------------------------------------
send_hyst_t:
		lds bin_al,hyst_t
		clr bin_ah
		rcall word_to_bcd
		mov temp,bcd1
		ldi dana,$20		;''
		sbrc temp,0
		ldi dana,$31		;1
		rcall send_to_lcd
		mov dana,bcd0
		rcall bcd_to_lcd
		ret
;------------------------------------------------------------------------
;-	Wywietlanie znacznikw - OFF/ON
;------------------------------------------------------------------------
send_off:
		ldi dana,$4f		;O
		rcall send_to_lcd
		ldi dana,$46		;F
		rcall send_to_lcd
		ldi dana,$46		;F
		rcall send_to_lcd
		ret
send_on:
		ldi dana,$4f		;O
		rcall send_to_lcd
		ldi dana,$4e		;N
		rcall send_to_lcd
		ldi dana,$20		;''
		rcall send_to_lcd
		ret
;------------------------------------------------------------------------
;-	Obliczenie napicia rznicowego z wej: VIA i VIB
;------------------------------------------------------------------------
difvol_set:
		lds bin_ah,vol_ah	;aduj komrki z SRAM
		lds bin_al,vol_al
		lds bin_bh,vol_bh
		lds bin_bl,vol_bl
		
		cp bin_al,bin_bl	;porwnaj napicia z wej VIA i VIB
		cpc bin_ah,bin_bh
		brlo sub_ba
		sub bin_al,bin_bl	;jeeli VIA>VIB to V=VIA-VIB
		sbc bin_ah,bin_bh
		sts vol_l,bin_al	;zachowaj wynik
		sts vol_h,bin_ah
		rjmp sub_abend
	sub_ba:
		sub bin_bl,bin_al	;jeeli VIA<VIB to V=VIB-VIA
		sbc bin_bh,bin_ah
		sts vol_l,bin_bl	;zachowaj wynik
		sts vol_h,bin_bh
	sub_abend:
		ret
;------------------------------------------------------------------------
;-	Porwnanie temperatury z wartoci zadan termostatu
;------------------------------------------------------------------------
temp_compare:
		lds temp,flag_0	;aduj bajt-znacznik 0
		sbrs temp,4		;jeli termostat wyczony
		rjmp no_hon		;(bit4=0) to nie porwnuj temperatury

		lds bin_bh,therm
		lds bin_bl,ds_temp
		cp bin_bl,bin_bh
		brlo no_teq
		lds temp,flag_1	;jeli nastpio zrwnanie temperatur
		andi temp,0b01111111	;to ustaw odpowiedni znacznik
		sts flag_1,temp
		cbi portb,tout		;oraz tout w stanie niskim
		ret
	no_teq:
		lds bin_bh,hyst_t
		cp bin_bl,bin_bh	;jeli temperatura spada poniej
		brsh no_heq		;histerezy to ustaw
	no_hon:
		sbi portb,tout		;tout w stanie niskim
		lds temp,flag_1
		ori temp,0b10000000	;oraz znacznik TO
		sts flag_1,temp
	no_heq:
		ret
;------------------------------------------------------------------------
;-	Porwnanie napicia z wejcia rnicowego z wartoci zadan
;------------------------------------------------------------------------
volt_compare:
		lds temp,flag_0	;aduj bajt-znacznik 0
		sbrs temp,6		;jeli wej. rnicowe wyczone
		rjmp no_vhon		;(bit6=0) to nie porwnuj napicia

		lds bin_ah,difvol_h
		lds bin_al,difvol_l
		lds bin_bh,vol_h
		lds bin_bl,vol_l

		cp bin_bl,bin_al
		cpc bin_bh,bin_ah
		brlo no_veq
		lds temp,flag_1	;jeli nastpio zrwnanie napi
		andi temp,0b10111111	;to ustaw odpowiedni znacznik
		sts flag_1,temp
		cbi portb,vout		;oraz vout w stanie niskim
		ret
	no_veq:
		lds bin_ah,hyst_vh
		lds bin_al,hyst_vl
		
		cp bin_bl,bin_al
		cpc bin_bh,bin_ah
		brsh no_vheq		;jeeli napicie spado poniej
	no_vhon:			;histerezy to ustaw
		sbi portb,vout		;vout w stanie wysokim
		lds temp,flag_1
		ori temp,0b01000000	;oraz znacznik VO
		sts flag_1,temp
	no_vheq:
		ret
;------------------------------------------------------------------------
;-	Odczyt bdu zera (offset error) przetwornika AC
;------------------------------------------------------------------------
offset_set:
		sbis switch1,sw1	;wykonaj tylko wtedy
		rjmp os			;jeli ktrykolwiek z klawiszy
		sbis switch2,sw2	;jest wcinity (zaraz po wczeniu)
		rjmp os
		rjmp no_offset_set
	os:
		rcall wait_long	;czekaj na ustabilizowanie napicia
		ser temp
		sts offset_h,temp	;ustaw offset_h
		rcall adc_conversion	;jednorazowa konwersja ADC

		ldi temp,22
		mov dana,bin_al
		rcall byte_to_eeprom
		ldi temp,23
		mov dana,bin_ah
		rcall byte_to_eeprom	;zapisz bd zera w pamici EEPROM
	no_offset_set:
		ret
;------------------------------------------------------------------------
;-	Gwna cz programu
;------------------------------------------------------------------------
start:
		ldi temp,$ff		;ustaw
		out spl,temp		;pocztek
		ldi temp,$03		;stosu
		out sph,temp


		rcall config		;konfiguracja mikrokontrolera
		rcall set_value
		rcall adc_start	;uruchom przetwornik AC
		rcall offset_set	;odczytaj bd zera ADC
		rcall read_from_eeprom	;odczyt danych z EEPROM
		ldi temp,$f0
		sts flag_1,temp	;zeruj bajt znacznik
		rcall lcd_init 	;inicjalizacja lcd
		rcall cur_off		;wycz kursor
		rcall send_window	;wywietl gwne okno danych

main_loop:				;gwna ptla programu
		rcall scan_sw		;skanuj klawisze
		rcall adc_conversion	;jednorazowa konwersja ADC
		rcall volt_compare	;porwnaj napicie
		rcall current_compare	;porwnaj prd
		rcall scan_sw		;skanuj klawisze
		rcall ds18b20_temp	;odczytaj temperatur z DS18B20
		rcall temp_compare	;porwnaj temperatur
		rcall scan_sw		;skanuj klawisze
		rcall send_window	;odwie gwne okno danych
		rjmp main_loop	
;------------------------------------------------------------------------
;***
;21.02.2009
;Zmiany w porwnaniu do wersji pierwszej:
;
;- Wejcie do menu nastaw moliwe jest tylko po duszym wcisniciu,
;  a nastpnie zwolnieniu klawisza. Zapobiega to przed niechcianym
;  wejciem do menu, np w momencie przypadkowego wcinicia klawisza.
;- Wyduenie czasu wywietlania kadego z menu nastaw.
;- Wyeliminowanie wywietlania na LCD przypadkowych wartoci
;  tu po zaczania zasilania moduu.