;------------------------------------------------------------------------
;-	Konfiguracja mikrokontrolera
;------------------------------------------------------------------------
config:
		ldi temp,0b01010110	;pb5 fizycznie poczony z GND (PCB)!
		out ddrb,temp
		ldi temp,0b11010111    
		out portb,temp

		ldi temp,0b01011111	;pd5 fizycznie poczony z VCC!
		out ddrd,temp
		ldi temp,0b11011111
		out portd,temp

		clr temp
		out ddrc,temp
		clr temp
		out portc,temp

		in temp,acsr
		ori temp,$80		;wycz komparator
		out acsr,temp		;w celu zmniejszenia poboru prdu
		ret 
;------------------------------------------------------------------------
;-	Zamiana liczb w BCD na kody dla LCD
;------------------------------------------------------------------------
bcd_to_lcd:
      		push dana	;zachowaj dan na stosie
      		swap dana	
      		andi dana,$0f 
      		ori dana,$30
      		rcall send_to_lcd
      		pop dana
      		andi dana,$0f
      		ori dana,$30
      		rcall send_to_lcd
      		ret     
;------------------------------------------------------------------------
;-	Inicjalizacja wewntrznego przetwornika AC 10-bit
;------------------------------------------------------------------------
adc_start:
		clr temp
		out adch,temp
		out adcl,temp
		sbi adcsr,adps0		;ustaw preskaler
		sbi adcsr,adps1
		sbi adcsr,adps2
		ldi temp,$00
		out admux,temp		;zewntrzne Vref, kana0=ADC0(PC0)
		sbi adcsr,aden		;wcz przetwornik
		sbi adcsr,adsc		;rozpocznij pierwsz konwersj
	adc_wait:
		sbic adcsr,adsc		;czekaj na zakoczenie 
		rjmp adc_wait		;konwersji
		ret	
;------------------------------------------------------------------------
;-	Wybr kanau przetwornika AC
;------------------------------------------------------------------------
channel_0:
		in temp,admux		;zaaduj rejestr admux
		andi temp,$f0		;zeruj modsz powk bajtu (kana=0)
		out admux,temp		;zachowaj zmiany do admux
		ret
channel_1:
		in temp,admux
		andi temp,$f0		;zeruj modsz powk bajtu
		ori temp,$01		;dodaj logicznie '1' (kana=1)
		out admux,temp
		ret
channel_2:
		in temp,admux
		andi temp,$f0		;zeruj modsz powk bajtu
		ori temp,$02		;dodaj logicznie '2' (kana=2)
		out admux,temp
		ret
channel_3:
		in temp,admux
		andi temp,$f0		;zeruj modsz powk bajtu
		ori temp,$03		;dodaj logicznie '3' (kana=3)
		out admux,temp
		ret
channel_4:
		in temp,admux
		andi temp,$f0		;zeruj modsz powk bajtu
		ori temp,$04		;dodaj logicznie '4' (kana=4)
		out admux,temp
		ret
;------------------------------------------------------------------------
;-	Odczyt temperatury z DS18B20
;------------------------------------------------------------------------
ds18b20_temp:
		rcall reset_1wire
		cpi dana,$ff
		brne no_ds

		ldi dana,$cc		;skip rom
		rcall write_byte

		ldi dana,$44		;convert temp.
		rcall write_byte
		ldi temp,255
	wt_tmp:
		rcall read_bit
		cpi dana,0
		breq wt_tmp

		rcall reset_1wire
		cpi dana,$ff
		brne no_ds

		ldi dana,$cc		;skip rom
		rcall write_byte
		ldi dana,$4e		;write scratchpad
		rcall write_byte
		ldi dana,0
		rcall write_byte	;Tx to Th
		ldi dana,0
		rcall write_byte	;Tx to Tl
		ldi dana,$00
		rcall write_byte	;Tx to config. byte = set 9bit resolution

		rcall reset_1wire
		cpi dana,$ff
		brne no_ds

		ldi dana,$cc		;skip rom
		rcall write_byte

		ldi dana,$be		;read scratchpad
		rcall write_byte

		rcall read_byte
		mov bin_al,dana	;read LS byte

		rcall read_byte	;read MS byte
		mov bin_ah,dana

		sbrs bin_ah,7		;czy wynik pomiaru ujemny?
		rjmp no_minus		;jeli tak to
		com bin_ah		;zaneguj wszystkie bity
		com bin_al
		adiw bin_ah:bin_al,1	;i dodaj 1 (z U2 na NKB)
		ori bin_ah,$08		;ustaw bit oznaczajcy minus
	no_minus:
		lsr bin_al		;odpowiednia korekta
		lsr bin_al
		lsr bin_al
		lsr bin_al		;formatu

		lsl bin_ah
		lsl bin_ah
		lsl bin_ah
		lsl bin_ah

		or bin_al,bin_ah	;cakowita cz pomiaru = ds_temp
		sts ds_temp,bin_al
		ret
	ds_time_out:	
	no_ds:
		ret
;------------------------------------------------------------------------
;	Zapis do pamici EEPROM
;------------------------------------------------------------------------
write_to_eeprom:
		clr zh
		out eearh,zh
		ldi zl,$6b		;=adres difvol_l
		
		ldi temp,10		;ustaw pocztkowy adres zapisu do eeprom

	ee0wt:	sbic eecr,eewe
		rjmp ee0wt
		out eearl,temp	
		ld dana,z+
		out eedr,dana		;przygotuj dan do zapisu
		sbi eecr,eemwe		;przygotuj eeprom do zapisu
		sbi eecr,eewe		;zapisz dan "calibr" pod adres = temp
		inc temp
		cpi temp,22
		brne ee0wt
		ret
byte_to_eeprom:
		clr zh
		out eearh,zh
	bte:
		sbic eecr,eewe
		rjmp bte
		out eearl,temp
		out eedr,dana
		sbi eecr,eemwe		;przygotuj eeprom do zapisu
		sbi eecr,eewe		;zapisz dan "calibr" pod adres = temp
		ret
;------------------------------------------------------------------------
;	Odczyt z pamici EEPROM
;------------------------------------------------------------------------
read_from_eeprom:
		clr zh
		out eearh,zh
		ldi zl,$6b		;=adres difvol_l

		ldi temp,10

	ee1wt:	sbic eecr,eewe
		rjmp ee1wt
		out eearl,temp	
		sbi eecr,eere		;odczytaj eeprom

		in dana,eedr
		st z+,dana

		inc temp		;zwiksz adres odczytu z eeprom
		cpi temp,24
		brne ee1wt
		lds temp,hyst_t
		cpi temp,$ff		;pierwsze uruchomienie daje
		brne no_fstart		;odczyty = ff wic 
		rcall set_value	;wyzeruj komrki
	no_fstart:
		lds temp,flag_2
		andi temp,0b00000010	;tylko bit 1 jest wany (ON/OFF dla 
		sts flag_2,temp		;ograniczenia prdowego)
		ret
;------------------------------------------------------------------------
;-	Zerowanie komrek dla pierwszego uruchomienia
;------------------------------------------------------------------------
set_value:
		ldi temp,$28  
		sts flag_0,temp
		clr temp 
		sts vol_l,temp
		sts vol_h,temp
		sts flag_2,temp
		sts difvol_l,temp
		sts difvol_h,temp
		sts hyst_vl,temp
		sts hyst_vh,temp
		sts therm,temp
		sts hyst_t,temp
		sts current_l,temp
		sts current_h,temp
		sts hyst_cl,temp
		sts hyst_ch,temp
		sts offset_l,temp
		sts offset_h,temp
		sts vola_h,temp
		sts vola_l,temp
		sts volb_h,temp
		sts volb_l,temp
		sts cur_h,temp
		sts cur_l,temp
		sts vol_ah,temp
		sts vol_al,temp
		sts vol_bh,temp
		sts vol_bl,temp
		sts ds_temp,temp
		clr dana
		ldi temp,22		;zapisz zerowy bd offsetu ADC
		rcall byte_to_eeprom	;do eeprom
		ldi temp,23
		rcall byte_to_eeprom
		clr bin_al
		clr bin_ah
		ret
;------------------------------------------------------------------------
;-	Porwnanie prdu z wartocia zadan
;------------------------------------------------------------------------
current_compare:
		lds temp,flag_0	;aduj bajt-znacznik 0
		sbrs temp,7		;jeli ograniczenie prdowe wyczone
		rjmp no_chon		;(bit7=0) to nie porwnuj prdu

		lds bin_ah,current_h	;aduj komrki z SRAM
		lds bin_al,current_l	;do rejestrw
		lds bin_bh,cur_h
		lds bin_bl,cur_l

		cp bin_bl,bin_al
		cpc bin_bh,bin_ah
		brlo no_ceq
		lds temp,flag_1	;jeli nastpio zrwnanie prdw
		andi temp,0b11011111	;to ustaw odpowiedni znacznik
		sts flag_1,temp
		cbi portb,iout		;oraz iout w stanie niskim
		ret
	no_ceq:
		lds bin_ah,hyst_ch
		lds bin_al,hyst_cl
		cp bin_bl,bin_al
		cpc bin_bh,bin_ah
		brsh no_cheq		;jeli napicie spado poniej
	no_chon:			;histerezy to ustaw
		sbi portb,iout		;iout w stanie wysokim
		lds temp,flag_1
		ori temp,0b00100000	;oraz znacznik CO
		sts flag_1,temp
	no_cheq:
	
		ret
;------------------------------------------------------------------------