
; CC5X Version 3.1F, Copyright (c) B Knudsen Data
; C compiler for the PICmicro family
; ************   4. Nov 2003  14:33  *************

	processor  16F84A
	radix  DEC

INDF        EQU   0x00
TMR0        EQU   0x01
PCL         EQU   0x02
STATUS      EQU   0x03
FSR         EQU   0x04
PORTA       EQU   0x05
TRISA       EQU   0x85
PORTB       EQU   0x06
TRISB       EQU   0x86
PCLATH      EQU   0x0A
INTCON      EQU   0x0B
INTEDG      EQU   6
Carry       EQU   0
Zero_       EQU   2
RP0         EQU   5
INTF        EQU   1
T0IF        EQU   2
RTIF        EQU   2
INTE        EQU   4
GIE         EQU   7
OPTION_REG  EQU   0x81
EEDATA      EQU   0x08
EEADR       EQU   0x09
EECON2      EQU   0x89
RD          EQU   0
WR          EQU   1
WREN        EQU   2
EEIF        EQU   4
Blend_Time  EQU   0x0C
Snooze_Time EQU   0x0D
DCF_Mode    EQU   0x0E
Auto_Date   EQU   0x0F
AL_Hour     EQU   0x10
AL_Minute   EQU   0x11
Counter_Set_a EQU   0x12
Counter_Set_b EQU   0x13
Counter_Set_c EQU   0x14
Loop_a_Corr EQU   0x15
Loop_b_Corr EQU   0x16
Year        EQU   0x17
Month       EQU   0x18
Day         EQU   0x19
Key_Bits1   EQU   0x1C
Key_Bits2   EQU   0x1E
Hour        EQU   0x20
Minute      EQU   0x21
Second      EQU   0x22
Old_Hour    EQU   0x23
Old_Minute  EQU   0x24
Old_Second  EQU   0x25
DCF_Hour    EQU   0x26
DCF_Minute  EQU   0x27
DCF_Second  EQU   0x28
DCF_Year    EQU   0x29
DCF_Month   EQU   0x2A
DCF_Day     EQU   0x2B
Snooze_Remain EQU   0x2C
DCF_BITS    EQU   0x2D
Unsynced    EQU   0x2E
Day_Test    EQU   0x2F
Status_Bits EQU   0x30
Counter_a   EQU   0x33
Counter_b   EQU   0x34
Counter_c   EQU   0x35
Display_Num EQU   0x36
cc          EQU   0x37
ca          EQU   0x38
cb          EQU   0x39
cf          EQU   0x3C
cg          EQU   0x3D
Key_1       EQU   1
Key_2       EQU   2
Key_3       EQU   3
Key_4       EQU   1
Key_5       EQU   2
Key_6       EQU   3
Key_7       EQU   1
Key_8       EQU   2
Key_9       EQU   3
DCF_PBIT    EQU   0
Second_Sync EQU   0
DCF_Sync    EQU   1
DCF_OK      EQU   2
Scan_Keys   EQU   1
Last_DCF_OK EQU   2
Had_DCF     EQU   3
DCF_Bit     EQU   6
Has_DCF_Bit EQU   7
Last_IO     EQU   0
Alarm_On    EQU   1
Alarm_Active EQU   2
Alarm_Changed EQU   3
Count_Reached EQU   6
Enable_Blend EQU   7
Toggle_Bit  EQU   0
in          EQU   0
AL          EQU   0
IO          EQU   1
a           EQU   0x3F
b           EQU   0x40
s1          EQU   0x49
s2          EQU   0x4A
BCD         EQU   0x4B
cx          EQU   0x41
cy          EQU   0x42
what        EQU   0x4B
cx_2        EQU   0x43
what_2      EQU   0x4B
col         EQU   0x44
oldport     EQU   0x45
real_col    EQU   0x46
s           EQU   0x47
s_2         EQU   0x48

	GOTO main

  ; FILE C:\PICSTUFF\NIXIE.C
			;/*
			; * simple nixie clock - control program for pic 16f84a
			; * (c) 2003 ch. klippel  -  ck@mamalala.de
			; *
			; * this implements a clock using nixie tubes. the clock can be free
			; * running or synchronized to a dcf time telegram.
			; * additionally, it implements an alarm function and a counter mode
			; * to count signals on the io pin.
			; *
			; * version 1.4
			; *
			; * changelog:
			; *
			; * v1.5: - modified the resync timing
			; *         it now has two stages: if we had no valid time telegram so far,
			; *         the resync will be tried every 4 seconds (if there is a signal
			; *         detected at the dcf input). once a valid time was received, the resync
			; *         will only happen every 4 minutes for the remaining of that hour.
			; *         the reason for that is, with very noisy signals and thus permanent
			; *         sync attempts, the clock's free running time gets skewed because
			; *         of the internal timer-resync. usually that is only a fraction of a second,
			; *         but done repeatedly causes a big shift.
			; *	   it didnt affect the clock when no signal is at the dcf input, but it was
			; *         annoying in situations with really noisy signal reception, like at my place.
			; *
			; * v1.4: - slight change to the timer correction.
			; *         now, when the correction values are set to 50 in the clock setup,
			; *         after the timer is ready to count again its value is where it would
			; *	   be when no timer was written. this is because we need certain instructions
			; *	   to reach the point where the timer is adjusted. writing to the timer,
			; *	   when the :2 prescaler is used, lets stay the counter at the written
			; *	   value for 6 instructions, including the writing instruction.
			; *	   to be in sync with the internal timer increment, the write must fall
			; *	   into the beginning of the timer increment (see the microchip docs)
			; *	   this makes the whole adjustment stuff better calculatable.	
			; *
			; * v1.3: - not really bugfixes. instead saved some codewords, before it
			; *         used 1020, now only 1008. this is because some code movement
			; *	   to avoid redundant checks, and then because we "clear" the used
			; *         variables with the pre-programmed ee-prom contens. since we read
			; *         it anyways, this saves to implement the clearRAM() stuff...
			; *         its good to have some codewords left free in case some bug appears
			; *         and needs some to fix it ....
			; *         also, the clock parameters are now prefilled with something 
			; *         meaningfull.
			; *         the only real change in functionality is that the free-running time 
			; *         update is now completely moved into the interrupt routine.
			; *
			; * v1.2: - time skew correction of loop a and b can now adjusted in the
			; *	   basic setup
			; *       - added second page to basic setup
			; *	 - values in basic setup can now be cleared with Key_4
			; *       - Key_6 in basic setup moves to second page, from there Key_8 exits
			; *	 - improved eeprom load/store mechanism
			; *
			; * v1.1: - fixed a bug in key handling that prevented the counter alarm
			; *         from beeing displayed correctly
			; *       - modifyed key scanning. now uses more ram but less codewords.
			; *       - improved dcf reception stability, 3 levels of checking selectable
			; *       - length of auto-date display can now be set in 5 second steps 
			; *       - the new parameters are saved to the internal eeprom also
			; *	 - fixed some typos in the source code comentary
			; *
			; * v1.0: - initial release
			; *
			; * this code is released under the terms of the gpl, version 2 or newer.
			; * see the file COPYING for more information about the license.
			; *
			; * compiler used is the cc5x from b. knudsen data.
			; * if you dont have that compiler, dont worry. it has generated an
			; * assembly file also, which should be included in the package you have
			; * downloaded.
			; *
			; * the code is written for use with a 10.240 mhz oscillator.
			; * this gives 2.560 mhz prescaler :2 input, 1.280 mhz tmr0 rate
			; * tmr0 irq each 256 tmr0 steps = 5.000 khz irq-rate
			; * each time the irq is called "a" is increased. if it reaches 125, "b" is
			; * increased and "a" reset to zero. if b reaches 40, it is set to zero and 
			; * one second passed. one increment of a equals to 0.200 ms, thus one 
			; * increment of b equals to 25 ms.
			; * after the start of a second, if b = 6 we can check for the dcf bit. 
			; * if dcf-in is 1, the dcf-bit is 0, otherwise it is 1
			; *
			; * (in other words we could say that the internal secon-clock is a 40th of
			; *  a 125th of a 256th of the half of the quarter crystal frequency ;-)
			; *
			; * after startup, we wait 4 seconds, after which we enable the irq for
			; * pin rb0. if that pin changes from high to low, there is probably the start
			; * of a dcf pulsed second and we sync the timer to it.
			; * after that we wait for the missing 59th pulse to sync with the start of
			; * a dcf time telegram. if this mark is found, we process each incomming
			; * bit and set the current second to 59. from now on each dcf bit is
			; * processed, and with the start of the 20th bit we start to decode the
			; * time telegram.
			; *
			; * if for any reason the input rb0 is high after b=2, something went wrong
			; * with the signal reception, and all sync bits are cleared.
			; * each 4 seconds the sync procedure repeats until a sync can be established.
			; * the internal clock the runs with oscillator accuracy.
			; * the received time telegram is checked with the contained parity bits,
			; * and if all is ok, the time and date is updated at the following second 0.
			; */
			;
			;/* define chiptype */
			;
			;#pragma chip PIC16F84A
			;
			;/* turn on compiler optimizations */
			;
			;#pragma optimize=1

  ; FILE C:\PICSTUFF\NIXIE.C
			;
			;/* set chip configuration : xt oscillator, power up timer on, watchdog off */
			;
			;#pragma config |= 0x3FF1
			;
			;/* preset the data eeprom for a usable clock setup, also inits all variables ;-) */
			;
			;#pragma cdata[0x2100] = 60, 15,  0,  0,  6, 45,  0,  0,  0, 50, 50,  3, 11,  3,  0,  0
			;#pragma cdata[0x2110] =  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3, 11,  3,  0
			;#pragma cdata[0x2120] =  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
			;#pragma cdata[0x2130] =  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
			;
			;
			;/* include stuff for interrupt handling */
			;
			;#include "int16CXX.h"
			;
			;/* variables that are read/written from/to the eeprom */
			;
			;static char EE_Array[11]   	@ 0x0C;
			;static char Blend_Time	   	@ EE_Array[0];
			;static char Snooze_Time    	@ EE_Array[1];				/* configures blend- and snooze-time */
			;static char DCF_Mode	   	@ EE_Array[2];				/* level of dcf signal checking. 0=minimal, 1=extended, 2=paranoid */
			;static char Auto_Date	   	@ EE_Array[3];				/* seconds to display the date before a new minute */
			;static char AL_Hour	   	@ EE_Array[4];				/* alarm time */
			;static char AL_Minute	  	@ EE_Array[5];				
			;static char Counter_Set_a  	@ EE_Array[6];				/* trigger counter Alarm_On at these values */
			;static char Counter_Set_b  	@ EE_Array[7];
			;static char Counter_Set_c  	@ EE_Array[8];
			;static char Loop_a_Corr	   	@ EE_Array[9];
			;static char Loop_b_Corr	   	@ EE_Array[10];				
			;
			;/* global variables */
			;
			;static char Year		@ 0x17;
			;static char Month		@ 0x18;
			;static char Day			@ 0x19;			/* actual time and date */
			;static char Key_Bits[6]    	@ 0x1A;			/* this wastes 3 bytes, but we have enough... */
			;static char Key_Bits1      	@ Key_Bits[2];					/* each key row now has it own byte to simplify handling */
			;static char Key_Bits2     	@ Key_Bits[4];
			;static char Key_Bits3     	@ Key_Bits[1];
			;static char Hour		@ 0x20;
			;static char Minute		@ 0x21;
			;static char Second		@ 0x22;
			;static char Old_Hour		@ 0x23;
			;static char Old_Minute		@ 0x24;
			;static char Old_Second		@ 0x25;			/* old date _or_ values to display when not showing the time */
			;static char DCF_Hour		@ 0x26;
			;static char DCF_Minute		@ 0x27;
			;static char DCF_Second		@ 0x28;
			;static char DCF_Year		@ 0x29;
			;static char DCF_Month		@ 0x2A;
			;static char DCF_Day 		@ 0x2B;			/* received dcf time, all in bcd except the second */
			;static char Snooze_Remain	@ 0x2C;			/* how many snooze time left ? */
			;static char DCF_BITS		@ 0x2D;			/* number of even bits of current dcf part */
			;static char Unsynced		@ 0x2E;			/* seconds without sync */
			;static char Day_Test		@ 0x2F;					/* for calendaring */
			;static char Status_Bits		@ 0x30;
			;static char More_Bits		@ 0x31;		/* more status bits */
			;static char More_Bits2		@ 0x32;
			;static char Counter_a		@ 0x33;
			;static char Counter_b		@ 0x34;
			;static char Counter_c		@ 0x35;		/* actual counter values */
			;static char Display_Num		@ 0x36;
			;static char cc			@ 0x37; 	/* temporary variables */
			;static char ca			@ 0x38;
			;static char cb			@ 0x39;
			;static char cd			@ 0x3A;
			;static char ce			@ 0x3B;
			;static char cf			@ 0x3C;
			;static char cg			@ 0x3D;			/* temporary variables */
			;
			;/* specific bits from the variables above */
			;
			;static bit Key_1           	@ Key_Bits1.1;
			;static bit Key_2           	@ Key_Bits1.2;
			;static bit Key_3           	@ Key_Bits1.3;
			;static bit Key_4          	@ Key_Bits2.1;
			;static bit Key_5          	@ Key_Bits2.2;
			;static bit Key_6          	@ Key_Bits2.3;
			;static bit Key_7         	@ Key_Bits3.1;
			;static bit Key_8         	@ Key_Bits3.2;
			;static bit Key_9        	@ Key_Bits3.3;		
			;static bit DCF_PBIT 		@ DCF_BITS.0;		/* to check the parity of the time telegram */
			;static bit Second_Sync		@ Status_Bits.0;		/* 1 = sync to dcf second pulse,   0 = out of sync */
			;static bit DCF_Sync 		@ Status_Bits.1;		/* 1 = in sync with dcf telegram,  0 = out of sync */
			;static bit DCF_OK 		@ Status_Bits.2;		/* 1 = time telegram valid so far, 0 = error */
			;static bit Scan_Keys 		@ More_Bits.1;		/* time to check the keys for autorepeat */
			;static bit Last_DCF_OK 		@ More_Bits.2;		/* indicates if the last dcf datagram was ok or not */
			;static bit Had_DCF		@ More_Bits.3;
			;static bit DCF_Bit 		@ More_Bits.6;		/* currently received dcf bit */
			;static bit Has_DCF_Bit 		@ More_Bits.7;		/* flags the arrival of a new dcf bit */
			;static bit Last_IO 	  	@ More_Bits2.0;		/* last state of the counter input pin */
			;static bit Alarm_On 	  	@ More_Bits2.1;		/* is the alarm time reached ? */
			;static bit Alarm_Active  	@ More_Bits2.2;
			;static bit Alarm_Changed 	@ More_Bits2.3;		/* indicates that the alarm time has changed */
			;static bit Test_Bit 	  	@ More_Bits2.5;		/* for general testing */
			;static bit Count_Reached 	@ More_Bits2.6;		/* is the programmed counter value reached ? */
			;static bit Enable_Blend  	@ More_Bits2.7;		/* blend between old and new numbers or not */
			;static bit Toggle_Bit 	  	@ cg.0;			/* to half the rate of the blend time by two */
			;
			;/* assign names to port pins */
			;
			;bit in  @ PORTB.0;	/* dcf input, open collector, logic 1 = 0v, logic 0 = +5v (via pullup) */
			;bit in1 @ PORTB.1;	/* in1 - in3 are the input pins for the keyboard */
			;bit in2 @ PORTB.2;
			;bit in3 @ PORTB.3;
			;bit AL  @ PORTA.0;	/* alarm output */
			;bit IO  @ PORTA.1;	/* io-pin, used for counter input */
			;
			;void Check_Parity   ( void );	/* calculate the parity of the dcf datagram */
			;void Process_DCF_Bit( void );	/* process the actual dcf-bit, if any */
			;void Update_Display ( void );	/* update the nixie display and read in the keys */
			;void Check_Counter(void);
			;void Advance_Day(void);
			;char BCD_2_Dec( char BCD );
			;
			;#pragma origin 4	/* start of the irq vector */
	ORG 0x0004
			;interrupt ISR(void)	/* interrupt service routine */
			;{
ISR
			;  static char a @ 0x3F, b @ 0x40;	/* internal counters, if a = 125 and b = 40 then one second passed */
			;  int_save_registers    /* save working registers */
	MOVWF s1
	SWAPF STATUS,W
	MOVWF s2
			;
			;  if ( T0IF )		/* timer interrupt occured */
	BCF   0x03,RP0
	BTFSS 0x0B,T0IF
	GOTO  m019
			;  {
			;    a++;		/* increase the "a" counter */
	INCF  a,1
			;
			;    if(a>124)				/* 125 counts done ? (0 to 124 = 125 steps = 25 ms) */
	MOVLW .125
	SUBWF a,W
	BTFSS 0x03,Carry
	GOTO  m012
			;    {					/* if so .... */
			;      nop();	        		/* to sync the timer adjust to its internal stepping */
	NOP  
			;      TMR0 = Loop_a_Corr + 216; 	/* when corr = 50, this means "no change" (see microchip datasheets) */
	MOVLW .216
	ADDWF Loop_a_Corr,W
	MOVWF TMR0
			;
			;      a = 0;		/* clear counter a */
	CLRF  a
			;      b++;		/* and increase counter b */
	INCF  b,1
			;      
			;      if (b == 2 && in && Second_Sync) 	/* shortly after a second started, there must be the dcf bit */
	MOVF  b,W
	XORLW .2
	BTFSS 0x03,Zero_
	GOTO  m004
	BTFSS 0x06,in
	GOTO  m004
	BTFSS 0x30,Second_Sync
	GOTO  m004
			;      {					/* if it is _not_ there, and we are in sync with the dcf second pulse */
			;        if ( DCF_Second != 59)		/* ... check for the missing 59th second (datagram start/end mark) */
	MOVF  DCF_Second,W
	XORLW .59
	BTFSC 0x03,Zero_
	GOTO  m003
			;        {				/* if it is not .... */
			;          if(DCF_Sync)			/* but we had synced to the dcf datagram before .... */
	BTFSS 0x30,DCF_Sync
	GOTO  m001
			;	  {
			;	    Second_Sync = 0;		/* ... then reset the sync flags, because we are out of sync */
	BCF   0x30,Second_Sync
			;	    DCF_Sync = 0;
	BCF   0x30,DCF_Sync
			;	  }
			;	  else				/* but if had no dcf datagram sync before .... */
	GOTO  m002
			;	    DCF_Second = 59;		/* ... then we just found it ;-) */
m001	MOVLW .59
	MOVWF DCF_Second
			;          DCF_OK = 0;			/* reset the dcf datagram status, because if we are here, we need to */
m002	BCF   0x30,DCF_OK
			;        }
			;
			;        if ( DCF_Second == 59)		/* and when we found the 59th second */
m003	MOVF  DCF_Second,W
	XORLW .59
	BTFSC 0x03,Zero_
			;           DCF_Sync = 1;		/* .... we set the status to in-sync */
	BSF   0x30,DCF_Sync
			;      }
			;     
			;      if (b == 6)			/* a bit more later, the state of the input is the actual dcf-bit */
m004	MOVF  b,W
	XORLW .6
	BTFSS 0x03,Zero_
	GOTO  m005
			;        DCF_Bit = !in;			/* but inverted, so we invert it here */
	BSF   0x31,DCF_Bit
	BTFSC 0x06,in
	BCF   0x31,DCF_Bit
			;
			;
			;      if(!(b & 0b.0000.0111))		/* after 200 ms .... */
m005	MOVLW .7
	ANDWF b,W
	BTFSC 0x03,Zero_
			;        Scan_Keys = 1;			/* flag for scanning the keys */
	BSF   0x31,Scan_Keys
			;
			;      if (b == 40)			/* has the b counter reached 40, i.e. one second is over ? */
	MOVF  b,W
	XORLW .40
	BTFSS 0x03,Zero_
	GOTO  m012
			;      {
			;        TMR0 = Loop_b_Corr + 228;       /* again, this means no adjust when corr = 50 */
	MOVLW .228
	ADDWF Loop_b_Corr,W
	MOVWF TMR0
			;				
			;        b = 0;				/* reset the b counter */
	CLRF  b
			;
			;        if(Second_Sync)			/* are we in sync with the dcf second pulse ? */
	BTFSS 0x30,Second_Sync
	GOTO  m006
			;          Has_DCF_Bit = 1;		/* if so, flag it */
	BSF   0x31,Has_DCF_Bit
			;        else
	GOTO  m007
			;          if (!Unsynced.2 && !Had_DCF)		/* if we are not in sync with the dcf second pulse */
m006	BTFSC Unsynced,2
	GOTO  m007
	BTFSS 0x31,Had_DCF
			;            Unsynced++;			/* increse the unsynced counter */
	INCF  Unsynced,1
			;
			;        if(Enable_Blend)
m007	BTFSS 0x32,Enable_Blend
	GOTO  m008
			;          Old_Second = Second;		/* save the old second */
	MOVF  Second,W
	MOVWF Old_Second
			;        cb = 0;				/* restart the blend-counter */
m008	CLRF  cb
			;
			;        Second++;			/* and increase the actual second */
	INCF  Second,1
			;        if (Second > 59)				/* after 60 seconds .... */
	MOVLW .60
	SUBWF Second,W
	BTFSS 0x03,Carry
	GOTO  m009
			;        {
			;          Second = 0;				/* ... set to second 0 .... */
	CLRF  Second
			;          Minute++;					/* ... and add a minute */
	INCF  Minute,1
			;
			;          if(Snooze_Remain != 0)			/* is snooze active ? (that is, alarm-pause */
	MOVF  Snooze_Remain,1
	BTFSS 0x03,Zero_
			;            Snooze_Remain--;			/* if we snooze, one minute less is left to snooze */
	DECF  Snooze_Remain,1
			;
			;          if (!Unsynced.2 && Had_DCF)		/* if we are not in sync with the dcf second pulse */
	BTFSC Unsynced,2
	GOTO  m009
	BTFSC 0x31,Had_DCF
			;            Unsynced++;			/* increse the unsynced counter */
	INCF  Unsynced,1
			;        }
			;
			;        if (Minute > 59)				/* and after 60 minutes .... */
m009	MOVLW .60
	SUBWF Minute,W
	BTFSS 0x03,Carry
	GOTO  m010
			;        {
			;          Minute  = 0;				/* ... the minute will be 0 .... */
	CLRF  Minute
			;          Had_DCF = 0;
	BCF   0x31,Had_DCF
			;          Hour++;					/* ... and a new hour started .... */
	INCF  Hour,1
			;        }
			;      
			;        if (Hour > 23)				/* the 25'th hour ....*/
m010	MOVLW .24
	SUBWF Hour,W
	BTFSS 0x03,Carry
	GOTO  m011
			;        {
			;          Hour = 0;				/* ... doesnt exist, so it is 0 ... */
	CLRF  Hour
			;          Advance_Day();			/* but means we have a new day ... */
	CALL  Advance_Day
			;        }
			;
			;        if (!Status_Bits)	/* do we miss any dcf sync bits ? */
m011	MOVF  Status_Bits,1
	BTFSS 0x03,Zero_
	GOTO  m012
			;        {
			;          if (Unsynced.2)				/* if so, and at least 4 seconds passed without any sync ...*/
	BTFSS Unsynced,2
	GOTO  m012
			;          {
			;            Unsynced = 0;				/* reset unsync-counter */
	CLRF  Unsynced
			;            INTF = 0;				/* reset dcf-io irq flag */
	BCF   0x0B,INTF
			;            INTE = 1;				/* and enable the dcf-io irq. when that happens, it must */
	BSF   0x0B,INTE
			;   						/* be the start of a second */
			;          }
			;        }
			;      }
			;    }
			;
			;    if(Last_IO && !IO)			/* check if we had a high/low transition on the counter input */
m012	BTFSS 0x32,Last_IO
	GOTO  m013
	BTFSC 0x05,IO
	GOTO  m013
			;    {
			;      Counter_a++;			/* if so, increase the 10's and ones of the counter */
	INCF  Counter_a,1
			;      Check_Counter();                  /* check the counter for overflows */
	CALL  Check_Counter
			;      Last_IO = 0;			/* this pulse is done, so clear its flag */
	BCF   0x32,Last_IO
			;
			;      					/* now lets check if the counter reached the programmed */
			;					/* value */
			;      if(Counter_a == Counter_Set_a && Counter_b == Counter_Set_b && Counter_c == Counter_Set_c )
	MOVF  Counter_a,W
	XORWF Counter_Set_a,W
	BTFSS 0x03,Zero_
	GOTO  m013
	MOVF  Counter_b,W
	XORWF Counter_Set_b,W
	BTFSS 0x03,Zero_
	GOTO  m013
	MOVF  Counter_c,W
	XORWF Counter_Set_c,W
	BTFSC 0x03,Zero_
			;        Count_Reached = 1;		/* ....and if we reched the count, flag it */
	BSF   0x32,Count_Reached
			;    }
			;
			;    Last_IO = IO;			/* remember the actual state of the io pin */ 
m013	BCF   0x32,Last_IO
	BTFSC 0x05,IO
	BSF   0x32,Last_IO
			;
			;    if (b > 8 && !in && DCF_Second != 59)	/* if the dcf input not as it should be at this time .... */
	MOVLW .9
	SUBWF b,W
	BTFSS 0x03,Carry
	GOTO  m015
	BTFSC 0x06,in
	GOTO  m015
	MOVF  DCF_Second,W
	XORLW .59
	BTFSC 0x03,Zero_
	GOTO  m015
			;    {
			;      if (DCF_Mode.1)				/* ... and we do paranoid cheking every 0.2 ms ... */
	BTFSC DCF_Mode,1
			;        goto resetdcf;				/* reset the dcf state */
	GOTO  m014
			;      
			;      if(!a && DCF_Mode.0)			/* ... or extended checking every 25 ms ... */
	MOVF  a,1
	BTFSS 0x03,Zero_
	GOTO  m015
	BTFSS DCF_Mode,0
	GOTO  m015
			;        goto resetdcf;				/* reset the dcf state */
			;      
			;      goto donecheck;				/* but if the signal seems ok, continue */
			;
			;      resetdcf:					/* reset the dcf flags */
			;      Status_Bits = 0;
m014	CLRF  Status_Bits
			;   
			;      donecheck:
			;    }   
			;
			;    if(Alarm_Active || Count_Reached)
m015	BTFSC 0x32,Alarm_Active
	GOTO  m016
	BTFSS 0x32,Count_Reached
	GOTO  m017
			;      AL = 1;
m016	BSF   0x05,AL
			;    else
	GOTO  m018
			;      AL = 0;
m017	BCF   0x05,AL
			;
			;    while(TMR0 > 216) 			/* sanity check if the timer adjust was to heavy */
m018	MOVLW .217
	SUBWF TMR0,W
	BTFSC 0x03,Carry
			;      {}				/* this is to avoid a unwanted timer irq */
	GOTO  m018
			;
			;    RTIF = 0;  				/* reset the timer interrupt flag */
	BCF   0x0B,RTIF
			;  }
			;
			;  if( INTF )				/* check if we had a level change on the dcf input */
m019	BTFSS 0x0B,INTF
	GOTO  m020
			;  {
			;    if( INTE ) 				/* if so, and we expected it .... */
	BTFSS 0x0B,INTE
	GOTO  m020
			;    {
			;      INTF = 0;				/* clear the interrupt flag */
	BCF   0x0B,INTF
			;      INTE=0;				/* and disable this interrupt */
	BCF   0x0B,INTE
			;      Second_Sync = 1;			/* we suspect te reason for this irq a dcf second start */
	BSF   0x30,Second_Sync
			;      a = 0;				/* because of that we clear counter a */
	CLRF  a
			;      b = 0;				/* and counter b to sync the internal clock */
	CLRF  b
			;    }
			;  }
			;
			;  int_restore_registers			/* irq done, resore the working registers */
m020	SWAPF s2,W
	MOVWF STATUS
	SWAPF s1,1
	SWAPF s1,W
			;}
	RETFIE
			;
			;char BCD_2_Dec( char BCD )		/* convert a 8 bit bcd number to decimal */
			;{
BCD_2_Dec
	MOVWF BCD
			;   static char cx @ 0x41,cy @ 0x42;			/* temporary variables */
			;   cx = BCD & 0b.11110000;		/* get the bcd 10's of the bcd num */
	MOVLW .240
	ANDWF BCD,W
	MOVWF cx
			;   					/* the following code equals to : */
			;					/* make it bcd-ones and multiply by ten */
			;   cy = cx >> 1;			/* imaginary "one's * 8" */
	BCF   0x03,Carry
	RRF   cx,W
	MOVWF cy
			;   cx >>= 4;				/* 10's to ones */
	SWAPF cx,W
	ANDLW .15
	MOVWF cx
			;   cy += cx;				/* plus ones = one's * 9 */
	ADDWF cy,1
			;   cy += cx;				/* plus ones = one's * 10 */
	ADDWF cy,1
			;   return((BCD & 0b.00001111) + cy); 	/* return bcd 1's plus decimal 10's */
	MOVLW .15
	ANDWF BCD,W
	ADDWF cy,W
	RETURN
			;}
			;
			;void Save_Old_Time ( void )		/* remember the just passed time */
			;{
Save_Old_Time
			;  Old_Hour = Hour;			/* the hour .... */
	MOVF  Hour,W
	MOVWF Old_Hour
			;  Old_Minute = Minute;			/* .... the minute ... */
	MOVF  Minute,W
	MOVWF Old_Minute
			;  Old_Second = Second;			/* ... and finally the second */
	MOVF  Second,W
	MOVWF Old_Second
			;}
	RETURN
			;
			;void Advance_Day( void )		/* advance the date by one day, to keep it current when */
			;					/* there is no dcf reception */
			;{
Advance_Day
			;  Day++;				/* advance the current day */
	INCF  Day,1
			;  Day_Test = 32;			/* check for the 32st day, which means a new month is reached */
	MOVLW .32
	MOVWF Day_Test
			;
			;  if(Month == 4 || Month == 6 || Month == 9 || Month == 11) /* but first check if the actual month ... */
	MOVF  Month,W
	XORLW .4
	BTFSC 0x03,Zero_
	GOTO  m021
	MOVF  Month,W
	XORLW .6
	BTFSC 0x03,Zero_
	GOTO  m021
	MOVF  Month,W
	XORLW .9
	BTFSC 0x03,Zero_
	GOTO  m021
	MOVF  Month,W
	XORLW .11
	BTFSS 0x03,Zero_
	GOTO  m022
			;    Day_Test = 31;			/* only has 30 days, i.e. we have the 31th day */
m021	MOVLW .31
	MOVWF Day_Test
			;
			;  if(Month == 2)			/* but in februrary .... */
m022	MOVF  Month,W
	XORLW .2
	BTFSS 0x03,Zero_
	GOTO  m024
			;  {
			;    Day_Test = 30;			/* ... we have only 29 days, so if this is the 30th day .... */
	MOVLW .30
	MOVWF Day_Test
			;      if(Year.0 || Year.1)		/* ... except for the special 4th year ... */
	BTFSC Year,0
	GOTO  m023
	BTFSC Year,1
			;    Day_Test--;			/* ... which only has 28 days, so check for the 29th day reached */
m023	DECF  Day_Test,1
			;  }
			; 
			;  if(Day == Day_Test)		/* so, if we have reached the next month .... */
m024	MOVF  Day,W
	XORWF Day_Test,W
	BTFSS 0x03,Zero_
	GOTO  m025
			;  {
			;    Day = 1;			/* start the month at day 1 */
	MOVLW .1
	MOVWF Day
			;    Month++;			/* and advance the month */
	INCF  Month,1
			;  }
			;
			;  if(Month > 12)			/* but if we passed the december */
m025	MOVLW .13
	SUBWF Month,W
	BTFSS 0x03,Carry
	GOTO  m026
			;  {
			;    Month = 1;			/* ... it must be now the first month */
	MOVLW .1
	MOVWF Month
			;    Year++;			/* HAPPY NEW YEAR ! ;-) */
	INCF  Year,1
			;  }
			;
			;  if(Year > 99)
m026	MOVLW .100
	SUBWF Year,W
	BTFSC 0x03,Carry
			;    Year = 0;
	CLRF  Year
			;}
	RETURN
			;
			;void Write_EE(void)
			;{
Write_EE
			;  for(EEADR = 0; EEADR < 11; EEADR++)
	CLRF  EEADR
m027	MOVLW .11
	SUBWF EEADR,W
	BTFSC 0x03,Carry
	GOTO  m030
			;  {
			;    EEDATA = EE_Array[EEADR];
	MOVLW .12
	ADDWF EEADR,W
	MOVWF FSR
	MOVF  INDF,W
	MOVWF EEDATA
			;    GIE = 0;				/* first, disable irq's during the write */
	BCF   0x0B,GIE
			;    WREN = 1;				/* enable the eeprom-write */
	BSF   0x03,RP0
	BSF   0x88,WREN
			;    EECON2 = 0x55;			/* this is the sequence needed to write the eeprom */
	MOVLW .85
	MOVWF EECON2
			;    EECON2 = 0xaa;			/* see the microchip datasheet */
	MOVLW .170
	MOVWF EECON2
			;    WR = 1;				/* do the write */
	BSF   0x88,WR
			;    GIE = 1;				/* re-enable the irq's */
	BSF   0x0B,GIE
			;    EEIF = 0;				/* clear the ee-write done flag */
	BCF   0x88,EEIF
			;    while(!EEIF)			/* until the flag is set, the write is in progress, so wait */
m028	BSF   0x03,RP0
	BTFSC 0x88,EEIF
	GOTO  m029
			;      Update_Display();
	CALL  Update_Display
	GOTO  m028
			;  }
m029	BCF   0x03,RP0
	INCF  EEADR,1
	GOTO  m027
			;}
m030	RETURN
			;
			;void Read_EE(void)
			;{
Read_EE
			;  for(EEADR = 0; !EEADR.6; EEADR++)
	CLRF  EEADR
m031	BTFSC EEADR,6
	GOTO  m032
			;  {
			;    RD = 1;
	BSF   0x03,RP0
	BSF   0x88,RD
			;    EE_Array[EEADR] = EEDATA;
	MOVLW .12
	BCF   0x03,RP0
	ADDWF EEADR,W
	MOVWF FSR
	MOVF  EEDATA,W
	MOVWF INDF
			;  }
	INCF  EEADR,1
	GOTO  m031
			;
			;}
m032	RETURN
			;
			;void Check_Counter(void)		/* check the 3 counter variables for overflow and adjust them */
			;{
Check_Counter
			;  if(Counter_a > 99)			/* check if the counter 10's and ones overflowed */
	MOVLW .100
	SUBWF Counter_a,W
	BTFSS 0x03,Carry
	GOTO  m033
			;  {
			;    Counter_a = 0;			/* reset them if so */
	CLRF  Counter_a
			;    Counter_b++;				/* and advance the 100's and 1000's */
	INCF  Counter_b,1
			;  }
			;
			;  if(Counter_b > 99)			/* check if the 100's and 1000's overflowed */
m033	MOVLW .100
	SUBWF Counter_b,W
	BTFSS 0x03,Carry
	GOTO  m034
			;  {
			;    Counter_b = 0;			/* reset them if so */
	CLRF  Counter_b
			;    Counter_c++;				/* advance the 10000's and 100000's */
	INCF  Counter_c,1
			;  }
			;  
			;  if(Counter_c > 99)			/* check if the 10000's and 100000's overflowed */
m034	MOVLW .100
	SUBWF Counter_c,W
	BTFSC 0x03,Carry
			;    Counter_c = 0;			/* reset them, if so */
	CLRF  Counter_c
			;}
	RETURN
			;void main( void)			/* the big blob of code that does nothing magical .... */
			;{
main
			;restart:				/* location to start all that stuff */
			;
			;  TRISA = 0b.0000.0010;  		/* setup portb, 1 = input, 0 = output */
	MOVLW .2
	BSF   0x03,RP0
	MOVWF TRISA
			;  TRISB = 0b.0000.1111;  		/* setup portb, 1 = input, 0 = output */
	MOVLW .15
	MOVWF TRISB
			;  OPTION = 128; 		 	/* prescaler divide by 2  */
	MOVLW .128
	MOVWF OPTION_REG
			;  INTEDG = 0; 		 		/* rb0 interrupt on falling edge */
	BCF   0x81,INTEDG
			;  INTCON = 160;				/* enable the irq's we want */
	MOVLW .160
	MOVWF INTCON
			;  AL = 0;				/* we dont want the alarm on at startup */
	BCF   0x03,RP0
	BCF   0x05,AL
			;
			;  Read_EE();
	CALL  Read_EE
			;
			;Update_Display();
	CALL  Update_Display
			;  if(!Key_8)				/* if no setup-key (Key_1) is pressed at startup... */
	BTFSS 0x1B,Key_8
			;    goto start;				/* go to the main stuff */
	GOTO  m043
			;
			;basicsetup:
			;
			;  Enable_Blend = 0;					/* otherwise do the setup-loop */
m035	BCF   0x32,Enable_Blend
			;  Old_Hour = Auto_Date;
	MOVF  Auto_Date,W
	MOVWF Old_Hour
			;  Old_Minute = Blend_Time;
	MOVF  Blend_Time,W
	MOVWF Old_Minute
			;  Old_Second = Snooze_Time;
	MOVF  Snooze_Time,W
	MOVWF Old_Second
			;
			;  Update_Display();			/* and show the values */
	CALL  Update_Display
			;
			;  if(Scan_Keys)				/* time to scan for autorepeat ? */
	BTFSS 0x31,Scan_Keys
	GOTO  m039
			;  {
			;    if(Key_4)
	BTFSS 0x1E,Key_4
	GOTO  m036
			;    {
			;      Auto_Date = 0;
	CLRF  Auto_Date
			;      Blend_Time = 1;
	MOVLW .1
	MOVWF Blend_Time
			;      Snooze_Time = 1;
	MOVWF Snooze_Time
			;    }
			;
			;    Auto_Date += Key_1;			/* Key_1 adjusts automatic date display time in 5 sec steps */
m036	BTFSC 0x1C,Key_1
	INCF  Auto_Date,1
			;    Blend_Time += Key_2;		/* Key_2 adjust the blend time */
	BTFSC 0x1C,Key_2
	INCF  Blend_Time,1
			;    Snooze_Time += Key_3;		/* Key_3 sets the snooze time */
	BTFSC 0x1C,Key_3
	INCF  Snooze_Time,1
			;
			;    if(Auto_Date > 60)			/* auto-date time too high ? */
	MOVLW .61
	SUBWF Auto_Date,W
	BTFSC 0x03,Carry
			;      Auto_Date = 0;			/* then reset it */
	CLRF  Auto_Date
			;
			;    if(Blend_Time > 99)			/* blend time too high ? */
	MOVLW .100
	SUBWF Blend_Time,W
	BTFSS 0x03,Carry
	GOTO  m037
			;      Blend_Time = 1;			/* then restart blend time from 1 */
	MOVLW .1
	MOVWF Blend_Time
			;
			;    if(Snooze_Time > 99)		/* more than 99 minutes snooze time ? */
m037	MOVLW .100
	SUBWF Snooze_Time,W
	BTFSS 0x03,Carry
	GOTO  m038
			;      Snooze_Time = 1;			/* snooze only one minute */
	MOVLW .1
	MOVWF Snooze_Time
			;
			;    Scan_Keys = 0;			/* we are done with checking the keys */
m038	BCF   0x31,Scan_Keys
			;  }
			; 
			;if(!Key_6)
m039	BTFSS 0x1E,Key_6
			;  goto basicsetup;				/* but if dont exit the setup, redo it until its done */
	GOTO  m035
			;
			;basicsetup2:					/* otherwise do the setup-loop */
			;  Old_Hour = DCF_Mode;
m040	MOVF  DCF_Mode,W
	MOVWF Old_Hour
			;  Old_Minute = Loop_a_Corr;
	MOVF  Loop_a_Corr,W
	MOVWF Old_Minute
			;  Old_Second = Loop_b_Corr;
	MOVF  Loop_b_Corr,W
	MOVWF Old_Second
			;
			;  Update_Display();			/* and show the values */
	CALL  Update_Display
			;
			;  
			;  if(Key_4)
	BTFSS 0x1E,Key_4
	GOTO  m041
			;  {
			;    Loop_a_Corr = 0;
	CLRF  Loop_a_Corr
			;    Loop_b_Corr = 0;
	CLRF  Loop_b_Corr
			;  }
			;
			;  if(Scan_Keys)				/* time to scan for autorepeat ? */
m041	BTFSS 0x31,Scan_Keys
	GOTO  m042
			;  {
			;    DCF_Mode += Key_1;			/* Key_1 adjusts automatic date display time in 5 sec steps */
	BTFSC 0x1C,Key_1
	INCF  DCF_Mode,1
			;    Loop_a_Corr += Key_2;		/* Key_2 adjust the blend time */
	BTFSC 0x1C,Key_2
	INCF  Loop_a_Corr,1
			;    Loop_b_Corr += Key_3;		/* Key_3 sets the snooze time */
	BTFSC 0x1C,Key_3
	INCF  Loop_b_Corr,1
			;
			;    if(DCF_Mode > 2)			/* auto-date time too high ? */
	MOVLW .3
	SUBWF DCF_Mode,W
	BTFSC 0x03,Carry
			;      DCF_Mode = 0;			/* then reset it */
	CLRF  DCF_Mode
			;
			;    if(Loop_a_Corr > 99)			/* blend time too high ? */
	MOVLW .100
	SUBWF Loop_a_Corr,W
	BTFSC 0x03,Carry
			;      Loop_a_Corr = 0;			/* then restart blend time from 1 */
	CLRF  Loop_a_Corr
			;
			;    if(Loop_b_Corr > 99)		/* more than 99 minutes snooze time ? */
	MOVLW .100
	SUBWF Loop_b_Corr,W
	BTFSC 0x03,Carry
			;      Loop_b_Corr = 0;			/* snooze only one minute */
	CLRF  Loop_b_Corr
			;
			;    Scan_Keys = 0;			/* we are done with checking the keys */
	BCF   0x31,Scan_Keys
			;  }
			;
			;if(!Key_8)
m042	BTFSS 0x1B,Key_8
			;  goto basicsetup2;				/* but if dont exit the setup, redo it until its done */
	GOTO  m040
			;
			;  Write_EE();					/* save the setup to the eeprom */
	CALL  Write_EE
			;  Read_EE();
	CALL  Read_EE
			;
			;start:					/* here the real code starts */
			;
			;  while (1)				/* we never finish that big loop, for sure */
			;  {
			;
			;    if(Has_DCF_Bit)				/* do we have a fresh dcf bit ? */
m043	BTFSC 0x31,Has_DCF_Bit
			;      Process_DCF_Bit();			/* if we have, process it of course ... */
	CALL  Process_DCF_Bit
			;
			;    if (!DCF_Second)				/* if we have 60 seconds received by the dcf */
	MOVF  DCF_Second,1
	BTFSS 0x03,Zero_
	GOTO  m044
			;    {
			;      Last_DCF_OK = DCF_OK;			/* remember the current status of the dcf datagram */
	BCF   0x31,Last_DCF_OK
	BTFSC 0x30,DCF_OK
	BSF   0x31,Last_DCF_OK
			;
			;      if(Status_Bits == 7) 	/* and all is in sync ... */
	MOVF  Status_Bits,W
	XORLW .7
	BTFSS 0x03,Zero_
	GOTO  m044
			;      {
			;         Hour = BCD_2_Dec(DCF_Hour);		/* ... update the hour to the dcf hour */
	MOVF  DCF_Hour,W
	CALL  BCD_2_Dec
	MOVWF Hour
			;         Minute = BCD_2_Dec(DCF_Minute);	/* and the mite */
	MOVF  DCF_Minute,W
	CALL  BCD_2_Dec
	MOVWF Minute
			;         Second = DCF_Second;			/* not to forget the second */
	MOVF  DCF_Second,W
	MOVWF Second
			;         Year = BCD_2_Dec(DCF_Year);		/* but also the year */
	MOVF  DCF_Year,W
	CALL  BCD_2_Dec
	MOVWF Year
			;         Month = BCD_2_Dec(DCF_Month);	/* the month */
	MOVF  DCF_Month,W
	CALL  BCD_2_Dec
	MOVWF Month
			;         Day = BCD_2_Dec(DCF_Day);		/* day too */
	MOVF  DCF_Day,W
	CALL  BCD_2_Dec
	MOVWF Day
			;         Last_DCF_OK = 1;			/* and flag that the last datagram was ok */
	BSF   0x31,Last_DCF_OK
			;         Had_DCF = 1;
	BSF   0x31,Had_DCF
			;      }
			;    }
			;
			;    if (cb == Blend_Time)			/* are we finished with fading away the old numbers ? */
m044	MOVF  cb,W
	XORWF Blend_Time,W
	BTFSS 0x03,Zero_
	GOTO  m045
			;    {
			;      Save_Old_Time();				/* then make the old time the current one, which means */
	CALL  Save_Old_Time
			;      cb = 0;					/* to blend between the same numbers, and that is no blending at all ;-) */
	CLRF  cb
			;    }
			;
			;    if(Key_7)					/* is the alarm-switch turned on ? */
m045	BTFSS 0x1B,Key_7
	GOTO  m047
			;    {
			;      if(Key_Bits1 != 0)				/* and is the snooze-button pressed ? */
	MOVF  Key_Bits1,1
	BTFSC 0x03,Zero_
	GOTO  m046
			;        Snooze_Remain = Snooze_Time;		/* then set to the configured snooze time */
	MOVF  Snooze_Time,W
	MOVWF Snooze_Remain
			;      
			;    if(Hour == AL_Hour && Minute == AL_Minute) /* if we have reached the alarm time ... */
m046	MOVF  Hour,W
	XORWF AL_Hour,W
	BTFSS 0x03,Zero_
	GOTO  m047
	MOVF  Minute,W
	XORWF AL_Minute,W
	BTFSC 0x03,Zero_
			;      Alarm_On = 1;
	BSF   0x32,Alarm_On
			;
			;    }
			;
			;    if(!Key_7)
m047	BTFSS 0x1B,Key_7
			;      Alarm_On = 0;
	BCF   0x32,Alarm_On
			;
			;    if(!Snooze_Remain && Alarm_On)		/* if we have no snooze, but a flagged alarm */
	MOVF  Snooze_Remain,1
	BTFSS 0x03,Zero_
	GOTO  m048
	BTFSS 0x32,Alarm_On
	GOTO  m048
			;      Alarm_Active = 1;
	BSF   0x32,Alarm_Active
			;    else
	GOTO  m049
			;      Alarm_Active = 0;
m048	BCF   0x32,Alarm_Active
			;
			;    Enable_Blend = 1;				/* eneble blending of the numbers */
m049	BSF   0x32,Enable_Blend
			;
			;    if(Scan_Keys)				/* check if a autorepeat intervall has occured */
	BTFSS 0x31,Scan_Keys
	GOTO  m060
			;    {
			;      Scan_Keys = 0;				/* ... reset the autorepeat flag then ... */
	BCF   0x31,Scan_Keys
			;
			;      if(Key_8)					/* when it was Key_8, we can adjust the time */
	BTFSS 0x1B,Key_8
	GOTO  m051
			;      {
			;        if(Key_4) Hour++;				/* advance the hour if Key_4 is pressed */
	BTFSC 0x1E,Key_4
	INCF  Hour,1
			;        if(Key_5) Minute++;			/* advance the minute if Key_5 is pressed */
	BTFSC 0x1E,Key_5
	INCF  Minute,1
			;
			;	if(Key_6)				/* reset time with Key_6 */
	BTFSS 0x1E,Key_6
	GOTO  m050
			;	{
			;	  Hour = 0;
	CLRF  Hour
			;	  Minute = 0;
	CLRF  Minute
			;	  Second = 0;
	CLRF  Second
			;	}
			;
			;	if(Minute > 59)				/* check if the minute overflowed */
m050	MOVLW .60
	SUBWF Minute,W
	BTFSC 0x03,Carry
			;	  Minute = 0;				/* clear minute, if so .... */
	CLRF  Minute
			;
			;	if(Hour > 23)				/* check if the hour overflowed */
	MOVLW .24
	SUBWF Hour,W
	BTFSS 0x03,Carry
	GOTO  m071
			;	  Hour = 0;				/* ... and reset, if .... */
	CLRF  Hour
			;        goto nextkey8;
	GOTO  m071
			;      }
			;
			;      if(Key_9)					/* process keys when Key_9 is active (counter mode) */
m051	BTFSS 0x1B,Key_9
	GOTO  m053
			;      {
			;        if(Key_4) Counter_c ++;			/* advance the 10000's and 100000's if Key_6 is pressed */
	BTFSC 0x1E,Key_4
	INCF  Counter_c,1
			;        if(Key_5) Counter_b ++;			/* advance 100's and 1000's if Key_5 is pressed */
	BTFSC 0x1E,Key_5
	INCF  Counter_b,1
			;	if(Key_6) Counter_a ++;			/* advance 10's and ones if Key_4 is pressed */
	BTFSC 0x1E,Key_6
	INCF  Counter_a,1
			;	Check_Counter();			/* check for counter overflows and adjust if needed */
	CALL  Check_Counter
			;        
			;        if(Key_3)
	BTFSS 0x1C,Key_3
	GOTO  m061
			;        {
			;          Counter_Set_a = Counter_a;		/* store counter content as counter-alarm point */
	MOVF  Counter_a,W
	MOVWF Counter_Set_a
			;          Counter_Set_b = Counter_b;
	MOVF  Counter_b,W
	MOVWF Counter_Set_b
			;          Counter_Set_c = Counter_c;
	MOVF  Counter_c,W
	MOVWF Counter_Set_c
			;          Write_EE();
	CALL  Write_EE
			;          Enable_Blend = 0;
	BCF   0x32,Enable_Blend
			;          while(Key_3)
m052	BTFSS 0x1C,Key_3
	GOTO  m061
			;          {
			;            Old_Second = Counter_a;
	MOVF  Counter_a,W
	MOVWF Old_Second
			;            Update_Display();
	CALL  Update_Display
			;          }            
	GOTO  m052
			;        }
			;        goto nextkey9;
			;      }
			;
			;      if(Key_2)					/* check for Key_2, adjust alarm when pressed */
m053	BTFSS 0x1C,Key_2
	GOTO  m055
			;      {
			;        if(Key_4) AL_Hour++;			/* advance alarm hour if Key_4 is pressed */
	BTFSC 0x1E,Key_4
	INCF  AL_Hour,1
			;        if(Key_5) AL_Minute++;			/* advance alarm minute if Key_5 is pressed */
	BTFSC 0x1E,Key_5
	INCF  AL_Minute,1
			;
			;	if(Key_6)				/* clear alarm time with Key_6 */
	BTFSS 0x1E,Key_6
	GOTO  m054
			;	{
			;	  AL_Hour = 0;
	CLRF  AL_Hour
			;	  AL_Minute = 0;
	CLRF  AL_Minute
			;	}
			;
			;	if(AL_Minute > 59)			/* check if alarm minute overflowed */
m054	MOVLW .60
	SUBWF AL_Minute,W
	BTFSC 0x03,Carry
			;	  AL_Minute = 0;			/* and clear it, if so */
	CLRF  AL_Minute
			;
			;	if(AL_Hour > 23)			/* check if the alarm hour overflowed */
	MOVLW .24
	SUBWF AL_Hour,W
	BTFSC 0x03,Carry
			;	  AL_Hour = 0;				/* and clear it, if so */
	CLRF  AL_Hour
			;
			;        if(Key_Bits2) 				/* if one of the set keys was pressed .... */
	MOVF  Key_Bits2,1
	BTFSC 0x03,Zero_
	GOTO  m067
			;          Alarm_Changed = 1;			/* flag the change of the alarm time */
	BSF   0x32,Alarm_Changed
			;        goto nextkey2;
	GOTO  m067
			;      }
			;
			;      if(Key_1)					/* check if Key_1 is pressed, then we can adjust the date */
m055	BTFSS 0x1C,Key_1
	GOTO  m064
			;      {
			;   	if(Key_3)			/* if Key_4 and Key_5 are pressed at the same time ... */
	BTFSS 0x1C,Key_3
	GOTO  m056
			; 	{
			;	  Day = 1;				/* reset the date */
	MOVLW .1
	MOVWF Day
			;	  Month = 1;
	MOVWF Month
			;          Year = 0;
	CLRF  Year
			;          goto nextkey1;          
	GOTO  m064
			;        }
			;
			;        if(Key_4)				/* ... with Key_4 we set the day .... */
m056	BTFSC 0x1E,Key_4
			;        {
			;	  Advance_Day();			/* ... by advancing it and checking for month-length */
	CALL  Advance_Day
			;        }
			;
			;	if(Key_5)				/* check if Key_5 is pressed ... */
	BTFSS 0x1E,Key_5
	GOTO  m057
			;	{
			;	  Month++;				/* ... advance the month, if so */
	INCF  Month,1
			;	  Day = 1;				/* and reset the day */
	MOVLW .1
	MOVWF Day
			;	}
			;
			;	if(Key_6)				/* check if Key_6 is pressed ... */
m057	BTFSS 0x1E,Key_6
	GOTO  m058
			;	{
			;	  Year++;				/* ... advance the year, if so ... */
	INCF  Year,1
			;	  Day = 1;				/* and reset the month */
	MOVLW .1
	MOVWF Day
			;	}
			;
			;        if(Month > 12)				/* check if the month overflowed */
m058	MOVLW .13
	SUBWF Month,W
	BTFSS 0x03,Carry
	GOTO  m059
			;	  Month = 1;				/* and reset it, if so */
	MOVLW .1
	MOVWF Month
			;
			;        if(Year > 99)				/* now check if the year overflowed */
m059	MOVLW .100
	SUBWF Year,W
	BTFSS 0x03,Carry
	GOTO  m064
			;	  Year = 0;				/* and reset it, if so */
	CLRF  Year
			;      }
			;    goto nextkey1;
	GOTO  m064
			;    }
			;
			;    if(Key_9)
m060	BTFSS 0x1B,Key_9
	GOTO  m064
			;    {
			;nextkey9:
			;      Old_Hour = Counter_c;			/* show the counter value by default */
m061	MOVF  Counter_c,W
	MOVWF Old_Hour
			;      Old_Minute = Counter_b;
	MOVF  Counter_b,W
	MOVWF Old_Minute
			;      Old_Second = Counter_a;
	MOVF  Counter_a,W
	MOVWF Old_Second
			;
			;      if(Key_1)					/* when Key_1 is pressed in counter-mode */
	BTFSS 0x1C,Key_1
	GOTO  m062
			;      {
			;        Old_Hour = Counter_Set_c;			/* show the counter-alarm instead */
	MOVF  Counter_Set_c,W
	MOVWF Old_Hour
			;        Old_Minute = Counter_Set_b;
	MOVF  Counter_Set_b,W
	MOVWF Old_Minute
			;        Old_Second = Counter_Set_a;
	MOVF  Counter_Set_a,W
	MOVWF Old_Second
			;      }
			;
			;      if(Key_2)				/* if Key_2 is pressed in counter mode ... */
m062	BTFSS 0x1C,Key_2
	GOTO  m063
			;      {
			;         Counter_a = 0;			/* clear the counters */
	CLRF  Counter_a
			;         Counter_b = 0;
	CLRF  Counter_b
			;         Counter_c = 0;
	CLRF  Counter_c
			;         Count_Reached = 0;			/* and clear the counter alarm also */
	BCF   0x32,Count_Reached
			;      }
			; 
			;      Enable_Blend = 0;				/* turn of number blending */
m063	BCF   0x32,Enable_Blend
			;      goto keysdone;
	GOTO  m072
			;    }
			;
			;nextkey1:
			;    cf = 60 - Auto_Date;			/* at what second should the date display start */
m064	MOVF  Auto_Date,W
	SUBLW .60
	MOVWF cf
			;    if(Second >= cf && Key_Bits1 == 0)		/* if that time is reached, and no accountable keys pressed ... */
	SUBWF Second,W
	BTFSS 0x03,Carry
	GOTO  m065
	MOVF  Key_Bits1,1
	BTFSC 0x03,Zero_
			;      Key_1 = 1;				/* emulate the pressing of Key_1 to show the date */
	BSF   0x1C,Key_1
			;
			;    if (Key_1)					/* if Key_1 is pressed */
m065	BTFSS 0x1C,Key_1
	GOTO  m066
			;    { 
			;      Old_Second = Year;			/* show the date */
	MOVF  Year,W
	MOVWF Old_Second
			;      Old_Minute = Month;
	MOVF  Month,W
	MOVWF Old_Minute
			;      Old_Hour = Day;
	MOVF  Day,W
	MOVWF Old_Hour
			;      Enable_Blend = 0;				/* and turn of number blending */
	BCF   0x32,Enable_Blend
			;goto keysdone;
	GOTO  m072
			;    }
			; 
			;    if(Key_2)					/* if Key_2 is pressed */
m066	BTFSS 0x1C,Key_2
	GOTO  m068
			;    {
			;nextkey2:
			;      Old_Hour = AL_Hour;			/* show the alarm time */
m067	MOVF  AL_Hour,W
	MOVWF Old_Hour
			;      Old_Minute = AL_Minute;
	MOVF  AL_Minute,W
	MOVWF Old_Minute
			;      Old_Second = 0;
	CLRF  Old_Second
			;      Enable_Blend = 0;				/* disable number blending */
	BCF   0x32,Enable_Blend
			;goto keysdone;
	GOTO  m072
			;    }
			;
			;    if (Key_3)					/* if Key_3 is pressed */
m068	BTFSS 0x1C,Key_3
	GOTO  m071
			;    {
			;      Old_Hour = Second_Sync;
	CLRF  Old_Hour
	BTFSC 0x30,Second_Sync
	INCF  Old_Hour,1
			;      Old_Hour += DCF_Sync;
	BTFSC 0x30,DCF_Sync
	INCF  Old_Hour,1
			;      Old_Hour += DCF_OK;
	BTFSC 0x30,DCF_OK
	INCF  Old_Hour,1
			;
			;      if(Last_DCF_OK)				/* if the last dcf datagram was ok */
	BTFSS 0x31,Last_DCF_OK
	GOTO  m069
			;        Old_Hour += 10;				/* show it as 1 one the hour 10's */
	MOVLW .10
	ADDWF Old_Hour,1
			;
			;      Old_Minute = 0;				/* set minute display to 00 */
m069	CLRF  Old_Minute
			;
			;      if(DCF_Bit)				/* if the received dcf bit is 1 */
	BTFSS 0x31,DCF_Bit
	GOTO  m070
			;        Old_Minute = 10;			/* show it in the minute 10's */
	MOVLW .10
	MOVWF Old_Minute
			;
			;      if(!in)					/* if the dcf input low (logic 1 for that signal) */
m070	BTFSS 0x06,in
			;        Old_Minute ++;				/* show it in minutes 1 */
	INCF  Old_Minute,1
			;
			;      Old_Second = DCF_Second;			/* show the actual/estimated dcf second in the seconds display */
	MOVF  DCF_Second,W
	MOVWF Old_Second
			;      Enable_Blend = 0;				/* disable number blending */
	BCF   0x32,Enable_Blend
			;    }
			;
			;nextkey8:
			;    if(Key_8 && Key_1)				/* is Key_8 and Key_1 pressed at the same time ? */
m071	BTFSS 0x1B,Key_8
	GOTO  m072
	BTFSC 0x1C,Key_1
			;      goto basicsetup;				/* if so, jump to the initial setup */
	GOTO  m035
			;
			;keysdone:
			;
			;    if(Alarm_Changed && Key_Bits1 == 0)		/* if the alarm was changed, and the keys released ... */
m072	BTFSS 0x32,Alarm_Changed
	GOTO  m073
	MOVF  Key_Bits1,1
	BTFSS 0x03,Zero_
	GOTO  m073
			;    {
			;      Alarm_Changed = 0;
	BCF   0x32,Alarm_Changed
			;      Write_EE();
	CALL  Write_EE
			;    }
			;
			;    Update_Display();				/* finally, show the stuff */
m073	CALL  Update_Display
			;  }
	GOTO  m043
			;}
			;
			;char Div_by_10(char what)			/* fixed division by 10, saves codewords */
			;{
Div_by_10
	MOVWF what
			;static char cx @ 0x43;				/* working variable */
			;
			;  cx = 0;					/* init variable to 0 */
	CLRF  cx_2
			;  while(what >= 10)				/* as long as the number is bigger than 10 */
m074	MOVLW .10
	SUBWF what,W
	BTFSS 0x03,Carry
	GOTO  m075
			;  {
			;    what -= 10;					/* substract 10 */
	MOVLW .10
	SUBWF what,1
			;    cx++;					/* and increase the working variable */
	INCF  cx_2,1
			;  }
	GOTO  m074
			;  return cx;					/* return the working variable to the caller */
m075	MOVF  cx_2,W
	RETURN
			;}
			;
			;char Modulo_10(char what)			/* fixed modulo 10, saves codewords */
			;{
Modulo_10
	MOVWF what_2
			;  while(what >= 10)				/* as long as the number is bigger than 10 */
m076	MOVLW .10
	SUBWF what_2,W
	BTFSS 0x03,Carry
	GOTO  m077
			;  {
			;    what -= 10;					/* substract 10 */
	MOVLW .10
	SUBWF what_2,1
			;  }
	GOTO  m076
			;  return what;					/* return the remaining number to the caller */
m077	MOVF  what_2,W
	RETURN
			;}
			;
			;void Update_Display( void )			/* display output and key scanning routine */
			;{
Update_Display
			;  static   char col @ 0x44, oldport @ 0x45, real_col @ 0x46, s @ 0x47;	/* local variables */
			;  col = 5;
	MOVLW .5
	MOVWF col
			;  while(col != 255)
	BCF   0x03,RP0
m078	INCF  col,W
	BTFSC 0x03,Zero_
	GOTO  m085
			;  {
			;    #pragma computedGoto 1			/* computed goto's are like a switch() in c, but less codewords */
			;    s = col << 3;
	BCF   0x03,Carry
	RLF   col,W
	MOVWF s
	BCF   0x03,Carry
	RLF   s,1
	BCF   0x03,Carry
	RLF   s,1
			;    s -= col;
	MOVF  col,W
	SUBWF s,1
			;    skip(s);					/* select what we have to display */
	MOVLW .2
	MOVWF PCLATH
	MOVF  s,W
	ADDWF PCL,1
			;    case0:  Display_Num = Modulo_10(Second); 	/* one's of the actual second */
	MOVF  Second,W
	CALL  Modulo_10
	MOVWF Display_Num
			;            cc = Modulo_10(Old_Second); 		/* one's of the old second */
	MOVF  Old_Second,W
	CALL  Modulo_10
	MOVWF cc
			;            goto done;				/* continue with display */
	GOTO  m079
			;    case1:  Display_Num = Div_by_10(Second); 	/* 10's of the actual second */
	MOVF  Second,W
	CALL  Div_by_10
	MOVWF Display_Num
			;            cc = Div_by_10(Old_Second); 		/* 10's of the old second */
	MOVF  Old_Second,W
	CALL  Div_by_10
	MOVWF cc
			;            goto done;				/* continue with display */
	GOTO  m079
			;    case2:  Display_Num = Modulo_10(Minute); 	/* now the one's of the minute */
	MOVF  Minute,W
	CALL  Modulo_10
	MOVWF Display_Num
			;            cc = Modulo_10(Old_Minute); 		/* and the old minute one's */
	MOVF  Old_Minute,W
	CALL  Modulo_10
	MOVWF cc
			;            goto done;				/* continue with display */
	GOTO  m079
			;    case3:  Display_Num = Div_by_10(Minute); 	/* 10's of the minute */
	MOVF  Minute,W
	CALL  Div_by_10
	MOVWF Display_Num
			;            cc = Div_by_10(Old_Minute); 		/* 10's of the old minute */
	MOVF  Old_Minute,W
	CALL  Div_by_10
	MOVWF cc
			;            goto done;				/* continue with display */
	GOTO  m079
			;    case4:  Display_Num = Modulo_10(Hour); 	/* the hour one's */
	MOVF  Hour,W
	CALL  Modulo_10
	MOVWF Display_Num
			;            cc = Modulo_10(Old_Hour); 		/* and the old hour one's */
	MOVF  Old_Hour,W
	CALL  Modulo_10
	MOVWF cc
			;            goto done;				/* continue with display */
	GOTO  m079
			;    case5:  Display_Num = Div_by_10(Hour); 	/* the hour 10's */
	MOVF  Hour,W
	CALL  Div_by_10
	MOVWF Display_Num
			;            cc = Div_by_10(Old_Hour); 		/* and finally the old hour 10's */
	MOVF  Old_Hour,W
	CALL  Div_by_10
	MOVWF cc
			;    done:
			;    #pragma computedGoto 0
			;
			;    Display_Num <<=4;		/* combine the old and new number to display, actual value in the higher 4 bit */
m079	SWAPF Display_Num,W
	ANDLW .240
	MOVWF Display_Num
			;    Display_Num += cc;		/* the old stuff goes to the lower 4 bits */
	MOVF  cc,W
	ADDWF Display_Num,1
			;
			;    oldport = PORTA & 227;	/* remember actual porta bits, but mask out the column bits */
	MOVLW .227
	BCF   0x03,RP0
	ANDWF PORTA,W
	MOVWF oldport
			;
			;    col <<= 2;			/* move the colum-counter bits to the right position */
	BCF   0x03,Carry
	RLF   col,1
	BCF   0x03,Carry
	RLF   col,1
			;    real_col = oldport + col;	/* add the column to the old, masked porta bits, store in a new variable */
	MOVF  col,W
	ADDWF oldport,W
	MOVWF real_col
			;    col >>=2;			/* shift back the column-counter bits */
	BCF   0x03,Carry
	RRF   col,1
	BCF   0x03,Carry
	RRF   col,1
			;    oldport += 28;		/* set all column bits on the old, stored porta value */
	MOVLW .28
	ADDWF oldport,1
			;    ca = 0;			/* initialize the blend-time counter */
	CLRF  ca
			;    PORTA = oldport;		/* blank the display */
	MOVF  oldport,W
	MOVWF PORTA
			;
			;    if(Enable_Blend)		/* if blending is enabled */
	BTFSS 0x32,Enable_Blend
	GOTO  m081
			;    {
			;      PORTB.4 = Display_Num.4;	/* set the number-bits of the output to the actual number bits */
	BTFSS Display_Num,4
	BCF   PORTB,4
	BTFSC Display_Num,4
	BSF   PORTB,4
			;      PORTB.5 = Display_Num.5;
	BTFSS Display_Num,5
	BCF   PORTB,5
	BTFSC Display_Num,5
	BSF   PORTB,5
			;      PORTB.6 = Display_Num.6;
	BTFSS Display_Num,6
	BCF   PORTB,6
	BTFSC Display_Num,6
	BSF   PORTB,6
			;      PORTB.7 = Display_Num.7;
	BTFSS Display_Num,7
	BCF   PORTB,7
	BTFSC Display_Num,7
	BSF   PORTB,7
			;      PORTA = real_col;		/* turn on the display at the right column */
	MOVF  real_col,W
	MOVWF PORTA
			;      for (;ca < cb; ca++) ;	/* show it until the blend-time has reached the blend counter */
m080	MOVF  cb,W
	SUBWF ca,W
	BTFSC 0x03,Carry
	GOTO  m082
	INCF  ca,1
	GOTO  m080
			;    }
			;    else				/* otherwise */
			;      cb = 0;			/* reset the blend counter */
m081	CLRF  cb
			;
			;    PORTA = oldport;		/* blank the display */
m082	MOVF  oldport,W
	MOVWF PORTA
			;    PORTB.4 = Display_Num.0;	/* set the number bit of the output to the old number bits */
	BTFSS Display_Num,0
	BCF   PORTB,4
	BTFSC Display_Num,0
	BSF   PORTB,4
			;    PORTB.5 = Display_Num.1;
	BTFSS Display_Num,1
	BCF   PORTB,5
	BTFSC Display_Num,1
	BSF   PORTB,5
			;    PORTB.6 = Display_Num.2;
	BTFSS Display_Num,2
	BCF   PORTB,6
	BTFSC Display_Num,2
	BSF   PORTB,6
			;    PORTB.7 = Display_Num.3;
	BTFSS Display_Num,3
	BCF   PORTB,7
	BTFSC Display_Num,3
	BSF   PORTB,7
			;    PORTA = real_col;		/* turn on again at the same column */
	MOVF  real_col,W
	MOVWF PORTA
			;    for(; ca < Blend_Time; ca++); /* display it for the remaining blend time */
m083	MOVF  Blend_Time,W
	SUBWF ca,W
	BTFSC 0x03,Carry
	GOTO  m084
	INCF  ca,1
	GOTO  m083
			;
			;    Key_Bits[col] = PORTB & 14;
m084	MOVLW .26
	ADDWF col,W
	MOVWF FSR
	MOVLW .14
	ANDWF PORTB,W
	MOVWF INDF
			;
			;    col--;
	DECF  col,1
			;  }
	GOTO  m078
			;
			;  cg++;						/* toggle the toggle bit, its bit0 @ cg */
m085	INCF  cg,1
			;  cb+= Toggle_Bit;				/* and decrease the blend timer, if the toggle is 1 */
	BTFSC 0x3D,Toggle_Bit
	INCF  cb,1
			;}
	RETURN
			;
			;void First_Check_Parity( void )	/* check parity bit for dcf hour and minute */
			;{
First_Check_Parity
			;  if (!DCF_PBIT)		/* if no parity bit is set */
	BTFSS 0x2D,DCF_PBIT
			;      DCF_OK = 1;		/* then clear the dcf status bit */
	BSF   0x30,DCF_OK
			;}
	RETURN
			;
			;void Check_Parity( void )	/* check parity bit for dcf hour and minute */
			;{
Check_Parity
			;  if (DCF_PBIT)		/* if no parity bit is set */
	BTFSC 0x2D,DCF_PBIT
			;      DCF_OK = 0;		/* then clear the dcf status bit */
	BCF   0x30,DCF_OK
			;  DCF_PBIT = 0;		/* clear the parity bit */
	BCF   0x2D,DCF_PBIT
			;}
	RETURN
			;
			;void Process_DCF_Bit( void)		/* process an incomming dcf bit */
			;{
Process_DCF_Bit
			; static  char s @ 0x48;			/* internal jump variable */
			;
			;  				/* if we are in sync with the dcf signal ... */
			;    if(DCF_Sync && DCF_Second > 20)			/* ... and more than 20 dcf seconds elapsed */
	BTFSS 0x30,DCF_Sync
	GOTO  m086
	MOVLW .21
	SUBWF DCF_Second,W
	BTFSS 0x03,Carry
	GOTO  m086
			;    {					/* we can start the processing */
			;      if(DCF_Bit) DCF_BITS++;		/* if the actual bit is 1, increase the dcf-bits counter, toggling the parity bit */
	BTFSC 0x31,DCF_Bit
	INCF  DCF_BITS,1
			;      #pragma computedGoto 1
			;      s = DCF_Second - 21;		/* prepare adress to jump to */
	MOVLW .21
	SUBWF DCF_Second,W
	MOVWF s_2
			;      s <<= 2;
	BCF   0x03,Carry
	RLF   s_2,1
	BCF   0x03,Carry
	RLF   s_2,1
			;      skip(s);				/* select which bit to process */
	MOVLW .3
	MOVWF PCLATH
	MOVF  s_2,W
	ADDWF PCL,1
			;      Case21 : DCF_Minute.0 = DCF_Bit; goto end;	/* minute bit0 */
	BCF   DCF_Minute,0
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Minute,0
	GOTO  m087
			;      Case22 : DCF_Minute.1 = DCF_Bit; goto end;	/* minute bit1 */
	BCF   DCF_Minute,1
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Minute,1
	GOTO  m087
			;      Case23 : DCF_Minute.2 = DCF_Bit; goto end;	/* ... */
	BCF   DCF_Minute,2
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Minute,2
	GOTO  m087
			;      Case24 : DCF_Minute.3 = DCF_Bit; goto end;
	BCF   DCF_Minute,3
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Minute,3
	GOTO  m087
			;      Case25 : DCF_Minute.4 = DCF_Bit; goto end;
	BCF   DCF_Minute,4
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Minute,4
	GOTO  m087
			;      Case26 : DCF_Minute.5 = DCF_Bit; goto end;
	BCF   DCF_Minute,5
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Minute,5
	GOTO  m087
			;      Case27 : DCF_Minute.6 = DCF_Bit; goto end;
	BCF   DCF_Minute,6
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Minute,6
	GOTO  m087
			;      Case28 : First_Check_Parity(); nop(); nop(); goto end;	/* minute complete, check for parity */
	CALL  First_Check_Parity
	NOP  
	NOP  
	GOTO  m087
			;      Case29 : DCF_Hour.0 = DCF_Bit; goto end;		/* hour */
	BCF   DCF_Hour,0
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Hour,0
	GOTO  m087
			;      Case30 : DCF_Hour.1 = DCF_Bit; goto end;
	BCF   DCF_Hour,1
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Hour,1
	GOTO  m087
			;      Case31 : DCF_Hour.2 = DCF_Bit; goto end;
	BCF   DCF_Hour,2
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Hour,2
	GOTO  m087
			;      Case32 : DCF_Hour.3 = DCF_Bit; goto end;
	BCF   DCF_Hour,3
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Hour,3
	GOTO  m087
			;      Case33 : DCF_Hour.4 = DCF_Bit; goto end;
	BCF   DCF_Hour,4
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Hour,4
	GOTO  m087
			;      Case34 : DCF_Hour.5 = DCF_Bit; goto end;
	BCF   DCF_Hour,5
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Hour,5
	GOTO  m087
			;      Case35 : Check_Parity(); nop(); nop(); goto end;		/* hour complete, check for parity */
	CALL  Check_Parity
	NOP  
	NOP  
	GOTO  m087
			;      Case36 : DCF_Day.0 = DCF_Bit; goto end;		/* day */
	BCF   DCF_Day,0
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Day,0
	GOTO  m087
			;      Case37 : DCF_Day.1 = DCF_Bit; goto end;
	BCF   DCF_Day,1
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Day,1
	GOTO  m087
			;      Case38 : DCF_Day.2 = DCF_Bit; goto end;
	BCF   DCF_Day,2
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Day,2
	GOTO  m087
			;      Case39 : DCF_Day.3 = DCF_Bit; goto end;
	BCF   DCF_Day,3
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Day,3
	GOTO  m087
			;      Case40 : DCF_Day.4 = DCF_Bit; goto end;
	BCF   DCF_Day,4
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Day,4
	GOTO  m087
			;      Case41 : DCF_Day.5 = DCF_Bit; goto end;
	BCF   DCF_Day,5
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Day,5
	GOTO  m087
			;      Case42 : nop(); nop(); nop(); goto end;		/* unused, is: day of week */
	NOP  
	NOP  
	NOP  
	GOTO  m087
			;      Case43 : nop(); nop(); nop(); goto end;
	NOP  
	NOP  
	NOP  
	GOTO  m087
			;      Case44 : nop(); nop(); nop(); goto end;
	NOP  
	NOP  
	NOP  
	GOTO  m087
			;      Case45 : DCF_Month.0 = DCF_Bit; goto end;		/* month */
	BCF   DCF_Month,0
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Month,0
	GOTO  m087
			;      Case46 : DCF_Month.1 = DCF_Bit; goto end;
	BCF   DCF_Month,1
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Month,1
	GOTO  m087
			;      Case47 : DCF_Month.2 = DCF_Bit; goto end;
	BCF   DCF_Month,2
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Month,2
	GOTO  m087
			;      Case48 : DCF_Month.3 = DCF_Bit; goto end;
	BCF   DCF_Month,3
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Month,3
	GOTO  m087
			;      Case49 : DCF_Month.4 = DCF_Bit; goto end;
	BCF   DCF_Month,4
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Month,4
	GOTO  m087
			;      Case50 : DCF_Year.0 = DCF_Bit; goto end;		/* year */
	BCF   DCF_Year,0
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Year,0
	GOTO  m087
			;      Case51 : DCF_Year.1 = DCF_Bit; goto end;
	BCF   DCF_Year,1
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Year,1
	GOTO  m087
			;      Case52 : DCF_Year.2 = DCF_Bit; goto end;
	BCF   DCF_Year,2
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Year,2
	GOTO  m087
			;      Case53 : DCF_Year.3 = DCF_Bit; goto end;
	BCF   DCF_Year,3
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Year,3
	GOTO  m087
			;      Case54 : DCF_Year.4 = DCF_Bit; goto end;
	BCF   DCF_Year,4
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Year,4
	GOTO  m087
			;      Case55 : DCF_Year.5 = DCF_Bit; goto end;
	BCF   DCF_Year,5
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Year,5
	GOTO  m087
			;      Case56 : DCF_Year.6 = DCF_Bit; goto end;
	BCF   DCF_Year,6
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Year,6
	GOTO  m087
			;      Case57 : DCF_Year.7 = DCF_Bit; goto end;
	BCF   DCF_Year,7
	BTFSC 0x31,DCF_Bit
	BSF   DCF_Year,7
	GOTO  m087
			;      Case58 : Check_Parity(); nop(); nop();		/* date complete, check parity */
	CALL  Check_Parity
	NOP  
	NOP  
			;      end:
			;      #pragma computedGoto 0
			;  }
			;  else 
	GOTO  m087
			;    DCF_PBIT = 0;
m086	BCF   0x2D,DCF_PBIT
			;
			;
			;  if(Has_DCF_Bit)	/* if we were flagged for a new bit, which means a new dcf second .... */
m087	BTFSC 0x31,Has_DCF_Bit
			;    DCF_Second++;	/* ... then increase the dcf second */
	INCF  DCF_Second,1
			;
			;  if(DCF_Second > 59)	/* check if the dcf second overflowed */
	MOVLW .60
	SUBWF DCF_Second,W
	BTFSS 0x03,Carry
	GOTO  m088
			;  {
			;    DCF_Second = 0;	/* if so, clear it */
	CLRF  DCF_Second
			;    DCF_PBIT = 0;	/* and also clear the parity bit */
	BCF   0x2D,DCF_PBIT
			;  }
			;  Has_DCF_Bit = 0;	/* clear new-dcf-bit flag */
m088	BCF   0x31,Has_DCF_Bit
			;}
	RETURN

	ORG 0x2100
	DATA 003CH
	DATA 000FH
	DATA 0000H
	DATA 0000H
	DATA 0006H
	DATA 002DH
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0032H
	DATA 0032H
	DATA 0003H
	DATA 000BH
	DATA 0003H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0003H
	DATA 000BH
	DATA 0003H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	DATA 0000H
	ORG 0x2007
	DATA 3FF1H
	END
