
#ifndef __MAIN_C__
#define __MAIN_C__

#include <p18cxxx.h>
#include <p18f2550.h>
#include <string.h>
#include <delays.h>
#include <stdio.h>
#include "typedefs.h"
#include "vars.h"
#include "i2c.h"
#include "lcd.h"

#pragma config PLLDIV   = 2 		//Divide by 2 (8 MHz oscillator input)	(0xF9)
#pragma config CPUDIV   = OSC1_PLL2 //[OSC1/OSC2 Src: /1][96 MHz PLL Src: /2]	(0xE7)
#pragma config USBDIV   = 2 		//USB clock source comes from the 96 MHz PLL divided by 2	(0xFF)
#pragma config FOSC     = HSPLL_HS 	//HS oscillator, PLL enabled, HS used by USB	(0xFE)
#pragma config FCMEN    = OFF 		//Fail-Safe Clock Monitor disabled	(0xBF)
#pragma config IESO     = OFF 		//Oscillator Switchover mode disabled	(0x7F)
#pragma config PWRT     = ON		//PWRT enabled
#pragma config BOR      = ON		//Brown-out Reset enabled in hardware only (SBOREN is disabled)
#pragma config BORV 	= 1			//4.33V 
#pragma config VREGEN   = ON		//USB voltage regulator enabled
#pragma config WDT      = OFF		//Watchdog Timer Disabled
#pragma config WDTPS    = 512		//Watchdog Timer Postscale 1:512
#pragma config MCLRE    = ON		//MCLR pin enabled// RE3 input pin disabled
#pragma config LPT1OSC  = OFF		//Timer1 configured for higher power operation
#pragma config PBADEN   = OFF		//PORTB<4:0> pins are configured as digital I/O on Reset
#pragma config CCP2MX   = OFF		//CCP2 input/output is multiplexed with RB3
#pragma config STVREN   = ON		//Stack full/underflow will cause Reset
#pragma config LVP      = OFF		//Single-Supply ICSP disabled
#pragma config XINST    = OFF		//Instruction set extension and Indexed Addressing mode disabled (Legacy mode)
#pragma config DEBUG    = OFF		//Background debugger disabled, RB6 and RB7 configured as general purpose I/O pins


/////////////////////////////////////////////////
//pins
#define STATUS_LED	LATCbits.LATC6

/////////////////////////////////////////////////
void main(void)
{
	char line[]= "       "; // 7 blanks
	U32 cnt = 0;
	
	INTCON  = 0x00;		// disable all interrupts
	INTCON2 = 0xF0;
	INTCON3 = 0x00;
	ADCON1 = 0b00001111;  // configure analog inputs and Vref
	PIR1 = 0x00;
	PIE1 = 0x00; 
	
	TRISA = 0x00; LATA = 0x00;
	TRISB = 0x00; LATB = 0x00;
	TRISC = 0x00; LATC = 0x00;
	
	delay200ms;

	lcd_config();	
	i2c_config();
  
	INTCON = 0x00;
	INTCONbits.PEIE = 1;
	INTCONbits.GIE = 1;
	while(1)
	{
		cnt++;
		//if (!PIR1bits.SSPIF && i2cdataReady)
		//{
		//	PIE1bits.SSPIE = 0; //disable interrupt
		//	reg = bufferRx[ 0];
		//	/////////
		//	TIDI
		//	/////////
		//	PIE1bits.SSPIE = 1; //enable interrupt
		//}

		if (AxisStepsPerMM.A)
		{
			sprintf((void*)&line, (const rom far char*)"%7ld", 100*Position.A / AxisStepsPerMM.A);
			lcd_pos(0, 0);
			delay40us;
			lcd_putsDec(line, 5); 
		}	
		if (AxisStepsPerMM.B)
		{
			sprintf((void*)&line, (const rom far char*)"%7ld", 100*Position.B / AxisStepsPerMM.B);
			lcd_pos(0, 8);
			delay40us;
			lcd_putsDec(line, 5); 
		}	
		if (AxisStepsPerMM.C)
		{
			sprintf((void*)&line, (const rom far char*)"%7ld", 100*Position.C / AxisStepsPerMM.C);
			lcd_pos(1, 0);
			delay40us;
			lcd_putsDec(line, 5); 
		}	
		if (AxisStepsPerMM.D)
		{
			sprintf((void*)&line, (const rom far char*)"%7ld", 100*Position.D / AxisStepsPerMM.D);
			lcd_pos(1, 8);
			delay40us;
			lcd_putsDec(line, 5); 
		}				

		
		sprintf((void*)&line, (const rom far char*)"%7ld", cnt);
		lcd_pos(3, 0);
		delay40us;
		lcd_puts(line);
		
		
		STATUS_LED = ~STATUS_LED; //blinking LED
		delay100ms; 
	}		
}	

#endif 

