
#ifndef __TYPE_H__
#define __TYPE_H__


typedef enum _BOOL { FALSE = 0, TRUE } BOOL;
#ifndef __FALSE
#define __FALSE   FALSE
#endif

#ifndef __TRUE
#define __TRUE    TRUE
#endif



typedef signed char			S8;
typedef unsigned char		U8;
typedef signed short		S16;
typedef unsigned short		U16;
typedef signed short long	S24;
typedef unsigned short long	U24;
typedef signed long			S32;
typedef unsigned long		U32;
typedef signed long long	S64;
typedef unsigned long long	U64;


#define NOT_BIGENDIAN	
#ifdef BIGENDIAN
	#define BYTE1(v)   (*(((unsigned char *) (&v)    )))
	#define BYTE2(v)   (*(((unsigned char *) (&v) + 1)))
	#define BYTE3(v)   (*(((unsigned char *) (&v) + 2)))
	#define BYTE4(v)   (*(((unsigned char *) (&v) + 3)))
#else
	#define BYTE4(v)   (*(((unsigned char *) (&v)    )))
	#define BYTE3(v)   (*(((unsigned char *) (&v) + 1)))
	#define BYTE2(v)   (*(((unsigned char *) (&v) + 2)))
	#define BYTE1(v)   (*(((unsigned char *) (&v) + 3)))
#endif

#define ABS(a) (((a)<0) ? -(a) : (a))
#define ZSGN(a) (((a)<0) ? -1 : (a)>0 ? 1 : 0)
#define MIN(a,b) (((a)<(b))?(a):(b))
#define MAX(a,b) (((a)>(b))?(a):(b))
#define MAX3(a, b, c) ( MAX(MAX(a, b), c) )

#endif  /* __TYPE_H__ */
