//************************************************************************************
//**  
//**  File name:     C:\Matrix Multimedia\SAVE\ADC\Flowcode2.c
//**  Generated by:  Flowcode v4.3.7.63
//**  Date:          Sunday, March 30, 2014 18:40:09
//**  Licence:       Professional
//**  Registered to: 20ACM8
//**  
//**  
//**  http://www.matrixmultimedia.com
//************************************************************************************


#define MX_PIC

//Mikrovezrl? defincik
#define P12F683
#define MX_EE
#define MX_EE_TYPE1
#define MX_EE_SIZE 256
#define MX_PWM
#define MX_PWM_CNT 1
#define MX_PWM_TRIS1 trisio
#define MX_PWM_1 2

//Fggvnyek
#define MX_CLK_SPEED 4000000
#ifdef _BOOSTC
#include <system.h>
#endif
#ifdef HI_TECH_C
#include <pic.h>
#endif

//Konfigurcis adatok
#ifdef _BOOSTC
#pragma DATA 0x2007, 0x30f4
#endif
#ifdef HI_TECH_C
__CONFIG(0x30f4);
#endif

//Bels? fggvnyek
#include "C:\Matrix Multimedia\Flowcode V4\FCD\internals.h"

//Makr deklarcik
void FCM_SPI_Write_Byte();
void FCM_MAX7219_INIT();
void FCM_Display_Value();


//Vltoz deklarcik
short FCV_AMP;
short FCV_VOLT;
char FCV_NUM;
short FCV_J;
short FCV_K;
short FCV_FLAG;
short FCV_ADC;
short FCV_MASK;
short FCV_ADC_OP;
short FCV_T;

char FCLV_LOOP1;
char FCLV_LOOP2;

//Defines:

/**** Macro Substitutions ****
2 = Which ADC Channel
40 = Acquisition time
3 = Conversion Speed
0 = VRef+ Option
500 = VRef Voltage x 0.01V
******************************/




//ADC(2): //Makr deklarcik

void FCD_ADC2_SampleADC();
char FCD_ADC2_ReadAsByte();
short FCD_ADC2_ReadAsInt();
float FCD_ADC2_ReadAsVoltage();
void FCD_ADC2_ReadAsString(char* FCR_RETVAL, char FCR_RETVAL_SIZE);
//Defines:

/**** Macro Substitutions ****
3 = Which ADC Channel
40 = Acquisition time
3 = Conversion Speed
0 = VRef+ Option
500 = VRef Voltage x 0.01V
******************************/




//ADC(3): //Makr deklarcik

void FCD_ADC3_SampleADC();
char FCD_ADC3_ReadAsByte();
short FCD_ADC3_ReadAsInt();
float FCD_ADC3_ReadAsVoltage();
void FCD_ADC3_ReadAsString(char* FCR_RETVAL, char FCR_RETVAL_SIZE);



//ADC(2): //Makr implementcik


void FCD_ADC2_SampleADC()
{
	
	/*******Supported Devices******************************************************************
	// 12F615, 12HV615, 12F675, 12F683
	******************************************************************************************/

		#define MX_ADC_CHANNEL		2
		#define MX_ADC_SAMP_TIME 	40
		#define MX_ADC_CONV_SP		3
		#define MX_ADC_VREF_OPT		0

		//set up ADC conversion
		char old_tris, cnt;
		#define MX_ADC_TRIS_REG  trisio

		//find appropriate bit
		#if (MX_ADC_CHANNEL == 0)
			#define MX_ADC_TRIS_MSK  0x01
			ansel = 0x01;
		#endif
		#if (MX_ADC_CHANNEL == 1)
			#define MX_ADC_TRIS_MSK  0x02
			ansel = 0x02;
			#if (MX_ADC_VREF_OPT != 0)
				#ifdef _BOOSTC
					#pragma error "Target device is currently using AN1 for VREF+"
				#endif
				#ifdef HI_TECH_C
					#error Target device is currently using AN1 for VREF+
				#endif
			#endif
		#endif
		#if (MX_ADC_CHANNEL == 2)
			#define MX_ADC_TRIS_MSK  0x04
			ansel = 0x04;
		#endif
		#if (MX_ADC_CHANNEL == 3)
			#define MX_ADC_TRIS_MSK  0x10
			ansel = 0x08;
		#endif

		//sanity check
		#ifndef MX_ADC_TRIS_MSK
			#ifdef _BOOSTC
				#pragma error "ADC Type 5 conversion code error - please contact technical support"
			#endif
			#ifdef HI_TECH_C
				#error ADC Type 5 conversion code error - please contact technical support
			#endif
		#endif

		//store old tris value, and set the i/o pin as an input
		old_tris = MX_ADC_TRIS_REG;
		MX_ADC_TRIS_REG = MX_ADC_TRIS_REG | MX_ADC_TRIS_MSK;

		//assign conversion rate
		ansel = ansel | ((MX_ADC_CONV_SP & 0x07) << 4);

		//turn ADC on
		adcon0 = 0x01 | (MX_ADC_CHANNEL << 2);

		//assign VREF functionality
		#if (MX_ADC_VREF_OPT == 1)
			st_bit(adcon0, VCFG);
		#endif

		//wait the acquisition time
		cnt =0;
		while (cnt < MX_ADC_SAMP_TIME) cnt++;

		//begin conversion and wait until it has finished
		adcon0 = adcon0 | 0x02;
		while (adcon0 & 0x02) ;

		//restore old tris value, and reset adc registers
		trisio = old_tris;
		ansel = 0x00;
		adcon0 = 0x00;

		#undef MX_ADC_TRIS_REG
		#undef MX_ADC_TRIS_MSK
		#undef MX_ADC_SAMP_TIME
		#undef MX_ADC_CHANNEL
		#undef MX_ADC_CONV_SP
		#undef MX_ADC_VREF_OPT

}

char FCD_ADC2_ReadAsByte()
{
	
		FCD_ADC2_SampleADC();

		return adresh;

}

short FCD_ADC2_ReadAsInt()
{
	
		short iRetVal;

		FCD_ADC2_SampleADC();

		iRetVal = (adresh << 2);
		iRetVal = iRetVal | (adresl >> 6);

		return (iRetVal);

}

float FCD_ADC2_ReadAsVoltage()
{
	

		int iSample;
		float fSample, fVoltage, fVperDiv;

		#define MX_ADC_VREF_V		500

		iSample = FCD_ADC2_ReadAsInt();											//Read as 10-bit Integer

		#ifdef _BOOSTC
			fVoltage = float32_from_int32(MX_ADC_VREF_V);					//Convert reference voltage count to floating point (0 - 500 x 10mV)
			fVoltage = float32_mul(fVoltage, 0.01);							//Convert reference voltage count to actual voltage (0 - 5)
			fVperDiv = float32_mul(fVoltage, 0.000976);						//Convert actual voltage to voltage per division (VRef / 1024)
			fSample = float32_from_int32(iSample);							//Convert to floating point variable
			fVoltage = float32_mul(fSample, fVperDiv);						//Calculate floating point voltage
		#endif

		#ifdef HI_TECH_C
			fVoltage = MX_ADC_VREF_V;										//Convert reference voltage count to floating point (0 - 500 x 10mV)
			fVoltage = fVoltage * 0.01;										//Convert reference voltage count to actual voltage (0 - 5)
			fVperDiv = fVoltage * 0.000976;									//Convert actual voltage to voltage per division (VRef / 1024)
			fSample = iSample;												//Convert to floating point variable
			fVoltage = fSample * fVperDiv;									//Calculate floating point voltage
		#endif

		#undef MX_ADC_VREF_V
		return (fVoltage);

}

void FCD_ADC2_ReadAsString(char* FCR_RETVAL, char FCR_RETVAL_SIZE)
{
	
		float fVoltage;

		fVoltage = FCD_ADC2_ReadAsVoltage();
		FCI_FLOAT_TO_STRING(fVoltage, 2, FCR_RETVAL, FCR_RETVAL_SIZE);	//Convert to String

}



//ADC(3): //Makr implementcik


void FCD_ADC3_SampleADC()
{
	
	/*******Supported Devices******************************************************************
	// 12F615, 12HV615, 12F675, 12F683
	******************************************************************************************/

		#define MX_ADC_CHANNEL		3
		#define MX_ADC_SAMP_TIME 	40
		#define MX_ADC_CONV_SP		3
		#define MX_ADC_VREF_OPT		0

		//set up ADC conversion
		char old_tris, cnt;
		#define MX_ADC_TRIS_REG  trisio

		//find appropriate bit
		#if (MX_ADC_CHANNEL == 0)
			#define MX_ADC_TRIS_MSK  0x01
			ansel = 0x01;
		#endif
		#if (MX_ADC_CHANNEL == 1)
			#define MX_ADC_TRIS_MSK  0x02
			ansel = 0x02;
			#if (MX_ADC_VREF_OPT != 0)
				#ifdef _BOOSTC
					#pragma error "Target device is currently using AN1 for VREF+"
				#endif
				#ifdef HI_TECH_C
					#error Target device is currently using AN1 for VREF+
				#endif
			#endif
		#endif
		#if (MX_ADC_CHANNEL == 2)
			#define MX_ADC_TRIS_MSK  0x04
			ansel = 0x04;
		#endif
		#if (MX_ADC_CHANNEL == 3)
			#define MX_ADC_TRIS_MSK  0x10
			ansel = 0x08;
		#endif

		//sanity check
		#ifndef MX_ADC_TRIS_MSK
			#ifdef _BOOSTC
				#pragma error "ADC Type 5 conversion code error - please contact technical support"
			#endif
			#ifdef HI_TECH_C
				#error ADC Type 5 conversion code error - please contact technical support
			#endif
		#endif

		//store old tris value, and set the i/o pin as an input
		old_tris = MX_ADC_TRIS_REG;
		MX_ADC_TRIS_REG = MX_ADC_TRIS_REG | MX_ADC_TRIS_MSK;

		//assign conversion rate
		ansel = ansel | ((MX_ADC_CONV_SP & 0x07) << 4);

		//turn ADC on
		adcon0 = 0x01 | (MX_ADC_CHANNEL << 2);

		//assign VREF functionality
		#if (MX_ADC_VREF_OPT == 1)
			st_bit(adcon0, VCFG);
		#endif

		//wait the acquisition time
		cnt =0;
		while (cnt < MX_ADC_SAMP_TIME) cnt++;

		//begin conversion and wait until it has finished
		adcon0 = adcon0 | 0x02;
		while (adcon0 & 0x02) ;

		//restore old tris value, and reset adc registers
		trisio = old_tris;
		ansel = 0x00;
		adcon0 = 0x00;

		#undef MX_ADC_TRIS_REG
		#undef MX_ADC_TRIS_MSK
		#undef MX_ADC_SAMP_TIME
		#undef MX_ADC_CHANNEL
		#undef MX_ADC_CONV_SP
		#undef MX_ADC_VREF_OPT

}

char FCD_ADC3_ReadAsByte()
{
	
		FCD_ADC3_SampleADC();

		return adresh;

}

short FCD_ADC3_ReadAsInt()
{
	
		short iRetVal;

		FCD_ADC3_SampleADC();

		iRetVal = (adresh << 2);
		iRetVal = iRetVal | (adresl >> 6);

		return (iRetVal);

}

float FCD_ADC3_ReadAsVoltage()
{
	

		int iSample;
		float fSample, fVoltage, fVperDiv;

		#define MX_ADC_VREF_V		500

		iSample = FCD_ADC3_ReadAsInt();											//Read as 10-bit Integer

		#ifdef _BOOSTC
			fVoltage = float32_from_int32(MX_ADC_VREF_V);					//Convert reference voltage count to floating point (0 - 500 x 10mV)
			fVoltage = float32_mul(fVoltage, 0.01);							//Convert reference voltage count to actual voltage (0 - 5)
			fVperDiv = float32_mul(fVoltage, 0.000976);						//Convert actual voltage to voltage per division (VRef / 1024)
			fSample = float32_from_int32(iSample);							//Convert to floating point variable
			fVoltage = float32_mul(fSample, fVperDiv);						//Calculate floating point voltage
		#endif

		#ifdef HI_TECH_C
			fVoltage = MX_ADC_VREF_V;										//Convert reference voltage count to floating point (0 - 500 x 10mV)
			fVoltage = fVoltage * 0.01;										//Convert reference voltage count to actual voltage (0 - 5)
			fVperDiv = fVoltage * 0.000976;									//Convert actual voltage to voltage per division (VRef / 1024)
			fSample = iSample;												//Convert to floating point variable
			fVoltage = fSample * fVperDiv;									//Calculate floating point voltage
		#endif

		#undef MX_ADC_VREF_V
		return (fVoltage);

}

void FCD_ADC3_ReadAsString(char* FCR_RETVAL, char FCR_RETVAL_SIZE)
{
	
		float fVoltage;

		fVoltage = FCD_ADC3_ReadAsVoltage();
		FCI_FLOAT_TO_STRING(fVoltage, 2, FCR_RETVAL, FCR_RETVAL_SIZE);	//Convert to String

}

//Makr implementcik

void FCM_SPI_Write_Byte()
{
	
	//Helyi vltoz defincik
	short FCL_T;
	short FCL_MASK;
	short FCL_FLAG;
	short FCL_NUM;

	//Kommentr:
	//EZ LENNE A "C" KD
	//void SPI_Write_Byte(unsigned short num){
	// unsigned short t, Mask, Flag;
	// CLK_Pin = 0;
	// Mask = 128;
	// for (t=0; t<8; t++){
	//  Flag = num & Mask;
	//  if(Flag == 0) MOSI_Pin = 0;
	//  else MOSI_Pin = 1;
	//  CLK_Pin = 1;
	//  CLK_Pin = 0;
	//  Mask = Mask >> 1;
	// }
	//}


	//Kimenet
	//Kimenet: 0 -> A5
	trisio = trisio & 0xdf;
	if (0)
		gpio = (gpio & 0xdf) | 0x20;
	else
		gpio = gpio & 0xdf;


	//Szmts
	//Szmts:
	//  mask = 128
	//  t = 0
	FCV_MASK = 128;
	FCV_T = 0;
	

	//Ciklus
	//Ciklus: Amg1
	while (1)
	{
		//Feltteles elgazs
		//Feltteles elgazs: t<8?
		if (FCV_T<8)
		{
			//Szmts
			//Szmts:
			//  flag = num & mask
			FCV_FLAG = FCV_NUM & FCV_MASK;
			

			//Feltteles elgazs
			//Feltteles elgazs: flag  == 0?
			if (FCV_FLAG  == 0)
			{
				//Kimenet
				//Kimenet: 0 -> A1
				trisio = trisio & 0xfd;
				if (0)
					gpio = (gpio & 0xfd) | 0x02;
				else
					gpio = gpio & 0xfd;


			} else {
				//Kimenet
				//Kimenet: 1 -> A1
				trisio = trisio & 0xfd;
				if (1)
					gpio = (gpio & 0xfd) | 0x02;
				else
					gpio = gpio & 0xfd;


			}


			//Kimenet
			//Kimenet: 1 -> A5
			trisio = trisio & 0xdf;
			if (1)
				gpio = (gpio & 0xdf) | 0x20;
			else
				gpio = gpio & 0xdf;


			//Kimenet
			//Kimenet: 0 -> A5
			trisio = trisio & 0xdf;
			if (0)
				gpio = (gpio & 0xdf) | 0x20;
			else
				gpio = gpio & 0xdf;


			//Szmts
			//Szmts:
			//  mask = mask >> 1
			FCV_MASK = FCV_MASK >> 1;
			

			//Szmts
			//Szmts:
			//  t = t + 1
			FCV_T = FCV_T + 1;
			

		} else {
			//Menj a kapcsoldsi porthoz
			//Menj a kapcsoldsi porthoz: [A]: A
			goto FCC_SPI_Write_Byte_A;


		}


	}


	//Kapcsoldsi pont
	//Kapcsoldsi pont: [A]: A
FCC_SPI_Write_Byte_A:
;


}

void FCM_MAX7219_INIT()
{
	
	//Kimenet
	//Kimenet: 0 -> A0
	trisio = trisio & 0xfe;
	if (0)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Szmts
	//Szmts:
	//  num = 0xC0
	FCV_NUM = 0xC0;
	

	//Disable Shutdown mode
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Szmts
	//Szmts:
	//  num = 0x01
	FCV_NUM = 0x01;
	

	//Disable Shutdown mode
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Kimenet
	//Kimenet: 1 -> A0
	trisio = trisio & 0xfe;
	if (1)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Kimenet
	//Kimenet: 0 -> A0
	trisio = trisio & 0xfe;
	if (0)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Szmts
	//Szmts:
	//  num = 0x09
	FCV_NUM = 0x09;
	

	//Set BCD decode mode 
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Szmts
	//Szmts:
	//  num = 0b11101110
	FCV_NUM = 238;
	

	//Makr hvs
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Kimenet
	//Kimenet: 1 -> A0
	trisio = trisio & 0xfe;
	if (1)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Kimenet
	//Kimenet: 0 -> A0
	trisio = trisio & 0xfe;
	if (0)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Szmts
	//Szmts:
	//  num = 0x0A
	FCV_NUM = 0x0A;
	

	//Set display brighness
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Szmts
	//Szmts:
	//  num = 0x09
	FCV_NUM = 0x09;
	

	//Makr hvs
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Kimenet
	//Kimenet: 1 -> A0
	trisio = trisio & 0xfe;
	if (1)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Kimenet
	//Kimenet: 0 -> A0
	trisio = trisio & 0xfe;
	if (0)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Szmts
	//Szmts:
	//  num = 0x0B
	FCV_NUM = 0x0B;
	

	//Set display refresh
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Szmts
	//Szmts:
	//  num = 0x07
	FCV_NUM = 0x07;
	

	//Makr hvs
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Kimenet
	//Kimenet: 1 -> A0
	trisio = trisio & 0xfe;
	if (1)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Kimenet
	//Kimenet: 0 -> A0
	trisio = trisio & 0xfe;
	if (0)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Szmts
	//Szmts:
	//  num = 0x0F
	FCV_NUM = 0x0F;
	

	//Enable Display-Test
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Szmts
	//Szmts:
	//  num = 0x01
	FCV_NUM = 0x01;
	

	//Makr hvs
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Kimenet
	//Kimenet: 1 -> A0
	trisio = trisio & 0xfe;
	if (1)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Ksleltets
	//Ksleltets: 1000 ms
	delay_ms(255);
	delay_ms(255);
	delay_ms(255);
	delay_ms(235);


	//Kimenet
	//Kimenet: 0 -> A0
	trisio = trisio & 0xfe;
	if (0)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Szmts
	//Szmts:
	//  num = 0x0F
	FCV_NUM = 0x0F;
	

	//Disable Display-Test
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Szmts
	//Szmts:
	//  num = 0x00
	FCV_NUM = 0x00;
	

	//Makr hvs
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Kimenet
	//Kimenet: 1 -> A0
	trisio = trisio & 0xfe;
	if (1)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


}

void FCM_Display_Value()
{
	
	//Helyi vltoz defincik
	short FCL_J;
	short FCL_K;

	//Kimenet
	//Kimenet: 0 -> A0
	trisio = trisio & 0xfe;
	if (0)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Szmts
	//Szmts:
	//  num = k
	FCV_NUM = FCV_K;
	

	//Makr hvs
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Szmts
	//Szmts:
	//  num = j
	//  num = (num/100)%10
	FCV_NUM = FCV_J;
	FCV_NUM = (FCV_NUM/100)%10;
	

	//Makr hvs
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Kimenet
	//Kimenet: 1 -> A0
	trisio = trisio & 0xfe;
	if (1)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Kimenet
	//Kimenet: 0 -> A0
	trisio = trisio & 0xfe;
	if (0)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Szmts
	//Szmts:
	//  num = k - 1
	FCV_NUM = FCV_K - 1;
	

	//Makr hvs
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Szmts
	//Szmts:
	//  num = j
	//  num = (num / 10)%10
	FCV_NUM = FCV_J;
	FCV_NUM = (FCV_NUM / 10)%10;
	

	//Makr hvs
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Kimenet
	//Kimenet: 1 -> A0
	trisio = trisio & 0xfe;
	if (1)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Kimenet
	//Kimenet: 0 -> A0
	trisio = trisio & 0xfe;
	if (0)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Szmts
	//Szmts:
	//  num = k - 2
	FCV_NUM = FCV_K - 2;
	

	//Makr hvs
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Szmts
	//Szmts:
	//  num = j
	//  num = num %10
	FCV_NUM = FCV_J;
	FCV_NUM = FCV_NUM %10;
	

	//Makr hvs
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Kimenet
	//Kimenet: 1 -> A0
	trisio = trisio & 0xfe;
	if (1)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Kimenet
	//Kimenet: 0 -> A0
	trisio = trisio & 0xfe;
	if (0)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


	//Szmts
	//Szmts:
	//  num = k - 3
	FCV_NUM = FCV_K - 3;
	

	//Makr hvs
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Feltteles elgazs
	//Feltteles elgazs: k==1?
	if (FCV_K==1)
	{
		//SzmtsU
		//Szmts:
		//  num = 0b00111110
		FCV_NUM = 62;
		

	} else {
		//SzmtsA
		//Szmts:
		//  num = 0b01110110
		FCV_NUM = 118;
		

	}


	//Makr hvs
	//Makr hvs: SPI_Write_Byte
	FCM_SPI_Write_Byte();


	//Kimenet
	//Kimenet: 1 -> A0
	trisio = trisio & 0xfe;
	if (1)
		gpio = (gpio & 0xfe) | 0x01;
	else
		gpio = gpio & 0xfe;


}

void main()
{
	
	//Inicializlsok
	ansel = 0x00;
cmcon0 = 0x07;


	//Megszakts inicializl kd
	option_reg = 0xC0;


	//Ksleltets
	//Ksleltets: 5 ms
	delay_ms(5);


	//Makr hvs
	//Makr hvs: MAX7219_INIT
	FCM_MAX7219_INIT();


	//Ciklus
	//Ciklus: Amg1
	while (1)
	{
		//Ksleltets
		//Ksleltets: 5 ms
		delay_ms(5);


		//Ciklus
		//Ciklus: Ciklus 8 alkalommal
		for (FCLV_LOOP1=0; FCLV_LOOP1<8; FCLV_LOOP1++)
		{
			//Komponens makr hvsa
			//Komponens makr hvsa: ADC_OP=ADC(2)::ReadAsInt
			FCV_ADC_OP = FCD_ADC2_ReadAsInt();


			//Szmts
			//Szmts:
			//  Amp = Amp + ADC_OP
			FCV_AMP = FCV_AMP + FCV_ADC_OP;
			

			//Ksleltets
			//Ksleltets: 5 ms
			delay_ms(5);


		}


		//Szmts
		//Szmts:
		//  Amp = Amp >> 3
		//  Amp = Amp * 2
		//  j = Amp
		//  k = 8
		FCV_AMP = FCV_AMP >> 3;
		FCV_AMP = FCV_AMP * 2;
		FCV_J = FCV_AMP;
		FCV_K = 8;
		

		//Makr hvs
		//Makr hvs: Display_Value
		FCM_Display_Value();


		//Ciklus
		//Ciklus: Ciklus 8 alkalommal
		for (FCLV_LOOP2=0; FCLV_LOOP2<8; FCLV_LOOP2++)
		{
			//Komponens makr hvsa
			//Komponens makr hvsa: ADC_OP=ADC(3)::ReadAsInt
			FCV_ADC_OP = FCD_ADC3_ReadAsInt();


			//Szmts
			//Szmts:
			//  Volt = Volt + ADC_OP
			FCV_VOLT = FCV_VOLT + FCV_ADC_OP;
			

			//Ksleltets
			//Ksleltets: 5 ms
			delay_ms(5);


		}


		//Szmts
		//Szmts:
		//  Volt = Volt >> 3
		//  Volt = Volt*6
		//  j = Volt
		//  k = 4
		FCV_VOLT = FCV_VOLT >> 3;
		FCV_VOLT = FCV_VOLT*6;
		FCV_J = FCV_VOLT;
		FCV_K = 4;
		

		//Makr hvs
		//Makr hvs: Display_Value
		FCM_Display_Value();


		//Ksleltets
		//Ksleltets: 5 ms
		delay_ms(5);


	}


	mainendloop: goto mainendloop;
}

void MX_INTERRUPT_MACRO(void)
{
}



