// ***********************************************************************
// LCD menu
// ***********************************************************************
#define _XTAL_FREQ 10000000


//************************************************************************
// MPLAB/HITECH-C includes
//************************************************************************
#include <htc.h>
#include <stdlib.h>
#include <PIC16F877A.h>
#include <xc.h>
#include <string.h>
// ***********************************************************************
//
//----------------------------------------------------------------------------//
#pragma config PWRTE=OFF
#pragma config FOSC=HS
#pragma config WDTE=OFF
#pragma config BOREN=OFF
#pragma config LVP=OFF
#pragma config CPD=OFF
#pragma config CP=OFF
// *****************************************************************************// Debounce macros
#define UP_KEY			PORTCbits.RC0//		get_key_press (1<<OBEN)
#define DOWN_KEY		PORTCbits.RC1//		get_key_press (1<<UNTEN)
#define ENTER_KEY		PORTCbits.RC2//		get_key_press (1<<ENTER)
#define RS                      PORTBbits.RB0
#define EN                      PORTBbits.RB2
#define ADATBITEK               PORTD
#define DISPLAY_ROWS	4
#define UPPER_SPACE 	2
#define LOWER_SPACE 	1
// *****************************************************************************//
void PIC_INIT(void);
void LCD_INIT(void);
void LCD_ENG(void);
void PARANCS(unsigned char c);
void ADAT(unsigned char c);
void SZOVEG(const char *q);
void ERTEKKIIRAS();
void gotoxy(unsigned char x, unsigned char y);
void LCDWriteStringROM(const char *lcd_zeichen);
void browse_menu(void);
// *****************************************************************************//
typedef const struct MenuStructure
{	const char *text;
	unsigned char num_menupoints;
	unsigned char up;
	unsigned char down;
	unsigned char enter;
  	void ( *fp )( void );
	// unsigned char value;
}MenuEntry;
// *****************************************************************************//
static unsigned char selected = 1;	
unsigned char leave_menu;
// *****************************************************************************//
const char menu_000[] = " [Reflow oven V1.1]";  	// 0
const char menu_001[] = "  Preheat options";  		// 1
const char menu_002[] = "  Peak options";  			// 2
const char menu_003[] = "  START";  				// 3

const char menu_100[] = " [Preheat options]";  		// 4
const char menu_101[] = "  set preheat time";  		// 5
const char menu_102[] = "  set preheat temp";  		// 6
const char menu_103[] = "  return";  				// 7

const char menu_200[] = " [Peak options]";  		// 8
const char menu_201[] = "  set peak time";  		// 9
const char menu_202[] = "  set peak temp";  		// 10
const char menu_203[] = "  return";  				// 11
// *****************************************************************************//
MenuEntry menu[] =
{
	{menu_000,  4,  0,  0,  0,  0}, 				// 0
	{menu_001,  4,  1,  2,  5,  0},
	{menu_002,  4,  1,  3,  9,  0},
	{menu_003,  4,  2,  3,  3,  0},

	{menu_100,  4,  0,  0,  0,  0},					// 4
	{menu_101,  4,  5,  6,  5,  0},
	{menu_102,  4,  5,  7,  6,  0},
	{menu_103,  4,  6,  7,  1,  0},					// 7

	{menu_200,  4,  0,  0,  0,  0},					// 8
	{menu_201,  4,  9, 10,  9,  0},
	{menu_202,  4,  9, 11, 10,  0},
	{menu_203,  4, 10, 11,  2,  0},					// 11
};
// *****************************************************************************//
/*const MenuEntry menu[];
unsigned char leave_menu;

// ***********************************************************************
// Variable definitions
// ***********************************************************************
// General
static unsigned char selected = 1;			// Start with first entry (apart from header)

// Menu strings
const char menu_000[] = " [Main Screen]";  	// 0
const char menu_001[] = "  Options1";  		// 1
const char menu_002[] = "  Options2";  		// 2
const char menu_003[] = "  Options3";  		// 3
const char menu_004[] = "  Options4";  		// 4
const char menu_005[] = "  Options5";  		// 5
const char menu_006[] = "  Options6";  		// 6
const char menu_007[] = "  Options7";  		// 7
const char menu_008[] = "  Options8";  		// 8
const char menu_009[] = "  Options9";  		// 9
const char menu_010[] = "  return";  		// 10

const char menu_100[] = " [Header1]";  		// 11
const char menu_101[] = "  Option101";  	// 12
const char menu_102[] = "  Option102";  	// 13
const char menu_103[] = "  Option103";  	// 14
const char menu_104[] = "  Option104";  	// 15
const char menu_105[] = "  Option105";  	// 16
const char menu_106[] = "  Option106";  	// 17
const char menu_107[] = "  Option107";  	// 18
const char menu_108[] = "  return";  		// 19

const char menu_200[] = " [Header2]";  		// 20
const char menu_201[] = "  Option201";  	// 21
const char menu_202[] = "  Option202";  	// 22	
const char menu_203[] = "  Option203";  	// 23
const char menu_204[] = "  Option204";  	// 24
const char menu_205[] = "  Option205";  	// 25
const char menu_206[] = "  Option206";  	// 26
const char menu_207[] = "  Option207";  	// 27
const char menu_208[] = "  return";  		// 28

const char menu_300[] = " [Header3]";  		// 29
const char menu_301[] = "  Option301";  	// 30
const char menu_302[] = "  Option302";  	// 31
const char menu_303[] = "  Option303";  	// 32
const char menu_304[] = "  Option304";  	// 33
const char menu_305[] = "  return";  		// 34


// Array of entries
MenuEntry menu[] =
{
	{menu_000, 11,  0,  0,  0,  0}, 		// 0
	{menu_001, 11,  1,  2, 12,  0},
	{menu_002, 11,  1,  3, 21,  0},
	{menu_003, 11,  2,  4, 30,  0},
	{menu_004, 11,  3,  5,  4,  0},
	{menu_005, 11,  4,  6,  5,  0},
	{menu_006, 11,  5,  7,  6,  0},
	{menu_007, 11,  6,  8,  7,  0},
	{menu_008, 11,  7,  9,  8,  0},
	{menu_009, 11,  8, 10,  9,  0},
	{menu_010, 11,  9, 10, 10,  0}, 		// 10

	{menu_100,  9,  0,  0,  0,  0},			// 11
	{menu_101,  9, 12, 13, 12,  0},
	{menu_102,  9, 12, 14, 13,  0},
	{menu_103,  9, 13, 15, 14,  0},
	{menu_104,  9, 14, 16, 15,  0},
	{menu_105,  9, 15, 17, 16,  0},
	{menu_106,  9, 16, 18, 17,  0},
	{menu_107,  9, 17, 19, 18,  0},
	{menu_108,  9, 18, 19,  1,  0},			// 19

	{menu_200,  9,  0,  0,  0,  0},			// 20
	{menu_201,  9, 21, 22, 21,  0},
	{menu_202,  9, 21, 23, 22,  0},
	{menu_203,  9, 22, 24, 23,  0},
	{menu_204,  9, 23, 25, 24,  0},
	{menu_205,  9, 24, 26, 25,  0},
	{menu_206,  9, 25, 27, 26,  0},
	{menu_207,  9, 26, 28, 27,  0},
	{menu_208,  9, 27, 28,  2,  0},			// 28

	{menu_300,  6,  0,  0,  0,  0},			// 29
	{menu_301,  6, 30, 31, 30,  0},
	{menu_302,  6, 30, 32, 31,  0},
	{menu_303,  6, 31, 33, 32,  0},
	{menu_304,  6, 32, 34, 33,  0},
	{menu_305,  6, 33, 34,  3,  0}			// 34
};
*/
//----------------------------------------------------------------------------//
void LCD_ENG(void) {
    EN = 1;
    __delay_us(1);
    EN = 0;
}
void ADAT(unsigned char c) {
    RS = 1;
    __delay_us(50);
    ADATBITEK = (c);
    LCD_ENG();
}
void PARANCS(unsigned char c) {
    RS = 0;
    __delay_us(50);
    ADATBITEK = (c);
    LCD_ENG();
}
void LCD_INIT(void) {
    __delay_ms(15);
    PARANCS(0x38);
    __delay_ms(1);
    PARANCS(0x38);
    __delay_us(100);
    PARANCS(0x38);
    PARANCS(0x0c); // Make cursorinvisible
    PARANCS(0x01);
    __delay_ms(2);
    PARANCS(0x6); // Set entry Mode(auto increment of cursor)
}
void PIC_INIT(void){
    TRISB = 0;
    TRISD = 0;
    TRISC=0B11111111;
}
void SZOVEG(const char *q) {
    while (*q) {
        ADAT(*q);
        *q++;
    }
}
void browse_menu(void)
{
	do
 	{	
                PARANCS(0x01);
                __delay_ms(2);
                PARANCS(0x80);
                SZOVEG(menu[selected].text);

	 	if (!UP_KEY){selected = menu[selected].up;}
                if (!DOWN_KEY)	{selected = menu[selected].down;  }
	 	if (!ENTER_KEY)
	 	{
	   	 if (menu[selected].fp != 0)
	  	 menu[selected].fp();

	  	 selected = menu[selected].enter;
	 	}

	 	__delay_ms(50);

 	}while(!leave_menu);
}
// *****************************************************************************//
void main(void) {
    PIC_INIT();
    LCD_INIT();
    while (1) {
        browse_menu();
    }
}
// *****************************************************************************//