'Elektor DSPradio SI4735
'S2 FM and search up/down
'S3 AM band select up/down
'S4 AM search up/down
'S5 memory

$regfile = "m168def.dat"
$baud = 38400
$crystal = 8000000
$hwstack = 16
$swstack = 32
$framesize = 32

Dim N As Word
Dim D As Word
Dim I As Word
Dim Am As Byte
Dim Ffm As Integer
Dim Fam As Integer
Dim T As Word
Dim T1 As Word
Dim T2 As Word
Dim T3 As Word
Dim T4 As Word
Dim Freq As Integer
Dim Rssi As Word
Dim Snr As Word
Dim Lcdrefresh As Byte
Dim C As Long
Dim Fin As Long
Dim H As Byte
Dim L As Byte
Dim Vol As Byte
Dim Status As Byte
Dim R1 As Byte
Dim R2 As Byte
Dim R3 As Byte
Dim R4 As Byte
Dim R5 As Byte
Dim R6 As Byte
Dim R7 As Byte
Dim R8 As Byte
Dim R9 As Byte
Dim R10 As Byte
Dim R11 As Byte
Dim R12 As Byte
Dim R13 As Byte
Dim Valid As Byte
Dim Bled As Byte
Dim Service As Byte
Dim Pos As Byte
Dim Ch As String * 1
Dim Tx As String * 2
Dim Utcoffset As Byte
Dim Minuten As Byte
Dim Stunden As Byte
Dim Lo As Byte
Dim Hi As Byte
Dim Pot As Word
Dim Dif As Integer
Dim Di2c(10) As Byte
Dim Rdsout As Byte
Dim Prop As Word
Dim Dat As Byte

Dim Band As Byte
Dim Bandstart(15) As Word

Dim Ammemory(20) As Word
Dim Ammemorypos As Byte
Dim Ammemorymax As Byte
Dim Amtext(20) As String * 10
Dim Fmmemory(20) As Word
Dim Fmmemorypos As Byte
Dim Fmmemorymax As Byte
Dim Memoryaktiv As Byte

Dim Encoder1 As Integer
Dim Encoder1old As Integer
Dim Code1 As Byte
Dim Code1old As Byte

Dim Command As Byte
Dim Bytesout As Byte
Dim Bytesin As Byte
Dim Text1 As String * 20
Dim Property_dat(16) As Byte

S2 Alias Pinb.2
S3 Alias Pinb.3
S4 Alias Pinb.4
S5 Alias Pinb.5

Declare Sub Get_int_status()
Declare Sub Refclock()
Declare Sub Rx_volume()
Declare Sub Power_down()
Declare Sub Property()
Declare Sub Init_am()
Declare Sub Init_fm()
Declare Sub Am_tune_freq()
Declare Sub Fm_tune_freq()
Declare Sub Fm_seek_freq_up()
Declare Sub Fm_seek_freq_down()
Declare Sub Am_seek_freq_up()
Declare Sub Am_seek_freq_down()
Declare Sub Fm_tune_status()
Declare Sub Fm_rsq_status()
Declare Sub Am_tune_status()
Declare Sub Am_tune_status_stop()
Declare Sub Am_rsq_status()
Declare Sub Fm_start()
Declare Sub Am_start()
Declare Sub Am_seek_step_9khz()
Declare Sub Am_seek_step_5khz()
Declare Sub Am_seek_step_1khz()
Declare Sub Init_rds()
Declare Sub Fm_rds_status()
Declare Sub Rds()


Declare Sub F_control()
Declare Sub Mam_control()
Declare Sub Mfm_control()
Declare Sub Pc_control_i2c()
Declare Sub Properties()
Declare Sub Property_adr()



Config Adc = Single , Prescaler = Auto , Reference = Off    ' Pre 8...32
Start Adc
Open "com1:" For Binary As #1


Config Lcdpin = Pin , Db4 = Portd.4 , Db5 = Portd.5 , Db6 = Portd.6 , Db7 = Portd.7 , E = Portd.3 , Rs = Portd.2
Config Lcd = 16 * 2 , Chipset = Dogm163v3

Config Timer1 = Pwm , Prescale = 8 , Pwm = 10 , Compare A Pwm = Clear Down
Start Timer1
Pwm1a = 0

Config Timer0 = Timer , Prescale = 8
On Ovf0 Tim0_isr
Enable Timer0
Enable Interrupts

Portb.2 = 1                                                 'Pullups S2...,S5
Portb.3 = 1
Portb.4 = 1
Portb.5 = 1

Portc.1 = 1                                                 'Encoder
Portc.2 = 1

Ffm = 8750
Fam = 6075
Vol = 45

'Ddra.3 = 1
'Waitms 100
'Ddra.3 = 0
'Waitms 100

Ddrb.0 = 1                                                  'Bandswitch
Ddrc.3 = 1


Initlcd
Waitms 100



Cls
Lcd "Elektor DSPradio"
Wait 1

For N = 1 To 16                                             'Read back Properies
    I = N + 440
    Readeeprom Dat , I
    Property_dat(n) = Dat
Next N


If S5 = 0 Then                                              'Clear Memory
   Waitms 300
   If S5 = 0 Then
     D = 0
     Writeeeprom D , 0
     Writeeeprom D , 1
     For N = 1 To 16
       Property_dat(n) = 255
       D = 255
       I = N + 440
       Writeeeprom D , I
     Next N
   End If
End If




Readeeprom Ammemorymax , 0
If Ammemorymax = 255 Then Ammemorymax = 0
Readeeprom Fmmemorymax , 1
If Fmmemorymax = 255 Then Fmmemorymax = 0
If Ammemorymax > 0 Then
  For N = 1 To Ammemorymax
    I = N * 2
    Readeeprom Freq , I
    Ammemory(n) = Freq
    I = N * 10
    I = I + 120
    Readeeprom Amtext(n) , I
  Next N
End If
If Fmmemorymax > 0 Then
  For N = 1 To Fmmemorymax
    I = N * 2
    I = I + 60
    Readeeprom Freq , I
    Fmmemory(n) = Freq
  Next N
End If


Cls
Cursor Off



Config Scl = Portc.5
Config Sda = Portc.4
I2cinit

Bandstart(1) = 153                                          'LW
Bandstart(2) = 549                                          'MW
Bandstart(3) = 3965                                         '75m
Bandstart(4) = 5800                                         '49m
Bandstart(5) = 7200                                         '41m
Bandstart(6) = 9400                                         '31m
Bandstart(7) = 11600                                        '25m
Bandstart(8) = 13550                                        '22m
Bandstart(9) = 15150                                        '19m
Bandstart(10) = 17400                                       '16m
Bandstart(11) = 8750                                        'FM



  Band = 11
  Am = 0
  Power_down
  Waitms 10

  Fm_start
  Waitms 100
  Fm_seek_freq_up
  Waitms 250
  Fm_tune_status
  Valid = 0
  If Freq = 8800 Then                                       'xtal x 11?
     Fm_seek_freq_up
     Valid = 0
  End If


Do                                                          'Main loop
'************ RS332 control *********************
    D = Inkey(#1)
    If D = 102 Then F_control                               'f, Freq
    If D = 109 Then Mam_control                             'm, Memory AM
    If D = 110 Then Mfm_control                             'n, Memory FM
    If D = 112 Then Properties                              'p, Property
    If D = 105 Then Pc_control_i2c                          'i, I2C command
    If D = 106 Then Rdsout = 1                              'j: RDS output
    If D = 107 Then Rdsout = 0                              'k: RDS output off
    If D = 114 Then Print Rssi                              'r: RSSI
    If D = 115 Then Print Snr                               's: SNR
    Waitms 1

'************ Encoder ***************************
  If Am = 1 Then
    If Encoder1old <> Encoder1 Then
      If Memoryaktiv = 1 Then
        If Ammemorymax > 0 Then
          If Encoder1 > 0 Then Ammemorypos = Ammemorypos + 1
          If Encoder1 < 0 Then Ammemorypos = Ammemorypos - 1
          Encoder1old = 0
          Encoder1 = 0
          If Ammemorypos > Ammemorymax Then Ammemorypos = 1
          If Ammemorypos < 1 Then Ammemorypos = Ammemorymax
          Locate 2 , 1
          Lcd "M"
          Lcd Ammemorypos
          Lcd "  "
          Fam = Ammemory(ammemorypos)
          Disable Interrupts
          Am_tune_freq
          Encoder1old = Encoder1
          Enable Interrupts
          Locate 1 , 1
          Lcd Fam
          Lcd " "
            If Ammemorypos < 21 Then
            Text1 = Amtext(ammemorypos)
            Locate 2 , 7
            Lcd Text1
           End If
        End If
      Else
        Freq = Encoder1 * 5
        If Band = 1 Then Freq = Encoder1 * 1
        If Band = 2 Then Freq = Encoder1 * 9
        Encoder1old = 0
        Encoder1 = 0
        Fam = Fam + Freq
        Print #1 , Fam
        Disable Interrupts
        Am_tune_status_stop
        Waitms 1
        Am_tune_freq
        Enable Interrupts
        Locate 1 , 1
        Lcd Fam
        Lcd "  "
        Waitms 300
      End If
    End If
  End If
  If Am = 0 Then
    If Encoder1old <> Encoder1 Then
      If Memoryaktiv = 1 Then
        If Fmmemorymax > 0 Then
          If Encoder1 > 0 Then Fmmemorypos = Fmmemorypos + 1
          If Encoder1 < 0 Then Fmmemorypos = Fmmemorypos - 1
          Encoder1old = 0
          Encoder1 = 0
          If Fmmemorypos > Fmmemorymax Then Fmmemorypos = 1
          If Fmmemorypos < 1 Then Fmmemorypos = Fmmemorymax
          Locate 1 , 14
          Lcd "M"
          Lcd Fmmemorypos
          Lcd "  "
          Ffm = Fmmemory(fmmemorypos)
          Disable Interrupts
          Fm_tune_freq
          Encoder1old = Encoder1
          Enable Interrupts
          Locate 1 , 1
          Lcd Ffm
          Lcd "0 "
          Locate 2 , 1
          Lcd "                "
        End If
      Else
        Freq = Encoder1 * 5
        Encoder1old = 0
        Encoder1 = 0
        Ffm = Ffm + Freq
        Disable Interrupts
        Fm_tune_freq
        Encoder1old = Encoder1
        Enable Interrupts
        Locate 1 , 1
        Lcd Ffm
        Lcd "0 "
        Locate 2 , 1
        Lcd "                "
      End If
    End If
  End If

'********* RX status to LCD ****************
    T = T + 1
    If T = 200 Then T = 0
    If T = 50 Then
      If Valid = 0 Then
        If Am = 0 Then
           Fm_tune_status
         Else
           Am_tune_status
        End If
      End If
    End If
    If T = 100 Then
      If Am = 0 Then
         Fm_rsq_status
         Rds
       Else
         Am_rsq_status
      End If
    End If

'*********** S2:  FM and seek **************
    If S2 = 0 Then
      Memoryaktiv = 0
      If Am = 0 Then
        T1 = 0
        Waitms 5                                            'debounce
        Do
          Waitms 1
          T1 = T1 + 1
        Loop Until S2 = 1
        If T1 < 500 Then                                    'short
          Valid = 0
          Fm_seek_freq_up
          Locate 2 , 1
          Lcd "                "
        Else                                                'long
          Valid = 0
          Fm_seek_freq_down
          Locate 2 , 1
          Lcd "                "
        End If
        Waitms 500
        Fm_tune_status
      Else
        Am = 0
        T1 = 0
        Power_down
        Waitms 10
        Fm_start
      End If
    End If

'********  S3: AM Bands  ****************
    If S3 = 0 Then
      Memoryaktiv = 0
      T2 = 0
      Waitms 5                                              'debounce
      If Am = 0 Then
        Am = 1
        Power_down
        Waitms 10
        Am_start
        Waitms 100
      Else
        Do
          Waitms 1
          T2 = T2 + 1
        Loop Until S3 = 1
        If T2 < 500 Then                                    'short
          Band = Band + 1
        Else                                                'long
          Band = Band - 1
        End If
        If Band > 10 Then Band = 1
        Am_tune_status_stop
        Waitms 10
        Fam = Bandstart(band)
        Am_tune_freq
        Waitms 250
        Am_tune_status
        If Band = 1 Then Am_seek_step_1khz
        If Band = 2 Then Am_seek_step_9khz
        If Band > 2 Then Am_seek_step_5khz
      End If
    End If

'************** S4: AM Seek *************
    If S4 = 0 Then
      Memoryaktiv = 0
      If Am = 1 Then
        T3 = 0
        Waitms 5                                            'debounce
        Do
          Waitms 1
          T3 = T3 + 1
        Loop Until S4 = 1
        If T3 < 500 Then                                    'short
          Valid = 0
          Am_seek_freq_up
        Else                                                'long
          Valid = 0
          Am_seek_freq_down
        End If
        'Waitms 500
         'Am_tune_status
      Else
        Am = 1
        T = 0
        Power_down
        Waitms 10
        Am_start
      End If
    End If

'****************** S5: Memory  *************
    If S5 = 0 Then
      T4 = 0
      Waitms 5                                              'debounce
      Do
        Waitms 1
        T4 = T4 + 1
      Loop Until S5 = 1
      If T4 > 500 Then                                      'long
        If Memoryaktiv = 0 Then
          Memoryaktiv = 1
          If Am = 1 Then
            Locate 2 , 1
            Lcd "M  "
          Else
            Locate 1 , 14
            Lcd "M  "
          End If
        Else
          Memoryaktiv = 0
          If Am = 1 Then
            Locate 2 , 1
            Lcd "   "
          Else
            Locate 1 , 14
            Lcd "   "
          End If
      End If
      Else
        If Memoryaktiv = 0 Then
          If Am = 1 Then
            Ammemorymax = Ammemorymax + 1
            If Ammemorymax > 20 Then Ammemorymax = 20
            Ammemory(ammemorymax) = Fam
            Locate 2 , 1
            Lcd "M"
            Lcd Ammemorymax
            Lcd " "
            Amtext(ammemorymax) = "   "
          Else
            Fmmemorymax = Fmmemorymax + 1
            If Fmmemorymax > 20 Then Fmmemorymax = 20
            Fmmemory(fmmemorymax) = Ffm
            Locate 1 , 14
            Lcd "M"
            Lcd Fmmemorymax
            Lcd " "
          End If
        Else
          Memoryaktiv = 0
          If Am = 1 Then
            Locate 2 , 1
            Lcd "   "
          Else
            Locate 1 , 14
            Lcd "   "
          End If
        End If
      End If
      If T4 > 2000 Then                                     'longer > 2000 ms
         Writeeeprom Ammemorymax , 0
         Writeeeprom Fmmemorymax , 1
         If Ammemorymax > 0 Then
            For N = 1 To Ammemorymax
              I = N * 2
              Freq = Ammemory(n)
              Writeeeprom Freq , I
              If N < 21 Then
                I = N * 10
                I = I + 120
                Writeeeprom Amtext(n) , I
              End If
            Next N
         End If
         If Fmmemorymax > 0 Then
            For N = 1 To Fmmemorymax
              I = N * 2
              I = I + 60
              Freq = Fmmemory(n)
              Writeeeprom Freq , I
            Next N
         End If
         For N = 1 To 16                                    'Properies
              I = N + 440
              Dat = Property_dat(n)
              Writeeeprom Dat , I
         Next N
      End If
    End If

'************** Volume *******************
    Pot = Getadc(0)
    Pot = Pot / 16
    Dif = Pot - Vol
    Dif = Abs(dif)
    If Dif > 1 Then
       Vol = Pot
       Rx_volume
    End If
  Loop

'************** PC tune commands *********
Sub F_control()
  Print "Tune"
  Input Fin
  If Am = 1 Then
    If Fin >= 60000 Then
      Power_down
      Waitms 10
      Am = 0
      Fm_start
      Waitms 100
    End If
  End If
  If Am = 0 Then
    If Fin < 60000 Then
      Power_down
      Waitms 10
      Am = 1
      Am_start
      Waitms 100
    End If
  End If
  If Am = 1 Then
    Fam = Fin
    Am_tune_freq
    Waitms 250
    Am_tune_status
  End If
  If Am = 0 Then
    Fin = Fin / 10
    Ffm = Fin
    Fm_tune_freq
    Waitms 250
    Fm_tune_status
  End If
End Sub


'************** PC memory commands *********
Sub Mam_control
  Print "Memory AM"
  Input N
  Input Fin
  Input Text1
  If N < 31 Then
    If N > Ammemorymax Then Ammemorymax = N
    Freq = Fin
    Ammemory(n) = Freq
    Text1 = Text1 + "         "
    Text1 = Left(text1 , 9)
    Amtext(n) = Text1
  End If
End Sub

Sub Mfm_control
  Print "Memory FM"
  Input N
  Input Fin
    If N < 31 Then
    If N > Fmmemorymax Then Fmmemorymax = N
    Fin = Fin / 10
    Freq = Fin
    Fmmemory(n) = Freq
  End If
End Sub


'************* Properties ***********
Sub Properties
  Print "Property"
  Input N
  If N > 16 Then N = 16
  Input Dat
  Property_dat(n) = Dat
  Property_adr
End Sub

Sub Property_adr
  If N = 1 Then Prop = &H1100                               'FM_DEEMPHASIS
  If N = 2 Then Prop = &H1105                               'FM_BLEND_STEREO_THRESHOLD
  If N = 3 Then Prop = &H1106                               'FM_BLEND_MONO_THRESHOLD
  If N = 4 Then Prop = &H1300                               'FM_SOFT_MUTE_RATE
  If N = 5 Then Prop = &H1302                               'FM_SOFT_MUTE_MAX_ATTENUATION
  If N = 6 Then Prop = &H1303                               'FM_SOFT_MUTE_SNR_THRESHOLD
  If N = 7 Then Prop = &H1403                               'FM_SEEK_TUNE_SNR_THRESHOLD
  If N = 8 Then Prop = &H1404                               'FM_SEEK_TUNE_RSSI_TRESHOLD
  If N = 9 Then Prop = &H3100                               'AM_DEEMPHASIS
  If N = 10 Then Prop = &H3102                              'AM_CHANNEL_FILTER
  If N = 11 Then Prop = &H3300                              'AM_SOFT_MUTE_RATE
  If N = 12 Then Prop = &H3301                              'AM_SOFT_MUTE_SLOPE
  If N = 13 Then Prop = &H3302                              'AM_SOFT_MUTE_MAX_ATTENUATION
  If N = 14 Then Prop = &H3303                              'AM_SOFT_MUTE_SNR_THRESHOLD
  If N = 15 Then Prop = &H3403                              'AM_SEEK_SNR_THRESHOLD
  If N = 16 Then Prop = &H3404                              'AM_SEEK_RSSI_THRESHOLD
  If N = 0 Then Prop = &H4000                               'Volume
  Property
End Sub


'************* PC I2C commands ***********
Sub Pc_control_i2c
  Print #1 , "I2C"
  Do
    Get #1 , Command                                        'I2C write and read to SI4735
    If Command = 67 Then                                    '"C"
       Get #1 , Bytesout
       Get #1 , Bytesin
       For N = 1 To Bytesout
         Get #1 , Di2c(n)
       Next N
       I2cstart
       I2cwbyte 34
       For N = 1 To Bytesout
          I2cwbyte Di2c(n)
       Next N
       I2cstop
       If Bytesin > 0 Then
         I2cstart
         I2cwbyte 35
         While Bytesin > 1
           Bytesin = Bytesin - 1
           I2crbyte D , Ack
           Put #1 , D
         Wend
         I2crbyte D , Nack
         Put #1 , D
         I2cstop
       End If
    End If
    If Command = 65 Then                                    'LCD Line 1
      Input #1 , Text1
      Locate 1 , 1
      Lcd Text1
    End If
    If Command = 66 Then                                    'LCD Line 2
      Input #1 , Text1
      Locate 2 , 1
      Lcd Text1
    End If
  Loop
End Sub


Sub Fm_start()
  Cls
  Init_fm
  Waitms 200
  Rx_volume
  Waitms 5
  Fm_tune_freq
  Waitms 500
  Fm_tune_status
  Waitms 50
  Init_rds
  For N = 1 To 8                                            'Read back Properies
    Dat = Property_dat(n)
    If Dat < 255 Then
      Property_adr
    End If
  Next N
End Sub

Sub Am_start()
  Cls
  Init_am
  Waitms 200
  Rx_volume
  Waitms 5
  Am_tune_freq
  Waitms 500
 ' Am_seek_step_5khz
  Waitms 1
  Am_tune_status
  For N = 9 To 16
    Dat = Property_dat(n)
    If Dat < 255 Then
      Property_adr
    End If
  Next N
End Sub

Sub Get_int_status()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H14
  I2cstop
  I2cstart
  I2cwbyte 35
  I2crbyte Status , Nack
  I2cstop
  Status = Status And 128
  Shift Status , Right , 7
End Sub


Sub Rx_volume()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H12
  I2cwbyte &H00
  I2cwbyte &H40
  I2cwbyte &H00
  I2cwbyte &H00
  I2cwbyte Vol
  I2cstop
End Sub

Sub Property()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H12
  I2cwbyte &H00
  H = High(prop)
  L = Low(prop)
  I2cwbyte H
  I2cwbyte L
  I2cwbyte &H00
  I2cwbyte Dat
  I2cstop
End Sub

Sub Am_seek_step_5khz()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H12
  I2cwbyte &H00
  I2cwbyte &H34
  I2cwbyte &H02
  I2cwbyte &H00
  I2cwbyte &H05
  I2cstop
End Sub

Sub Am_seek_step_9khz()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H12
  I2cwbyte &H00
  I2cwbyte &H34
  I2cwbyte &H02
  I2cwbyte &H00
  I2cwbyte &H09
  I2cstop
End Sub

Sub Am_seek_step_1khz()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H12
  I2cwbyte &H00
  I2cwbyte &H34
  I2cwbyte &H02
  I2cwbyte &H00
  I2cwbyte &H01
  I2cstop
End Sub

Sub Power_down()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H11
  I2cstop
End Sub

Sub Init_am()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H01
  I2cwbyte &H11
  I2cwbyte &H05
  I2cstop
End Sub

Sub Init_fm()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H01
  I2cwbyte &H10
  I2cwbyte &H05
  I2cstop
End Sub

Sub Am_tune_freq()
  If Fam > 500 Then
    If Fam > 2000 Then
       Portb.0 = 1                                          'SW
       Portc.3 = 0
    Else
       Portb.0 = 0                                          'MW
       Portc.3 = 1
    End If
  Else
       Portb.0 = 0                                          'LW
       Portc.3 = 0
  End If

  I2cstart
  I2cwbyte 34
  I2cwbyte &H40
  I2cwbyte &H00
  H = High(fam)
  L = Low(fam)
  I2cwbyte H
  I2cwbyte L
  I2cwbyte &H00
  I2cstop

End Sub

Sub Fm_tune_freq()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H20
  I2cwbyte &H00
  H = High(ffm)
  L = Low(ffm)
  I2cwbyte H
  I2cwbyte L
  I2cwbyte &H00
  I2cstop
End Sub

Sub Fm_seek_freq_up()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H21
  I2cwbyte &H0C
  I2cstop
End Sub


Sub Fm_seek_freq_down()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H21
  I2cwbyte &H04
  I2cstop
End Sub


Sub Am_seek_freq_up()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H41
  I2cwbyte &H0C
  I2cstop
End Sub


Sub Am_seek_freq_down()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H41
  I2cwbyte &H04
  I2cstop
End Sub



Sub Fm_tune_status()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H22
  I2cwbyte &H3
  I2cstop
  I2cstart
  I2cwbyte 35
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Nack
  Freq = 256 * R2
  Freq = Freq + R3
  Rssi = R4
  Snr = R5
  Valid = R1.0
  Locate 1 , 1
  Lcd Freq
  Lcd "0 "
  I2cstop
  Encoder1old = 0
  Encoder1 = 0
  If Valid = 1 Then Ffm = Freq
  Pwm1a = Rssi * 12
End Sub

Sub Fm_rsq_status()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H23
  I2cwbyte &H00
  I2cstop
  I2cstart
  I2cwbyte 35
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Nack
  I2cstop
  Rssi = R4
  Snr = R5
  Lcdrefresh = Lcdrefresh + 1
  If Lcdrefresh > 5 Then
    Lcdrefresh = 0
    Locate 1 , 8
    Lcd Rssi
    Lcd " "
    Locate 1 , 11
    Lcd Snr
    Lcd " "
  End If
  Locate 1 , 8
  Lcd Rssi
  Lcd " "
  Locate 1 , 11
  Lcd Snr
  Lcd " "
  Pwm1a = Rssi * 12
End Sub


Sub Am_tune_status_stop()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H42
  I2cwbyte &H03
  I2cstop
End Sub

Sub Am_tune_status()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H42
  I2cwbyte &H01
  I2cstop
  I2cstart
  I2cwbyte 35
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Nack
  Freq = 256 * R2
  Freq = Freq + R3
  Rssi = R4
  Snr = R5
  C = 256 * R6
  C = C + R7
  C = C * 95
  C = C / 1000
  C = C + 7
  Valid = R1.0
  Locate 1 , 1
  Lcd Freq
  If Freq < 10000 Then Lcd " "
  If Freq < 1000 Then Lcd "  "
  Locate 1 , 13
  Lcd C
  Lcd "  "
  I2cstop
  Encoder1old = 0
  Encoder1 = 0
  If Valid = 1 Then Fam = Freq
  Pwm1a = Rssi * 12
End Sub

Sub Am_rsq_status()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H43
  I2cwbyte &H00
  I2cstop
  I2cstart
  I2cwbyte 35
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Nack
  I2cstop
  Rssi = R4
  Snr = R5
  Lcdrefresh = Lcdrefresh + 1
  If Lcdrefresh > 5 Then
    Lcdrefresh = 0
    Locate 1 , 7
    Lcd Rssi
    Lcd " "
    Locate 1 , 10
    Lcd Snr
    Lcd " "
  End If
  Pwm1a = Rssi * 12
End Sub


Sub Init_rds()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H12
  I2cwbyte &H00
  I2cwbyte &H15
  I2cwbyte &H02
  I2cwbyte &H00
  I2cwbyte &H01
  I2cstop
End Sub



Sub Fm_rds_status()
  I2cstart
  I2cwbyte 34
  I2cwbyte &H24
  I2cwbyte &H00
  I2cstop
  I2cstart
  I2cwbyte 35
  I2crbyte Status , Ack
  I2crbyte R1 , Ack
  I2crbyte R2 , Ack
  I2crbyte R3 , Ack
  I2crbyte R4 , Ack
  I2crbyte R5 , Ack
  I2crbyte R6 , Ack
  I2crbyte R7 , Ack
  I2crbyte R8 , Ack
  I2crbyte R9 , Ack
  I2crbyte R10 , Ack
  I2crbyte R11 , Ack
  I2crbyte R12 , Ack
  I2crbyte R13 , Nack
  I2cstop
End Sub


Sub Rds()
  For N = 1 To 15
    Get_int_status
    If Status = 1 Then
      Fm_rds_status
      If R3 > 0 Then                                        'new data?
        If Rdsout = 1 Then Print Chr(66) ; Chr(66) ; Chr(r3) ; Chr(r4) ; Chr(r5) ; Chr(r6) ; Chr(r7) ; Chr(r8) ; Chr(r9) ; Chr(r10) ; Chr(r11) ; Chr(r12)
        Bled = R12 And 3
        Service = R6 And 248
        If Service = 0 Then                                 '0A, Tuning Information
          If Bled = 0 Then
            Pos = R7 And 3
            Pos = Pos * 2
            Pos = Pos + 1
            Locate 2 , Pos
            Ch = Chr(r10)
            Lcd Ch
            Ch = Chr(r11)
            Lcd Ch
          End If
        End If
        If Service = 64 Then                                '4A, Time
          Utcoffset = R11 And 31
          Utcoffset = Utcoffset / 2
          Lo = R11 / 64
          Hi = R10 And 15
          Hi = Hi * 4
          Minuten = Hi + Lo
          Lo = R10 / 16
          Hi = R9 And 1
          Hi = Hi * 16
          Stunden = Hi + Lo
          If R11.5 = 1 Then
            Stunden = Stunden - Utcoffset
          Else
            Stunden = Stunden + Utcoffset
          End If
          Locate 2 , 10
          Tx = Str(stunden)
          If Stunden < 10 Then
            Tx = "0" + Tx
          End If
          Lcd Tx
          Lcd ":"
          Tx = Str(minuten)
          If Minuten < 10 Then
            Tx = "0" + Tx
          End If
          Lcd Tx
        End If
      End If
    End If
  Next N
End Sub


Tim0_isr:
  Code1 = Pinc
  Code1 = Code1 And 6
  If Code1.2 < Code1old.2 Then
    If Code1.1 = 1 Then Encoder1 = Encoder1 + 1
    If Code1.1 = 0 Then Encoder1 = Encoder1 - 1
  End If
  Code1old = Code1
Return


End