/*
	Set the clock source to the inernal oscillator and turn off the watch dog timer. the
	following line is specific to PIC18 and PIC18F2455/2550/4455/4550 
*/
#pragma config FOSC = INTOSCIO_EC, FCMEN=ON, WDT=OFF, BOR = OFF, VREGEN = OFF, LVP = OFF



#include <p18cxxx.h>
#include "sed1335.h"
#include "graphic.h"
#include "ebaylogo.h"

void pixel_test(void);
void logo_test(void);
void line_test(void);
void circle_test(void);



void main(void)
{
/*
	Set the internal oscillator to 8Mhz by setting all three IRCF bits to 1.
	this is specific to PIC18F2455/2550/4455/4550.
*/
	OSCCON |= (7 << 4);
	
	UCONbits.USBEN = 0; //disable USB module
	UCFGbits.UTRDIS = 1; //disable USB transciever
	
/* Start stability test */
	
	delay_ms(100);
	
	GLCD_Initialize();



	while(1)
	{
		logo_test();
		delay_ms(1500);
		pixel_test();
		delay_ms(1500);
		line_test();
		delay_ms(1500);
		circle_test();
		delay_ms(1500);
	}

	while(1);
}
void logo_test(void)
{
	char buf[] = "Stability Test";
	GLCD_ClearText();
	GLCD_ClearGraphic();
	GLCD_TextGoTo(0,0);
	GLCD_WriteText(buf);
	GLCD_TextGoTo(26,29);
	GLCD_WriteText(buf);
	GLCD_Bitmap((rom const unsigned char *) ebaylogo, 0, 0, 320, 240);
}
void pixel_test(void)
{
	int x;
	int y;
	unsigned char c;

	GLCD_ClearText();
	GLCD_ClearGraphic();

	c = 0;
	for (y = 0; y < 240; y+=2)
	{
		c = !c;
		for (x = 0; x < 320; x+=2)
		{
			c = !c;
			GLCD_SetPixel(x,y,c);
		}
	}
}
void line_test(void)
{

	int x1;
	int y1;
	int x2;
	int y2;
	int i;

	GLCD_ClearText();
	GLCD_ClearGraphic();

	x1 = 0; y1 = 0; x2 = 319; y2 = 239;

	for (i = 0; i < 160; i++)
	{
		GLCD_Line(x1, y1,x2,y2);
		x1+=2;
		x2-=2;
	}

	x1 = 0; y1 = 0; x2 = 319; y2 = 239;

	for (i = 0; i < 120; i++)
	{
		GLCD_Line(x1, y1,x2,y2);
		y1+=2;
		y2-=2;
	}

}
void circle_test(void)
{
	int x1;
	int y1;
	int r;
	int i;

	x1 = 160; y1 = 120; r = 10;

	GLCD_ClearText();
	GLCD_ClearGraphic();

	for (i = 0; i < 55; i++)
	{
		GLCD_Circle(x1,y1,r);
		r += 2;
	}
}