//-------------------------------------------------------------------------------------------------
// 
//-------------------------------------------------------------------------------------------------

#include <p18cxxx.h>
#include "sed1335.h"

#define SED1335_DATA_PORT		LATD
#define SED1335_DATA_DIR		TRISD
#define SED1335_DATA_PIN		PORTD

#define SED1335_CONTROL_PORT	LATC
#define SED1335_CONTROL_DIR		TRISC
#define	SED1335_CONTROL_PIN		PORTC

#define SED1335_A0				(1 << 6)
#define SED1335_WR				(1 << 1)
#define SED1335_RD				(1 << 0)
#define SED1335_CS				(1 << 7)
#define SED1335_RES				(1 << 2)
//-------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------
/*************************************/
/*Uncomment this line for over 32Mhz */
/*************************************/
//#define READDELAY(); Nop();Nop();Nop();Nop();Nop();Nop();Nop();Nop();Nop();Nop();
/*************************************/
/*Uncomment this line for 16-32MHz */
/*************************************/
#define READDELAY(); Nop();Nop();Nop();Nop();Nop();Nop();
/*************************************/
/*Uncomment this line for 8-16MHz */
/*************************************/
//#define READDELAY(); Nop();Nop();
/*************************************/
/*Uncomment this line for 4MHz */
/*************************************/
//#define READDELAY(); Nop();

void GLCD_InitializePorts(void)
{
SED1335_DATA_DIR = 0x00;
SED1335_CONTROL_PORT |= (SED1335_A0 | SED1335_WR | SED1335_RD | SED1335_CS | SED1335_RES); 
SED1335_CONTROL_DIR &= ~(SED1335_A0 | SED1335_WR | SED1335_RD | SED1335_CS | SED1335_RES); 
}
void GLCD_HardReset(void)
{
	SED1335_CONTROL_DIR &= ~(SED1335_RES);
	delay_ms(3);
	SED1335_CONTROL_DIR |= (SED1335_RES);
	delay_ms(10);	
}
//-------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------
void GLCD_WriteData(unsigned char dataToWrite)
{
SED1335_DATA_PORT = dataToWrite;
SED1335_DATA_DIR = 0;
SED1335_CONTROL_PORT &= ~(SED1335_CS);
SED1335_CONTROL_PORT &= ~(SED1335_A0 | SED1335_WR);
SED1335_CONTROL_PORT |= (SED1335_CS);
SED1335_CONTROL_PORT |= (SED1335_A0 | SED1335_WR);
}
//-------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------
void GLCD_WriteCommand(unsigned char commandToWrite)
{
	
SED1335_DATA_PORT = commandToWrite;
SED1335_DATA_DIR = 0;
SED1335_CONTROL_PORT &= ~(SED1335_WR);
SED1335_CONTROL_PORT &= ~SED1335_CS;
SED1335_CONTROL_PORT |= (SED1335_WR);
SED1335_CONTROL_PORT |= SED1335_CS;
}
//-------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------
unsigned char GLCD_ReadData(void)
{
unsigned char tmp;
SED1335_CONTROL_PORT &= ~(SED1335_CS);
SED1335_DATA_DIR = 0xFF;
SED1335_CONTROL_PORT &= ~(SED1335_RD);
READDELAY();
tmp =  SED1335_DATA_PIN;
SED1335_CONTROL_PORT |= (SED1335_CS);
SED1335_CONTROL_PORT |= (SED1335_RD);
return tmp;
}
//-------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------
unsigned char GLCD_ReadByteFromROMMemory(rom const unsigned char * ptr)
{
	return *ptr;
}
//-------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------

