; Pldaprogram v1.0b
; Felhasznlhat PIC-ek mdosts nlkl: 
	;PIC16F27A,628A,628
; A megfelel PIC headerfjl sorok ell a megjegyzseket ki kell venni. 
; Az MPLAB projectben a megfelel PIC-et ki kell vlasztani.

; Funkci: 
	;PIC-PC soros kommunikci
; Lers: 
;	Megszakts nlkli adat vtel a PC-rl, majd a vett adatok azonnali visszakldse
; 	A vett adatok nem kerlnek letrolsra s feldolgozsra sem.
; 	A plda a konfigurcit, az USART belltst, a Makrk hasznlatt s a Reset pont megfelel kialaktst mutatja be.
; 	Az RX_OK s a TX_OK rutinok nincsenek felksztve a soros adat elmaradsa ill. hibja esetn elmarad felttelek helyes lekezelsre, 
;	ezrt ms programokban val felhasznlsra csak korltozottan alkalmas. 

 

;	LIST P=16F627A, F=INHX32	
;	#include <P16F627A.INC>	

	LIST P=16F628, F=INHX32	
	#include <P16F628.INC>
	
;	LIST P=16F628A, F=INHX32	
;	#include <P16F628A.INC>	


;----------------------------------------------------------
;--				CONFIGURCIS BITEK BELLTSA			 --	
;----------------------------------------------------------	
	__CONFIG _INTRC_OSC_NOCLKOUT&_WDT_OFF&_CP_OFF&_PWRTE_ON&_MCLRE_OFF&_LVP_OFF&_BODEN_OFF


;----------------------------------------------------------
;--							MAKRK						 --	
;----------------------------------------------------------
BANK0	MACRO
	BCF		STATUS,RP0
	BCF		STATUS,RP1
	ENDM
BANK1	MACRO
	BSF		STATUS,RP0
	BCF		STATUS,RP1	
	ENDM



;----------------------------------------------------------
;--						.RESET PONT.					 --	
;----------------------------------------------------------
	ORG	0X0000
	GOTO	INI
	ORG	0X0004
	GOTO	MEGSZAK
	

;----------------------------------------------------------
;--					PORTOK BELLTSA					 --	
;----------------------------------------------------------
INI
	BANK1
	MOVLW	B'11111011'				; RB0->kettspont, RB1->RX BE, RB2->TX KI, 
	MOVWF	TRISB					
	MOVLW	B'11111111'				; MIND BEMENET, 
	MOVWF	TRISA
		
	BSF		PCON,OSCF				; 4MHz bels RC oszci			(B1)
	CLRF	VRCON					; Referencia feszltsgeket bellt reg.

;	USART Belltsa
	CALL	PIC_COMM_SET			; BANK0-AL TR VISSZA


;----------------------------------------------------------
;--						 F CIKLUS 						 --	
;----------------------------------------------------------
DO
	CALL 	RX_OK			; VTEL KSZ?
	MOVF	RCREG,W			; VETT ADAT W-BE
	
	CALL	TX_OK			; ADSRA KSZ?
	MOVWF	TXREG			; VETT ADAT VISSZAKLDSE
	GOTO 	DO



;----------------------------------------------------------
;--					 USART BELLTSA 					 --	
;----------------------------------------------------------
PIC_COMM_SET

	#DEFINE	orajel	D'4000000'	
	#DEFINE	BAUD(X)	((orajel/X)/D'16')-1	; X-BE IRAND A BAUD RATE KIVANT ERTEKE, BRGH = 1 !!
;	#DEFINE	BAUD(X)	((orajel/X)/D'64')-1	; X-BE IRAND A BAUD RATE KIVANT ERTEKE, BRGH = 0 !!
	; RSZLETEK AZ ADATLAP TBLZATAIBAN		
	
	BANK1
	MOVLW	BAUD(D'9600') 		; BAUD RATE BEALLITASA
	MOVWF	SPBRG

						; ADS (TXSTA) belltsai	
	BCF		TXSTA,TX9			; 8 BITES TVITELI MD BELLTVA
	BSF		TXSTA,TXEN			; TRANSMIT ENGEDLYEZS
	BCF		TXSTA,SYNC			; Asynchronous mode	
	BSF		TXSTA,BRGH			; BaudRate tartomny 
	;		TXSTA,TRMT : Transmit Shift Register Status bit
	;		TXSTA,TX9D : 9th bit of Transmit Data / Can be address/data bit or a parity bit	(9. BIT HELYE)

						; VTEL (RCSTA) belltsai
	BANK0
	BSF		RCSTA,SPEN			; SOROS PORT ENGEDLYEZSE
	BCF		RCSTA,RX9			; 8-bites VTELI MD 
	BSF		RCSTA,CREN			; Continuous Receive Enable bit	ENGEDLYEZSE
	BCF		RCSTA,ADEN			; Address Detect Enable bit 
			; 1 = Enables address detection, enables interrupt and load of the receive buffer when RSR<8> is set
			; 0 = Disables address detection, all bytes are received, and ninth bit can be used as parity bit
			; Ha ez a bit be van kapcsolva, akkor soros megszakts csak akkor van, ha a 9. bit 1!
		
	;		RCSTA,FERR : Framing Error bit (KERET HIBA)
		;		1 = Framing error (can be updated by reading RCREG register and receive next valid byte)
		;		0 = No framing error
	
	; 		RCSTA,OERR: Overrun Error bit  (ELRASZTST JELEZ BIT)
		;		1 = Overrun error (can be cleared by clearing bit CREN)
		;		0 = No overrun error
	; 		RX9D: 9th bit of Received Data (A FOGADOTT 9.-BIT VAN BENNE)
		; 		Can be address/data bit or a parity bit
	RETURN

	
;----------------------------------------------------------
;--		 USART ADS ELTTI BUFFER VIZSGLAT				 --	
;----------------------------------------------------------
TX_OK	
	BANK1
BUFFER_T
	BTFSS	TXSTA,TRMT			; ADS MVELET KSZ? BUFFER Empty (res) BIT = 1
	GOTO	BUFFER_T
	BANK0
	RETURN						; BUFFER KIRLT				


;----------------------------------------------------------
;--			USART VTEL LEHETSGT VIZSGLJA			 --	
;----------------------------------------------------------
RX_OK						
	BTFSS	PIR1,RCIF			; VTEL MEGSZAKTS FLAG BIT (HA A VTEL TELJES, A BIT = TRUE)
	GOTO	RX_OK
	RETURN						; LEHET VENNI
	
	
;............ MEGSZAKTS LEKEZELSE ..................	
MEGSZAK
	RETFIE	
	
	END